---
authors:
    - Corey T. White
    - GRASS Development Team
title: Development Introduction
---

## API reference and documentation

- [Python library](https://grass.osgeo.org/grass-stable/manuals/libpython/index.html)
- [C API reference and developer manual](https://grass.osgeo.org/programming8/)
- [Tools](full_index.md)
- [Standard parser options](parser_standard_options.md)
  (for writing new or custom tools)

## Testing

- [Testing](https://grass.osgeo.org/grass-stable/manuals/libpython/gunittest_testing.html)

## Addons

In addition to the core tools, GRASS also provides a number of addons that
extend the functionality of GRASS. Addons are part of the [OSGeo/grass-addons](https://github.com/OSGeo/grass-addons)
repository and are a great place to plubish and share custom tools, models, and reserach.
The addons are maintained by the GRASS community and are a great way to extend the
functionality of GRASS.

- [Addons](https://grass.osgeo.org/grass-stable/manuals/addons/)

## Contributing

- [Style guide](style_guide.md)
- [GitHub guide](github_guide.md)
- [Investigating code history](investigating_history.md)
- [CONTRIBUTING file on GitHub](https://github.com/OSGeo/grass/blob/main/CONTRIBUTING.md)
