---
name: d.mon
description: Controls graphics display monitors from the command line.
keywords: [ display, graphics, monitors ]
---

# d.mon

Controls graphics display monitors from the command line.

=== "Command line"

    **d.mon**
    [**-lpcgsrtux**]
    [**start**=*string*]
    [**stop**=*string*]
    [**select**=*string*]
    [**width**=*value*]
    [**height**=*value*]
    [**resolution**=*value*]
    [**bgcolor**=*name*]
    [**output**=*name*]
    [**--overwrite**]
    [**--verbose**]
    [**--quiet**]
    [**--qq**]
    [**--ui**]

    Example:

    ```sh
    d.mon
    ```

=== "Python (grass.script)"

    *grass.script.run_command*("***d.mon***",
        **start**=*None*,
        **stop**=*None*,
        **select**=*None*,
        **width**=*None*,
        **height**=*None*,
        **resolution**=*None*,
        **bgcolor**=*"white"*,
        **output**=*None*,
        **flags**=*None*,
        **overwrite**=*None*,
        **verbose**=*None*,
        **quiet**=*None*,
        **superquiet**=*None*)

    Example:

    ```python
    gs.run_command("d.mon")
    ```

=== "Python (grass.tools)"

    *grass.tools.Tools.d_mon*(**start**=*None*,
        **stop**=*None*,
        **select**=*None*,
        **width**=*None*,
        **height**=*None*,
        **resolution**=*None*,
        **bgcolor**=*"white"*,
        **output**=*None*,
        **flags**=*None*,
        **overwrite**=*None*,
        **verbose**=*None*,
        **quiet**=*None*,
        **superquiet**=*None*)

    Example:

    ```python
    tools = Tools()
    tools.d_mon()
    ```

    This grass.tools API is experimental in version 8.5 and expected to be stable in version 8.6.

## Parameters

=== "Command line"

    **start**=*string*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of monitor to start  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *wx0, wx1, wx2, wx3, wx4, wx5, wx6, wx7, png, ps, html, cairo*  
    **stop**=*string*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of monitor to stop  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *wx0, wx1, wx2, wx3, wx4, wx5, wx6, wx7, png, ps, html, cairo*  
    **select**=*string*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of monitor to select  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *wx0, wx1, wx2, wx3, wx4, wx5, wx6, wx7, png, ps, html, cairo*  
    **width**=*value*  
    &nbsp;&nbsp;&nbsp;&nbsp;Width for display monitor if not set by GRASS_RENDER_WIDTH  
    &nbsp;&nbsp;&nbsp;&nbsp;Default value: 720  
    **height**=*value*  
    &nbsp;&nbsp;&nbsp;&nbsp;Height for display monitor if not set by GRASS_RENDER_HEIGHT  
    &nbsp;&nbsp;&nbsp;&nbsp;Default value: 480  
    **resolution**=*value*  
    &nbsp;&nbsp;&nbsp;&nbsp;Dimensions of display monitor versus current size  
    &nbsp;&nbsp;&nbsp;&nbsp;Example: resolution=2 enlarge display monitor twice to 1280x960  
    **bgcolor**=*name*  
    &nbsp;&nbsp;&nbsp;&nbsp;Background color  
    &nbsp;&nbsp;&nbsp;&nbsp;Either a standard color name, R:G:B triplet, or "none"  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *white*  
    **output**=*name*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name for output file (when starting new monitor)  
    &nbsp;&nbsp;&nbsp;&nbsp;Ignored for 'wx' monitors  
    **-l**  
    &nbsp;&nbsp;&nbsp;&nbsp;List running monitors and exit  
    **-p**  
    &nbsp;&nbsp;&nbsp;&nbsp;Print name of currently selected monitor and exit  
    **-c**  
    &nbsp;&nbsp;&nbsp;&nbsp;Print commands for currently selected monitor and exit  
    **-g**  
    &nbsp;&nbsp;&nbsp;&nbsp;Print path to support files of currently selected monitor and exit  
    **-s**  
    &nbsp;&nbsp;&nbsp;&nbsp;Do not automatically select when starting  
    **-r**  
    &nbsp;&nbsp;&nbsp;&nbsp;Release and stop currently selected monitor and exit  
    **-t**  
    &nbsp;&nbsp;&nbsp;&nbsp;Disable true colors  
    **-u**  
    &nbsp;&nbsp;&nbsp;&nbsp;Open output file in update mode  
    &nbsp;&nbsp;&nbsp;&nbsp;Requires --overwrite flag  
    **-x**  
    &nbsp;&nbsp;&nbsp;&nbsp;Launch light-weight wx monitor without toolbars and statusbar  
    &nbsp;&nbsp;&nbsp;&nbsp;Requires 'start=wx0-7'  
    **--overwrite**  
    &nbsp;&nbsp;&nbsp;&nbsp;Allow output files to overwrite existing files  
    **--help**  
    &nbsp;&nbsp;&nbsp;&nbsp;Print usage summary  
    **--verbose**  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    **--quiet**  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    **--qq**  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    **--ui**  
    &nbsp;&nbsp;&nbsp;&nbsp;Force launching GUI dialog

=== "Python (grass.script)"

    **start** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of monitor to start  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *wx0, wx1, wx2, wx3, wx4, wx5, wx6, wx7, png, ps, html, cairo*  
    **stop** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of monitor to stop  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *wx0, wx1, wx2, wx3, wx4, wx5, wx6, wx7, png, ps, html, cairo*  
    **select** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of monitor to select  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *wx0, wx1, wx2, wx3, wx4, wx5, wx6, wx7, png, ps, html, cairo*  
    **width** : int, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Width for display monitor if not set by GRASS_RENDER_WIDTH  
    &nbsp;&nbsp;&nbsp;&nbsp;Default value: 720  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: *value*  
    **height** : int, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Height for display monitor if not set by GRASS_RENDER_HEIGHT  
    &nbsp;&nbsp;&nbsp;&nbsp;Default value: 480  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: *value*  
    **resolution** : int, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Dimensions of display monitor versus current size  
    &nbsp;&nbsp;&nbsp;&nbsp;Example: resolution=2 enlarge display monitor twice to 1280x960  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: *value*  
    **bgcolor** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Background color  
    &nbsp;&nbsp;&nbsp;&nbsp;Either a standard color name, R:G:B triplet, or "none"  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, color, *name*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *white*  
    **output** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name for output file (when starting new monitor)  
    &nbsp;&nbsp;&nbsp;&nbsp;Ignored for 'wx' monitors  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: output, file, *name*  
    **flags** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *l*, *p*, *c*, *g*, *s*, *r*, *t*, *u*, *x*  
    &nbsp;&nbsp;&nbsp;&nbsp;**l**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;List running monitors and exit  
    &nbsp;&nbsp;&nbsp;&nbsp;**p**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Print name of currently selected monitor and exit  
    &nbsp;&nbsp;&nbsp;&nbsp;**c**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Print commands for currently selected monitor and exit  
    &nbsp;&nbsp;&nbsp;&nbsp;**g**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Print path to support files of currently selected monitor and exit  
    &nbsp;&nbsp;&nbsp;&nbsp;**s**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Do not automatically select when starting  
    &nbsp;&nbsp;&nbsp;&nbsp;**r**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Release and stop currently selected monitor and exit  
    &nbsp;&nbsp;&nbsp;&nbsp;**t**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Disable true colors  
    &nbsp;&nbsp;&nbsp;&nbsp;**u**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Open output file in update mode  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Requires --overwrite flag  
    &nbsp;&nbsp;&nbsp;&nbsp;**x**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Launch light-weight wx monitor without toolbars and statusbar  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Requires 'start=wx0-7'  
    **overwrite** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allow output files to overwrite existing files  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **verbose** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **quiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **superquiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  

=== "Python (grass.tools)"

    **start** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of monitor to start  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *wx0, wx1, wx2, wx3, wx4, wx5, wx6, wx7, png, ps, html, cairo*  
    **stop** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of monitor to stop  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *wx0, wx1, wx2, wx3, wx4, wx5, wx6, wx7, png, ps, html, cairo*  
    **select** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of monitor to select  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *wx0, wx1, wx2, wx3, wx4, wx5, wx6, wx7, png, ps, html, cairo*  
    **width** : int, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Width for display monitor if not set by GRASS_RENDER_WIDTH  
    &nbsp;&nbsp;&nbsp;&nbsp;Default value: 720  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: *value*  
    **height** : int, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Height for display monitor if not set by GRASS_RENDER_HEIGHT  
    &nbsp;&nbsp;&nbsp;&nbsp;Default value: 480  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: *value*  
    **resolution** : int, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Dimensions of display monitor versus current size  
    &nbsp;&nbsp;&nbsp;&nbsp;Example: resolution=2 enlarge display monitor twice to 1280x960  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: *value*  
    **bgcolor** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Background color  
    &nbsp;&nbsp;&nbsp;&nbsp;Either a standard color name, R:G:B triplet, or "none"  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, color, *name*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *white*  
    **output** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name for output file (when starting new monitor)  
    &nbsp;&nbsp;&nbsp;&nbsp;Ignored for 'wx' monitors  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: output, file, *name*  
    **flags** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *l*, *p*, *c*, *g*, *s*, *r*, *t*, *u*, *x*  
    &nbsp;&nbsp;&nbsp;&nbsp;**l**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;List running monitors and exit  
    &nbsp;&nbsp;&nbsp;&nbsp;**p**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Print name of currently selected monitor and exit  
    &nbsp;&nbsp;&nbsp;&nbsp;**c**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Print commands for currently selected monitor and exit  
    &nbsp;&nbsp;&nbsp;&nbsp;**g**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Print path to support files of currently selected monitor and exit  
    &nbsp;&nbsp;&nbsp;&nbsp;**s**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Do not automatically select when starting  
    &nbsp;&nbsp;&nbsp;&nbsp;**r**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Release and stop currently selected monitor and exit  
    &nbsp;&nbsp;&nbsp;&nbsp;**t**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Disable true colors  
    &nbsp;&nbsp;&nbsp;&nbsp;**u**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Open output file in update mode  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Requires --overwrite flag  
    &nbsp;&nbsp;&nbsp;&nbsp;**x**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Launch light-weight wx monitor without toolbars and statusbar  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Requires 'start=wx0-7'  
    **overwrite** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allow output files to overwrite existing files  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **verbose** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **quiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **superquiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  

    Returns:

    **result** : grass.tools.support.ToolResult | None  
    If the tool produces text as standard output, a *ToolResult* object will be returned. Otherwise, `None` will be returned.

    Raises:

    *grass.tools.ToolError*: When the tool ended with an error.

## DESCRIPTION

*d.mon* allows the user to start, select, list, release, and stop
available graphics monitors.

### Starting a monitor

In order to display on-screen GRASS graphics, the user must **start**
and **select** a graphics monitor. By default, the **start** command
actually runs two commands, to both start and select whatever monitor is
named by the user. The user can get a list of running monitors by
setting the **-l** flag on the command line. Note that some monitor
[drivers](displaydrivers.md) use environment *[variables](variables.md)*
or the specific *[driver
documentation](variables.md#list-of-selected-grass-environment-variables-for-rendering)*.

When a monitor is *started*, it is therefore also (automatically)
*selected* for output, unless the **-s** flag is set by the user; the
user can also explicitly **select** a monitor that has been started.

The desired monitor should be started once and need not be restarted
unless it is stopped for some reason. A monitor may continue to run for
any length of time, even when no GRASS session is being run.

### Listing currently running monitors

A graphics monitor has two different types of status: monitor program
*not running*, and monitor *running*. A monitor that has been started
and/or selected will be listed as running; a monitor that has been
stopped (or not started) will be listed as not running. The **-l** flag
will list all currently running monitors.

### Selecting a monitor

When the user *starts* a monitor, it is also (automatically) *selected*
for graphics output unless the user sets the **-s** flag. In order to
use (direct graphics output to) a monitor, the user must *select* that
monitor for use, either by simply starting the monitor without the
**-s** flag or by explicitly selecting the monitor for output. Only
running monitors can be selected for graphics output.

The user can run multiple graphics monitors by simply starting each of
the graphics monitors the user wishes to direct output to.

### Releasing (unselecting) a monitor

Currently *selected* a monitor can be released by **-r** flag.

## NOTES

*d.mon* is designed for interactive use. If non-interactive use is
needed (e.g., in a script) set `GRASS_RENDER_IMMEDIATE=png` (or
`=cairo`) and use the related environment [variables](variables.md) to
control output size etc.

## EXAMPLES

### wx0 monitor

To start the interactive *[wxGUI map
display](wxGUI.md#map-display-window)*, run

```sh
d.mon start=wx0
```

![Blank wx0 display](d_mon_wx0.png)  
*Figure: The initialization of display monitor wx0*

All subsequently displayed data will be rendered on monitor `wx0`.

```sh
g.region raster=elevation -p
d.rast map=elevation
```

![Display wx0 with raster map](d_mon_wx0_raster.png)  
*Figure: The display wx0 showing an elevation raster map*

### CAIRO file renderer monitor

A CAIRO monitor can be started (and selected) by

```sh
d.mon start=cairo output=out.pdf
```

From this moment on all displayed data will be rendered into file
`output.pdf`.

### List running monitors

To list the currently running monitors, use

```sh
d.mon -l

List of running monitors:
wx0
cairo
```

### Show currently selected monitor

To identify the currently selected monitor, use

```sh
d.mon -p

cairo
```

### Switching between monitors

To switch back to interactive display mode, here to an earlier started
and still running wxGUI monitor, use

```sh
d.mon select=wx0
```

### Stopping a monitor

To close the wxGUI monitor, run

```sh
d.mon stop=wx0
```

## SEE ALSO

*[d.erase](d.erase.md), [d.redraw](d.redraw.md), [d.rast](d.rast.md),
[d.vect](d.vect.md), [d.frame](d.frame.md)*

See also [list of variables for
rendering](variables.md#list-of-selected-grass-environment-variables-for-rendering),
[display drivers](displaydrivers.md)

## AUTHOR

Martin Landa, OSGeoREL, Czech Technical University in Prague, Czech
Republic

## SOURCE CODE

Available at: [d.mon source code](https://github.com/OSGeo/grass/tree/main/display/d.mon)
([history](https://github.com/OSGeo/grass/commits/main/display/d.mon))  
Latest change: Thursday May 08 14:17:52 2025 in commit [3caa352](https://github.com/OSGeo/grass/commit/3caa352f78f86a51ca463a6f1ba7ffe3db9771df)
