---
name: g.copy
description: Creates copies of maps and other elements Copies available data files in the current mapset search path to the user's current mapset.
keywords: [ general, map management, copy ]
---

# g.copy

Creates copies of maps and other elements

Copies available data files in the current mapset search path to the user's current mapset.

=== "Command line"

    **g.copy**
    [**raster**=*from,to*]
    [**raster_3d**=*from,to*]
    [**vector**=*from,to*]
    [**label**=*from,to*]
    [**region**=*from,to*]
    [**group**=*from,to*]
    [**--overwrite**]
    [**--verbose**]
    [**--quiet**]
    [**--qq**]
    [**--ui**]

    Example:

    ```sh
    g.copy
    ```

=== "Python (grass.script)"

    *grass.script.run_command*("***g.copy***",
        **raster**=*None*,
        **raster_3d**=*None*,
        **vector**=*None*,
        **label**=*None*,
        **region**=*None*,
        **group**=*None*,
        **overwrite**=*None*,
        **verbose**=*None*,
        **quiet**=*None*,
        **superquiet**=*None*)

    Example:

    ```python
    gs.run_command("g.copy")
    ```

=== "Python (grass.tools)"

    *grass.tools.Tools.g_copy*(**raster**=*None*,
        **raster_3d**=*None*,
        **vector**=*None*,
        **label**=*None*,
        **region**=*None*,
        **group**=*None*,
        **overwrite**=*None*,
        **verbose**=*None*,
        **quiet**=*None*,
        **superquiet**=*None*)

    Example:

    ```python
    tools = Tools()
    tools.g_copy()
    ```

    This grass.tools API is experimental in version 8.5 and expected to be stable in version 8.6.

## Parameters

=== "Command line"

    **raster**=*from,to*  
    &nbsp;&nbsp;&nbsp;&nbsp;raster map(s) to be copied  
    **raster_3d**=*from,to*  
    &nbsp;&nbsp;&nbsp;&nbsp;3D raster map(s) to be copied  
    **vector**=*from,to*  
    &nbsp;&nbsp;&nbsp;&nbsp;vector map(s) to be copied  
    **label**=*from,to*  
    &nbsp;&nbsp;&nbsp;&nbsp;paint label file(s) to be copied  
    **region**=*from,to*  
    &nbsp;&nbsp;&nbsp;&nbsp;region definition(s) to be copied  
    **group**=*from,to*  
    &nbsp;&nbsp;&nbsp;&nbsp;imagery group(s) to be copied  
    **--overwrite**  
    &nbsp;&nbsp;&nbsp;&nbsp;Allow output files to overwrite existing files  
    **--help**  
    &nbsp;&nbsp;&nbsp;&nbsp;Print usage summary  
    **--verbose**  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    **--quiet**  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    **--qq**  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    **--ui**  
    &nbsp;&nbsp;&nbsp;&nbsp;Force launching GUI dialog

=== "Python (grass.script)"

    **raster** : tuple[str, str] | list[str] | str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;raster map(s) to be copied  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, raster, *from,to*  
    **raster_3d** : tuple[str, str] | list[str] | str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;3D raster map(s) to be copied  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, 3D raster, *from,to*  
    **vector** : tuple[str, str] | list[str] | str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;vector map(s) to be copied  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, vector, *from,to*  
    **label** : tuple[str, str] | list[str] | str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;paint label file(s) to be copied  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, label, *from,to*  
    **region** : tuple[str, str] | list[str] | str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;region definition(s) to be copied  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, region definition, *from,to*  
    **group** : tuple[str, str] | list[str] | str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;imagery group(s) to be copied  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, imagery group, *from,to*  
    **overwrite** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allow output files to overwrite existing files  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **verbose** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **quiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **superquiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  

=== "Python (grass.tools)"

    **raster** : tuple[str | np.ndarray, str | np.ndarray] | list[str | np.ndarray] | str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;raster map(s) to be copied  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, raster, *from,to*  
    **raster_3d** : tuple[str, str] | list[str] | str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;3D raster map(s) to be copied  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, 3D raster, *from,to*  
    **vector** : tuple[str, str] | list[str] | str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;vector map(s) to be copied  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, vector, *from,to*  
    **label** : tuple[str, str] | list[str] | str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;paint label file(s) to be copied  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, label, *from,to*  
    **region** : tuple[str, str] | list[str] | str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;region definition(s) to be copied  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, region definition, *from,to*  
    **group** : tuple[str, str] | list[str] | str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;imagery group(s) to be copied  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, imagery group, *from,to*  
    **overwrite** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allow output files to overwrite existing files  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **verbose** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **quiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **superquiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  

    Returns:

    **result** : grass.tools.support.ToolResult | None  
    If the tool produces text as standard output, a *ToolResult* object will be returned. Otherwise, `None` will be returned.

    Raises:

    *grass.tools.ToolError*: When the tool ended with an error.

## DESCRIPTION

The *g.copy* module creates a copy of existing raster maps, vector maps,
or other elements. The copy is always created in the current mapset. The
source data can be in the current mapset, in an explicitly specified
mapset, or in a mapset which is in the current mapset search path
(typically the PERMANENT mapset).

The maps and other elements to copy are specified in pairs
**from**,**to** according to their types. Although typically only one
map is copied in one module call, multiple pairs can be provided for
each type and multiple types can be provided at the same time.

### Relation to mapsets

A user may access data stored under the other mapsets listed in their
mapset search path. However, the user may only modify data stored under
their own current mapset. *g.copy* allows the user to copy existing data
files **from** other mapsets **to** the user's current mapset
(`g.mapset -p`). The files to be copied must exist in the user's current
mapset search path (`g.mapsets -p`) and project; output is sent to the
relevant data element directory(ies) under the user's current mapset.

### Behavior on error

Errors typically occur when a map or other element does not exist,
**from** and **to** are the same, **to** element already exists and
overwriting (e.g., by **--overwrite**) is not enabled, or the **to**
element has an illegal name. When only one map or other element is
requested to be copied and the copying is not possible or fails, an
error is reported.

If multiple maps or other elements are copied in one command, *g.copy*
attempts to copy as much as possible even when problems occur with one
of the elements. In that case, copying of the element causing problems
is skipped, and *g.copy* proceeds with copying the remaining elements.
If nothing can be copied or an error occurred during one of the copy
operations, an error message is reported after other possible copy
operations were performed.

## EXAMPLES

If the user wished to copy the existing raster file *soils* to a file
called *soils.ph* and to copy an existing vector map *roads* to a file
called *rds.old*, the user could type:

```sh
g.copy raster=soils,soils.ph
g.copy vector=roads,rds.old

# or even combined:
g.copy raster=soils,soils.ph vector=roads,rds.old
```

Data files can also be specified by their mapsets. For example, the
below command copies the raster map named *soils* from the mapset
*wilson* to a new file called *soils* to be placed under the user's
current mapset:

```sh
g.copy raster=soils@wilson,soils
```

If no mapset name is specified, *g.copy* searches for the named **from**
map in each of the mapset directories listed in the user's current
mapset search path in the order in which mapsets are listed there (see
*[g.mapsets](g.mapsets.md)*).

## SEE ALSO

*[g.access](g.access.md), [g.list](g.list.md),
[g.mapsets](g.mapsets.md), [g.remove](g.remove.md),
[g.rename](g.rename.md)*

## AUTHOR

Michael Shapiro, U.S. Army Construction Engineering Research Laboratory

## SOURCE CODE

Available at: [g.copy source code](https://github.com/OSGeo/grass/tree/main/general/g.copy)
([history](https://github.com/OSGeo/grass/commits/main/general/g.copy))  
Latest change: Friday Feb 07 19:16:09 2025 in commit [a82a39f](https://github.com/OSGeo/grass/commit/a82a39f673b97fafcfce1604dc3e6015cb96487a)
