---
name: g.mapset
description: Changes or reports current mapset. Optionally, creates new mapset or lists available mapsets in given project (location).
keywords: [ general, settings, project ]
---

# g.mapset

Changes or reports current mapset.

Optionally, creates new mapset or lists available mapsets in given project (location).

=== "Command line"

    **g.mapset**
    [**-clp**]
    **mapset**=*name*
    [**project**=*name*]
    [**dbase**=*path*]
    **format**=*name*
    [**--overwrite**]
    [**--verbose**]
    [**--quiet**]
    [**--qq**]
    [**--ui**]

    Example:

    ```sh
    g.mapset mapset=name format=plain
    ```

=== "Python (grass.script)"

    *grass.script.parse_command*("***g.mapset***",
        **mapset**,
        **project**=*None*,
        **dbase**=*None*,
        **format**=*"plain"*,
        **flags**=*None*,
        **overwrite**=*None*,
        **verbose**=*None*,
        **quiet**=*None*,
        **superquiet**=*None*)

    Example:

    ```python
    gs.parse_command("g.mapset", mapset="name", format="json")
    ```

=== "Python (grass.tools)"

    *grass.tools.Tools.g_mapset*(**mapset**,
        **project**=*None*,
        **dbase**=*None*,
        **format**=*"plain"*,
        **flags**=*None*,
        **overwrite**=*None*,
        **verbose**=*None*,
        **quiet**=*None*,
        **superquiet**=*None*)

    Example:

    ```python
    tools = Tools()
    tools.g_mapset(mapset="name", format="json")
    ```

    This grass.tools API is experimental in version 8.5 and expected to be stable in version 8.6.

## Parameters

=== "Command line"

    **mapset**=*name* **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of mapset (default: current search path)  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of mapset where to switch  
    **project**=*name*  
    &nbsp;&nbsp;&nbsp;&nbsp;Project (location) name  
    &nbsp;&nbsp;&nbsp;&nbsp;Project name (not path to project)  
    **dbase**=*path*  
    &nbsp;&nbsp;&nbsp;&nbsp;GRASS database directory  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: path to the current GRASS database  
    **format**=*name* **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;Output format  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *plain, json*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *plain*  
    &nbsp;&nbsp;&nbsp;&nbsp;**plain**: Plain text output  
    &nbsp;&nbsp;&nbsp;&nbsp;**json**: JSON (JavaScript Object Notation)  
    **-c**  
    &nbsp;&nbsp;&nbsp;&nbsp;Create mapset if it doesn't exist  
    **-l**  
    &nbsp;&nbsp;&nbsp;&nbsp;List available mapsets and exit  
    **-p**  
    &nbsp;&nbsp;&nbsp;&nbsp;Print current mapset and exit  
    **--overwrite**  
    &nbsp;&nbsp;&nbsp;&nbsp;Allow output files to overwrite existing files  
    **--help**  
    &nbsp;&nbsp;&nbsp;&nbsp;Print usage summary  
    **--verbose**  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    **--quiet**  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    **--qq**  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    **--ui**  
    &nbsp;&nbsp;&nbsp;&nbsp;Force launching GUI dialog

=== "Python (grass.script)"

    **mapset** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of mapset (default: current search path)  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of mapset where to switch  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: output, mapset, *name*  
    **project** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Project (location) name  
    &nbsp;&nbsp;&nbsp;&nbsp;Project name (not path to project)  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, location, *name*  
    **dbase** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;GRASS database directory  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: path to the current GRASS database  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, dbase, *path*  
    **format** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Output format  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: *name*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *plain, json*  
    &nbsp;&nbsp;&nbsp;&nbsp;**plain**: Plain text output  
    &nbsp;&nbsp;&nbsp;&nbsp;**json**: JSON (JavaScript Object Notation)  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *plain*  
    **flags** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *c*, *l*, *p*  
    &nbsp;&nbsp;&nbsp;&nbsp;**c**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Create mapset if it doesn't exist  
    &nbsp;&nbsp;&nbsp;&nbsp;**l**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;List available mapsets and exit  
    &nbsp;&nbsp;&nbsp;&nbsp;**p**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Print current mapset and exit  
    **overwrite** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allow output files to overwrite existing files  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **verbose** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **quiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **superquiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  

=== "Python (grass.tools)"

    **mapset** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of mapset (default: current search path)  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of mapset where to switch  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: output, mapset, *name*  
    **project** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Project (location) name  
    &nbsp;&nbsp;&nbsp;&nbsp;Project name (not path to project)  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, location, *name*  
    **dbase** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;GRASS database directory  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: path to the current GRASS database  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, dbase, *path*  
    **format** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Output format  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: *name*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *plain, json*  
    &nbsp;&nbsp;&nbsp;&nbsp;**plain**: Plain text output  
    &nbsp;&nbsp;&nbsp;&nbsp;**json**: JSON (JavaScript Object Notation)  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *plain*  
    **flags** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *c*, *l*, *p*  
    &nbsp;&nbsp;&nbsp;&nbsp;**c**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Create mapset if it doesn't exist  
    &nbsp;&nbsp;&nbsp;&nbsp;**l**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;List available mapsets and exit  
    &nbsp;&nbsp;&nbsp;&nbsp;**p**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Print current mapset and exit  
    **overwrite** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allow output files to overwrite existing files  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **verbose** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **quiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **superquiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  

    Returns:

    **result** : grass.tools.support.ToolResult | None  
    If the tool produces text as standard output, a *ToolResult* object will be returned. Otherwise, `None` will be returned.

    Raises:

    *grass.tools.ToolError*: When the tool ended with an error.

## DESCRIPTION

*g.mapset* changes the current working mapset, project (formerly known
as location), or GISDBASE (directory with one or more projects).

With *g.mapset*, the shell history (i.e. `.bash_history` file of the
initial project will be used to record the command history.

The *g.mapset* tool can also report the current mapset and all mapsets in
the current project.

## NOTES

By default, the shell continues to use the history for the old mapset.
To change this behaviour the history can be switched to record in the
new mapset's history file as follows:

```sh
# bash example
history -w
history -r /"$GISDBASE/$LOCATION/$MAPSET"/.bash_history
HISTFILE=/"$GISDBASE/$LOCATION/$MAPSET"/.bash_history
```

For parsing the outputs, always use the JSON output. The current *plain* format
may change in a future major release. Please, open an issue if you need a
stable parsable format which is not JSON.

## EXAMPLES

### Print the name of the current mapset

To print the name of the current mapset, use the **-p** command as shown
below:

```sh
# In plain format:
g.mapset -p

# In JSON format:
g.mapset -p format=json
```

To print the name of the current mapset in JSON format using python:

```python
import grass.script as gs

# Run the g.mapset command with -p flag to print the current mapset using JSON
# output format
data = gs.parse_command(
    "g.mapset",
    flags="p",
    format="json",
)

print(f"project: {data['project']}")
print(f"mapset: {data['mapset']}")
```

### List available mapsets

To list available mapsets, use the **-l** command as shown below:

```sh
# In plain format:
g.mapset -l

# In JSON format:
g.mapset -l format=json
```

This should list all the mapsets, such as: "landsat new PERMANENT
user1."

To print the list of available mapsets in JSON format using python:

```python
import grass.script as gs

# Run the g.mapset command with -l flag to list available mapsets using JSON
# output format
data = gs.parse_command(
    "g.mapset",
    flags="l",
    format="json",
)

print(f"project: {data['project']}")
print(f"mapsets: {' '.join(data['mapsets'])}")
```

### Change the current mapset

To change the current mapset to "user1" use the following command:

```sh
g.mapset mapset=user1 project=nc_spm_08_grass7
```

You should receive the following message: "Mapset switched. Your shell
continues to use the history for the old mapset."

### Create a new mapset

To create a new mapset, use the **-c** tag as shown below:

```sh
g.mapset -c mapset=new project=nc_spm_08_grass7
```

## SEE ALSO

*[g.gisenv](g.gisenv.md), [g.mapsets](g.mapsets.md)*

## AUTHOR

Radim Blazek

## SOURCE CODE

Available at: [g.mapset source code](https://github.com/OSGeo/grass/tree/main/general/g.mapset)
([history](https://github.com/OSGeo/grass/commits/main/general/g.mapset))  
Latest change: Thursday Oct 02 14:39:13 2025 in commit [1850489](https://github.com/OSGeo/grass/commit/1850489bf42c72d8dcfe2e4db1738441b4a7dc43)
