---
name: r.resample
description: GRASS raster map layer data resampling capability.
keywords: [ raster, resample, nearest neighbor ]
---

# r.resample

GRASS raster map layer data resampling capability.

=== "Command line"

    **r.resample**
    **input**=*string*
    **output**=*string*
    [**--overwrite**]
    [**--verbose**]
    [**--quiet**]
    [**--qq**]
    [**--ui**]

    Example:

    ```sh
    r.resample input=string output=string
    ```

=== "Python (grass.script)"

    *grass.script.run_command*("***r.resample***",
        **input**,
        **output**,
        **overwrite**=*None*,
        **verbose**=*None*,
        **quiet**=*None*,
        **superquiet**=*None*)

    Example:

    ```python
    gs.run_command("r.resample", input="string", output="string")
    ```

=== "Python (grass.tools)"

    *grass.tools.Tools.r_resample*(**input**,
        **output**,
        **overwrite**=*None*,
        **verbose**=*None*,
        **quiet**=*None*,
        **superquiet**=*None*)

    Example:

    ```python
    tools = Tools()
    tools.r_resample(input="string", output="string")
    ```

    This grass.tools API is experimental in version 8.5 and expected to be stable in version 8.6.

## Parameters

=== "Command line"

    **input**=*string* **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of an input layer  
    **output**=*string* **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of an output layer  
    **--overwrite**  
    &nbsp;&nbsp;&nbsp;&nbsp;Allow output files to overwrite existing files  
    **--help**  
    &nbsp;&nbsp;&nbsp;&nbsp;Print usage summary  
    **--verbose**  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    **--quiet**  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    **--qq**  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    **--ui**  
    &nbsp;&nbsp;&nbsp;&nbsp;Force launching GUI dialog

=== "Python (grass.script)"

    **input** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of an input layer  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, raster  
    **output** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of an output layer  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: output, raster  
    **overwrite** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allow output files to overwrite existing files  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **verbose** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **quiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **superquiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  

=== "Python (grass.tools)"

    **input** : str | np.ndarray, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of an input layer  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, raster  
    **output** : str | type(np.ndarray) | type(np.array) | type(gs.array.array), *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of an output layer  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: output, raster  
    **overwrite** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allow output files to overwrite existing files  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **verbose** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **quiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **superquiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  

    Returns:

    **result** : grass.tools.support.ToolResult | np.ndarray | tuple[np.ndarray] | None  
    If the tool produces text as standard output, a *ToolResult* object will be returned. Otherwise, `None` will be returned. If an array type (e.g., *np.ndarray*) is used for one of the raster outputs, the result will be an array and will have the shape corresponding to the computational region. If an array type is used for more than one raster output, the result will be a tuple of arrays.

    Raises:

    *grass.tools.ToolError*: When the tool ended with an error.

## DESCRIPTION

*r.resample* resamples the data values in a user-specified raster input
map layer *name* (bounded by the current geographic region and masked by
the current mask), and produces a new raster output map layer *name*
containing the results of the resampling. The category values in the new
raster output map layer will be the same as those in the original,
except that the resolution and extent of the new raster output map layer
will match those of the current geographic region settings (see
*[g.region](g.region.md)*). *r.resample* is intended for resampling of
discrete raster data (such as land cover, geology or soil type) to a
different resolution. Continuous data (such as elevation or temperature)
usually require reinterpolation when changing resolution, see
*[r.resamp.interp](r.resamp.interp.md)*.

## NOTES

The method by which resampling is conducted is "nearest neighbor" (see
*[r.neighbors](r.neighbors.md)*). The resulting raster map layer will
have the same resolution as the resolution of the current geographic
region (set using *[g.region](g.region.md)*).

The resulting raster map layer may be identical to the original raster
map layer. The *r.resample* program will copy the color table and
history file associated with the original raster map layer for the
resulting raster map layer and will create a modified category file
which contains description of only those categories which appear in
resampled file.

When the user resamples a GRASS *reclass* file, a true raster map is
created by *r.resample*.

## SEE ALSO

*[g.region](g.region.md), [r.mapcalc](r.mapcalc.md),
[r.mfilter](r.mfilter.md), [r.neighbors](r.neighbors.md),
[r.rescale](r.rescale.md), [r.resamp.interp](r.resamp.interp.md)*

Overview: [Interpolation and
Resampling](https://grasswiki.osgeo.org/wiki/Interpolation) in GRASS

## AUTHOR

Michael Shapiro, U.S.Army Construction Engineering Research Laboratory

## SOURCE CODE

Available at: [r.resample source code](https://github.com/OSGeo/grass/tree/main/raster/r.resample)
([history](https://github.com/OSGeo/grass/commits/main/raster/r.resample))  
Latest change: Friday Aug 08 09:39:19 2025 in commit [ed72c71](https://github.com/OSGeo/grass/commit/ed72c71d8580e872cd6fd345c84a15c324764465)
