---
name: r.topmodel
description: Simulates TOPMODEL which is a physically based hydrologic model.
keywords: [ raster, hydrology, model ]
---

# r.topmodel

Simulates TOPMODEL which is a physically based hydrologic model.

=== "Command line"

    **r.topmodel**
    [**-p**]
    **parameters**=*name*
    **topidxstats**=*name*
    **input**=*name*
    **output**=*name*
    [**timestep**=*integer*]
    [**topidxclass**=*integer*]
    [**topidx**=*name*]
    [**ntopidxclasses**=*integer*]
    [**outtopidxstats**=*name*]
    [**--overwrite**]
    [**--verbose**]
    [**--quiet**]
    [**--qq**]
    [**--ui**]

    Example:

    ```sh
    r.topmodel parameters=name topidxstats=name input=name output=name
    ```

=== "Python (grass.script)"

    *grass.script.run_command*("***r.topmodel***",
        **parameters**,
        **topidxstats**,
        **input**,
        **output**,
        **timestep**=*None*,
        **topidxclass**=*None*,
        **topidx**=*None*,
        **ntopidxclasses**=*30*,
        **outtopidxstats**=*None*,
        **flags**=*None*,
        **overwrite**=*None*,
        **verbose**=*None*,
        **quiet**=*None*,
        **superquiet**=*None*)

    Example:

    ```python
    gs.run_command("r.topmodel", parameters="name", topidxstats="name", input="name", output="name")
    ```

=== "Python (grass.tools)"

    *grass.tools.Tools.r_topmodel*(**parameters**,
        **topidxstats**,
        **input**,
        **output**,
        **timestep**=*None*,
        **topidxclass**=*None*,
        **topidx**=*None*,
        **ntopidxclasses**=*30*,
        **outtopidxstats**=*None*,
        **flags**=*None*,
        **overwrite**=*None*,
        **verbose**=*None*,
        **quiet**=*None*,
        **superquiet**=*None*)

    Example:

    ```python
    tools = Tools()
    tools.r_topmodel(parameters="name", topidxstats="name", input="name", output="name")
    ```

    This grass.tools API is experimental in version 8.5 and expected to be stable in version 8.6.

## Parameters

=== "Command line"

    **parameters**=*name* **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of input TOPMODEL parameters file  
    **topidxstats**=*name* **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of input topographic index statistics file  
    **input**=*name* **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of input rainfall and potential evapotranspiration data file  
    **output**=*name* **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;Name for output file  
    **timestep**=*integer*  
    &nbsp;&nbsp;&nbsp;&nbsp;Time step  
    &nbsp;&nbsp;&nbsp;&nbsp;Generate output for this time step  
    **topidxclass**=*integer*  
    &nbsp;&nbsp;&nbsp;&nbsp;Topographic index class  
    &nbsp;&nbsp;&nbsp;&nbsp;Generate output for this topographic index class  
    **topidx**=*name*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of input topographic index raster map  
    &nbsp;&nbsp;&nbsp;&nbsp;Must be clipped to the catchment boundary. Used for generating outtopidxstats  
    **ntopidxclasses**=*integer*  
    &nbsp;&nbsp;&nbsp;&nbsp;Number of topographic index classes  
    &nbsp;&nbsp;&nbsp;&nbsp;Used for generating outtopidxstats  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *30*  
    **outtopidxstats**=*name*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name for output topographic index statistics file  
    &nbsp;&nbsp;&nbsp;&nbsp;Requires topidx and ntopidxclasses  
    **-p**  
    &nbsp;&nbsp;&nbsp;&nbsp;Preprocess only and stop after generating outtopidxstats  
    **--overwrite**  
    &nbsp;&nbsp;&nbsp;&nbsp;Allow output files to overwrite existing files  
    **--help**  
    &nbsp;&nbsp;&nbsp;&nbsp;Print usage summary  
    **--verbose**  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    **--quiet**  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    **--qq**  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    **--ui**  
    &nbsp;&nbsp;&nbsp;&nbsp;Force launching GUI dialog

=== "Python (grass.script)"

    **parameters** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of input TOPMODEL parameters file  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, file, *name*  
    **topidxstats** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of input topographic index statistics file  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, file, *name*  
    **input** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of input rainfall and potential evapotranspiration data file  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, file, *name*  
    **output** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name for output file  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: output, file, *name*  
    **timestep** : int, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Time step  
    &nbsp;&nbsp;&nbsp;&nbsp;Generate output for this time step  
    **topidxclass** : int, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Topographic index class  
    &nbsp;&nbsp;&nbsp;&nbsp;Generate output for this topographic index class  
    **topidx** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of input topographic index raster map  
    &nbsp;&nbsp;&nbsp;&nbsp;Must be clipped to the catchment boundary. Used for generating outtopidxstats  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, raster, *name*  
    **ntopidxclasses** : int, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Number of topographic index classes  
    &nbsp;&nbsp;&nbsp;&nbsp;Used for generating outtopidxstats  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *30*  
    **outtopidxstats** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name for output topographic index statistics file  
    &nbsp;&nbsp;&nbsp;&nbsp;Requires topidx and ntopidxclasses  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: output, file, *name*  
    **flags** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *p*  
    &nbsp;&nbsp;&nbsp;&nbsp;**p**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Preprocess only and stop after generating outtopidxstats  
    **overwrite** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allow output files to overwrite existing files  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **verbose** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **quiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **superquiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  

=== "Python (grass.tools)"

    **parameters** : str | io.StringIO, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of input TOPMODEL parameters file  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, file, *name*  
    **topidxstats** : str | io.StringIO, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of input topographic index statistics file  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, file, *name*  
    **input** : str | io.StringIO, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of input rainfall and potential evapotranspiration data file  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, file, *name*  
    **output** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name for output file  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: output, file, *name*  
    **timestep** : int, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Time step  
    &nbsp;&nbsp;&nbsp;&nbsp;Generate output for this time step  
    **topidxclass** : int, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Topographic index class  
    &nbsp;&nbsp;&nbsp;&nbsp;Generate output for this topographic index class  
    **topidx** : str | np.ndarray, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of input topographic index raster map  
    &nbsp;&nbsp;&nbsp;&nbsp;Must be clipped to the catchment boundary. Used for generating outtopidxstats  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, raster, *name*  
    **ntopidxclasses** : int, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Number of topographic index classes  
    &nbsp;&nbsp;&nbsp;&nbsp;Used for generating outtopidxstats  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *30*  
    **outtopidxstats** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name for output topographic index statistics file  
    &nbsp;&nbsp;&nbsp;&nbsp;Requires topidx and ntopidxclasses  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: output, file, *name*  
    **flags** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *p*  
    &nbsp;&nbsp;&nbsp;&nbsp;**p**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Preprocess only and stop after generating outtopidxstats  
    **overwrite** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allow output files to overwrite existing files  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **verbose** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **quiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **superquiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  

    Returns:

    **result** : grass.tools.support.ToolResult | None  
    If the tool produces text as standard output, a *ToolResult* object will be returned. Otherwise, `None` will be returned.

    Raises:

    *grass.tools.ToolError*: When the tool ended with an error.

## DESCRIPTION

*r.topmodel* simulates TOPMODEL which is a physically based hydrologic
model.

### Parameters description

**parameters**  
This file contains TOPMODEL parameters that describe the study area. Any
lines starting with a \# sign or empty lines are ignored.

```sh
# Subcatchment name
Subcatchment 1

################################################################################
# A [m^2]: Total subcatchment area
3.31697E+07

################################################################################
# qs0 [m/h]: Initial subsurface flow per unit area
#       "The first streamflow input is assumed to represent
#        only the subsurface flow contribution in the watershed."
#                               - Liaw (1988)
0.000075

# lnTe [ln(m^2/h)]: Areal average of the soil surface transmissivity
4.

# m [m]: Parameter controlling the decline rate of transmissivity
# See Beven and Kirkby (1979)
0.0125

# Sr0 [m]: Initial root zone storage deficit
0.0025

# Srmax [m]: Maximum root zone storage deficit
0.041

# td [h]: Unsaturated zone time delay per unit storage deficit if greater than 0
#  OR
# -alpha: Effective vertical hydraulic gradient if not greater than 0.
#
# For example, -10 means alpha=10.
60.

# vch [m/h]: Main channel routing velocity
20000.

# vr [m/h]: Internal subcatchment routing velocity
10000.

################################################################################
# infex: Calculate infiltration excess if not zero (integer)
0

# K0 [m/h]: Surface hydraulic conductivity
2.

# psi [m]: Wetting front suction
0.1

# dtheta: Water content change across the wetting front
0.1

################################################################################
# d [m]: Distance from the catchment outlet
#       The first value should be the mainstream distance from
#       the subcatchment outlet to the catchment outlet.
# Ad_r:  Cumulative area ratio of subcatchment (0.0 to 1.0)
#       The first and last values should be 0 and 1, respectively.

#   d  Ad_r
    0   0.0
 1000   0.2
 2000   0.4
 3000   0.6
 4000   0.8
 5000   1.0
```

**input**  
This file contains observed weather data.

```sh
# dt [h]: Time step
24

################################################################################
# R [m/dt]:  Rainfall
# Ep [m/dt]: Potential evapotranspiration

# R             Ep
0.000033        0.000000
0.000053        0.011938
0.004821        0.000000
.
.
.
```

**timestep**  
If a time step is specified, output will be generated for the specific
time step in addition to the summary and total flows at the outlet. This
parameter can be combined with **topidxclass** to specify a time step
and topographic index class at the same time. If no **topidxclass** is
given, output will be generated for all the topographic index classes.

**toptopidxclass**  
If a topographic index class is specified, output will be generated for
the given topographic index class. This parameter can be combined with
**timestep**. If no **timestep** is given, output will be generated for
all the time steps.

**topidx**, **ntoptopidxclasses**, **outtoptopidxstats**  
The **topidx** map can optionally be used for creating a new topographic
index statistics file. This map has to be already clipped to the
catchment boundary. The entire range of topographic index values will be
divided into **ntoptopidxclasses** and the area ratio of each class will
be reported in the **outtoptopidxstats** file. These three parameters
can be omitted unless a new **topidxstats** file needs to be created.

## REFERENCES

- Beven, K. J., 1984. Infiltration into a class of vertically
  non-uniform soils. Hydrological Sciences Journal 29 (4), 425-434.
- Beven, K. J., Kirkby, M. J., 1979. A physically based, variable
  contributing area model of basin hydrology. Hydrological Sciences
  Bulletin 24 (1), 43-69.
- Beven K. J., R. Lamb, P. Quinn, R. Romanowicz, and J. Freer, 1995.
  TOPMODEL, in V.P. Singh (Ed.). Computer Models of Watershed Hydrology.
  Water Resources Publications.
- Cho, H., 2000. GIS Hydrological Modeling System by Using Programming
  Interface of GRASS. Master's Thesis, Department of Civil Engineering,
  Kyungpook National University, South Korea.
- Liaw, S. C., 1988. Streamflow Simulation Using a Physically Based
  Hydrologic Model in Humid Forested Watersheds. Dissertation, Colorado
  State University, CO. p163.
- Morel-Seytoux, H. J., Khanji, J., 1974. Derivation of an equation of
  infiltration. Water Resources Research 10 (4), 795-800.

## SEE ALSO

*[r.fill.dir](r.fill.dir.md), [r.mapcalc](r.mapcalc.md),
[r.topidx](r.topidx.md)*  
[How to run r.topmodel](http://idea.isnew.info/r.topmodel.html)

## AUTHORS

[Huidae Cho](mailto:grass4u@gmail-com), Hydro Laboratory, Kyungpook
National University, South Korea

Based on TMOD9502.FOR by Keith Beven.

## SOURCE CODE

Available at: [r.topmodel source code](https://github.com/OSGeo/grass/tree/main/raster/r.topmodel)
([history](https://github.com/OSGeo/grass/commits/main/raster/r.topmodel))  
Latest change: Thursday May 08 20:58:05 2025 in commit [4144ba8](https://github.com/OSGeo/grass/commit/4144ba81fa125e1549fc52e1cf5feb4fa004be8b)
