---
name: t.rast.export.py
description: Exports space time raster dataset.
keywords: [ temporal, export, raster, time ]
---

# t.rast.export.py

Exports space time raster dataset.

=== "Command line"

    **t.rast.export.py**
    **input**=*name*
    **output**=*name*
    [**directory**=*name*]
    [**compression**=*string*]
    [**format**=*string*]
    [**type**=*string*]
    [**createopt**=*string* [,*string*,...]]
    [**metaopt**=*string* [,*string*,...]]
    [**nodata**=*float*]
    [**where**=*sql_query*]
    [**--overwrite**]
    [**--verbose**]
    [**--quiet**]
    [**--qq**]
    [**--ui**]

    Example:

    ```sh
    t.rast.export.py input=name output=name
    ```

=== "Python (grass.script)"

    *grass.script.run_command*("***t.rast.export.py***",
        **input**,
        **output**,
        **directory**=*"./"*,
        **compression**=*"bzip2"*,
        **format**=*"GTiff"*,
        **type**=*None*,
        **createopt**=*None*,
        **metaopt**=*None*,
        **nodata**=*None*,
        **where**=*None*,
        **overwrite**=*None*,
        **verbose**=*None*,
        **quiet**=*None*,
        **superquiet**=*None*)

    Example:

    ```python
    gs.run_command("t.rast.export.py", input="name", output="name")
    ```

=== "Python (grass.tools)"

    *grass.tools.Tools.t_rast_export_py*(**input**,
        **output**,
        **directory**=*"./"*,
        **compression**=*"bzip2"*,
        **format**=*"GTiff"*,
        **type**=*None*,
        **createopt**=*None*,
        **metaopt**=*None*,
        **nodata**=*None*,
        **where**=*None*,
        **overwrite**=*None*,
        **verbose**=*None*,
        **quiet**=*None*,
        **superquiet**=*None*)

    Example:

    ```python
    tools = Tools()
    tools.t_rast_export_py(input="name", output="name")
    ```

    This grass.tools API is experimental in version 8.5 and expected to be stable in version 8.6.

## Parameters

=== "Command line"

    **input**=*name* **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of the input space time raster dataset  
    **output**=*name* **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of a space time raster dataset archive  
    **directory**=*name*  
    &nbsp;&nbsp;&nbsp;&nbsp;Path to the directory where output is written  
    &nbsp;&nbsp;&nbsp;&nbsp;If not given, the default is the current working directory  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *./*  
    **compression**=*string*  
    &nbsp;&nbsp;&nbsp;&nbsp;Compression method of the tar archive  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *no, gzip, bzip2*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *bzip2*  
    **format**=*string*  
    &nbsp;&nbsp;&nbsp;&nbsp;The export format of a single raster map  
    &nbsp;&nbsp;&nbsp;&nbsp;Supported are GTiff, AAIGrid via r.out.gdal and the GRASS package format of r.pack  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *GTiff, AAIGrid, pack*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *GTiff*  
    **type**=*string*  
    &nbsp;&nbsp;&nbsp;&nbsp;Data type  
    &nbsp;&nbsp;&nbsp;&nbsp;Supported only for GTiff  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *Byte, Int16, UInt16, Int32, UInt32, Float32, Float64, CInt16, CInt32, CFloat32, CFloat64*  
    **createopt**=*string* [,*string*,...]  
    &nbsp;&nbsp;&nbsp;&nbsp;Creation option(s) to pass to the output format driver  
    &nbsp;&nbsp;&nbsp;&nbsp;In the form of "NAME=VALUE", separate multiple entries with a comma  
    **metaopt**=*string* [,*string*,...]  
    &nbsp;&nbsp;&nbsp;&nbsp;Metadata key(s) and value(s) to include  
    &nbsp;&nbsp;&nbsp;&nbsp;In the form of "META-TAG=VALUE", separate multiple entries with a comma. Not supported by all output format drivers.  
    **nodata**=*float*  
    &nbsp;&nbsp;&nbsp;&nbsp;Assign a specified nodata value to output bands  
    &nbsp;&nbsp;&nbsp;&nbsp;If given, the nodata value is always written to metadata even if there are no NULL cells in the input band (enhances output compatibility).  
    **where**=*sql_query*  
    &nbsp;&nbsp;&nbsp;&nbsp;WHERE conditions of SQL statement without 'where' keyword used in the temporal GIS framework  
    &nbsp;&nbsp;&nbsp;&nbsp;Example: start_time &gt; '2001-01-01 12:30:00'  
    **--overwrite**  
    &nbsp;&nbsp;&nbsp;&nbsp;Allow output files to overwrite existing files  
    **--help**  
    &nbsp;&nbsp;&nbsp;&nbsp;Print usage summary  
    **--verbose**  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    **--quiet**  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    **--qq**  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    **--ui**  
    &nbsp;&nbsp;&nbsp;&nbsp;Force launching GUI dialog

=== "Python (grass.script)"

    **input** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of the input space time raster dataset  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, strds, *name*  
    **output** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of a space time raster dataset archive  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: output, file, *name*  
    **directory** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Path to the directory where output is written  
    &nbsp;&nbsp;&nbsp;&nbsp;If not given, the default is the current working directory  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, dir, *name*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *./*  
    **compression** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Compression method of the tar archive  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *no, gzip, bzip2*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *bzip2*  
    **format** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;The export format of a single raster map  
    &nbsp;&nbsp;&nbsp;&nbsp;Supported are GTiff, AAIGrid via r.out.gdal and the GRASS package format of r.pack  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *GTiff, AAIGrid, pack*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *GTiff*  
    **type** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Data type  
    &nbsp;&nbsp;&nbsp;&nbsp;Supported only for GTiff  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *Byte, Int16, UInt16, Int32, UInt32, Float32, Float64, CInt16, CInt32, CFloat32, CFloat64*  
    **createopt** : str | list[str], *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Creation option(s) to pass to the output format driver  
    &nbsp;&nbsp;&nbsp;&nbsp;In the form of "NAME=VALUE", separate multiple entries with a comma  
    **metaopt** : str | list[str], *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Metadata key(s) and value(s) to include  
    &nbsp;&nbsp;&nbsp;&nbsp;In the form of "META-TAG=VALUE", separate multiple entries with a comma. Not supported by all output format drivers.  
    **nodata** : float, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Assign a specified nodata value to output bands  
    &nbsp;&nbsp;&nbsp;&nbsp;If given, the nodata value is always written to metadata even if there are no NULL cells in the input band (enhances output compatibility).  
    **where** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;WHERE conditions of SQL statement without 'where' keyword used in the temporal GIS framework  
    &nbsp;&nbsp;&nbsp;&nbsp;Example: start_time &gt; '2001-01-01 12:30:00'  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: *sql_query*  
    **overwrite** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allow output files to overwrite existing files  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **verbose** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **quiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **superquiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  

=== "Python (grass.tools)"

    **input** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of the input space time raster dataset  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, strds, *name*  
    **output** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of a space time raster dataset archive  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: output, file, *name*  
    **directory** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Path to the directory where output is written  
    &nbsp;&nbsp;&nbsp;&nbsp;If not given, the default is the current working directory  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, dir, *name*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *./*  
    **compression** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Compression method of the tar archive  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *no, gzip, bzip2*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *bzip2*  
    **format** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;The export format of a single raster map  
    &nbsp;&nbsp;&nbsp;&nbsp;Supported are GTiff, AAIGrid via r.out.gdal and the GRASS package format of r.pack  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *GTiff, AAIGrid, pack*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *GTiff*  
    **type** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Data type  
    &nbsp;&nbsp;&nbsp;&nbsp;Supported only for GTiff  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *Byte, Int16, UInt16, Int32, UInt32, Float32, Float64, CInt16, CInt32, CFloat32, CFloat64*  
    **createopt** : str | list[str], *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Creation option(s) to pass to the output format driver  
    &nbsp;&nbsp;&nbsp;&nbsp;In the form of "NAME=VALUE", separate multiple entries with a comma  
    **metaopt** : str | list[str], *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Metadata key(s) and value(s) to include  
    &nbsp;&nbsp;&nbsp;&nbsp;In the form of "META-TAG=VALUE", separate multiple entries with a comma. Not supported by all output format drivers.  
    **nodata** : float, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Assign a specified nodata value to output bands  
    &nbsp;&nbsp;&nbsp;&nbsp;If given, the nodata value is always written to metadata even if there are no NULL cells in the input band (enhances output compatibility).  
    **where** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;WHERE conditions of SQL statement without 'where' keyword used in the temporal GIS framework  
    &nbsp;&nbsp;&nbsp;&nbsp;Example: start_time &gt; '2001-01-01 12:30:00'  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: *sql_query*  
    **overwrite** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allow output files to overwrite existing files  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **verbose** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **quiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **superquiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  

    Returns:

    **result** : grass.tools.support.ToolResult | None  
    If the tool produces text as standard output, a *ToolResult* object will be returned. Otherwise, `None` will be returned.

    Raises:

    *grass.tools.ToolError*: When the tool ended with an error.

## DESCRIPTION

*t.rast.export* exports a space time raster dataset (strds) as a tar
archive. The archive contains the raster maps either as GeoTIFF files or
as GRASS binary files exported using *r.pack*. The map specific color
tables are exported in case of GeoTIFF files. In addition several
metadata files are created in the archive that describe the temporal
layout. All time stamps are stored in the file "list.txt", for each map
one row. The name of the map, the start time and the end time are
written. In case of a time instance, the start time is equal to the end
time. The "init.txt" file stores the temporal type, the number of maps,
the chosen export format and some other metadata. The "proj.txt" file
stores the coordinate reference system information as a proj4 string of
the project the space time raster dataset was exported from. The file
"readme.txt" describes the file format. The output of *r.info* for each
raster map in the space time dataset is stored in "metadata.txt".

The tar archive can be compressed using the **compress** option. Gzip
and bzip2 (default) are available. A **where** option can be specified,
to export only a subset of the space time dataset. Archives exported
with *t.rast.export* can be imported with
*[t.rast.import](t.vect.import.md)*.

## NOTES

The name of output file has to carry the suffix of the archive type, the
following suffix can be used:

- **.tar** in the case of **compress=no**
- **.tar.bzip2** in the case of **compress=bzip2**
- **.tar.gzip** in the case of **compress=gzip**

## EXAMPLE

In this example, all the raster maps of 2012 of "tempmean_monthly" will
be exported:

```sh
t.rast.export input=tempmean_monthly output=tempmean_monthly.tar.bzip2 \
              where="start_time >= '2012-01-01' and start_time < '2013-01-01'"

tar xvjf precipitation_daily.tar.bzip2

2012_01_tempmean.tif
2012_01_tempmean.color
2012_02_tempmean.tif
2012_02_tempmean.color
2012_03_tempmean.tif
2012_03_tempmean.color
2012_04_tempmean.tif
2012_04_tempmean.color
2012_05_tempmean.tif
2012_05_tempmean.color
2012_06_tempmean.tif
2012_06_tempmean.color
2012_07_tempmean.tif
2012_07_tempmean.color
2012_08_tempmean.tif
2012_08_tempmean.color
2012_09_tempmean.tif
2012_09_tempmean.color
2012_10_tempmean.tif
2012_10_tempmean.color
2012_11_tempmean.tif
2012_11_tempmean.color
2012_12_tempmean.tif
2012_12_tempmean.color
list.txt
proj.txt
init.txt
readme.txt
metadata.txt


cat init.txt
stds_type=strds
format=GTiff
temporal_type=absolute
semantic_type=mean
number_of_maps=48
north=320000.0
south=10000.0
east=935000.0
west=120000.0


cat proj.txt
+proj=lcc
+lat_1=36.16666666666666
+lat_2=34.33333333333334
+lat_0=33.75
+lon_0=-79
+x_0=609601.22
+y_0=0
+no_defs
+a=6378137
+rf=298.257222101
+towgs84=0.000,0.000,0.000
+to_meter=1


cat list.txt
2012_01_tempmean|2012-01-01 00:00:00|2012-02-01 00:00:00
2012_02_tempmean|2012-02-01 00:00:00|2012-03-01 00:00:00
2012_03_tempmean|2012-03-01 00:00:00|2012-04-01 00:00:00
2012_04_tempmean|2012-04-01 00:00:00|2012-05-01 00:00:00
2012_05_tempmean|2012-05-01 00:00:00|2012-06-01 00:00:00
2012_06_tempmean|2012-06-01 00:00:00|2012-07-01 00:00:00
2012_07_tempmean|2012-07-01 00:00:00|2012-08-01 00:00:00
2012_08_tempmean|2012-08-01 00:00:00|2012-09-01 00:00:00
2012_09_tempmean|2012-09-01 00:00:00|2012-10-01 00:00:00
2012_10_tempmean|2012-10-01 00:00:00|2012-11-01 00:00:00
2012_11_tempmean|2012-11-01 00:00:00|2012-12-01 00:00:00
2012_12_tempmean|2012-12-01 00:00:00|2013-01-01 00:00:00


cat readme.txt
This space time raster dataset was exported with t.rast.export of GRASS GIS 7

Files:
       *.tif  -- GeoTIFF raster files
     *.color  -- GRASS GIS raster color rules
     proj.txt -- Projection information in PROJ format
     init.txt -- GRASS GIS space time raster dataset information
     list.txt -- Time series file, lists all maps by name with interval
                 time stamps in ISO-Format. Field separator is |
 metadata.txt -- The output of t.info
   readme.txt -- This file
```

## SEE ALSO

*[t.rast.import](t.rast.import.md), [t.create](t.create.md),
[t.info](t.info.md), [r.out.gdal](r.out.gdal.md), [r.pack](r.pack.md),
[t.vect.export](t.vect.export.md)*

## AUTHOR

Sören Gebbert, Thünen Institute of Climate-Smart Agriculture

## SOURCE CODE

Available at: [t.rast.export source code](https://github.com/OSGeo/grass/tree/main/temporal/t.rast.export)
([history](https://github.com/OSGeo/grass/commits/main/temporal/t.rast.export))  
Latest change: Saturday Apr 19 17:44:03 2025 in commit [24d7441](https://github.com/OSGeo/grass/commit/24d74415758cba0ffef1c1b6f75e21dd5d2a2993)
