---
name: v.decimate
description: Decimates a point cloud Copies points from one vector to another while applying different decimations
keywords: [ vector, LIDAR, generalization, decimation, extract, select, points, level1 ]
---

# v.decimate

Decimates a point cloud

Copies points from one vector to another while applying different decimations

=== "Command line"

    **v.decimate**
    [**-gfczxbt**]
    **input**=*name*
    [**layer**=*string*]
    **output**=*name*
    [**zrange**=*min,max*]
    [**cats**=*range*]
    [**skip**=*integer*]
    [**preserve**=*integer*]
    [**offset**=*integer*]
    [**limit**=*integer*]
    [**zdiff**=*float*]
    [**cell_limit**=*integer*]
    [**--overwrite**]
    [**--verbose**]
    [**--quiet**]
    [**--qq**]
    [**--ui**]

    Example:

    ```sh
    v.decimate input=name output=name skip=0
    ```

=== "Python (grass.script)"

    *grass.script.run_command*("***v.decimate***",
        **input**,
        **layer**=*"-1"*,
        **output**,
        **zrange**=*None*,
        **cats**=*None*,
        **skip**=*None*,
        **preserve**=*None*,
        **offset**=*None*,
        **limit**=*None*,
        **zdiff**=*None*,
        **cell_limit**=*None*,
        **flags**=*None*,
        **overwrite**=*None*,
        **verbose**=*None*,
        **quiet**=*None*,
        **superquiet**=*None*)

    Example:

    ```python
    gs.run_command("v.decimate", input="name", output="name", skip=0)
    ```

=== "Python (grass.tools)"

    *grass.tools.Tools.v_decimate*(**input**,
        **layer**=*"-1"*,
        **output**,
        **zrange**=*None*,
        **cats**=*None*,
        **skip**=*None*,
        **preserve**=*None*,
        **offset**=*None*,
        **limit**=*None*,
        **zdiff**=*None*,
        **cell_limit**=*None*,
        **flags**=*None*,
        **overwrite**=*None*,
        **verbose**=*None*,
        **quiet**=*None*,
        **superquiet**=*None*)

    Example:

    ```python
    tools = Tools()
    tools.v_decimate(input="name", output="name", skip=0)
    ```

    This grass.tools API is experimental in version 8.5 and expected to be stable in version 8.6.

## Parameters

=== "Command line"

    **input**=*name* **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of input vector map  
    &nbsp;&nbsp;&nbsp;&nbsp;Or data source for direct OGR access  
    **layer**=*string*  
    &nbsp;&nbsp;&nbsp;&nbsp;Layer number or name ('-1' for all layers)  
    &nbsp;&nbsp;&nbsp;&nbsp;A single vector map can be connected to multiple database tables. This number determines which table to use. When used with direct OGR access this is the layer name.  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *-1*  
    **output**=*name* **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;Name for output vector map  
    **zrange**=*min,max*  
    &nbsp;&nbsp;&nbsp;&nbsp;Filter range for z data (min,max)  
    **cats**=*range*  
    &nbsp;&nbsp;&nbsp;&nbsp;Category values  
    &nbsp;&nbsp;&nbsp;&nbsp;Example: 1,3,7-9,13  
    **skip**=*integer*  
    &nbsp;&nbsp;&nbsp;&nbsp;Throw away every n-th point  
    &nbsp;&nbsp;&nbsp;&nbsp;For example, 5 will import 80 percent of points. If not specified, all points are copied  
    **preserve**=*integer*  
    &nbsp;&nbsp;&nbsp;&nbsp;Preserve only every n-th point  
    &nbsp;&nbsp;&nbsp;&nbsp;For example, 4 will import 25 percent of points. If not specified, all points are copied  
    **offset**=*integer*  
    &nbsp;&nbsp;&nbsp;&nbsp;Skip first n points  
    &nbsp;&nbsp;&nbsp;&nbsp;Skips the given number of points at the beginning.  
    **limit**=*integer*  
    &nbsp;&nbsp;&nbsp;&nbsp;Copy only n points  
    &nbsp;&nbsp;&nbsp;&nbsp;Copies only the given number of points  
    **zdiff**=*float*  
    &nbsp;&nbsp;&nbsp;&nbsp;Minimal difference of z values  
    &nbsp;&nbsp;&nbsp;&nbsp;Minimal difference between z values in grid-based decimation  
    **cell_limit**=*integer*  
    &nbsp;&nbsp;&nbsp;&nbsp;Preserve only n points per grid cell  
    &nbsp;&nbsp;&nbsp;&nbsp;Preserves only the given number of points per grid cell in grid-based decimation  
    **-g**  
    &nbsp;&nbsp;&nbsp;&nbsp;Apply grid-based decimation  
    **-f**  
    &nbsp;&nbsp;&nbsp;&nbsp;Use only first point in grid cell during grid-based decimation  
    **-c**  
    &nbsp;&nbsp;&nbsp;&nbsp;Only one point per cat in grid cell  
    **-z**  
    &nbsp;&nbsp;&nbsp;&nbsp;Use z in grid decimation  
    **-x**  
    &nbsp;&nbsp;&nbsp;&nbsp;Store only the coordinates, throw away categories  
    &nbsp;&nbsp;&nbsp;&nbsp;Do not story any categories even if they are present in input data  
    **-b**  
    &nbsp;&nbsp;&nbsp;&nbsp;Do not build topology  
    &nbsp;&nbsp;&nbsp;&nbsp;Advantageous when handling a large number of points  
    **-t**  
    &nbsp;&nbsp;&nbsp;&nbsp;Do not create attribute table  
    **--overwrite**  
    &nbsp;&nbsp;&nbsp;&nbsp;Allow output files to overwrite existing files  
    **--help**  
    &nbsp;&nbsp;&nbsp;&nbsp;Print usage summary  
    **--verbose**  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    **--quiet**  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    **--qq**  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    **--ui**  
    &nbsp;&nbsp;&nbsp;&nbsp;Force launching GUI dialog

=== "Python (grass.script)"

    **input** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of input vector map  
    &nbsp;&nbsp;&nbsp;&nbsp;Or data source for direct OGR access  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, vector, *name*  
    **layer** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Layer number or name ('-1' for all layers)  
    &nbsp;&nbsp;&nbsp;&nbsp;A single vector map can be connected to multiple database tables. This number determines which table to use. When used with direct OGR access this is the layer name.  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, layer  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *-1*  
    **output** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name for output vector map  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: output, vector, *name*  
    **zrange** : tuple[float, float] | list[float] | str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Filter range for z data (min,max)  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: *min,max*  
    **cats** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Category values  
    &nbsp;&nbsp;&nbsp;&nbsp;Example: 1,3,7-9,13  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, cats, *range*  
    **skip** : int, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Throw away every n-th point  
    &nbsp;&nbsp;&nbsp;&nbsp;For example, 5 will import 80 percent of points. If not specified, all points are copied  
    **preserve** : int, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Preserve only every n-th point  
    &nbsp;&nbsp;&nbsp;&nbsp;For example, 4 will import 25 percent of points. If not specified, all points are copied  
    **offset** : int, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Skip first n points  
    &nbsp;&nbsp;&nbsp;&nbsp;Skips the given number of points at the beginning.  
    **limit** : int, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Copy only n points  
    &nbsp;&nbsp;&nbsp;&nbsp;Copies only the given number of points  
    **zdiff** : float, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Minimal difference of z values  
    &nbsp;&nbsp;&nbsp;&nbsp;Minimal difference between z values in grid-based decimation  
    **cell_limit** : int, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Preserve only n points per grid cell  
    &nbsp;&nbsp;&nbsp;&nbsp;Preserves only the given number of points per grid cell in grid-based decimation  
    **flags** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *g*, *f*, *c*, *z*, *x*, *b*, *t*  
    &nbsp;&nbsp;&nbsp;&nbsp;**g**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Apply grid-based decimation  
    &nbsp;&nbsp;&nbsp;&nbsp;**f**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Use only first point in grid cell during grid-based decimation  
    &nbsp;&nbsp;&nbsp;&nbsp;**c**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Only one point per cat in grid cell  
    &nbsp;&nbsp;&nbsp;&nbsp;**z**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Use z in grid decimation  
    &nbsp;&nbsp;&nbsp;&nbsp;**x**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Store only the coordinates, throw away categories  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Do not story any categories even if they are present in input data  
    &nbsp;&nbsp;&nbsp;&nbsp;**b**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Do not build topology  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Advantageous when handling a large number of points  
    &nbsp;&nbsp;&nbsp;&nbsp;**t**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Do not create attribute table  
    **overwrite** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allow output files to overwrite existing files  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **verbose** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **quiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **superquiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  

=== "Python (grass.tools)"

    **input** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of input vector map  
    &nbsp;&nbsp;&nbsp;&nbsp;Or data source for direct OGR access  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, vector, *name*  
    **layer** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Layer number or name ('-1' for all layers)  
    &nbsp;&nbsp;&nbsp;&nbsp;A single vector map can be connected to multiple database tables. This number determines which table to use. When used with direct OGR access this is the layer name.  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, layer  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *-1*  
    **output** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name for output vector map  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: output, vector, *name*  
    **zrange** : tuple[float, float] | list[float] | str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Filter range for z data (min,max)  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: *min,max*  
    **cats** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Category values  
    &nbsp;&nbsp;&nbsp;&nbsp;Example: 1,3,7-9,13  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, cats, *range*  
    **skip** : int, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Throw away every n-th point  
    &nbsp;&nbsp;&nbsp;&nbsp;For example, 5 will import 80 percent of points. If not specified, all points are copied  
    **preserve** : int, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Preserve only every n-th point  
    &nbsp;&nbsp;&nbsp;&nbsp;For example, 4 will import 25 percent of points. If not specified, all points are copied  
    **offset** : int, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Skip first n points  
    &nbsp;&nbsp;&nbsp;&nbsp;Skips the given number of points at the beginning.  
    **limit** : int, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Copy only n points  
    &nbsp;&nbsp;&nbsp;&nbsp;Copies only the given number of points  
    **zdiff** : float, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Minimal difference of z values  
    &nbsp;&nbsp;&nbsp;&nbsp;Minimal difference between z values in grid-based decimation  
    **cell_limit** : int, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Preserve only n points per grid cell  
    &nbsp;&nbsp;&nbsp;&nbsp;Preserves only the given number of points per grid cell in grid-based decimation  
    **flags** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *g*, *f*, *c*, *z*, *x*, *b*, *t*  
    &nbsp;&nbsp;&nbsp;&nbsp;**g**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Apply grid-based decimation  
    &nbsp;&nbsp;&nbsp;&nbsp;**f**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Use only first point in grid cell during grid-based decimation  
    &nbsp;&nbsp;&nbsp;&nbsp;**c**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Only one point per cat in grid cell  
    &nbsp;&nbsp;&nbsp;&nbsp;**z**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Use z in grid decimation  
    &nbsp;&nbsp;&nbsp;&nbsp;**x**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Store only the coordinates, throw away categories  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Do not story any categories even if they are present in input data  
    &nbsp;&nbsp;&nbsp;&nbsp;**b**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Do not build topology  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Advantageous when handling a large number of points  
    &nbsp;&nbsp;&nbsp;&nbsp;**t**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Do not create attribute table  
    **overwrite** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allow output files to overwrite existing files  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **verbose** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **quiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **superquiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  

    Returns:

    **result** : grass.tools.support.ToolResult | None  
    If the tool produces text as standard output, a *ToolResult* object will be returned. Otherwise, `None` will be returned.

    Raises:

    *grass.tools.ToolError*: When the tool ended with an error.

## DESCRIPTION

*v.decimate* reduces number of points in the input vector map and copies
them over to the output vector map. Different point decimation
techniques can be applied to reduce the number of points.

Two main decimation techniques are:

- count-based decimation (**skip**, **preserve**, **offset** and
  **limit** options)
- grid-based decimation (**-g** flag)

The grid-based decimation will remove points based on:

- similar z coordinates (**-z** flag and **zdiff** option)
- same categories (**-c** flag)
- count of points (**-f** flag and **cell_limit** option)

The grid-based decimation is currently using a 2D grid, so the points
are placed and compared within this 2D grid. The comparison can happen
using z coordinates or categories. Note that although the grid is only
2D, the module works with 3D points.

The grid-based decimation extent and resolution depend on the current
computational region as set by *[g.region](g.region.md)*. As a
consequence, the output is limited only to computational region in this
case.

TODO: Currently, any output is limited by the region.

The count-based decimation result highly depends on how the data are
ordered in the input. This applies especially to **offset** and
**limit** options where the resulting shape and densities can be
surprising. The options **skip** and **preserve** are influenced by
order of points in a similar way but they usually keep relative density
of points (which may or may not be desired). On the other hand, the
grid-based decimation will generally result in more even density of
output points (see Figure 1).

Besides decimation, point count can be reduced by applying different
selections or filters, these are:

- selection by category (**cats** option)
- selection by z values (**zrange** option)

## NOTES

The grid-based decimation requires all points which will be saved in
output to fit into the computer's memory (RAM). It is advantageous to
have the region only in the area with the points, otherwise unnecessary
memory is allocated. Higher (finer) resolutions and higher amount of
preserved points per cell require more memory. The count-based
decimation has no limitation regarding the available memory.

Significant speed up can be gained using **-b** flag which disables
building of topology for the output vector map. This may limit the use
of the vector map by some modules, but for example, this module works
without topology as well.

## EXAMPLES

Keep only every forth point, throw away the rest:

```sh
v.decimate input=points_all output=points_decimated_every_4 preserve=4
```

Keep only points within a grid cell (given by the current computational
region) which has unique categories (e.g. LIDAR classes):

```sh
v.decimate input=points_all output=points_decimated_unique_cats layer=1 -g -c
```

![original points](v_decimate_original.png)
![decimation result with every forth point preserved](v_decimate_count.png)
![grid-based decimation result with points with unique categories in each grid cell](v_decimate_grid_cat.png)  
*Figure 1: Comparison of original points, decimation result with every
forth point preserved, and grid-based decimation result with points with
unique categories in each grid cell*

Keep only points with category 2 and keep only approximately 80% of the
points:

```sh
v.decimate input=points_all output=points_decimated_ skip=5 cats=2 layer=1
```

## REFERENCES

- Petras, V., Petrasova, A., Jeziorska, J., Mitasova, H. (2016).
  Processing UAV and LiDAR point clouds in grass GIS. The International
  Archives of Photogrammetry, Remote Sensing and Spatial Information
  Sciences, 41, 945
  ([DOI](https://doi.org/10.5194/isprsarchives-XLI-B7-945-2016))

## SEE ALSO

*[v.extract](v.extract.md), [v.outlier](v.outlier.md),
[v.select](v.select.md), [v.category](v.category.md),
[v.build](v.build.md), [v.in.pdal](v.in.pdal.md),
[g.region](g.region.md)*

## AUTHOR

Vaclav Petras, [NCSU GeoForAll
Lab](https://geospatial.ncsu.edu/geoforall/)

## SOURCE CODE

Available at: [v.decimate source code](https://github.com/OSGeo/grass/tree/main/vector/v.decimate)
([history](https://github.com/OSGeo/grass/commits/main/vector/v.decimate))  
Latest change: Wednesday Aug 20 15:16:32 2025 in commit [42b4dc5](https://github.com/OSGeo/grass/commit/42b4dc5bd1173b8a0e2e1561e7ed71cae30fb245)
