---
name: v.what
description: Queries a vector map at given locations.
keywords: [ vector, querying, position ]
---

# v.what

Queries a vector map at given locations.

=== "Command line"

    **v.what**
    [**-aidgjm**]
    **map**=*name* [,*name*,...]
    [**layer**=*string* [,*string*,...]]
    [**type**=*string* [,*string*,...]]
    **coordinates**=*east,north*
    [**distance**=*float*]
    [**columns**=*name* [,*name*,...]]
    [**format**=*name*]
    [**--verbose**]
    [**--quiet**]
    [**--qq**]
    [**--ui**]

    Example:

    ```sh
    v.what map=name coordinates=0.0
    ```

=== "Python (grass.script)"

    *grass.script.parse_command*("***v.what***",
        **map**,
        **layer**=*"-1"*,
        **type**=*"point,line,area,face"*,
        **coordinates**,
        **distance**=*0*,
        **columns**=*None*,
        **format**=*None*,
        **flags**=*None*,
        **verbose**=*None*,
        **quiet**=*None*,
        **superquiet**=*None*)

    Example:

    ```python
    gs.parse_command("v.what", map="name", coordinates=0.0, format="json")
    ```

=== "Python (grass.tools)"

    *grass.tools.Tools.v_what*(**map**,
        **layer**=*"-1"*,
        **type**=*"point,line,area,face"*,
        **coordinates**,
        **distance**=*0*,
        **columns**=*None*,
        **format**=*None*,
        **flags**=*None*,
        **verbose**=*None*,
        **quiet**=*None*,
        **superquiet**=*None*)

    Example:

    ```python
    tools = Tools()
    tools.v_what(map="name", coordinates=0.0, format="json")
    ```

    This grass.tools API is experimental in version 8.5 and expected to be stable in version 8.6.

## Parameters

=== "Command line"

    **map**=*name* [,*name*,...] **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of vector map(s)  
    **layer**=*string* [,*string*,...]  
    &nbsp;&nbsp;&nbsp;&nbsp;Layer number or name ('-1' for all layers)  
    &nbsp;&nbsp;&nbsp;&nbsp;A single vector map can be connected to multiple database tables. This number determines which table to use. When used with direct OGR access this is the layer name.  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *-1*  
    **type**=*string* [,*string*,...]  
    &nbsp;&nbsp;&nbsp;&nbsp;Input feature type  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *point, line, boundary, centroid, area, face, kernel*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *point,line,area,face*  
    **coordinates**=*east,north* **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;Coordinates for query  
    &nbsp;&nbsp;&nbsp;&nbsp;'-' for standard input  
    **distance**=*float*  
    &nbsp;&nbsp;&nbsp;&nbsp;Query threshold distance  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *0*  
    **columns**=*name* [,*name*,...]  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of attribute column(s)  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: all columns  
    **format**=*name*  
    &nbsp;&nbsp;&nbsp;&nbsp;Output format  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *plain, shell, json*  
    &nbsp;&nbsp;&nbsp;&nbsp;**plain**: Plain text output  
    &nbsp;&nbsp;&nbsp;&nbsp;**shell**: shell script style output  
    &nbsp;&nbsp;&nbsp;&nbsp;**json**: JSON (JavaScript Object Notation)  
    **-a**  
    &nbsp;&nbsp;&nbsp;&nbsp;Print attribute information  
    **-i**  
    &nbsp;&nbsp;&nbsp;&nbsp;Print attribute database connection information  
    **-d**  
    &nbsp;&nbsp;&nbsp;&nbsp;Print topological information (debugging)  
    &nbsp;&nbsp;&nbsp;&nbsp;Prints internal information for topology debugging  
    **-g**  
    &nbsp;&nbsp;&nbsp;&nbsp;Print the stats in shell script style [deprecated]  
    &nbsp;&nbsp;&nbsp;&nbsp;This flag is deprecated and will be removed in a future release. Use format=shell instead.  
    **-j**  
    &nbsp;&nbsp;&nbsp;&nbsp;Print the stats in JSON [deprecated]  
    &nbsp;&nbsp;&nbsp;&nbsp;This flag is deprecated and will be removed in a future release. Use format=json instead.  
    **-m**  
    &nbsp;&nbsp;&nbsp;&nbsp;Print multiple features for each map if they meet the criteria  
    &nbsp;&nbsp;&nbsp;&nbsp;For JSON, this places features under a "features" key  
    **--help**  
    &nbsp;&nbsp;&nbsp;&nbsp;Print usage summary  
    **--verbose**  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    **--quiet**  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    **--qq**  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    **--ui**  
    &nbsp;&nbsp;&nbsp;&nbsp;Force launching GUI dialog

=== "Python (grass.script)"

    **map** : str | list[str], *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of vector map(s)  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, vector, *name*  
    **layer** : str | list[str], *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Layer number or name ('-1' for all layers)  
    &nbsp;&nbsp;&nbsp;&nbsp;A single vector map can be connected to multiple database tables. This number determines which table to use. When used with direct OGR access this is the layer name.  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, layer  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *-1*  
    **type** : str | list[str], *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Input feature type  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *point, line, boundary, centroid, area, face, kernel*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *point,line,area,face*  
    **coordinates** : tuple[float, float] | list[float] | str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Coordinates for query  
    &nbsp;&nbsp;&nbsp;&nbsp;'-' for standard input  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, coords, *east,north*  
    **distance** : float, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Query threshold distance  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *0*  
    **columns** : str | list[str], *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of attribute column(s)  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: all columns  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, dbcolumn, *name*  
    **format** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Output format  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: *name*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *plain, shell, json*  
    &nbsp;&nbsp;&nbsp;&nbsp;**plain**: Plain text output  
    &nbsp;&nbsp;&nbsp;&nbsp;**shell**: shell script style output  
    &nbsp;&nbsp;&nbsp;&nbsp;**json**: JSON (JavaScript Object Notation)  
    **flags** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *a*, *i*, *d*, *g*, *j*, *m*  
    &nbsp;&nbsp;&nbsp;&nbsp;**a**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Print attribute information  
    &nbsp;&nbsp;&nbsp;&nbsp;**i**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Print attribute database connection information  
    &nbsp;&nbsp;&nbsp;&nbsp;**d**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Print topological information (debugging)  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Prints internal information for topology debugging  
    &nbsp;&nbsp;&nbsp;&nbsp;**g**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Print the stats in shell script style [deprecated]  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;This flag is deprecated and will be removed in a future release. Use format=shell instead.  
    &nbsp;&nbsp;&nbsp;&nbsp;**j**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Print the stats in JSON [deprecated]  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;This flag is deprecated and will be removed in a future release. Use format=json instead.  
    &nbsp;&nbsp;&nbsp;&nbsp;**m**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Print multiple features for each map if they meet the criteria  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;For JSON, this places features under a "features" key  
    **verbose** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **quiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **superquiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  

=== "Python (grass.tools)"

    **map** : str | list[str], *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of vector map(s)  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, vector, *name*  
    **layer** : str | list[str], *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Layer number or name ('-1' for all layers)  
    &nbsp;&nbsp;&nbsp;&nbsp;A single vector map can be connected to multiple database tables. This number determines which table to use. When used with direct OGR access this is the layer name.  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, layer  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *-1*  
    **type** : str | list[str], *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Input feature type  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *point, line, boundary, centroid, area, face, kernel*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *point,line,area,face*  
    **coordinates** : tuple[float, float] | list[float] | str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Coordinates for query  
    &nbsp;&nbsp;&nbsp;&nbsp;'-' for standard input  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, coords, *east,north*  
    **distance** : float, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Query threshold distance  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *0*  
    **columns** : str | list[str], *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of attribute column(s)  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: all columns  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, dbcolumn, *name*  
    **format** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Output format  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: *name*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *plain, shell, json*  
    &nbsp;&nbsp;&nbsp;&nbsp;**plain**: Plain text output  
    &nbsp;&nbsp;&nbsp;&nbsp;**shell**: shell script style output  
    &nbsp;&nbsp;&nbsp;&nbsp;**json**: JSON (JavaScript Object Notation)  
    **flags** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *a*, *i*, *d*, *g*, *j*, *m*  
    &nbsp;&nbsp;&nbsp;&nbsp;**a**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Print attribute information  
    &nbsp;&nbsp;&nbsp;&nbsp;**i**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Print attribute database connection information  
    &nbsp;&nbsp;&nbsp;&nbsp;**d**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Print topological information (debugging)  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Prints internal information for topology debugging  
    &nbsp;&nbsp;&nbsp;&nbsp;**g**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Print the stats in shell script style [deprecated]  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;This flag is deprecated and will be removed in a future release. Use format=shell instead.  
    &nbsp;&nbsp;&nbsp;&nbsp;**j**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Print the stats in JSON [deprecated]  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;This flag is deprecated and will be removed in a future release. Use format=json instead.  
    &nbsp;&nbsp;&nbsp;&nbsp;**m**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Print multiple features for each map if they meet the criteria  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;For JSON, this places features under a "features" key  
    **verbose** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **quiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **superquiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  

    Returns:

    **result** : grass.tools.support.ToolResult | None  
    If the tool produces text as standard output, a *ToolResult* object will be returned. Otherwise, `None` will be returned.

    Raises:

    *grass.tools.ToolError*: When the tool ended with an error.

## DESCRIPTION

*v.what* outputs the features associated with
user-specified location(s) in user-specified vector map(s).
The tool operates on features which are vector geometry objects,
such as point or area. The result is a list of these features
along with their associated categories for the layer specified by *layer*.
If there are no categories for the specified layer, the feature
is not included in the result. With `layer=-1` (all layers), all features
are included in the result regardless of their categories.

### Output content

By default, the closest feature is returned for each coordinate and each
vector map if the feature fulfills the geometry query and layer selection
criteria. With the *-m* flag, all matching features are returned, not just
the closest one.

If an attribute database connection is defined for a given layer
and the *-a* flag is specified, attributes from the associated attribute table
will be returned for each category associated with the feature.

The tool operates on features defined as vector geometry objects as opposed
to features defined by categories. Consequently, the output is organized
by geometry IDs, to which possible categories and attributes are attached.
If multiple geometries have the same category, the same set of attributes
is repeated for each geometry.

The output also includes the coordinates used in the query,
the vector map name, and the mapset. For vector lines,
the length is returned. The *-d* flag returns internal topological
information.

### JSON output

With `format="json"`, a list of matching features is returned.
Each feature includes the geometry ID (`id`), geometry type (`type`),
vector map name (`map` and `mapset`), and the relevant part of the spatial
query (`coordinates`).
If the feature has associated categories for the given *layer*,
they are included under `data` in a list of items with `layer` and `category` values.
With *-a*, `data` will also include `attributes` for each `category`.

A feature is not included in the result if there are no categories
for the specified layer. For `layer=-1`, all features
are included in the result and each feature's `data` will contain all
associated categories in all layers.

With the *-m* flag, each list item contains coordinates, a vector map name,
and a list of matching features under the `features` key.
In other words, rather than being organized by feature, the list now contains
lists of features nested under each combination of coordinate pair and vector map.

## NOTES

The *-g* and *-j* flags are deprecated and will be removed in a future release.
Please, use `format="json"` instead.

The behavior of the *-d* flag for internal topology information is not guaranteed.

## EXAMPLE

North Carolina sample dataset example:

Query polygon at given position:

```sh
v.what zipcodes_wake coordinates=637502.25,221744.25
```

Find closest hospital to given position within given distance (search
radius):

```sh
v.what hospitals coordinates=542690.4,204802.7 distance=2000000
```

Extracting categories from JSON output using Python:

```python
import json
import grass.script as gs

result = gs.read_command(
    "v.what",
    map="hospitals",
    coordinates=[542690.4, 204802.7],
    distance=2000000,
    flags="a",
    format="json",
)

data = json.loads(result)
print(data[0]["data"])
```

Possible output:

```text
[{'layer': 1, 'category': 22, 'attributes': {'cat': 22, 'OBJECTID': 22, 'AREA': 0, 'PERIMETER': 0, 'HLS_': 22, 'HLS_ID': 22, 'NAME': 'Randolph Hospital', 'ADDRESS': '364 White Oak St', 'CITY': 'Asheboro', 'ZIP': '27203', 'COUNTY': 'Randolph', 'PHONE': '(336) 625-5151', 'CANCER': 'yes', 'POLYGONID': 0, 'SCALE': 1, 'ANGLE': 1}}]
```

The whole JSON may look like this:

```json
[
    {
        "coordinate": {
            "easting": 542690.40000000002,
            "northing": 204802.70000000001
        },
        "map": "hospitals",
        "mapset": "PERMANENT",
        "id": 22,
        "type": "point",
        "data": [
            {
                "layer": 1,
                "category": 22,
                "attributes": {
                    "cat": 22,
                    "OBJECTID": 22,
                    "AREA": 0,
                    "PERIMETER": 0,
                    "HLS_": 22,
                    "HLS_ID": 22,
                    "NAME": "Randolph Hospital",
                    "ADDRESS": "364 White Oak St",
                    "CITY": "Asheboro",
                    "ZIP": "27203",
                    "COUNTY": "Randolph",
                    "PHONE": "(336) 625-5151",
                    "CANCER": "yes",
                    "POLYGONID": 0,
                    "SCALE": 1,
                    "ANGLE": 1
                }
            }
        ]
    }
]
```

## SEE ALSO

*[d.what.rast](d.what.rast.md), [d.what.vect](d.what.vect.md),
[v.rast.stats](v.rast.stats.md), [v.vect.stats](v.vect.stats.md),
[v.what.rast](v.what.rast.md), [v.what.rast3](v.what.rast3.md),
[v.what.vect](v.what.vect.md), [r.what](r.what.md)*

## AUTHOR

Trevor Wiens  
Edmonton, Alberta, Canada

## SOURCE CODE

Available at: [v.what source code](https://github.com/OSGeo/grass/tree/main/vector/v.what)
([history](https://github.com/OSGeo/grass/commits/main/vector/v.what))  
Latest change: Thursday Oct 02 14:39:13 2025 in commit [1850489](https://github.com/OSGeo/grass/commit/1850489bf42c72d8dcfe2e4db1738441b4a7dc43)
