---
name: r.colors.out
description: Exports the color table associated with a raster map.
keywords: [ raster, color table, export ]
---

# r.colors.out

Exports the color table associated with a raster map.

=== "Command line"

    **r.colors.out**
    [**-p**]
    **map**=*name*
    [**rules**=*name*]
    **format**=*name*
    **color_format**=*name*
    [**--overwrite**]
    [**--verbose**]
    [**--quiet**]
    [**--qq**]
    [**--ui**]

    Example:

    ```sh
    r.colors.out map=name format=plain color_format=hex
    ```

=== "Python (grass.script)"

    *grass.script.parse_command*("***r.colors.out***",
        **map**,
        **rules**=*None*,
        **format**=*"plain"*,
        **color_format**=*"hex"*,
        **flags**=*None*,
        **overwrite**=*None*,
        **verbose**=*None*,
        **quiet**=*None*,
        **superquiet**=*None*)

    Example:

    ```python
    gs.parse_command("r.colors.out", map="name", format="json", color_format="hex")
    ```

=== "Python (grass.tools)"

    *grass.tools.Tools.r_colors_out*(**map**,
        **rules**=*None*,
        **format**=*"plain"*,
        **color_format**=*"hex"*,
        **flags**=*None*,
        **overwrite**=*None*,
        **verbose**=*None*,
        **quiet**=*None*,
        **superquiet**=*None*)

    Example:

    ```python
    tools = Tools()
    tools.r_colors_out(map="name", format="json", color_format="hex")
    ```

    This grass.tools API is experimental in version 8.5 and expected to be stable in version 8.6.

## Parameters

=== "Command line"

    **map**=*name* **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of raster map  
    **rules**=*name*  
    &nbsp;&nbsp;&nbsp;&nbsp;Path to output rules file  
    &nbsp;&nbsp;&nbsp;&nbsp;If not given write to standard output  
    **format**=*name* **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;Output format  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *plain, json*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *plain*  
    &nbsp;&nbsp;&nbsp;&nbsp;**plain**: Plain text output  
    &nbsp;&nbsp;&nbsp;&nbsp;**json**: JSON (JavaScript Object Notation)  
    **color_format**=*name* **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;Color format  
    &nbsp;&nbsp;&nbsp;&nbsp;Color format for output values.  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *rgb, hex, hsv, triplet*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *hex*  
    &nbsp;&nbsp;&nbsp;&nbsp;**rgb**: output color in RGB format  
    &nbsp;&nbsp;&nbsp;&nbsp;**hex**: output color in HEX format  
    &nbsp;&nbsp;&nbsp;&nbsp;**hsv**: output color in HSV format (experimental)  
    &nbsp;&nbsp;&nbsp;&nbsp;**triplet**: output color in colon-separated RGB format  
    **-p**  
    &nbsp;&nbsp;&nbsp;&nbsp;Output values as percentages  
    **--overwrite**  
    &nbsp;&nbsp;&nbsp;&nbsp;Allow output files to overwrite existing files  
    **--help**  
    &nbsp;&nbsp;&nbsp;&nbsp;Print usage summary  
    **--verbose**  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    **--quiet**  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    **--qq**  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    **--ui**  
    &nbsp;&nbsp;&nbsp;&nbsp;Force launching GUI dialog

=== "Python (grass.script)"

    **map** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of raster map  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, raster, *name*  
    **rules** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Path to output rules file  
    &nbsp;&nbsp;&nbsp;&nbsp;If not given write to standard output  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: output, file, *name*  
    **format** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Output format  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: *name*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *plain, json*  
    &nbsp;&nbsp;&nbsp;&nbsp;**plain**: Plain text output  
    &nbsp;&nbsp;&nbsp;&nbsp;**json**: JSON (JavaScript Object Notation)  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *plain*  
    **color_format** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Color format  
    &nbsp;&nbsp;&nbsp;&nbsp;Color format for output values.  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: *name*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *rgb, hex, hsv, triplet*  
    &nbsp;&nbsp;&nbsp;&nbsp;**rgb**: output color in RGB format  
    &nbsp;&nbsp;&nbsp;&nbsp;**hex**: output color in HEX format  
    &nbsp;&nbsp;&nbsp;&nbsp;**hsv**: output color in HSV format (experimental)  
    &nbsp;&nbsp;&nbsp;&nbsp;**triplet**: output color in colon-separated RGB format  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *hex*  
    **flags** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *p*  
    &nbsp;&nbsp;&nbsp;&nbsp;**p**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Output values as percentages  
    **overwrite** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allow output files to overwrite existing files  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **verbose** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **quiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **superquiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  

=== "Python (grass.tools)"

    **map** : str | np.ndarray, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of raster map  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, raster, *name*  
    **rules** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Path to output rules file  
    &nbsp;&nbsp;&nbsp;&nbsp;If not given write to standard output  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: output, file, *name*  
    **format** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Output format  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: *name*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *plain, json*  
    &nbsp;&nbsp;&nbsp;&nbsp;**plain**: Plain text output  
    &nbsp;&nbsp;&nbsp;&nbsp;**json**: JSON (JavaScript Object Notation)  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *plain*  
    **color_format** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Color format  
    &nbsp;&nbsp;&nbsp;&nbsp;Color format for output values.  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: *name*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *rgb, hex, hsv, triplet*  
    &nbsp;&nbsp;&nbsp;&nbsp;**rgb**: output color in RGB format  
    &nbsp;&nbsp;&nbsp;&nbsp;**hex**: output color in HEX format  
    &nbsp;&nbsp;&nbsp;&nbsp;**hsv**: output color in HSV format (experimental)  
    &nbsp;&nbsp;&nbsp;&nbsp;**triplet**: output color in colon-separated RGB format  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *hex*  
    **flags** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *p*  
    &nbsp;&nbsp;&nbsp;&nbsp;**p**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Output values as percentages  
    **overwrite** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allow output files to overwrite existing files  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **verbose** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **quiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **superquiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  

    Returns:

    **result** : grass.tools.support.ToolResult | None  
    If the tool produces text as standard output, a *ToolResult* object will be returned. Otherwise, `None` will be returned.

    Raises:

    *grass.tools.ToolError*: When the tool ended with an error.

## DESCRIPTION

*r.colors.out* allows the user to export the color table for a raster
map to a file which is suitable as input to *[r.colors](r.colors.md)*.

Alternatively, the color rules can be exported as a JSON format
with **format=json**, to use them in other software.
The color format in JSON can be modified using the **color_format** parameter,
which includes the following options:

- hex: #00BFBF
- rgb: rgb(0, 191, 191)
- hsv: hsv(180, 100, 74)
- triplet: 0:191:191

## EXAMPLES

=== "Command line"

    ```sh
    r.colors.out map=elevation
    ```

    Output:

    ```text
    55.5788 0:191:191
    75.729 0:255:0
    95.8792 255:255:0
    116.029 255:127:0
    136.18 191:127:63
    156.33 20:20:20
    nv 255:255:255
    default 255:255:255
    ```

 === "Python (grass.script)"

    ```python
    import grass.script as gs

    colors = gs.parse_command("r.colors.out", map="elevation", format="json")
    ```

    The JSON output looks like:

    ```json
    [
        {
            "value": 55.578792572021484,
            "color": "#00BFBF"
        },
        {
            "value": 75.729006957999999,
            "color": "#00FF00"
        },
        {
            "value": 95.879221344000001,
            "color": "#FFFF00"
        },
        {
            "value": 116.02943573,
            "color": "#FF7F00"
        },
        {
            "value": 136.179650116,
            "color": "#BF7F3F"
        },
        {
            "value": 156.32986450195312,
            "color": "#141414"
        },
        {
            "value": "nv",
            "color": "#FFFFFF"
        },
        {
            "value": "default",
            "color": "#FFFFFF"
        }
    ]
    ```

## SEE ALSO

*[r.colors](r.colors.md)*

## AUTHOR

Glynn Clements

## SOURCE CODE

Available at: [r.colors.out source code](https://github.com/OSGeo/grass/tree/main/raster/r.colors.out)
([history](https://github.com/OSGeo/grass/commits/main/raster/r.colors.out))  
Latest change: Wednesday Jun 25 11:38:52 2025 in commit [b90b316](https://github.com/OSGeo/grass/commit/b90b316b7c48d2294de02a91b0c56bb56e46a237)
