---
name: r.contour
description: Produces a vector map of specified contours from a raster map.
keywords: [ raster, surface, contours, vector ]
---

# r.contour

Produces a vector map of specified contours from a raster map.

=== "Command line"

    **r.contour**
    [**-t**]
    **input**=*name*
    **output**=*name*
    [**step**=*float*]
    [**levels**=*float* [,*float*,...]]
    [**minlevel**=*float*]
    [**maxlevel**=*float*]
    [**cut**=*integer*]
    [**--overwrite**]
    [**--verbose**]
    [**--quiet**]
    [**--qq**]
    [**--ui**]

    Example:

    ```sh
    r.contour input=name output=name
    ```

=== "Python (grass.script)"

    *grass.script.run_command*("***r.contour***",
        **input**,
        **output**,
        **step**=*None*,
        **levels**=*None*,
        **minlevel**=*None*,
        **maxlevel**=*None*,
        **cut**=*2*,
        **flags**=*None*,
        **overwrite**=*None*,
        **verbose**=*None*,
        **quiet**=*None*,
        **superquiet**=*None*)

    Example:

    ```python
    gs.run_command("r.contour", input="name", output="name")
    ```

=== "Python (grass.tools)"

    *grass.tools.Tools.r_contour*(**input**,
        **output**,
        **step**=*None*,
        **levels**=*None*,
        **minlevel**=*None*,
        **maxlevel**=*None*,
        **cut**=*2*,
        **flags**=*None*,
        **overwrite**=*None*,
        **verbose**=*None*,
        **quiet**=*None*,
        **superquiet**=*None*)

    Example:

    ```python
    tools = Tools()
    tools.r_contour(input="name", output="name")
    ```

    This grass.tools API is experimental in version 8.5 and expected to be stable in version 8.6.

## Parameters

=== "Command line"

    **input**=*name* **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of input raster map  
    **output**=*name* **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;Name for output vector map  
    **step**=*float*  
    &nbsp;&nbsp;&nbsp;&nbsp;Increment between contour levels  
    **levels**=*float* [,*float*,...]  
    &nbsp;&nbsp;&nbsp;&nbsp;List of contour levels  
    **minlevel**=*float*  
    &nbsp;&nbsp;&nbsp;&nbsp;Minimum contour level  
    **maxlevel**=*float*  
    &nbsp;&nbsp;&nbsp;&nbsp;Maximum contour level  
    **cut**=*integer*  
    &nbsp;&nbsp;&nbsp;&nbsp;Minimum number of points for a contour line (0 -&gt; no limit)  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *2*  
    **-t**  
    &nbsp;&nbsp;&nbsp;&nbsp;Do not create attribute table  
    **--overwrite**  
    &nbsp;&nbsp;&nbsp;&nbsp;Allow output files to overwrite existing files  
    **--help**  
    &nbsp;&nbsp;&nbsp;&nbsp;Print usage summary  
    **--verbose**  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    **--quiet**  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    **--qq**  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    **--ui**  
    &nbsp;&nbsp;&nbsp;&nbsp;Force launching GUI dialog

=== "Python (grass.script)"

    **input** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of input raster map  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, raster, *name*  
    **output** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name for output vector map  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: output, vector, *name*  
    **step** : float, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Increment between contour levels  
    **levels** : float | list[float] | str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;List of contour levels  
    **minlevel** : float, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Minimum contour level  
    **maxlevel** : float, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Maximum contour level  
    **cut** : int, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Minimum number of points for a contour line (0 -&gt; no limit)  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *2*  
    **flags** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *t*  
    &nbsp;&nbsp;&nbsp;&nbsp;**t**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Do not create attribute table  
    **overwrite** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allow output files to overwrite existing files  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **verbose** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **quiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **superquiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  

=== "Python (grass.tools)"

    **input** : str | np.ndarray, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of input raster map  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, raster, *name*  
    **output** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name for output vector map  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: output, vector, *name*  
    **step** : float, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Increment between contour levels  
    **levels** : float | list[float] | str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;List of contour levels  
    **minlevel** : float, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Minimum contour level  
    **maxlevel** : float, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Maximum contour level  
    **cut** : int, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Minimum number of points for a contour line (0 -&gt; no limit)  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *2*  
    **flags** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *t*  
    &nbsp;&nbsp;&nbsp;&nbsp;**t**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Do not create attribute table  
    **overwrite** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allow output files to overwrite existing files  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **verbose** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **quiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **superquiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  

    Returns:

    **result** : grass.tools.support.ToolResult | None  
    If the tool produces text as standard output, a *ToolResult* object will be returned. Otherwise, `None` will be returned.

    Raises:

    *grass.tools.ToolError*: When the tool ended with an error.

## DESCRIPTION

*r.contour* produces a vector map of specified contours from input
raster map. Contours can be produced using a comma-separated list of
values in **levels**, or at some regular increment using the **step**
parameter, using **minlevel** and **maxlevel** as minimum and maximum
contour values, respectively. If no **minlevel** or **maxlevel** is
specified, the minimum and maximum cell values in the **input** raster
map will be used.

## NOTES

*r.contour* will either step through incremental contours or produce
contours from a list of levels, not both. If both a list of levels and a
step are specified, the list will be produced and the step will be
ignored.

Zero is treated as a valid data value by *r.contour*.

If a contour level exactly matches a category value in the raster map,
the contour line may backtrack on itself, causing illegal arcs to be
produced in the output vector map.

The optional **cut** parameter allows the user to specify a minimum
number of raster cells eligilble to be included in a contour line
written to the **output** vector map. It acts like a filter, omitting
spurs, single points, etc., making the output more generalized.

## EXAMPLES

In the Spearfish dataset, produce a vector contour map from input raster
*elevation.dem* with contour levels from 1000m to 2000m, 100m contour
step, and a minimum of 200 input raster points contributing to the
contour line:

```sh
r.contour input=elevation.dem output=elevation_dem_contours \
          minlevel=1000 maxlevel=2000 step=100 cut=200
```

For an example of using levels with *r.contour* this example uses the
elevation map from the North Carolina database:

```sh
g.region raster=elevation
r.contour in=elevation out=contours levels=60,90,120,150 --o
d.mon wx0
d.rast elevation_shade
d.vect contours color=red
```

![r.contours example](r_contour_using_levels.png)  
*Contour lines shown on shaded terrain map*

For an example of using steps with *r.contour* this example uses the
LiDAR data derived elevation map from the North Carolina database:

```sh
g.region raster=elev_lid792_1m -p
r.contour input=elev_lid792_1m output=elev_lid792_1m_contours \
          minlevel=100 maxlevel=150 step=10
```

## AUTHORS

Terry Baker, U.S. Army Construction Engineering Research Laboratory  
3/2001: cut parameter and fixes by Andrea Aime (<aaime@libero.it>)

## SOURCE CODE

Available at: [r.contour source code](https://github.com/OSGeo/grass/tree/main/raster/r.contour)
([history](https://github.com/OSGeo/grass/commits/main/raster/r.contour))  
Latest change: Monday Sep 22 10:54:45 2025 in commit [b6e1e4a](https://github.com/OSGeo/grass/commit/b6e1e4a62afb5db38630ceff0acec6f58696c06a)
