---
name: r.in.wms.py
description: Downloads and imports data from OGC WMS and OGC WMTS web mapping servers.
keywords: [ raster, import, OGC web services, OGC WMS, OGC WMTS ]
---

# r.in.wms.py

Downloads and imports data from OGC WMS and OGC WMTS web mapping servers.

=== "Command line"

    **r.in.wms.py**
    [**-cob**]
    **url**=*string*
    **output**=*name*
    **layers**=*string* [,*string*,...]
    [**styles**=*string* [,*string*,...]]
    [**format**=*string*]
    [**srs**=*integer*]
    [**driver**=*string*]
    [**wms_version**=*string*]
    [**maxcols**=*integer*]
    [**maxrows**=*integer*]
    [**urlparams**=*string*]
    [**username**=*string*]
    [**password**=*string*]
    [**method**=*string*]
    [**gdal_createopt**=*string* [,*string*,...]]
    [**region**=*string*]
    [**bgcolor**=*string*]
    [**proxy**=*string*]
    [**proxy_user_pw**=*string*]
    [**capfile**=*name*]
    [**capfile_output**=*name*]
    [**--overwrite**]
    [**--verbose**]
    [**--quiet**]
    [**--qq**]
    [**--ui**]

    Example:

    ```sh
    r.in.wms.py url=string output=name layers=string
    ```

=== "Python (grass.script)"

    *grass.script.run_command*("***r.in.wms.py***",
        **url**,
        **output**,
        **layers**,
        **styles**=*None*,
        **format**=*"png"*,
        **srs**=*4326*,
        **driver**=*"WMS_GRASS"*,
        **wms_version**=*"1.1.1"*,
        **maxcols**=*512*,
        **maxrows**=*512*,
        **urlparams**=*None*,
        **username**=*None*,
        **password**=*None*,
        **method**=*"nearest"*,
        **gdal_createopt**=*None*,
        **region**=*None*,
        **bgcolor**=*None*,
        **proxy**=*None*,
        **proxy_user_pw**=*None*,
        **capfile**=*None*,
        **capfile_output**=*None*,
        **flags**=*None*,
        **overwrite**=*None*,
        **verbose**=*None*,
        **quiet**=*None*,
        **superquiet**=*None*)

    Example:

    ```python
    gs.run_command("r.in.wms.py", url="string", output="name", layers="string")
    ```

=== "Python (grass.tools)"

    *grass.tools.Tools.r_in_wms_py*(**url**,
        **output**,
        **layers**,
        **styles**=*None*,
        **format**=*"png"*,
        **srs**=*4326*,
        **driver**=*"WMS_GRASS"*,
        **wms_version**=*"1.1.1"*,
        **maxcols**=*512*,
        **maxrows**=*512*,
        **urlparams**=*None*,
        **username**=*None*,
        **password**=*None*,
        **method**=*"nearest"*,
        **gdal_createopt**=*None*,
        **region**=*None*,
        **bgcolor**=*None*,
        **proxy**=*None*,
        **proxy_user_pw**=*None*,
        **capfile**=*None*,
        **capfile_output**=*None*,
        **flags**=*None*,
        **overwrite**=*None*,
        **verbose**=*None*,
        **quiet**=*None*,
        **superquiet**=*None*)

    Example:

    ```python
    tools = Tools()
    tools.r_in_wms_py(url="string", output="name", layers="string")
    ```

    This grass.tools API is experimental in version 8.5 and expected to be stable in version 8.6.

## Parameters

=== "Command line"

    **url**=*string* **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;Typically starts with "http://"  
    **output**=*name* **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;Name for output raster map  
    **layers**=*string* [,*string*,...] **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;Layer(s) to request from the map server  
    **styles**=*string* [,*string*,...]  
    &nbsp;&nbsp;&nbsp;&nbsp;Layer style(s) to request from the map server  
    **format**=*string*  
    &nbsp;&nbsp;&nbsp;&nbsp;Image format requested from the server  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *geotiff, tiff, jpeg, gif, png, png8*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *png*  
    **srs**=*integer*  
    &nbsp;&nbsp;&nbsp;&nbsp;EPSG code of requested source projection  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *4326*  
    **driver**=*string*  
    &nbsp;&nbsp;&nbsp;&nbsp;Driver used for communication with the server  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *WMS_GDAL,  WMS_GRASS,  WMTS_GRASS,  OnEarth_GRASS*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *WMS_GRASS*  
    &nbsp;&nbsp;&nbsp;&nbsp;**WMS_GDAL**: Download data using GDAL WMS driver  
    &nbsp;&nbsp;&nbsp;&nbsp;**WMS_GRASS**: Download data using native GRASS-WMS driver  
    &nbsp;&nbsp;&nbsp;&nbsp;**WMTS_GRASS**: Download data using native GRASS-WMTS driver  
    &nbsp;&nbsp;&nbsp;&nbsp;**OnEarth_GRASS**: Download data using native GRASS-OnEarth driver  
    **wms_version**=*string*  
    &nbsp;&nbsp;&nbsp;&nbsp;WMS standard version  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *1.1.0, 1.1.1, 1.3.0*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *1.1.1*  
    **maxcols**=*integer*  
    &nbsp;&nbsp;&nbsp;&nbsp;Maximum columns to request at a time  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *512*  
    **maxrows**=*integer*  
    &nbsp;&nbsp;&nbsp;&nbsp;Maximum rows to request at a time  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *512*  
    **urlparams**=*string*  
    &nbsp;&nbsp;&nbsp;&nbsp;Additional query parameters to pass to the server  
    **username**=*string*  
    &nbsp;&nbsp;&nbsp;&nbsp;Username for server connection  
    **password**=*string*  
    &nbsp;&nbsp;&nbsp;&nbsp;Password for server connection  
    **method**=*string*  
    &nbsp;&nbsp;&nbsp;&nbsp;Interpolation method to use in reprojection  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *nearest, linear, cubic, cubicspline*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *nearest*  
    **gdal_createopt**=*string* [,*string*,...]  
    &nbsp;&nbsp;&nbsp;&nbsp;GDAL creation option(s) to pass to the output format driver  
    &nbsp;&nbsp;&nbsp;&nbsp;In the form of "NAME=VALUE", separate multiple entries with a comma  
    **region**=*string*  
    &nbsp;&nbsp;&nbsp;&nbsp;Request data for this named region instead of the current region bounds  
    **bgcolor**=*string*  
    &nbsp;&nbsp;&nbsp;&nbsp;Background color  
    &nbsp;&nbsp;&nbsp;&nbsp;Format: 0xRRGGBB  
    **proxy**=*string*  
    &nbsp;&nbsp;&nbsp;&nbsp;HTTP proxy only GDAL driver (GDAL_HTTP_PROXY)  
    &nbsp;&nbsp;&nbsp;&nbsp;HTTP proxy  
    **proxy_user_pw**=*string*  
    &nbsp;&nbsp;&nbsp;&nbsp;User and password for HTTP proxy only for GDAL driver (GDAL_HTTP_PROXYUSERPWD). Must be in the form of [user name]:[password].  
    &nbsp;&nbsp;&nbsp;&nbsp;User and password for HTTP proxy  
    **capfile**=*name*  
    &nbsp;&nbsp;&nbsp;&nbsp;Capabilities file to parse (input). It is relevant for WMTS_GRASS and OnEarth_GRASS drivers  
    **capfile_output**=*name*  
    &nbsp;&nbsp;&nbsp;&nbsp;File where the server capabilities will be saved ('c' flag)  
    **-c**  
    &nbsp;&nbsp;&nbsp;&nbsp;Get the server capabilities, print them out, then exit  
    **-o**  
    &nbsp;&nbsp;&nbsp;&nbsp;Do not request transparent data  
    **-b**  
    &nbsp;&nbsp;&nbsp;&nbsp;Keep original bands (default: create composite)  
    **--overwrite**  
    &nbsp;&nbsp;&nbsp;&nbsp;Allow output files to overwrite existing files  
    **--help**  
    &nbsp;&nbsp;&nbsp;&nbsp;Print usage summary  
    **--verbose**  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    **--quiet**  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    **--qq**  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    **--ui**  
    &nbsp;&nbsp;&nbsp;&nbsp;Force launching GUI dialog

=== "Python (grass.script)"

    **url** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Typically starts with "http://"  
    **output** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name for output raster map  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: output, raster, *name*  
    **layers** : str | list[str], *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Layer(s) to request from the map server  
    **styles** : str | list[str], *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Layer style(s) to request from the map server  
    **format** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Image format requested from the server  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *geotiff, tiff, jpeg, gif, png, png8*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *png*  
    **srs** : int, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;EPSG code of requested source projection  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *4326*  
    **driver** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Driver used for communication with the server  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *WMS_GDAL,  WMS_GRASS,  WMTS_GRASS,  OnEarth_GRASS*  
    &nbsp;&nbsp;&nbsp;&nbsp;**WMS_GDAL**: Download data using GDAL WMS driver  
    &nbsp;&nbsp;&nbsp;&nbsp;**WMS_GRASS**: Download data using native GRASS-WMS driver  
    &nbsp;&nbsp;&nbsp;&nbsp;**WMTS_GRASS**: Download data using native GRASS-WMTS driver  
    &nbsp;&nbsp;&nbsp;&nbsp;**OnEarth_GRASS**: Download data using native GRASS-OnEarth driver  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *WMS_GRASS*  
    **wms_version** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;WMS standard version  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *1.1.0, 1.1.1, 1.3.0*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *1.1.1*  
    **maxcols** : int, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Maximum columns to request at a time  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *512*  
    **maxrows** : int, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Maximum rows to request at a time  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *512*  
    **urlparams** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Additional query parameters to pass to the server  
    **username** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Username for server connection  
    **password** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Password for server connection  
    **method** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Interpolation method to use in reprojection  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *nearest, linear, cubic, cubicspline*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *nearest*  
    **gdal_createopt** : str | list[str], *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;GDAL creation option(s) to pass to the output format driver  
    &nbsp;&nbsp;&nbsp;&nbsp;In the form of "NAME=VALUE", separate multiple entries with a comma  
    **region** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Request data for this named region instead of the current region bounds  
    **bgcolor** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Background color  
    &nbsp;&nbsp;&nbsp;&nbsp;Format: 0xRRGGBB  
    **proxy** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;HTTP proxy only GDAL driver (GDAL_HTTP_PROXY)  
    &nbsp;&nbsp;&nbsp;&nbsp;HTTP proxy  
    **proxy_user_pw** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;User and password for HTTP proxy only for GDAL driver (GDAL_HTTP_PROXYUSERPWD). Must be in the form of [user name]:[password].  
    &nbsp;&nbsp;&nbsp;&nbsp;User and password for HTTP proxy  
    **capfile** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Capabilities file to parse (input). It is relevant for WMTS_GRASS and OnEarth_GRASS drivers  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, file, *name*  
    **capfile_output** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;File where the server capabilities will be saved ('c' flag)  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: output, file, *name*  
    **flags** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *c*, *o*, *b*  
    &nbsp;&nbsp;&nbsp;&nbsp;**c**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Get the server capabilities, print them out, then exit  
    &nbsp;&nbsp;&nbsp;&nbsp;**o**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Do not request transparent data  
    &nbsp;&nbsp;&nbsp;&nbsp;**b**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Keep original bands (default: create composite)  
    **overwrite** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allow output files to overwrite existing files  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **verbose** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **quiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **superquiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  

=== "Python (grass.tools)"

    **url** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Typically starts with "http://"  
    **output** : str | type(np.ndarray) | type(np.array) | type(gs.array.array), *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name for output raster map  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: output, raster, *name*  
    **layers** : str | list[str], *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Layer(s) to request from the map server  
    **styles** : str | list[str], *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Layer style(s) to request from the map server  
    **format** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Image format requested from the server  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *geotiff, tiff, jpeg, gif, png, png8*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *png*  
    **srs** : int, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;EPSG code of requested source projection  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *4326*  
    **driver** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Driver used for communication with the server  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *WMS_GDAL,  WMS_GRASS,  WMTS_GRASS,  OnEarth_GRASS*  
    &nbsp;&nbsp;&nbsp;&nbsp;**WMS_GDAL**: Download data using GDAL WMS driver  
    &nbsp;&nbsp;&nbsp;&nbsp;**WMS_GRASS**: Download data using native GRASS-WMS driver  
    &nbsp;&nbsp;&nbsp;&nbsp;**WMTS_GRASS**: Download data using native GRASS-WMTS driver  
    &nbsp;&nbsp;&nbsp;&nbsp;**OnEarth_GRASS**: Download data using native GRASS-OnEarth driver  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *WMS_GRASS*  
    **wms_version** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;WMS standard version  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *1.1.0, 1.1.1, 1.3.0*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *1.1.1*  
    **maxcols** : int, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Maximum columns to request at a time  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *512*  
    **maxrows** : int, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Maximum rows to request at a time  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *512*  
    **urlparams** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Additional query parameters to pass to the server  
    **username** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Username for server connection  
    **password** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Password for server connection  
    **method** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Interpolation method to use in reprojection  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *nearest, linear, cubic, cubicspline*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *nearest*  
    **gdal_createopt** : str | list[str], *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;GDAL creation option(s) to pass to the output format driver  
    &nbsp;&nbsp;&nbsp;&nbsp;In the form of "NAME=VALUE", separate multiple entries with a comma  
    **region** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Request data for this named region instead of the current region bounds  
    **bgcolor** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Background color  
    &nbsp;&nbsp;&nbsp;&nbsp;Format: 0xRRGGBB  
    **proxy** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;HTTP proxy only GDAL driver (GDAL_HTTP_PROXY)  
    &nbsp;&nbsp;&nbsp;&nbsp;HTTP proxy  
    **proxy_user_pw** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;User and password for HTTP proxy only for GDAL driver (GDAL_HTTP_PROXYUSERPWD). Must be in the form of [user name]:[password].  
    &nbsp;&nbsp;&nbsp;&nbsp;User and password for HTTP proxy  
    **capfile** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Capabilities file to parse (input). It is relevant for WMTS_GRASS and OnEarth_GRASS drivers  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, file, *name*  
    **capfile_output** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;File where the server capabilities will be saved ('c' flag)  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: output, file, *name*  
    **flags** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *c*, *o*, *b*  
    &nbsp;&nbsp;&nbsp;&nbsp;**c**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Get the server capabilities, print them out, then exit  
    &nbsp;&nbsp;&nbsp;&nbsp;**o**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Do not request transparent data  
    &nbsp;&nbsp;&nbsp;&nbsp;**b**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Keep original bands (default: create composite)  
    **overwrite** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allow output files to overwrite existing files  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **verbose** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **quiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **superquiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  

    Returns:

    **result** : grass.tools.support.ToolResult | np.ndarray | tuple[np.ndarray] | None  
    If the tool produces text as standard output, a *ToolResult* object will be returned. Otherwise, `None` will be returned. If an array type (e.g., *np.ndarray*) is used for one of the raster outputs, the result will be an array and will have the shape corresponding to the computational region. If an array type is used for more than one raster output, the result will be a tuple of arrays.

    Raises:

    *grass.tools.ToolError*: When the tool ended with an error.

## DESCRIPTION

*r.in.wms* handles all of downloading and importing raster data from
[OGC WMS](https://www.ogc.org/publications/standard/wms/) and [OGC
WMTS](https://www.ogc.org/publications/standard/wmts/) web mapping
servers. It only needs be told the desired data to collect (bounds and
resolution) via a region, the server to get the data from, and the layer
or layers to get. It downloads the data in tiles, reprojects it, imports
it, and patches it back together.

## NOTES

To understand the data you are getting it is necessary to look at the
capabilities of the WMS server. This should be available via a
capabilities request (see examples)

If possible, the EPSG code of the current project should be used with
the **srs** option to avoid unnecessary reprojection.

When using GDAL WMS driver (**driver=WMS_GDAL**), the GDAL library needs
to be built with WMS support, see [GDAL
WMS](https://gdal.org/en/stable/drivers/raster/wms.html) manual page for
details.

### Tiled WMS

Into the parameter **layers** the name of the *TiledGroup* need to be
inserted from Tile Service file. Time variable can be specified in
**urlparams** parameter, e.g: `urlparams='time=2012-1-1'`.

## EXAMPLES

### General Get Capabilities Request

```sh
# Topographic WMS with OpenStreetMap by mundialis
r.in.wms -c url="https://ows.mundialis.de/services/service?"
r.in.wms -c url="https://ows.mundialis.de/services/service?" | grep Name

# Czech WMS
r.in.wms -c url="https://wms.cuzk.cz/wms.asp"
```

### Download raster data from WMS server (GetMap request)

#### Open Street Map

```sh
# OSM, using WMS_GRASS driver
g.region n=90 s=-90 w=-180 e=180 res=0:10:00 -p
r.in.wms url="http://watzmann-geog.urz.uni-heidelberg.de/cached/osm" layers=osm_auto:all output=osm format=png
r.info osm
```

```sh
# OSM Overlay WMS (can be used as an overlay for other maps)
r.in.wms url="http://ows.mundialis.de/services/service?" layer=OSM-Overlay-WMS output=osm_overlay format=png

# TOPO-OSM-WMS
r.in.wms url="http://ows.mundialis.de/services/service?" layer=TOPO-OSM-WMS output=topo_osm format=png
r.info topo_osm

# TOPO-WMS
r.in.wms url="http://ows.mundialis.de/services/service?" layer=TOPO-WMS output=topo format=png
r.info topo
```

More OSM WMS servers can be found online, e.g. on the OSM wiki in a [OSM
WMS Servers
list](https://wiki.openstreetmap.org/wiki/WMS#Public_WMS_Servers) and on
the [WORLD_OSM_WMS](https://wiki.openstreetmap.org/wiki/WORLD_OSM_WMS)
page.

#### Countries and coastlines

```sh
# using WMS_GRASS driver
r.in.wms url="http://www2.demis.nl/WMS/wms.asp" layers=Countries,Borders,Coastline output=countries srs=4326 format=png
r.info countries
```

#### Sentinel-2 satellite cloud free global coverage

```sh
# North Carolina sample data
g.region raster=elevation -p
# using WMS_GRASS driver
r.in.wms url="https://tiles.maps.eox.at/wms?" layers=s2cloudless output=sentinel2 format=png
r.info sentinel2
```

![Raleigh (NC, USA) seen by Sentinel-2](r_in_wms_sentinel2.jpg)  
*Figure: Raleigh (NC, USA) seen by Sentinel-2 (10m resolution; image
courtesy: EOX)*

#### OGC WMTS Example

```sh
# using WMTS_GRASS driver
r.in.wms url="http://gpp3-wxs.ign.fr/yourAPIkey/geoportail/wmts" layers=ORTHOIMAGERY.ORTHOPHOTOS \
         output=orthophoto srs=3857 format=jpeg driver=WMTS_GRASS style=normal password="*" username="*"
r.info orthophoto
```

Note: username, password and API key can be obtained from [IGN
API](http://api.ign.fr/) website

#### Data covering the Czech Republic

```sh
# using WMS_GRASS driver
r.in.wms url="http://wms.cuzk.cz/wms.asp" layers=prehledka_kraju-linie srs=4326 output=kn format=png
```

```sh
# using WMTS_GRASS driver
r.in.wms url="http://geoportal.cuzk.cz/WMTS_ORTOFOTO/WMTService.aspx" layers=orto output=orthophoto \
         srs=3857 format=jpeg driver=WMTS_GRASS style=default
r.info orthophoto
```

Note: data are provided by [Czech office for surveying, mapping and
cadastre](https://cuzk.cz/en).

#### Satellite data covering Europe

Copernicus Core003 View Services - Optical VHR2 coverage over EU
2011-2013 (provided by JRC; usage is restricted to non-commercial
activities):

```sh
# get WMS layer list
r.in.wms -c url="http://cidportal.jrc.ec.europa.eu/copernicus/services/ows/wms/public/core003?"
r.in.wms -c url="http://cidportal.jrc.ec.europa.eu/copernicus/services/ows/wms/public/core003?" | grep Name

# spatial subset of Europe
# enlarging maxcols and maxrows in order to minimize impact of copyright notice in map
g.region n=56 s=47 w=5 e=16 res=0:00:10 -pa
# using WMS_GRASS driver
r.in.wms url="http://cidportal.jrc.ec.europa.eu/copernicus/services/ows/wms/public/core003?" \
         layer="OI.Mosaic.NaturalColor.Feathering" output="jrc_copernicus_core003_mosaik" \
         maxcols=3400 maxrows=3400
r.info jrc_copernicus_core003_mosaik

# Alternatively, using WMS_GDAL driver with BIGTIFF and compression enabled
r.in.wms url="http://cidportal.jrc.ec.europa.eu/copernicus/services/ows/wms/public/core003?" \
         layer="OI.Mosaic.NaturalColor.Feathering" output="jrc_copernicus_core003_mosaik2" \
         maxcols=3400 maxrows=3400 driver=WMS_GDAL gdal_createopt="BIGTIFF=YES,COMPRESS=DEFLATE"
r.info jrc_copernicus_core003_mosaik2

```

## REQUIREMENTS

*r.in.wms* requires the
[gdalwarp](https://gdal.org/en/stable/programs/gdalwarp.html) utility
from the GDAL/OGR library.

## REFERENCES

- [OGC WMS](https://www.ogc.org/publications/standard/wms/)
- [OGC WMTS](https://www.ogc.org/publications/standard/wmts/)

## SEE ALSO

*[r.in.gdal](r.in.gdal.md), [r.patch](r.patch.md),
[r.colors](r.colors.md), [r.composite](r.composite.md),
[v.in.wfs](v.in.wfs.md)*

See also [WMS support in
wxGUI](https://grasswiki.osgeo.org/wiki/WxGUI/Video_tutorials#Add_web_service_layer).

## AUTHOR

Stepan Turek, Czech Technical University in Prague, Czech Republic  
(bachelor's final project 2012, mentor: Martin Landa)

## SOURCE CODE

Available at: [r.in.wms source code](https://github.com/OSGeo/grass/tree/main/scripts/r.in.wms)
([history](https://github.com/OSGeo/grass/commits/main/scripts/r.in.wms))  
Latest change: Friday Sep 19 18:49:52 2025 in commit [8588808](https://github.com/OSGeo/grass/commit/8588808ad1f507bb05441ad6b2137cef12ebeb5a)
