---
name: test.r3flow
description: Testing flow lines.
keywords: [ raster3d, unit test ]
---

# test.r3flow

Testing flow lines.

=== "Command line"

    **test.r3flow**
    **test**=*string*
    [**coordinates**=*float* [,*float*,...]]
    [**input**=*name* [,*name*,...]]
    [**--verbose**]
    [**--quiet**]
    [**--qq**]
    [**--ui**]

    Example:

    ```sh
    test.r3flow test=interpolation
    ```

=== "Python (grass.script)"

    *grass.script.run_command*("***test.r3flow***",
        **test**,
        **coordinates**=*None*,
        **input**=*None*,
        **verbose**=*None*,
        **quiet**=*None*,
        **superquiet**=*None*)

    Example:

    ```python
    gs.run_command("test.r3flow", test="interpolation")
    ```

=== "Python (grass.tools)"

    *grass.tools.Tools.test_r3flow*(**test**,
        **coordinates**=*None*,
        **input**=*None*,
        **verbose**=*None*,
        **quiet**=*None*,
        **superquiet**=*None*)

    Example:

    ```python
    tools = Tools()
    tools.test_r3flow(test="interpolation")
    ```

    This grass.tools API is experimental in version 8.5 and expected to be stable in version 8.6.

## Parameters

=== "Command line"

    **test**=*string* **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;Select what is tested  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *interpolation, gradient*  
    **coordinates**=*float* [,*float*,...]  
    &nbsp;&nbsp;&nbsp;&nbsp;x,y,z coordinates  
    **input**=*name* [,*name*,...]  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of input 3D raster map(s)  
    **--help**  
    &nbsp;&nbsp;&nbsp;&nbsp;Print usage summary  
    **--verbose**  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    **--quiet**  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    **--qq**  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    **--ui**  
    &nbsp;&nbsp;&nbsp;&nbsp;Force launching GUI dialog

=== "Python (grass.script)"

    **test** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Select what is tested  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *interpolation, gradient*  
    **coordinates** : float | list[float] | str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;x,y,z coordinates  
    **input** : str | list[str], *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of input 3D raster map(s)  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, raster_3d, *name*  
    **verbose** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **quiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **superquiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  

=== "Python (grass.tools)"

    **test** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Select what is tested  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *interpolation, gradient*  
    **coordinates** : float | list[float] | str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;x,y,z coordinates  
    **input** : str | list[str], *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of input 3D raster map(s)  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, raster_3d, *name*  
    **verbose** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **quiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **superquiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  

    Returns:

    **result** : grass.tools.support.ToolResult | None  
    If the tool produces text as standard output, a *ToolResult* object will be returned. Otherwise, `None` will be returned.

    Raises:

    *grass.tools.ToolError*: When the tool ended with an error.

## DESCRIPTION

Testing module for *r3.flow*.

## SEE ALSO

*[r3.flow](r3.flow.md)*

## AUTHOR

Anna Petrasova

## SOURCE CODE

Available at: [test.r3flow source code](https://github.com/OSGeo/grass/tree/main/raster3d/r3.flow)
([history](https://github.com/OSGeo/grass/commits/main/raster3d/r3.flow))  
Latest change: Thursday May 08 20:58:05 2025 in commit [4144ba8](https://github.com/OSGeo/grass/commit/4144ba81fa125e1549fc52e1cf5feb4fa004be8b)
