---
name: db.connect
description: Prints/sets general DB connection for current mapset.
keywords: [ database, attribute table, connection settings ]
---

# db.connect

Prints/sets general DB connection for current mapset.

=== "Command line"

    **db.connect**
    [**-pgcd**]
    [**driver**=*name*]
    [**database**=*name*]
    [**schema**=*name*]
    [**group**=*string*]
    **format**=*name*
    [**--verbose**]
    [**--quiet**]
    [**--qq**]
    [**--ui**]

    Example:

    ```sh
    db.connect format=plain
    ```

=== "Python (grass.script)"

    *grass.script.parse_command*("***db.connect***",
        **driver**=*"sqlite"*,
        **database**=*"$GISDBASE/$LOCATION_NAME/$MAPSET/sqlite/sqlite.db"*,
        **schema**=*None*,
        **group**=*None*,
        **format**=*"plain"*,
        **flags**=*None*,
        **verbose**=*None*,
        **quiet**=*None*,
        **superquiet**=*None*)

    Example:

    ```python
    gs.parse_command("db.connect", format="json")
    ```

=== "Python (grass.tools)"

    *grass.tools.Tools.db_connect*(**driver**=*"sqlite"*,
        **database**=*"$GISDBASE/$LOCATION_NAME/$MAPSET/sqlite/sqlite.db"*,
        **schema**=*None*,
        **group**=*None*,
        **format**=*"plain"*,
        **flags**=*None*,
        **verbose**=*None*,
        **quiet**=*None*,
        **superquiet**=*None*)

    Example:

    ```python
    tools = Tools()
    tools.db_connect(format="json")
    ```

    This grass.tools API is experimental in version 8.5 and expected to be stable in version 8.6.

## Parameters

=== "Command line"

    **driver**=*name*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of database driver  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *dbf, odbc, ogr, pg, sqlite*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *sqlite*  
    **database**=*name*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of database  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *$GISDBASE/$LOCATION_NAME/$MAPSET/sqlite/sqlite.db*  
    **schema**=*name*  
    &nbsp;&nbsp;&nbsp;&nbsp;Database schema  
    &nbsp;&nbsp;&nbsp;&nbsp;Do not use this option if schemas are not supported by driver/database server  
    **group**=*string*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default group of database users to which select privilege is granted  
    **format**=*name* **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;Output format  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *plain, shell, json*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *plain*  
    &nbsp;&nbsp;&nbsp;&nbsp;**plain**: Plain text output  
    &nbsp;&nbsp;&nbsp;&nbsp;**shell**: shell script style output  
    &nbsp;&nbsp;&nbsp;&nbsp;**json**: JSON (JavaScript Object Notation)  
    **-p**  
    &nbsp;&nbsp;&nbsp;&nbsp;Print current connection parameters and exit  
  
    **-g**  
    &nbsp;&nbsp;&nbsp;&nbsp;Print current connection parameters using shell style and exit [deprecated]  
    &nbsp;&nbsp;&nbsp;&nbsp;This flag is deprecated and will be removed in a future release. Use format=shell instead.  
    **-c**  
    &nbsp;&nbsp;&nbsp;&nbsp;Check connection parameters, set if uninitialized, and exit  
    **-d**  
    &nbsp;&nbsp;&nbsp;&nbsp;Set from default settings and exit  
    &nbsp;&nbsp;&nbsp;&nbsp;Overwrite current settings if already initialized  
    **--help**  
    &nbsp;&nbsp;&nbsp;&nbsp;Print usage summary  
    **--verbose**  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    **--quiet**  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    **--qq**  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    **--ui**  
    &nbsp;&nbsp;&nbsp;&nbsp;Force launching GUI dialog

=== "Python (grass.script)"

    **driver** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of database driver  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, dbdriver, *name*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *dbf, odbc, ogr, pg, sqlite*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *sqlite*  
    **database** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of database  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, dbname, *name*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *$GISDBASE/$LOCATION_NAME/$MAPSET/sqlite/sqlite.db*  
    **schema** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Database schema  
    &nbsp;&nbsp;&nbsp;&nbsp;Do not use this option if schemas are not supported by driver/database server  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: *name*  
    **group** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default group of database users to which select privilege is granted  
    **format** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Output format  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: *name*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *plain, shell, json*  
    &nbsp;&nbsp;&nbsp;&nbsp;**plain**: Plain text output  
    &nbsp;&nbsp;&nbsp;&nbsp;**shell**: shell script style output  
    &nbsp;&nbsp;&nbsp;&nbsp;**json**: JSON (JavaScript Object Notation)  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *plain*  
    **flags** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *p*, *g*, *c*, *d*  
    &nbsp;&nbsp;&nbsp;&nbsp;**p**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Print current connection parameters and exit  
  
    &nbsp;&nbsp;&nbsp;&nbsp;**g**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Print current connection parameters using shell style and exit [deprecated]  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;This flag is deprecated and will be removed in a future release. Use format=shell instead.  
    &nbsp;&nbsp;&nbsp;&nbsp;**c**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Check connection parameters, set if uninitialized, and exit  
    &nbsp;&nbsp;&nbsp;&nbsp;**d**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Set from default settings and exit  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Overwrite current settings if already initialized  
    **verbose** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **quiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **superquiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  

=== "Python (grass.tools)"

    **driver** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of database driver  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, dbdriver, *name*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *dbf, odbc, ogr, pg, sqlite*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *sqlite*  
    **database** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of database  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, dbname, *name*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *$GISDBASE/$LOCATION_NAME/$MAPSET/sqlite/sqlite.db*  
    **schema** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Database schema  
    &nbsp;&nbsp;&nbsp;&nbsp;Do not use this option if schemas are not supported by driver/database server  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: *name*  
    **group** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default group of database users to which select privilege is granted  
    **format** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Output format  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: *name*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *plain, shell, json*  
    &nbsp;&nbsp;&nbsp;&nbsp;**plain**: Plain text output  
    &nbsp;&nbsp;&nbsp;&nbsp;**shell**: shell script style output  
    &nbsp;&nbsp;&nbsp;&nbsp;**json**: JSON (JavaScript Object Notation)  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *plain*  
    **flags** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *p*, *g*, *c*, *d*  
    &nbsp;&nbsp;&nbsp;&nbsp;**p**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Print current connection parameters and exit  
  
    &nbsp;&nbsp;&nbsp;&nbsp;**g**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Print current connection parameters using shell style and exit [deprecated]  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;This flag is deprecated and will be removed in a future release. Use format=shell instead.  
    &nbsp;&nbsp;&nbsp;&nbsp;**c**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Check connection parameters, set if uninitialized, and exit  
    &nbsp;&nbsp;&nbsp;&nbsp;**d**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Set from default settings and exit  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Overwrite current settings if already initialized  
    **verbose** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **quiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **superquiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  

    Returns:

    **result** : grass.tools.support.ToolResult | None  
    If the tool produces text as standard output, a *ToolResult* object will be returned. Otherwise, `None` will be returned.

    Raises:

    *grass.tools.ToolError*: When the tool ended with an error.

## DESCRIPTION

*db.connect* allows the user to set database connection parameters.
These parameters are then taken as default values by modules so that the
user does not need to enter the parameters each time.

The default database backend in GRASS is [SQLite](grass-sqlite.md)
(since version 7).

## NOTES

Values are stored in the mapset's `VAR` file; the connection is not
tested for validity.

The **-p** flag displays the current connection parameters. Use the **format** option
to specify the output format—`plain`, `shell`, or `json`—with `plain` being the
default.

The **-c** flag will silently check if the connection parameters have
been set, and if not will set them to use GRASS's default values.
(useful in scripts before you attempt to create a new database table)

The **-g** flag is deprecated and will be removed in a future release. Please
use **format=shell** option with the **-p** flag instead.

To connect a vector map to a database table, use
*[v.db.connect](v.db.connect.md)* or
*[v.db.addtable](v.db.addtable.md)*.

## EXAMPLES

### SQLite (default backend)

Local storage:  

```sh
db.connect -d
db.connect -p
db.tables -p
```

The SQLite database file is created automatically when used the first
time.

See [SQLite](grass-sqlite.md) database driver for details.

### PostgreSQL (local connection)

Local storage, database tables stored in database "mydb" (may require
the use of *[db.login](db.login.md)*):  

```sh
db.connect driver=pg database=mydb
db.login user=myname pass=secret
db.connect -p
db.tables -p
```

See [PostgreSQL](grass-pg.md) database driver for details.

### PostgreSQL (network connection)

Network storage, database tables stored in database "mydb" (may require
the use of *[db.login](db.login.md)*):  

```sh
db.connect driver=pg database=mydb
db.login user=myname pass=secret host=myserver.com port=6666
db.connect -p
db.tables -p
```

See [PostgreSQL](grass-pg.md) database driver for details.

### MySQL (local connection)

Local storage, database tables stored in database "mydb" (may require
the use of *[db.login](db.login.md)*):  

```sh
db.connect driver=mysql database=mydb
db.login user=myname pass=secret
db.connect -p
db.tables -p
```

See [MySQL](grass-mysql.md) database driver for details.

### MySQL (network connection)

Network storage, database tables stored in database "mydb" (may require
the use of *[db.login](db.login.md)*):  

```sh
db.connect driver=mysql database=mydb
db.login user=myname pass=secret host=myserver.com
db.connect -p
db.tables -p
```

See [MySQL](grass-mysql.md) database driver for details.

### ODBC

Network storage, database tables stored in database "mydb" (may require
the use of *[db.login](db.login.md)*):  

```sh
db.connect driver=odbc database=mydb
db.login user=myname pass=secret
db.connect -p
db.tables -p
```

See [ODBC](grass-odbc.md) database driver for details.

### Print current connection parameters using Python

```python
import grass.script as gs

data = gs.parse_command("db.connect", flags="p", format="json")
print(data)
```

Possible output:

```text
{'driver': 'sqlite', 'database_template': '$GISDBASE/$LOCATION_NAME/$MAPSET/sqlite/sqlite.db', 'database': '/grassdata/PERMANENT/sqlite/sqlite.db', 'schema': None, 'group': None}
```

### DBF (local, not recommended)

Local storage (the dbf/ subdirectory in the mapset must exist or must be
created by the user):  

```sh
db.connect driver=dbf database='$GISDBASE/$LOCATION_NAME/$MAPSET/dbf/'
db.tables -p
```

See [DBF](grass-dbf.md) database driver for details.

## SEE ALSO

*[db.columns](db.columns.md), [db.copy](db.copy.md),
[db.drivers](db.drivers.md), [db.login](db.login.md),
[db.tables](db.tables.md), [v.db.addtable](v.db.addtable.md),
[v.db.connect](v.db.connect.md)*

[GRASS SQL interface](sql.md)

## AUTHORS

Main author: Radim Blazek, ITC-Irst, Trento, Italy  
GRASS 7 improvements: Martin Landa, Markus Metz

## SOURCE CODE

Available at: [db.connect source code](https://github.com/OSGeo/grass/tree/main/db/db.connect)
([history](https://github.com/OSGeo/grass/commits/main/db/db.connect))  
Latest change: Thursday Oct 02 14:39:13 2025 in commit [1850489](https://github.com/OSGeo/grass/commit/1850489bf42c72d8dcfe2e4db1738441b4a7dc43)
