<style>
.img-list {
    margin: 0;
    padding: 0;
    list-style-type: none;
}

.img-list li {
    padding: 5px;
    overflow: auto;
}

.img-list li:hover {
    background-color: #eee;
}

.img-list li a {
    color: initial;
    text-decoration: none;
    display: block;
}

.img-list li img {
    width: 10%;
    float: left;
    margin: 0 15px 0 0;
    background: white;
    object-fit: scale-down;
}

.img-list li img.default-img {
    max-height: 5ex;
    background-color: var(--gs-primary-color);
    padding: 5px;
}

.img-list li .desc {
    margin: 0px;
}

.img-list li .name {
    margin: 5px;
    display: block;
    color: #409940;
    font-weight: bold;
    font-style: italic;
}
</style>
Go to <a href="imageryintro.html">imagery introduction</a> | <a href="topics.html">topics</a> <p>
# Imagery tools
<ul class="img-list"><li><a href="i.albedo.html"><img class="linkimg" src="i_albedo_landsat5.png"></a><a href="i.albedo.html"><span class="name">i.albedo</span> <span class="desc">Computes broad band albedo from surface reflectance.</span></a></li><li><a href="i.aster.toar.html"><img class="default-img" src="grass_logo.svg"></a><a href="i.aster.toar.html"><span class="name">i.aster.toar</span> <span class="desc">Calculates Top of Atmosphere Radiance/Reflectance/Brightness Temperature from ASTER DN.</span></a></li><li><a href="i.atcorr.html"><img class="linkimg" src="i_atcorr_B02_atcorr.png"></a><a href="i.atcorr.html"><span class="name">i.atcorr</span> <span class="desc">Performs atmospheric correction using the 6S algorithm. 6S - Second Simulation of Satellite Signal in the Solar Spectrum.</span></a></li><li><a href="i.band.library.html"><img class="default-img" src="grass_logo.svg"></a><a href="i.band.library.html"><span class="name">i.band.library</span> <span class="desc">Prints available semantic label information used for multispectral data.</span></a></li><li><a href="i.biomass.html"><img class="default-img" src="grass_logo.svg"></a><a href="i.biomass.html"><span class="name">i.biomass</span> <span class="desc">Computes biomass growth, precursor of crop yield calculation.</span></a></li><li><a href="i.cca.html"><img class="default-img" src="grass_logo.svg"></a><a href="i.cca.html"><span class="name">i.cca</span> <span class="desc">Canonical components analysis (CCA) program for image processing.</span></a></li><li><a href="i.cluster.html"><img class="linkimg" src="i_cluster_landsat_clustering.png"></a><a href="i.cluster.html"><span class="name">i.cluster</span> <span class="desc">Generates spectral signatures for land cover types in an image using a clustering algorithm. The resulting signature file is used as input for i.maxlik, to generate an unsupervised image classification.</span></a></li><li><a href="i.colors.enhance.html"><img class="linkimg" src="i_colors_enhance_corrected.jpg"></a><a href="i.colors.enhance.html"><span class="name">i.colors.enhance</span> <span class="desc">Performs auto-balancing of colors for RGB images.</span></a></li><li><a href="i.eb.eta.html"><img class="default-img" src="grass_logo.svg"></a><a href="i.eb.eta.html"><span class="name">i.eb.eta</span> <span class="desc">Actual evapotranspiration for diurnal period (Bastiaanssen, 1995).</span></a></li><li><a href="i.eb.evapfr.html"><img class="default-img" src="grass_logo.svg"></a><a href="i.eb.evapfr.html"><span class="name">i.eb.evapfr</span> <span class="desc">Computes evaporative fraction and root zone soil moisture.</span></a></li><li><a href="i.eb.hsebal01.html"><img class="default-img" src="grass_logo.svg"></a><a href="i.eb.hsebal01.html"><span class="name">i.eb.hsebal01</span> <span class="desc">Computes sensible heat flux iteration SEBAL 01.</span></a></li><li><a href="i.eb.netrad.html"><img class="default-img" src="grass_logo.svg"></a><a href="i.eb.netrad.html"><span class="name">i.eb.netrad</span> <span class="desc">Net radiation approximation (Bastiaanssen, 1995).</span></a></li><li><a href="i.eb.soilheatflux.html"><img class="default-img" src="grass_logo.svg"></a><a href="i.eb.soilheatflux.html"><span class="name">i.eb.soilheatflux</span> <span class="desc">Soil heat flux approximation (Bastiaanssen, 1995).</span></a></li><li><a href="i.emissivity.html"><img class="default-img" src="grass_logo.svg"></a><a href="i.emissivity.html"><span class="name">i.emissivity</span> <span class="desc">Computes emissivity from NDVI, generic method for sparse land.</span></a></li><li><a href="i.evapo.mh.html"><img class="default-img" src="grass_logo.svg"></a><a href="i.evapo.mh.html"><span class="name">i.evapo.mh</span> <span class="desc">Computes evapotranspiration calculation modified or original Hargreaves formulation, 2001.</span></a></li><li><a href="i.evapo.pm.html"><img class="default-img" src="grass_logo.svg"></a><a href="i.evapo.pm.html"><span class="name">i.evapo.pm</span> <span class="desc">Computes potential evapotranspiration calculation with hourly Penman-Monteith.</span></a></li><li><a href="i.evapo.pt.html"><img class="default-img" src="grass_logo.svg"></a><a href="i.evapo.pt.html"><span class="name">i.evapo.pt</span> <span class="desc">Computes evapotranspiration calculation Priestley and Taylor formulation, 1972.</span></a></li><li><a href="i.evapo.time.html"><img class="linkimg" src="i_evapo_time.png"></a><a href="i.evapo.time.html"><span class="name">i.evapo.time</span> <span class="desc">Computes temporal integration of satellite ET actual (ETa) following the daily ET reference (ETo) from meteorological station(s).</span></a></li><li><a href="i.fft.html"><img class="default-img" src="grass_logo.svg"></a><a href="i.fft.html"><span class="name">i.fft</span> <span class="desc">Fast Fourier Transform (FFT) for image processing.</span></a></li><li><a href="i.gensig.html"><img class="default-img" src="grass_logo.svg"></a><a href="i.gensig.html"><span class="name">i.gensig</span> <span class="desc">Generates statistics for i.maxlik from raster map.</span></a></li><li><a href="i.gensigset.html"><img class="default-img" src="grass_logo.svg"></a><a href="i.gensigset.html"><span class="name">i.gensigset</span> <span class="desc">Generates statistics for i.smap from raster map.</span></a></li><li><a href="i.group.html"><img class="default-img" src="grass_logo.svg"></a><a href="i.group.html"><span class="name">i.group</span> <span class="desc">Creates, edits, and lists groups of imagery data.</span></a></li><li><a href="i.his.rgb.html"><img class="default-img" src="grass_logo.svg"></a><a href="i.his.rgb.html"><span class="name">i.his.rgb</span> <span class="desc">Transforms raster maps from HIS (Hue-Intensity-Saturation) color space to RGB (Red-Green-Blue) color space.</span></a></li><li><a href="i.ifft.html"><img class="default-img" src="grass_logo.svg"></a><a href="i.ifft.html"><span class="name">i.ifft</span> <span class="desc">Inverse Fast Fourier Transform (IFFT) for image processing.</span></a></li><li><a href="i.image.mosaic.html"><img class="default-img" src="grass_logo.svg"></a><a href="i.image.mosaic.html"><span class="name">i.image.mosaic</span> <span class="desc">Mosaics several images and extends colormap.</span></a></li><li><a href="i.in.spotvgt.html"><img class="default-img" src="grass_logo.svg"></a><a href="i.in.spotvgt.html"><span class="name">i.in.spotvgt</span> <span class="desc">Imports SPOT VGT NDVI data into a raster map.</span></a></li><li><a href="i.landsat.acca.html"><img class="default-img" src="grass_logo.svg"></a><a href="i.landsat.acca.html"><span class="name">i.landsat.acca</span> <span class="desc">Performs Landsat TM/ETM+ Automatic Cloud Cover Assessment (ACCA).</span></a></li><li><a href="i.landsat.toar.html"><img class="default-img" src="grass_logo.svg"></a><a href="i.landsat.toar.html"><span class="name">i.landsat.toar</span> <span class="desc">Calculates top-of-atmosphere radiance or reflectance and temperature for Landsat MSS/TM/ETM+/OLI</span></a></li><li><a href="i.maxlik.html"><img class="linkimg" src="i_maxlik_rgb.png"></a><a href="i.maxlik.html"><span class="name">i.maxlik</span> <span class="desc">Classifies the cell spectral reflectances in imagery data. Classification is based on the spectral signature information generated by either i.cluster, g.gui.iclass, or i.gensig.</span></a></li><li><a href="i.modis.qc.html"><img class="default-img" src="grass_logo.svg"></a><a href="i.modis.qc.html"><span class="name">i.modis.qc</span> <span class="desc">Extracts quality control parameters from MODIS QC layers.</span></a></li><li><a href="i.oif.html"><img class="default-img" src="grass_logo.svg"></a><a href="i.oif.html"><span class="name">i.oif</span> <span class="desc">Calculates Optimum-Index-Factor table for spectral bands</span></a></li><li><a href="i.ortho.camera.html"><img class="linkimg" src="i_ortho_camera.png"></a><a href="i.ortho.camera.html"><span class="name">i.ortho.camera</span> <span class="desc">Select and modify the imagery group camera reference file.</span></a></li><li><a href="i.ortho.elev.html"><img class="default-img" src="grass_logo.svg"></a><a href="i.ortho.elev.html"><span class="name">i.ortho.elev</span> <span class="desc">Select or modify the target elevation model.</span></a></li><li><a href="i.ortho.init.html"><img class="default-img" src="grass_logo.svg"></a><a href="i.ortho.init.html"><span class="name">i.ortho.init</span> <span class="desc">Interactively creates or modifies entries in a camera initial exposure station file for imagery group referenced by a sub-block.</span></a></li><li><a href="i.ortho.photo.html"><img class="linkimg" src="i_ortho_photo_step1.png"></a><a href="i.ortho.photo.html"><span class="name">i.ortho.photo</span> <span class="desc">Menu driver for the photo imagery programs.</span></a></li><li><a href="i.ortho.rectify.html"><img class="default-img" src="grass_logo.svg"></a><a href="i.ortho.rectify.html"><span class="name">i.ortho.rectify</span> <span class="desc">Orthorectifies an image by using the image to photo coordinate transformation matrix.</span></a></li><li><a href="i.ortho.target.html"><img class="default-img" src="grass_logo.svg"></a><a href="i.ortho.target.html"><span class="name">i.ortho.target</span> <span class="desc">Select or modify the imagery group target.</span></a></li><li><a href="i.ortho.transform.html"><img class="default-img" src="grass_logo.svg"></a><a href="i.ortho.transform.html"><span class="name">i.ortho.transform</span> <span class="desc">Computes a coordinate transformation based on the control points.</span></a></li><li><a href="i.pansharpen.html"><img class="linkimg" src="i_pansharpen_rgb_ihs542.jpg"></a><a href="i.pansharpen.html"><span class="name">i.pansharpen</span> <span class="desc">Image fusion algorithms to sharpen multispectral with high-res panchromatic channels</span></a></li><li><a href="i.pca.html"><img class="linkimg" src="i_pca_result.png"></a><a href="i.pca.html"><span class="name">i.pca</span> <span class="desc">Principal components analysis (PCA) for image processing.</span></a></li><li><a href="i.rectify.html"><img class="default-img" src="grass_logo.svg"></a><a href="i.rectify.html"><span class="name">i.rectify</span> <span class="desc">Rectifies an image by computing a coordinate transformation for each pixel in the image based on the control points.</span></a></li><li><a href="i.rgb.his.html"><img class="default-img" src="grass_logo.svg"></a><a href="i.rgb.his.html"><span class="name">i.rgb.his</span> <span class="desc">Transforms raster maps from RGB (Red-Green-Blue) color space to HIS (Hue-Intensity-Saturation) color space.</span></a></li><li><a href="i.segment.html"><img class="linkimg" src="i_segment_lsat7_pan.png"></a><a href="i.segment.html"><span class="name">i.segment</span> <span class="desc">Identifies segments (objects) from imagery data.</span></a></li><li><a href="i.signatures.html"><img class="default-img" src="grass_logo.svg"></a><a href="i.signatures.html"><span class="name">i.signatures</span> <span class="desc">Manage imagery classification signature files</span></a></li><li><a href="i.smap.html"><img class="default-img" src="grass_logo.svg"></a><a href="i.smap.html"><span class="name">i.smap</span> <span class="desc">Performs contextual image classification using sequential maximum a posteriori (SMAP) estimation.</span></a></li><li><a href="i.spectral.html"><img class="linkimg" src="i_spectral.png"></a><a href="i.spectral.html"><span class="name">i.spectral</span> <span class="desc">Displays spectral response at user specified locations in group or images.</span></a></li><li><a href="i.target.html"><img class="default-img" src="grass_logo.svg"></a><a href="i.target.html"><span class="name">i.target</span> <span class="desc">Targets an imagery group to a GRASS location and mapset.</span></a></li><li><a href="i.tasscap.html"><img class="linkimg" src="i_tasscap_haze.jpg"></a><a href="i.tasscap.html"><span class="name">i.tasscap</span> <span class="desc">Performs Tasseled Cap (Kauth Thomas) transformation.</span></a></li><li><a href="i.topo.corr.html"><img class="linkimg" src="i_topo_corr_angles.png"></a><a href="i.topo.corr.html"><span class="name">i.topo.corr</span> <span class="desc">Computes topographic correction of reflectance.</span></a></li><li><a href="i.vi.html"><img class="linkimg" src="i_vi_arvi.png"></a><a href="i.vi.html"><span class="name">i.vi</span> <span class="desc">Calculates different types of vegetation indices. Uses red and nir bands mostly, and some indices require additional bands.</span></a></li><li><a href="i.zc.html"><img class="default-img" src="grass_logo.svg"></a><a href="i.zc.html"><span class="name">i.zc</span> <span class="desc">Zero-crossing "edge detection" raster function for image processing.</span></a></li></ul>