---
name: r.out.mpeg
description: Converts raster map series to MPEG movie.
keywords: [ raster, export, output, animation ]
---

# r.out.mpeg

Converts raster map series to MPEG movie.

=== "Command line"

    **r.out.mpeg**
    [**-c**]
    **view1**=*name* [,*name*,...]
    [**view2**=*name* [,*name*,...]]
    [**view3**=*name* [,*name*,...]]
    [**view4**=*name* [,*name*,...]]
    **output**=*name*
    [**quality**=*integer*]
    [**--overwrite**]
    [**--verbose**]
    [**--quiet**]
    [**--qq**]
    [**--ui**]

    Example:

    ```sh
    r.out.mpeg view1=name output=name
    ```

=== "Python (grass.script)"

    *grass.script.run_command*("***r.out.mpeg***",
        **view1**,
        **view2**=*None*,
        **view3**=*None*,
        **view4**=*None*,
        **output**,
        **quality**=*3*,
        **flags**=*None*,
        **overwrite**=*None*,
        **verbose**=*None*,
        **quiet**=*None*,
        **superquiet**=*None*)

    Example:

    ```python
    gs.run_command("r.out.mpeg", view1="name", output="name")
    ```

=== "Python (grass.tools)"

    *grass.tools.Tools.r_out_mpeg*(**view1**,
        **view2**=*None*,
        **view3**=*None*,
        **view4**=*None*,
        **output**,
        **quality**=*3*,
        **flags**=*None*,
        **overwrite**=*None*,
        **verbose**=*None*,
        **quiet**=*None*,
        **superquiet**=*None*)

    Example:

    ```python
    tools = Tools()
    tools.r_out_mpeg(view1="name", output="name")
    ```

    This grass.tools API is experimental in version 8.5 and expected to be stable in version 8.6.

## Parameters

=== "Command line"

    **view1**=*name* [,*name*,...] **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of input raster map(s) for view no.1  
    **view2**=*name* [,*name*,...]  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of input raster map(s) for view no.2  
    **view3**=*name* [,*name*,...]  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of input raster map(s) for view no.3  
    **view4**=*name* [,*name*,...]  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of input raster map(s) for view no.4  
    **output**=*name* **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;Name for output file  
    **quality**=*integer*  
    &nbsp;&nbsp;&nbsp;&nbsp;Quality factor (1 = highest quality, lowest compression)  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *1-5*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *3*  
    **-c**  
    &nbsp;&nbsp;&nbsp;&nbsp;Convert on the fly, uses less disk space  
    &nbsp;&nbsp;&nbsp;&nbsp;Requires r.out.ppm with stdout option  
    **--overwrite**  
    &nbsp;&nbsp;&nbsp;&nbsp;Allow output files to overwrite existing files  
    **--help**  
    &nbsp;&nbsp;&nbsp;&nbsp;Print usage summary  
    **--verbose**  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    **--quiet**  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    **--qq**  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    **--ui**  
    &nbsp;&nbsp;&nbsp;&nbsp;Force launching GUI dialog

=== "Python (grass.script)"

    **view1** : str | list[str], *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of input raster map(s) for view no.1  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, raster, *name*  
    **view2** : str | list[str], *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of input raster map(s) for view no.2  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, raster, *name*  
    **view3** : str | list[str], *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of input raster map(s) for view no.3  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, raster, *name*  
    **view4** : str | list[str], *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of input raster map(s) for view no.4  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, raster, *name*  
    **output** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name for output file  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: output, file, *name*  
    **quality** : int, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Quality factor (1 = highest quality, lowest compression)  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *1-5*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *3*  
    **flags** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *c*  
    &nbsp;&nbsp;&nbsp;&nbsp;**c**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Convert on the fly, uses less disk space  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Requires r.out.ppm with stdout option  
    **overwrite** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allow output files to overwrite existing files  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **verbose** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **quiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **superquiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  

=== "Python (grass.tools)"

    **view1** : str | list[str], *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of input raster map(s) for view no.1  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, raster, *name*  
    **view2** : str | list[str], *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of input raster map(s) for view no.2  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, raster, *name*  
    **view3** : str | list[str], *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of input raster map(s) for view no.3  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, raster, *name*  
    **view4** : str | list[str], *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of input raster map(s) for view no.4  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, raster, *name*  
    **output** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name for output file  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: output, file, *name*  
    **quality** : int, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Quality factor (1 = highest quality, lowest compression)  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *1-5*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *3*  
    **flags** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *c*  
    &nbsp;&nbsp;&nbsp;&nbsp;**c**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Convert on the fly, uses less disk space  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Requires r.out.ppm with stdout option  
    **overwrite** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allow output files to overwrite existing files  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **verbose** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **quiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **superquiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  

    Returns:

    **result** : grass.tools.support.ToolResult | None  
    If the tool produces text as standard output, a *ToolResult* object will be returned. Otherwise, `None` will be returned.

    Raises:

    *grass.tools.ToolError*: When the tool ended with an error.

## DESCRIPTION

*r.out.mpeg* is a tool for combining a series of GRASS raster maps into
a single MPEG-1 ([Motion Pictures Experts
Group](https://en.wikipedia.org/wiki/Moving_Picture_Experts_Group))
format file. MPEG-1 is a "lossy" video compression format, so the
quality of each resulting frame of the animation will be much diminished
from the original raster image. The resulting output file may then be
viewed using your favorite mpeg-format viewing program. MPEG-2 and
MPEG-4 provide much better quality animations.

The user may define up to four "views", or sub-windows, to animate
simultaneously. e.g., View 1 could be rainfall, View 2 flooded areas,
View 3 damage to bridges or levees, View 4 other economic damage, all
animated as a time series. A black border 2 pixels wide is drawn around
each view. There is an arbitrary limit of 400 files per view (400
animation frames). Temporary files are created in the conversion
process, so lack of adequate tmp space could also limit the number of
frames you are able to convert.

The environment variable GMPEG_SIZE is checked for a value to use as the
dimension, in pixels, of the longest dimension of the animation image.
If GMPEG_SIZE is not set, the animation size defaults to the rows &
columns in the current GRASS region, scaling if necessary to a default
minimum size of 200 and maximum of 500. These size defaults are
overridden when using the **-c** flag (see below). The resolution of the
current GRASS region is maintained, independent of image size. Playback
programs have to decode the compressed data "on-the-fly", therefore
smaller dimensioned animations will provide higher frame rates and
smoother animations.

UNIX - style wild cards may be used with the command line version in
place of a raster map name, but wild cards must be quoted.

A quality value of **quality=1** will yield higher quality images, but
with less compression (larger MPEG file size). Compression ratios will
vary depending on the number of frames in the animation, but an MPEG
produced using **quality=5** will usually be about 60% the size of the
MPEG produced using **quality=1**.

## EXAMPLES

```sh
r.out.mpeg view1="rain[1-9]","rain1[0-2]" view2="temp*"
```

If the number of files differs for each view, the view with the fewest
files will determine the number of frames in the animation.

With **-c** flag the module converts "on the fly", uses less disk space
by using *[r.out.ppm](r.out.ppm.md)* with stdout option to convert
frames as needed instead of converting all frames to ppm before
encoding. Only use when encoding a single view. Use of this option also
overrides any size defaults, using the **CURRENTLY DEFINED GRASS REGION
for the output size**. So be careful to set region to a reasonable size
prior to encoding.

## KNOWN ISSUES

MPEG images must be 16-pixel aligned for successful compression, so if
the rows & columns of the calculated image size (scaled, with borders
added) are not evenly divisible by 16, a few rows/columns will be cut
off the bottom & right sides of the image. The MPEG format is optimized
to recognize image MOTION, so abrupt changes from one frame to another
will cause a "noisy" encoding.

## NOTES

This program requires the program *mpeg_encode* (aka *ppmtompeg*):

MPEG-1 Video Software Encoder  
(Version 1.3; March 14, 1994)

Lawrence A. Rowe, Kevin Gong, Ketan Patel, and Dan Wallach Computer
Science Division-EECS, Univ. of Calif. at Berkeley

Available from Berkeley:
[http://biowiki.org/BerkeleyMpegEncoder](https://web.archive.org/web/20091223063452/http://biowiki.org/BerkeleyMpegEncoder)
(Wayback machine)  
or as part of the netpbm package (*ppmtompeg*):
<https://netpbm.sourceforge.net>

Use of the **-c** flag requires the *[r.out.ppm](r.out.ppm.md)* GRASS
module with the **stdout** option.

## SEE ALSO

*[r.out.ppm](r.out.ppm.md)*  

## AUTHOR

Bill Brown, U.S. Army Construction Engineering Research Laboratories

## SOURCE CODE

Available at: [r.out.mpeg source code](https://github.com/OSGeo/grass/tree/main/raster/r.out.mpeg)
([history](https://github.com/OSGeo/grass/commits/main/raster/r.out.mpeg))  
Latest change: Thursday Sep 04 04:17:35 2025 in commit [61f7953](https://github.com/OSGeo/grass/commit/61f7953c9e70117eff9f1cbf65b3aad68b95e7fb)
