---
name: v.out.vtk
description: Converts a vector map to VTK ASCII output.
keywords: [ vector, export, output, VTK ]
---

# v.out.vtk

Converts a vector map to VTK ASCII output.

=== "Command line"

    **v.out.vtk**
    [**-cn**]
    **input**=*name*
    [**layer**=*string*]
    [**output**=*name*]
    [**type**=*string* [,*string*,...]]
    [**precision**=*integer*]
    [**zscale**=*float*]
    [**--overwrite**]
    [**--verbose**]
    [**--quiet**]
    [**--qq**]
    [**--ui**]

    Example:

    ```sh
    v.out.vtk input=name
    ```

=== "Python (grass.script)"

    *grass.script.run_command*("***v.out.vtk***",
        **input**,
        **layer**=*"1"*,
        **output**=*None*,
        **type**=*"point,kernel,centroid,line,boundary,area,face"*,
        **precision**=*None*,
        **zscale**=*1.0*,
        **flags**=*None*,
        **overwrite**=*None*,
        **verbose**=*None*,
        **quiet**=*None*,
        **superquiet**=*None*)

    Example:

    ```python
    gs.run_command("v.out.vtk", input="name")
    ```

=== "Python (grass.tools)"

    *grass.tools.Tools.v_out_vtk*(**input**,
        **layer**=*"1"*,
        **output**=*None*,
        **type**=*"point,kernel,centroid,line,boundary,area,face"*,
        **precision**=*None*,
        **zscale**=*1.0*,
        **flags**=*None*,
        **overwrite**=*None*,
        **verbose**=*None*,
        **quiet**=*None*,
        **superquiet**=*None*)

    Example:

    ```python
    tools = Tools()
    tools.v_out_vtk(input="name")
    ```

    This grass.tools API is experimental in version 8.5 and expected to be stable in version 8.6.

## Parameters

=== "Command line"

    **input**=*name* **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of input vector map  
    &nbsp;&nbsp;&nbsp;&nbsp;Or data source for direct OGR access  
    **layer**=*string*  
    &nbsp;&nbsp;&nbsp;&nbsp;Layer number or name  
    &nbsp;&nbsp;&nbsp;&nbsp;Vector features can have category values in different layers. This number determines which layer to use. When used with direct OGR access this is the layer name.  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *1*  
    **output**=*name*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name for output VTK file  
    **type**=*string* [,*string*,...]  
    &nbsp;&nbsp;&nbsp;&nbsp;Input feature type  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *point, kernel, centroid, line, boundary, area, face*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *point,kernel,centroid,line,boundary,area,face*  
    **precision**=*integer*  
    &nbsp;&nbsp;&nbsp;&nbsp;Number of significant digits  
    **zscale**=*float*  
    &nbsp;&nbsp;&nbsp;&nbsp;Scale factor for elevation  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *1.0*  
    **-c**  
    &nbsp;&nbsp;&nbsp;&nbsp;Correct the coordinates to fit the VTK-OpenGL precision  
    **-n**  
    &nbsp;&nbsp;&nbsp;&nbsp;Export numeric attribute table fields as VTK scalar variables  
    **--overwrite**  
    &nbsp;&nbsp;&nbsp;&nbsp;Allow output files to overwrite existing files  
    **--help**  
    &nbsp;&nbsp;&nbsp;&nbsp;Print usage summary  
    **--verbose**  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    **--quiet**  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    **--qq**  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    **--ui**  
    &nbsp;&nbsp;&nbsp;&nbsp;Force launching GUI dialog

=== "Python (grass.script)"

    **input** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of input vector map  
    &nbsp;&nbsp;&nbsp;&nbsp;Or data source for direct OGR access  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, vector, *name*  
    **layer** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Layer number or name  
    &nbsp;&nbsp;&nbsp;&nbsp;Vector features can have category values in different layers. This number determines which layer to use. When used with direct OGR access this is the layer name.  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, layer  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *1*  
    **output** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name for output VTK file  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: output, file, *name*  
    **type** : str | list[str], *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Input feature type  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *point, kernel, centroid, line, boundary, area, face*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *point,kernel,centroid,line,boundary,area,face*  
    **precision** : int, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Number of significant digits  
    **zscale** : float, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Scale factor for elevation  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *1.0*  
    **flags** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *c*, *n*  
    &nbsp;&nbsp;&nbsp;&nbsp;**c**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Correct the coordinates to fit the VTK-OpenGL precision  
    &nbsp;&nbsp;&nbsp;&nbsp;**n**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Export numeric attribute table fields as VTK scalar variables  
    **overwrite** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allow output files to overwrite existing files  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **verbose** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **quiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **superquiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  

=== "Python (grass.tools)"

    **input** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of input vector map  
    &nbsp;&nbsp;&nbsp;&nbsp;Or data source for direct OGR access  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, vector, *name*  
    **layer** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Layer number or name  
    &nbsp;&nbsp;&nbsp;&nbsp;Vector features can have category values in different layers. This number determines which layer to use. When used with direct OGR access this is the layer name.  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, layer  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *1*  
    **output** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name for output VTK file  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: output, file, *name*  
    **type** : str | list[str], *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Input feature type  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *point, kernel, centroid, line, boundary, area, face*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *point,kernel,centroid,line,boundary,area,face*  
    **precision** : int, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Number of significant digits  
    **zscale** : float, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Scale factor for elevation  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *1.0*  
    **flags** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *c*, *n*  
    &nbsp;&nbsp;&nbsp;&nbsp;**c**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Correct the coordinates to fit the VTK-OpenGL precision  
    &nbsp;&nbsp;&nbsp;&nbsp;**n**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Export numeric attribute table fields as VTK scalar variables  
    **overwrite** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allow output files to overwrite existing files  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **verbose** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **quiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **superquiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  

    Returns:

    **result** : grass.tools.support.ToolResult | None  
    If the tool produces text as standard output, a *ToolResult* object will be returned. Otherwise, `None` will be returned.

    Raises:

    *grass.tools.ToolError*: When the tool ended with an error.

## DESCRIPTION

*v.out.vtk* converts a GRASS vector map in binary format to the VTK
ASCII output.

If the **output** parameter is not given, the output will be send to
stdout.

## NOTES

The following vector types can be exported together in one VTK ascii
file:

- point
- line
- centroid
- boundary
- area
- face

Category data (cat) for the selected vector type and layer will be
written as scalar data with name "cat\_{vectorname}". If no cat exists,
the value will set to -1 as normal cat's are always positive. If a
vector has more categories in one layer, only the first category will be
exported.  
  
3d vectors are supported by default. The created VTK data always
includes x, y and z coordinates (z = 0 if not a 3d vector map). Note
that you can easily convert your 2d vectors into 3d vectors with
v.drape.  
  
Because of the 32bit limits of OpenGL which is used by VTK,
visualisation errors may occur if the grass region contains coordinates
greater than 1.000.000 and vector coordinates with 0.01 - 0.001 meters
precisison. For this reason, the flag "-c" was added. The coordinates
are transformed to smaller coordinates (by decreasing the coordinates
with the region center).  
  
If the "-c" flag is used and the data should be visualised together with
other data exported via \*.out.vtk modules, be sure the "-c" flag was
also set in these modules. But this will only work with data from the
SAME location (The reference point for the coordinates transformation is
based on the default region).  
  
The GRASS vector data is converted into the polydata format of VTK:

- *vtk Vertices* -- representing points and centroids
- *vtk lines* -- representing lines and boundaries
- *vtk polygons* -- representing areas and faces

The VTK file can be visualized with *[VTK Toolkit](https://vtk.org/)*,
*[Paraview](https://www.paraview.org/)* and
*[MayaVi](https://github.com/enthought/mayavi)*.

### Attention

If areas or faces are exported, the data have to be triangulated within
Paraview or MayaVi.

## EXAMPLE

Spearfish example:

Export the soils with cats in layer 1:

```sh
v.out.vtk input=soils type=area layer=1 output=/tmp/soils.vtk
```

Export the streams with cats in layer 1:

```sh
v.out.vtk input=streams type=line layer=1 output=/tmp/streams.vtk
```

Write the archsite vtk output to stdout with cats in layer 1:

```sh
v.out.vtk input=archsites type=point layer=1
```

## SEE ALSO

*[v.out.ascii](v.out.ascii.md), [r.out.vtk](r.out.vtk.md),
[r3.out.vtk](r3.out.vtk.md)*

## AUTHOR

Soeren Gebbert

## SOURCE CODE

Available at: [v.out.vtk source code](https://github.com/OSGeo/grass/tree/main/vector/v.out.vtk)
([history](https://github.com/OSGeo/grass/commits/main/vector/v.out.vtk))  
Latest change: Friday May 09 14:33:40 2025 in commit [b356c7e](https://github.com/OSGeo/grass/commit/b356c7e108fcbeca77474c8e83ebec8f1e7b3e4a)
