---
name: r3.colors.out
description: Exports the color table associated with a 3D raster map.
keywords: [ raster3d, color table, export ]
---

# r3.colors.out

Exports the color table associated with a 3D raster map.

=== "Command line"

    **r3.colors.out**
    [**-p**]
    **map**=*name*
    [**rules**=*name*]
    **format**=*name*
    **color_format**=*name*
    [**--overwrite**]
    [**--verbose**]
    [**--quiet**]
    [**--qq**]
    [**--ui**]

    Example:

    ```sh
    r3.colors.out map=name format=plain color_format=hex
    ```

=== "Python (grass.script)"

    *grass.script.parse_command*("***r3.colors.out***",
        **map**,
        **rules**=*None*,
        **format**=*"plain"*,
        **color_format**=*"hex"*,
        **flags**=*None*,
        **overwrite**=*None*,
        **verbose**=*None*,
        **quiet**=*None*,
        **superquiet**=*None*)

    Example:

    ```python
    gs.parse_command("r3.colors.out", map="name", format="json", color_format="hex")
    ```

=== "Python (grass.tools)"

    *grass.tools.Tools.r3_colors_out*(**map**,
        **rules**=*None*,
        **format**=*"plain"*,
        **color_format**=*"hex"*,
        **flags**=*None*,
        **overwrite**=*None*,
        **verbose**=*None*,
        **quiet**=*None*,
        **superquiet**=*None*)

    Example:

    ```python
    tools = Tools()
    tools.r3_colors_out(map="name", format="json", color_format="hex")
    ```

    This grass.tools API is experimental in version 8.5 and expected to be stable in version 8.6.

## Parameters

=== "Command line"

    **map**=*name* **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of 3D raster map  
    **rules**=*name*  
    &nbsp;&nbsp;&nbsp;&nbsp;Path to output rules file  
    &nbsp;&nbsp;&nbsp;&nbsp;If not given write to standard output  
    **format**=*name* **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;Output format  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *plain, json*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *plain*  
    &nbsp;&nbsp;&nbsp;&nbsp;**plain**: Plain text output  
    &nbsp;&nbsp;&nbsp;&nbsp;**json**: JSON (JavaScript Object Notation)  
    **color_format**=*name* **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;Color format  
    &nbsp;&nbsp;&nbsp;&nbsp;Color format for output values.  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *rgb, hex, hsv, triplet*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *hex*  
    &nbsp;&nbsp;&nbsp;&nbsp;**rgb**: output color in RGB format  
    &nbsp;&nbsp;&nbsp;&nbsp;**hex**: output color in HEX format  
    &nbsp;&nbsp;&nbsp;&nbsp;**hsv**: output color in HSV format (experimental)  
    &nbsp;&nbsp;&nbsp;&nbsp;**triplet**: output color in colon-separated RGB format  
    **-p**  
    &nbsp;&nbsp;&nbsp;&nbsp;Output values as percentages  
    **--overwrite**  
    &nbsp;&nbsp;&nbsp;&nbsp;Allow output files to overwrite existing files  
    **--help**  
    &nbsp;&nbsp;&nbsp;&nbsp;Print usage summary  
    **--verbose**  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    **--quiet**  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    **--qq**  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    **--ui**  
    &nbsp;&nbsp;&nbsp;&nbsp;Force launching GUI dialog

=== "Python (grass.script)"

    **map** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of 3D raster map  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, raster_3d, *name*  
    **rules** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Path to output rules file  
    &nbsp;&nbsp;&nbsp;&nbsp;If not given write to standard output  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: output, file, *name*  
    **format** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Output format  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: *name*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *plain, json*  
    &nbsp;&nbsp;&nbsp;&nbsp;**plain**: Plain text output  
    &nbsp;&nbsp;&nbsp;&nbsp;**json**: JSON (JavaScript Object Notation)  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *plain*  
    **color_format** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Color format  
    &nbsp;&nbsp;&nbsp;&nbsp;Color format for output values.  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: *name*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *rgb, hex, hsv, triplet*  
    &nbsp;&nbsp;&nbsp;&nbsp;**rgb**: output color in RGB format  
    &nbsp;&nbsp;&nbsp;&nbsp;**hex**: output color in HEX format  
    &nbsp;&nbsp;&nbsp;&nbsp;**hsv**: output color in HSV format (experimental)  
    &nbsp;&nbsp;&nbsp;&nbsp;**triplet**: output color in colon-separated RGB format  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *hex*  
    **flags** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *p*  
    &nbsp;&nbsp;&nbsp;&nbsp;**p**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Output values as percentages  
    **overwrite** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allow output files to overwrite existing files  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **verbose** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **quiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **superquiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  

=== "Python (grass.tools)"

    **map** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of 3D raster map  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, raster_3d, *name*  
    **rules** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Path to output rules file  
    &nbsp;&nbsp;&nbsp;&nbsp;If not given write to standard output  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: output, file, *name*  
    **format** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Output format  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: *name*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *plain, json*  
    &nbsp;&nbsp;&nbsp;&nbsp;**plain**: Plain text output  
    &nbsp;&nbsp;&nbsp;&nbsp;**json**: JSON (JavaScript Object Notation)  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *plain*  
    **color_format** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Color format  
    &nbsp;&nbsp;&nbsp;&nbsp;Color format for output values.  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: *name*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *rgb, hex, hsv, triplet*  
    &nbsp;&nbsp;&nbsp;&nbsp;**rgb**: output color in RGB format  
    &nbsp;&nbsp;&nbsp;&nbsp;**hex**: output color in HEX format  
    &nbsp;&nbsp;&nbsp;&nbsp;**hsv**: output color in HSV format (experimental)  
    &nbsp;&nbsp;&nbsp;&nbsp;**triplet**: output color in colon-separated RGB format  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *hex*  
    **flags** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *p*  
    &nbsp;&nbsp;&nbsp;&nbsp;**p**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Output values as percentages  
    **overwrite** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allow output files to overwrite existing files  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **verbose** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **quiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **superquiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  

    Returns:

    **result** : grass.tools.support.ToolResult | None  
    If the tool produces text as standard output, a *ToolResult* object will be returned. Otherwise, `None` will be returned.

    Raises:

    *grass.tools.ToolError*: When the tool ended with an error.

## DESCRIPTION

*r3.colors.out* allows the user to export the color table for a 3D raster
map to a file which is suitable as input to *[r3.colors](r3.colors.md)*.

Alternatively, the color rules can be exported as a JSON format
with **format=json**, to use them in other software.
The color format in JSON can be modified using the **color_format** parameter,
which includes the following options:

- hex: #00BFBF
- rgb: rgb(0, 191, 191)
- hsv: hsv(180, 100, 74)
- triplet: 0:191:191

## EXAMPLES

=== "Command line"

    ```sh
    r3.mapcalc "random = rand(1, 5)" -s
    r3.colors map=random color=gyr
    r3.colors.out map=random
    ```

    Output:

    ```text
    1 0:255:0
    2.5 255:255:0
    4 255:0:0
    nv 255:255:255
    default 255:255:255
    ```

 === "Python (grass.script)"

    ```python
    import grass.script as gs

    gs.run_command("r3.mapcalc", expression="random = rand(1, 5)", flags="s")
    gs.run_command("r3.colors", map="random", color="gyr")
    colors = gs.parse_command("r3.colors.out", map="random", format="json")
    ```

    The JSON output looks like:

    ```json
    [
        {
            "value": 1,
            "color": "#00FF00"
        },
        {
            "value": 2.5,
            "color": "#FFFF00"
        },
        {
            "value": 4,
            "color": "#FF0000"
        },
        {
            "value": "nv",
            "color": "#FFFFFF"
        },
        {
            "value": "default",
            "color": "#FFFFFF"
        }
    ]
    ```

## SEE ALSO

*[r.colors](r.colors.md), [r.colors.out](r.colors.out.md),
[r3.colors](r3.colors.md) [v.colors](v.colors.md),
[v.colors.out](v.colors.out.md)*

## AUTHOR

Glynn Clements

## SOURCE CODE

Available at: [r3.colors.out source code](https://github.com/OSGeo/grass/tree/main/raster/r.colors.out)
([history](https://github.com/OSGeo/grass/commits/main/raster/r.colors.out))  
Latest change: Wednesday Jun 25 11:38:52 2025 in commit [b90b316](https://github.com/OSGeo/grass/commit/b90b316b7c48d2294de02a91b0c56bb56e46a237)
