---
name: v.report.py
description: Reports geometry statistics for vector maps.
keywords: [ vector, geometry, statistics ]
---

# v.report.py

Reports geometry statistics for vector maps.

=== "Command line"

    **v.report.py**
    [**-cd**]
    **map**=*name*
    [**layer**=*string*]
    **option**=*string*
    [**units**=*string*]
    [**sort**=*string*]
    [**separator**=*character*]
    [**--verbose**]
    [**--quiet**]
    [**--qq**]
    [**--ui**]

    Example:

    ```sh
    v.report.py map=name option=area
    ```

=== "Python (grass.script)"

    *grass.script.run_command*("***v.report.py***",
        **map**,
        **layer**=*"1"*,
        **option**,
        **units**=*None*,
        **sort**=*None*,
        **separator**=*"pipe"*,
        **flags**=*None*,
        **verbose**=*None*,
        **quiet**=*None*,
        **superquiet**=*None*)

    Example:

    ```python
    gs.run_command("v.report.py", map="name", option="area")
    ```

=== "Python (grass.tools)"

    *grass.tools.Tools.v_report_py*(**map**,
        **layer**=*"1"*,
        **option**,
        **units**=*None*,
        **sort**=*None*,
        **separator**=*"pipe"*,
        **flags**=*None*,
        **verbose**=*None*,
        **quiet**=*None*,
        **superquiet**=*None*)

    Example:

    ```python
    tools = Tools()
    tools.v_report_py(map="name", option="area")
    ```

    This grass.tools API is experimental in version 8.5 and expected to be stable in version 8.6.

## Parameters

=== "Command line"

    **map**=*name* **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of vector map  
    &nbsp;&nbsp;&nbsp;&nbsp;Or data source for direct OGR access  
    **layer**=*string*  
    &nbsp;&nbsp;&nbsp;&nbsp;Layer number or name  
    &nbsp;&nbsp;&nbsp;&nbsp;Vector features can have category values in different layers. This number determines which layer to use. When used with direct OGR access this is the layer name.  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *1*  
    **option**=*string* **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;Value to calculate  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *area, length, coor*  
    **units**=*string*  
    &nbsp;&nbsp;&nbsp;&nbsp;Units  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *miles, feet, meters, kilometers, acres, hectares, percent*  
    **sort**=*string*  
    &nbsp;&nbsp;&nbsp;&nbsp;Sort the result  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *asc, desc*  
    &nbsp;&nbsp;&nbsp;&nbsp;**asc**: Sort in ascending order  
    &nbsp;&nbsp;&nbsp;&nbsp;**desc**: Sort in descending order  
    **separator**=*character*  
    &nbsp;&nbsp;&nbsp;&nbsp;Field separator  
    &nbsp;&nbsp;&nbsp;&nbsp;Special characters: pipe, comma, space, tab, newline  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *pipe*  
    **-c**  
    &nbsp;&nbsp;&nbsp;&nbsp;Do not include column names in output  
    **-d**  
    &nbsp;&nbsp;&nbsp;&nbsp;Report for geometries with no database records  
    **--help**  
    &nbsp;&nbsp;&nbsp;&nbsp;Print usage summary  
    **--verbose**  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    **--quiet**  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    **--qq**  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    **--ui**  
    &nbsp;&nbsp;&nbsp;&nbsp;Force launching GUI dialog

=== "Python (grass.script)"

    **map** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of vector map  
    &nbsp;&nbsp;&nbsp;&nbsp;Or data source for direct OGR access  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, vector, *name*  
    **layer** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Layer number or name  
    &nbsp;&nbsp;&nbsp;&nbsp;Vector features can have category values in different layers. This number determines which layer to use. When used with direct OGR access this is the layer name.  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, layer  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *1*  
    **option** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Value to calculate  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *area, length, coor*  
    **units** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Units  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *miles, feet, meters, kilometers, acres, hectares, percent*  
    **sort** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Sort the result  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *asc, desc*  
    &nbsp;&nbsp;&nbsp;&nbsp;**asc**: Sort in ascending order  
    &nbsp;&nbsp;&nbsp;&nbsp;**desc**: Sort in descending order  
    **separator** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Field separator  
    &nbsp;&nbsp;&nbsp;&nbsp;Special characters: pipe, comma, space, tab, newline  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, separator, *character*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *pipe*  
    **flags** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *c*, *d*  
    &nbsp;&nbsp;&nbsp;&nbsp;**c**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Do not include column names in output  
    &nbsp;&nbsp;&nbsp;&nbsp;**d**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Report for geometries with no database records  
    **verbose** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **quiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **superquiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  

=== "Python (grass.tools)"

    **map** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of vector map  
    &nbsp;&nbsp;&nbsp;&nbsp;Or data source for direct OGR access  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, vector, *name*  
    **layer** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Layer number or name  
    &nbsp;&nbsp;&nbsp;&nbsp;Vector features can have category values in different layers. This number determines which layer to use. When used with direct OGR access this is the layer name.  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, layer  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *1*  
    **option** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Value to calculate  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *area, length, coor*  
    **units** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Units  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *miles, feet, meters, kilometers, acres, hectares, percent*  
    **sort** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Sort the result  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *asc, desc*  
    &nbsp;&nbsp;&nbsp;&nbsp;**asc**: Sort in ascending order  
    &nbsp;&nbsp;&nbsp;&nbsp;**desc**: Sort in descending order  
    **separator** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Field separator  
    &nbsp;&nbsp;&nbsp;&nbsp;Special characters: pipe, comma, space, tab, newline  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, separator, *character*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *pipe*  
    **flags** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *c*, *d*  
    &nbsp;&nbsp;&nbsp;&nbsp;**c**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Do not include column names in output  
    &nbsp;&nbsp;&nbsp;&nbsp;**d**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Report for geometries with no database records  
    **verbose** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **quiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **superquiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  

    Returns:

    **result** : grass.tools.support.ToolResult | None  
    If the tool produces text as standard output, a *ToolResult* object will be returned. Otherwise, `None` will be returned.

    Raises:

    *grass.tools.ToolError*: When the tool ended with an error.

## DESCRIPTION

*v.report* generates a table showing the area present in each of the
categories of a user-selected data layer.

Area is given in hectares, square meters, and square kilometers. If the
units option is used, area is given in acres, square feet, and square
miles.

Feet and acre units are always reported in their common versions (i.e.
the International Foot, exactly 5280 feet in a mile), even when the
coordinate reference system's standard map unit is the US Survey foot.

*v.report* works on the full map data; therefore, the current region is
ignored. If you wish to spatially limit the statistics, a map subset
must be created with *v.in.region* and *v.overlay*, and then run
*v.report* on the new map.

## EXAMPLE

North Carolina sample dataset:

```sh
v.report zipcodes_wake option=area units=hectares
```

In the output, there is an extra column added containing the results.

## SEE ALSO

*[v.in.region](v.in.region.md), [v.to.db](v.to.db.md),
[v.overlay](v.overlay.md)*

## AUTHOR

Markus Neteler, GDF Hannover

## SOURCE CODE

Available at: [v.report source code](https://github.com/OSGeo/grass/tree/main/scripts/v.report)
([history](https://github.com/OSGeo/grass/commits/main/scripts/v.report))  
Latest change: Friday Feb 07 19:16:09 2025 in commit [a82a39f](https://github.com/OSGeo/grass/commit/a82a39f673b97fafcfce1604dc3e6015cb96487a)
