---
name: db.login
description: Sets user/password for DB driver/database.
keywords: [ database, connection settings ]
---

# db.login

Sets user/password for DB driver/database.

=== "Command line"

    **db.login**
    [**-p**]
    **driver**=*name*
    **database**=*name*
    [**user**=*string*]
    [**password**=*string*]
    [**host**=*string*]
    [**port**=*string*]
    [**--overwrite**]
    [**--verbose**]
    [**--quiet**]
    [**--qq**]
    [**--ui**]

    Example:

    ```sh
    db.login driver=sqlite database=$GISDBASE/$LOCATION_NAME/$MAPSET/sqlite/sqlite.db
    ```

=== "Python (grass.script)"

    *grass.script.run_command*("***db.login***",
        **driver**=*"sqlite"*,
        **database**=*"$GISDBASE/$LOCATION_NAME/$MAPSET/sqlite/sqlite.db"*,
        **user**=*None*,
        **password**=*None*,
        **host**=*None*,
        **port**=*None*,
        **flags**=*None*,
        **overwrite**=*None*,
        **verbose**=*None*,
        **quiet**=*None*,
        **superquiet**=*None*)

    Example:

    ```python
    gs.run_command("db.login", driver="sqlite", database="$GISDBASE/$LOCATION_NAME/$MAPSET/sqlite/sqlite.db")
    ```

=== "Python (grass.tools)"

    *grass.tools.Tools.db_login*(**driver**=*"sqlite"*,
        **database**=*"$GISDBASE/$LOCATION_NAME/$MAPSET/sqlite/sqlite.db"*,
        **user**=*None*,
        **password**=*None*,
        **host**=*None*,
        **port**=*None*,
        **flags**=*None*,
        **overwrite**=*None*,
        **verbose**=*None*,
        **quiet**=*None*,
        **superquiet**=*None*)

    Example:

    ```python
    tools = Tools()
    tools.db_login(driver="sqlite", database="$GISDBASE/$LOCATION_NAME/$MAPSET/sqlite/sqlite.db")
    ```

    This grass.tools API is experimental in version 8.5 and expected to be stable in version 8.6.

## Parameters

=== "Command line"

    **driver**=*name* **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of database driver  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *dbf, odbc, ogr, pg, sqlite*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *sqlite*  
    **database**=*name* **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of database  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *$GISDBASE/$LOCATION_NAME/$MAPSET/sqlite/sqlite.db*  
    **user**=*string*  
    &nbsp;&nbsp;&nbsp;&nbsp;Username  
    **password**=*string*  
    &nbsp;&nbsp;&nbsp;&nbsp;Password  
    **host**=*string*  
    &nbsp;&nbsp;&nbsp;&nbsp;Hostname  
    &nbsp;&nbsp;&nbsp;&nbsp;Relevant only for pg and mysql driver  
    **port**=*string*  
    &nbsp;&nbsp;&nbsp;&nbsp;Port  
    &nbsp;&nbsp;&nbsp;&nbsp;Relevant only for pg and mysql driver  
    **-p**  
    &nbsp;&nbsp;&nbsp;&nbsp;Print connection settings and exit  
    **--overwrite**  
    &nbsp;&nbsp;&nbsp;&nbsp;Allow output files to overwrite existing files  
    **--help**  
    &nbsp;&nbsp;&nbsp;&nbsp;Print usage summary  
    **--verbose**  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    **--quiet**  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    **--qq**  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    **--ui**  
    &nbsp;&nbsp;&nbsp;&nbsp;Force launching GUI dialog

=== "Python (grass.script)"

    **driver** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of database driver  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, dbdriver, *name*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *dbf, odbc, ogr, pg, sqlite*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *sqlite*  
    **database** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of database  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, dbname, *name*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *$GISDBASE/$LOCATION_NAME/$MAPSET/sqlite/sqlite.db*  
    **user** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Username  
    **password** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Password  
    **host** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Hostname  
    &nbsp;&nbsp;&nbsp;&nbsp;Relevant only for pg and mysql driver  
    **port** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Port  
    &nbsp;&nbsp;&nbsp;&nbsp;Relevant only for pg and mysql driver  
    **flags** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *p*  
    &nbsp;&nbsp;&nbsp;&nbsp;**p**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Print connection settings and exit  
    **overwrite** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allow output files to overwrite existing files  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **verbose** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **quiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **superquiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  

=== "Python (grass.tools)"

    **driver** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of database driver  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, dbdriver, *name*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *dbf, odbc, ogr, pg, sqlite*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *sqlite*  
    **database** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of database  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, dbname, *name*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *$GISDBASE/$LOCATION_NAME/$MAPSET/sqlite/sqlite.db*  
    **user** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Username  
    **password** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Password  
    **host** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Hostname  
    &nbsp;&nbsp;&nbsp;&nbsp;Relevant only for pg and mysql driver  
    **port** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Port  
    &nbsp;&nbsp;&nbsp;&nbsp;Relevant only for pg and mysql driver  
    **flags** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *p*  
    &nbsp;&nbsp;&nbsp;&nbsp;**p**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Print connection settings and exit  
    **overwrite** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allow output files to overwrite existing files  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **verbose** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **quiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **superquiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  

    Returns:

    **result** : grass.tools.support.ToolResult | None  
    If the tool produces text as standard output, a *ToolResult* object will be returned. Otherwise, `None` will be returned.

    Raises:

    *grass.tools.ToolError*: When the tool ended with an error.

## DESCRIPTION

*db.login* sets login parameters such an user name and optionally also a
password, a hostname or a port for the connection to the selected
**database** through the DB **driver**.

## NOTE

Options **host** and **port** are related to only SQL database backends
like [PostgreSQL](grass-pg.md), [MySQL](grass-mysql.md) or
[ODBC](grass-odbc.md).

Note that the passwords are stored in a hidden, *unencrypted* file in
the user account, specifically

- in the 'home' directory, i.e. `$HOME/.grass8/dblogin` (Unix-like
  systems)
- `%APPDATA%\Roaming\GRASS8\dblogin` (MS-Windows)

Only the file owner can access this file.

## EXAMPLES

Only username specified (assuming locally accessible PostgreSQL DB
without password):

```sh
db.login driver=pg database=mydb
```

Username, password and hostname specified (note that the command lines
history will store the password in this way):

```sh
db.login driver=pg database=mydb user=bacava password=secret host=db.example.com
```

Username and empty password specified:

```sh
db.login driver=pg database=mydb user=bacava password=""
```

## SEE ALSO

*[db.connect](db.connect.md), [db.test](db.test.md),
[db.tables](db.tables.md)*

[SQL support in GRASS](sql.md)

## AUTHOR

Radim Blazek  
Support for hostname and port by Martin Landa, OSGeoREL, Czech Technical
University in Prague, Czech Republic (GRASS 7.1)

## SOURCE CODE

Available at: [db.login source code](https://github.com/OSGeo/grass/tree/main/db/db.login)
([history](https://github.com/OSGeo/grass/commits/main/db/db.login))  
Latest change: Friday Aug 08 09:39:19 2025 in commit [ed72c71](https://github.com/OSGeo/grass/commit/ed72c71d8580e872cd6fd345c84a15c324764465)
