---
name: i.group
description: Creates, edits, and lists groups of imagery data.
keywords: [ imagery, map management ]
---

# i.group

Creates, edits, and lists groups of imagery data.

=== "Command line"

    **i.group**
    [**-rlsg**]
    **group**=*name*
    [**subgroup**=*name*]
    [**input**=*name* [,*name*,...]]
    [**file**=*name*]
    **format**=*name*
    [**--verbose**]
    [**--quiet**]
    [**--qq**]
    [**--ui**]

    Example:

    ```sh
    i.group group=name format=plain
    ```

=== "Python (grass.script)"

    *grass.script.parse_command*("***i.group***",
        **group**,
        **subgroup**=*None*,
        **input**=*None*,
        **file**=*None*,
        **format**=*"plain"*,
        **flags**=*None*,
        **verbose**=*None*,
        **quiet**=*None*,
        **superquiet**=*None*)

    Example:

    ```python
    gs.parse_command("i.group", group="name", format="json")
    ```

=== "Python (grass.tools)"

    *grass.tools.Tools.i_group*(**group**,
        **subgroup**=*None*,
        **input**=*None*,
        **file**=*None*,
        **format**=*"plain"*,
        **flags**=*None*,
        **verbose**=*None*,
        **quiet**=*None*,
        **superquiet**=*None*)

    Example:

    ```python
    tools = Tools()
    tools.i_group(group="name", format="json")
    ```

    This grass.tools API is experimental in version 8.5 and expected to be stable in version 8.6.

## Parameters

=== "Command line"

    **group**=*name* **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of imagery group  
    **subgroup**=*name*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of imagery subgroup  
    **input**=*name* [,*name*,...]  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of raster map(s) to include in group  
    **file**=*name*  
    &nbsp;&nbsp;&nbsp;&nbsp;Input file with one raster map name per line  
    **format**=*name* **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;Output format  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *plain, shell, json*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *plain*  
    &nbsp;&nbsp;&nbsp;&nbsp;**plain**: Human readable text output  
    &nbsp;&nbsp;&nbsp;&nbsp;**shell**: shell script style text output  
    &nbsp;&nbsp;&nbsp;&nbsp;**json**: JSON (JavaScript Object Notation)  
    **-r**  
    &nbsp;&nbsp;&nbsp;&nbsp;Remove selected files from specified group or subgroup  
    **-l**  
    &nbsp;&nbsp;&nbsp;&nbsp;List files from specified (sub)group  
    **-s**  
    &nbsp;&nbsp;&nbsp;&nbsp;List subgroups from specified group  
    **-g**  
    &nbsp;&nbsp;&nbsp;&nbsp;Print in shell script style [deprecated]  
    &nbsp;&nbsp;&nbsp;&nbsp;This flag is deprecated and will be removed in a future release. Use format=shell instead.  
    **--help**  
    &nbsp;&nbsp;&nbsp;&nbsp;Print usage summary  
    **--verbose**  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    **--quiet**  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    **--qq**  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    **--ui**  
    &nbsp;&nbsp;&nbsp;&nbsp;Force launching GUI dialog

=== "Python (grass.script)"

    **group** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of imagery group  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, group, *name*  
    **subgroup** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of imagery subgroup  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, subgroup, *name*  
    **input** : str | list[str], *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of raster map(s) to include in group  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, raster, *name*  
    **file** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Input file with one raster map name per line  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, file, *name*  
    **format** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Output format  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: *name*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *plain, shell, json*  
    &nbsp;&nbsp;&nbsp;&nbsp;**plain**: Human readable text output  
    &nbsp;&nbsp;&nbsp;&nbsp;**shell**: shell script style text output  
    &nbsp;&nbsp;&nbsp;&nbsp;**json**: JSON (JavaScript Object Notation)  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *plain*  
    **flags** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *r*, *l*, *s*, *g*  
    &nbsp;&nbsp;&nbsp;&nbsp;**r**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Remove selected files from specified group or subgroup  
    &nbsp;&nbsp;&nbsp;&nbsp;**l**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;List files from specified (sub)group  
    &nbsp;&nbsp;&nbsp;&nbsp;**s**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;List subgroups from specified group  
    &nbsp;&nbsp;&nbsp;&nbsp;**g**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Print in shell script style [deprecated]  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;This flag is deprecated and will be removed in a future release. Use format=shell instead.  
    **verbose** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **quiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **superquiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  

=== "Python (grass.tools)"

    **group** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of imagery group  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, group, *name*  
    **subgroup** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of imagery subgroup  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, subgroup, *name*  
    **input** : str | list[str], *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of raster map(s) to include in group  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, raster, *name*  
    **file** : str | io.StringIO, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Input file with one raster map name per line  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, file, *name*  
    **format** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Output format  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: *name*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *plain, shell, json*  
    &nbsp;&nbsp;&nbsp;&nbsp;**plain**: Human readable text output  
    &nbsp;&nbsp;&nbsp;&nbsp;**shell**: shell script style text output  
    &nbsp;&nbsp;&nbsp;&nbsp;**json**: JSON (JavaScript Object Notation)  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *plain*  
    **flags** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *r*, *l*, *s*, *g*  
    &nbsp;&nbsp;&nbsp;&nbsp;**r**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Remove selected files from specified group or subgroup  
    &nbsp;&nbsp;&nbsp;&nbsp;**l**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;List files from specified (sub)group  
    &nbsp;&nbsp;&nbsp;&nbsp;**s**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;List subgroups from specified group  
    &nbsp;&nbsp;&nbsp;&nbsp;**g**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Print in shell script style [deprecated]  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;This flag is deprecated and will be removed in a future release. Use format=shell instead.  
    **verbose** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **quiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **superquiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  

    Returns:

    **result** : grass.tools.support.ToolResult | None  
    If the tool produces text as standard output, a *ToolResult* object will be returned. Otherwise, `None` will be returned.

    Raises:

    *grass.tools.ToolError*: When the tool ended with an error.

## DESCRIPTION

*i.group* allows the user to collect raster map layers in an imagery
group by assigning them to user-named subgroups or other groups. This
enables the user to run analyses on any combination of the raster map
layers in a group. The user creates the groups and subgroups and selects
the raster map layers that are to reside in them. Imagery analysis
programs like *[g.gui.gcp](g.gui.gcp.md)*, *[i.rectify](i.rectify.md)*,
*[i.ortho.photo](i.ortho.photo.md)* and others ask the user for the name
of an imagery group whose data are to be analyzed. Imagery analysis
programs like *[i.cluster](i.cluster.md)* and *[i.maxlik](i.maxlik.md)*
ask the user for the imagery group and imagery subgroup whose data are
to be analyzed.

## NOTES

The *i.group* options are only available for imagery map layers in the
current LOCATION_NAME.

Subgroup names may not contain more than 12 characters.

## EXAMPLES

### Create a group and subgroup

This example runs in the "landsat" mapset of the North Carolina sample
dataset. The following command creates a group and subgroup containing
only the visible light bands of Landsat-7:

```sh
i.group group=vis_bands subgroup=vis_bands input=lsat7_2000_10,lsat7_2000_20,lsat7_2000_30
```

### List maps from a subgroup

To list maps in the `vis_bands` subgroup under the `vis_bands` group:

<!-- markdownlint-disable MD046 -->
=== "Command line"

    ```sh
    i.group group=vis_bands subgroup=vis_bands -l
    ```

    Possible output:

    ```text
    -------------
    <lsat7_2000_10@PERMANENT>    <lsat7_2000_20@PERMANENT>    
    <lsat7_2000_30@PERMANENT>    
    -------------
    ```

=== "Python (grass.script)"

    ```python
    import grass.script as gs

    data = gs.parse_command(
        "i.group", group="vis_bands", subgroup="vis_bands", flags="l", format="json"
    )
    print(data)
    ```

    Possible output:

    ```text
    ['lsat7_2000_10@PERMANENT', 'lsat7_2000_20@PERMANENT', 'lsat7_2000_30@PERMANENT']
    ```

### List maps in a group

To list maps in the `vis_bands` group:

=== "Command line"

    ```sh
    i.group group=vis_bands -l
    ```

    Possible output:

    ```text
    -------------
    <lsat7_2000_10@PERMANENT>    <lsat7_2000_20@PERMANENT>    
    <lsat7_2000_30@PERMANENT>    
    -------------
    ```

=== "Python (grass.script)"

    ```python
    import grass.script as gs

    data = gs.parse_command("i.group", group="vis_bands", flags="l", format="json")
    print(data)
    ```

    Possible output:

    ```text
    ['lsat7_2000_10@PERMANENT', 'lsat7_2000_20@PERMANENT', 'lsat7_2000_30@PERMANENT']
    ```

### List subgroups in a group

To list subgroups in the `vis_bands` group:

=== "Command line"

    ```sh
    i.group group=vis_bands -s
    ```

    Possible output:

    ```text
    -------------
    vis_bands    
    -------------
    ```

=== "Python (grass.script)"

    ```python
    import grass.script as gs

    data = gs.parse_command("i.group", group="vis_bands", flags="s", format="json")
    print(data)
    ```

    Possible output:

    ```text
    ['vis_bands']
    ```
<!-- markdownlint-restore -->

## SEE ALSO

The GRASS 4 *[Image Processing
manual](https://grass.osgeo.org/gdp/imagery/grass4_image_processing.pdf)*

*[g.gui.gcp](g.gui.gcp.md), [i.cluster](i.cluster.md),
[i.maxlik](i.maxlik.md), [i.rectify](i.rectify.md),
[i.ortho.photo](i.ortho.photo.md)*

## AUTHORS

Michael Shapiro, U.S.Army Construction Engineering Research Laboratory  
Parser support: Bob Covill (Tekmap, Canada)

## SOURCE CODE

Available at: [i.group source code](https://github.com/OSGeo/grass/tree/main/imagery/i.group)
([history](https://github.com/OSGeo/grass/commits/main/imagery/i.group))  
Latest change: Thursday Oct 02 14:39:13 2025 in commit [1850489](https://github.com/OSGeo/grass/commit/1850489bf42c72d8dcfe2e4db1738441b4a7dc43)
