---
name: r.in.ascii
description: Converts a GRASS ASCII raster file to binary raster map.
keywords: [ raster, import, conversion, ASCII ]
---

# r.in.ascii

Converts a GRASS ASCII raster file to binary raster map.

=== "Command line"

    **r.in.ascii**
    [**-s**]
    **input**=*name*
    **output**=*name*
    [**type**=*string*]
    [**title**=*phrase*]
    [**multiplier**=*float*]
    [**null_value**=*string*]
    [**--overwrite**]
    [**--verbose**]
    [**--quiet**]
    [**--qq**]
    [**--ui**]

    Example:

    ```sh
    r.in.ascii input=name output=name
    ```

=== "Python (grass.script)"

    *grass.script.run_command*("***r.in.ascii***",
        **input**,
        **output**,
        **type**=*None*,
        **title**=*None*,
        **multiplier**=*None*,
        **null_value**=*None*,
        **flags**=*None*,
        **overwrite**=*None*,
        **verbose**=*None*,
        **quiet**=*None*,
        **superquiet**=*None*)

    Example:

    ```python
    gs.run_command("r.in.ascii", input="name", output="name")
    ```

=== "Python (grass.tools)"

    *grass.tools.Tools.r_in_ascii*(**input**,
        **output**,
        **type**=*None*,
        **title**=*None*,
        **multiplier**=*None*,
        **null_value**=*None*,
        **flags**=*None*,
        **overwrite**=*None*,
        **verbose**=*None*,
        **quiet**=*None*,
        **superquiet**=*None*)

    Example:

    ```python
    tools = Tools()
    tools.r_in_ascii(input="name", output="name")
    ```

    This grass.tools API is experimental in version 8.5 and expected to be stable in version 8.6.

## Parameters

=== "Command line"

    **input**=*name* **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of input file to be imported  
    &nbsp;&nbsp;&nbsp;&nbsp;'-' for standard input  
    **output**=*name* **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;Name for output raster map  
    **type**=*string*  
    &nbsp;&nbsp;&nbsp;&nbsp;Type of raster map to be created  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: CELL for integer values, DCELL for floating-point values  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *CELL, FCELL, DCELL*  
    &nbsp;&nbsp;&nbsp;&nbsp;**CELL**: Integer  
    &nbsp;&nbsp;&nbsp;&nbsp;**FCELL**: Single precision floating point  
    &nbsp;&nbsp;&nbsp;&nbsp;**DCELL**: Double precision floating point  
    **title**=*phrase*  
    &nbsp;&nbsp;&nbsp;&nbsp;Title for resultant raster map  
    **multiplier**=*float*  
    &nbsp;&nbsp;&nbsp;&nbsp;Multiplier for ASCII data  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: read from header  
    **null_value**=*string*  
    &nbsp;&nbsp;&nbsp;&nbsp;String representing NULL value data cell  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: read from header  
    **-s**  
    &nbsp;&nbsp;&nbsp;&nbsp;SURFER (Golden Software) ASCII file will be imported  
    **--overwrite**  
    &nbsp;&nbsp;&nbsp;&nbsp;Allow output files to overwrite existing files  
    **--help**  
    &nbsp;&nbsp;&nbsp;&nbsp;Print usage summary  
    **--verbose**  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    **--quiet**  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    **--qq**  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    **--ui**  
    &nbsp;&nbsp;&nbsp;&nbsp;Force launching GUI dialog

=== "Python (grass.script)"

    **input** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of input file to be imported  
    &nbsp;&nbsp;&nbsp;&nbsp;'-' for standard input  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, file, *name*  
    **output** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name for output raster map  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: output, raster, *name*  
    **type** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Type of raster map to be created  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: CELL for integer values, DCELL for floating-point values  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *CELL, FCELL, DCELL*  
    &nbsp;&nbsp;&nbsp;&nbsp;**CELL**: Integer  
    &nbsp;&nbsp;&nbsp;&nbsp;**FCELL**: Single precision floating point  
    &nbsp;&nbsp;&nbsp;&nbsp;**DCELL**: Double precision floating point  
    **title** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Title for resultant raster map  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: *phrase*  
    **multiplier** : float, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Multiplier for ASCII data  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: read from header  
    **null_value** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;String representing NULL value data cell  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: read from header  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: *string*  
    **flags** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *s*  
    &nbsp;&nbsp;&nbsp;&nbsp;**s**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;SURFER (Golden Software) ASCII file will be imported  
    **overwrite** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allow output files to overwrite existing files  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **verbose** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **quiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **superquiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  

=== "Python (grass.tools)"

    **input** : str | io.StringIO, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of input file to be imported  
    &nbsp;&nbsp;&nbsp;&nbsp;'-' for standard input  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, file, *name*  
    **output** : str | type(np.ndarray) | type(np.array) | type(gs.array.array), *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name for output raster map  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: output, raster, *name*  
    **type** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Type of raster map to be created  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: CELL for integer values, DCELL for floating-point values  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *CELL, FCELL, DCELL*  
    &nbsp;&nbsp;&nbsp;&nbsp;**CELL**: Integer  
    &nbsp;&nbsp;&nbsp;&nbsp;**FCELL**: Single precision floating point  
    &nbsp;&nbsp;&nbsp;&nbsp;**DCELL**: Double precision floating point  
    **title** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Title for resultant raster map  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: *phrase*  
    **multiplier** : float, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Multiplier for ASCII data  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: read from header  
    **null_value** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;String representing NULL value data cell  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: read from header  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: *string*  
    **flags** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *s*  
    &nbsp;&nbsp;&nbsp;&nbsp;**s**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;SURFER (Golden Software) ASCII file will be imported  
    **overwrite** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allow output files to overwrite existing files  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **verbose** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **quiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **superquiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  

    Returns:

    **result** : grass.tools.support.ToolResult | np.ndarray | tuple[np.ndarray] | None  
    If the tool produces text as standard output, a *ToolResult* object will be returned. Otherwise, `None` will be returned. If an array type (e.g., *np.ndarray*) is used for one of the raster outputs, the result will be an array and will have the shape corresponding to the computational region. If an array type is used for more than one raster output, the result will be a tuple of arrays.

    Raises:

    *grass.tools.ToolError*: When the tool ended with an error.

## DESCRIPTION

*r.in.ascii* allows a user to create a (binary) GRASS raster map layer
from an ASCII raster input file with (optional) TITLE.

The GRASS ASCII **input** file has a header section which describes the
location and size of the data, followed by the data itself.

The header has 6 lines:

```sh
north:   xxxxxx.xx
south:   xxxxxx.xx
east:    xxxxxx.xx
west:    xxxxxx.xx
rows:    r
cols:    c
```

The north, south, east, and west field values entered are the
coordinates of the edges of the geographic region. The rows and cols
field values entered describe the dimensions of the matrix of data to
follow. The data which follows is *r* rows of *c* integers.

Optionally the following parameters can be defined in the header
section:

```sh
null: nn
type: float
multiplier: 2.
```

"null" defines a string or number to be converted to NULL value (no
data).  
"type" defines the data type (int, float double) and is not required.  
"multiplier" is an optional parameter to multiply each cell value.

## NOTES

The geographic coordinates north, south, east, and west describe the
outer edges of the geographic region. They run along the edges of the
cells at the edge of the geographic region and *not* through the center
of the cells at the edges. The NW value occurs at the beginning of the
first line of data, and the SW value occurs at the beginning of the last
line of data.

The data (which follows the header section) must contain `r` *x* `c`
values, but it is not necessary that all the data for a row be on one
line. A row may be split over many lines.

The imported cell type can be forced using the **type** option, default
is auto-detection.

The header information in ESRI Raster ASCII files differs from GRASS. To
convert an Arc/Info (ArcView) ASCII grid file into GRASS, see
*[r.in.gdal](r.in.gdal.md)*.

SURFER (Golden Software) ASCII files may be imported by passing the
**-s** flag.

## EXAMPLE

The following is a sample **input** file to *r.in.ascii*:

```sh
north:                   4299000.00
south:                   4247000.00
east:                     528000.00
west:                     500000.00
rows:                         10
cols:                         15
null:                      -9999

1 2 3 4 5 6 7 8 9 10 11 12 13 14 15
1 2 3 4 5 6 7 8 9 10 11 12 13 14 15
1 2 3 4 5 6 7 8 9 10 11 12 13 14 15
1 2 3 4 5 6 7 8 9 10 11 12 13 14 15
1 2 3 4 5 6 7 8 9 10 11 12 13 14 15
1 2 3 4 5 6 7 8 9 10 11 12 13 14 15
1 2 3 4 5 6 7 8 9 10 11 12 13 14 15
1 2 3 4 5 6 7 8 9 10 11 12 13 14 15
1 2 3 4 5 6 7 8 9 10 11 12 13 14 15
1 2 3 4 5 6 7 8 9 10 11 12 13 14 15
```

## SEE ALSO

*[r.import](r.import.md), [r.out.ascii](r.out.ascii.md),
[r.in.gdal](r.in.gdal.md), [r.out.gdal](r.out.gdal.md),
[r.in.bin](r.in.bin.md), [r3.in.ascii](r3.in.ascii.md)*

## AUTHORS

Michael Shapiro, U.S. Army Construction Engineering Research
Laboratory  
Surfer support by Roger Miller

## SOURCE CODE

Available at: [r.in.ascii source code](https://github.com/OSGeo/grass/tree/main/raster/r.in.ascii)
([history](https://github.com/OSGeo/grass/commits/main/raster/r.in.ascii))  
Latest change: Friday Mar 07 07:39:48 2025 in commit [e1e37d8](https://github.com/OSGeo/grass/commit/e1e37d87e78212dfcf4c97aaf32c54042adbd2b0)
