---
name: t.rast.gapfill.py
description: Replaces gaps in a space time raster dataset with interpolated raster maps.
keywords: [ temporal, interpolation, raster, time, no-data filling ]
---

# t.rast.gapfill.py

Replaces gaps in a space time raster dataset with interpolated raster maps.

=== "Command line"

    **t.rast.gapfill.py**
    [**-t**]
    **input**=*name*
    [**where**=*sql_query*]
    **basename**=*string*
    [**suffix**=*string*]
    [**nprocs**=*integer*]
    [**--verbose**]
    [**--quiet**]
    [**--qq**]
    [**--ui**]

    Example:

    ```sh
    t.rast.gapfill.py input=name basename=string
    ```

=== "Python (grass.script)"

    *grass.script.run_command*("***t.rast.gapfill.py***",
        **input**,
        **where**=*None*,
        **basename**,
        **suffix**=*"gran"*,
        **nprocs**=*1*,
        **flags**=*None*,
        **verbose**=*None*,
        **quiet**=*None*,
        **superquiet**=*None*)

    Example:

    ```python
    gs.run_command("t.rast.gapfill.py", input="name", basename="string")
    ```

=== "Python (grass.tools)"

    *grass.tools.Tools.t_rast_gapfill_py*(**input**,
        **where**=*None*,
        **basename**,
        **suffix**=*"gran"*,
        **nprocs**=*1*,
        **flags**=*None*,
        **verbose**=*None*,
        **quiet**=*None*,
        **superquiet**=*None*)

    Example:

    ```python
    tools = Tools()
    tools.t_rast_gapfill_py(input="name", basename="string")
    ```

    This grass.tools API is experimental in version 8.5 and expected to be stable in version 8.6.

## Parameters

=== "Command line"

    **input**=*name* **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of the input space time raster dataset  
    **where**=*sql_query*  
    &nbsp;&nbsp;&nbsp;&nbsp;WHERE conditions of SQL statement without 'where' keyword used in the temporal GIS framework  
    &nbsp;&nbsp;&nbsp;&nbsp;Example: start_time &gt; '2001-01-01 12:30:00'  
    **basename**=*string* **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;Basename of the new generated output maps  
    &nbsp;&nbsp;&nbsp;&nbsp;A numerical suffix separated by an underscore will be attached to create a unique identifier  
    **suffix**=*string*  
    &nbsp;&nbsp;&nbsp;&nbsp;Suffix to add at basename: set 'gran' for granularity, 'time' for the full time format, 'num' for numerical suffix with a specific number of digits (default %05)  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *gran*  
    **nprocs**=*integer*  
    &nbsp;&nbsp;&nbsp;&nbsp;Number of interpolation processes to run in parallel  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *1*  
    **-t**  
    &nbsp;&nbsp;&nbsp;&nbsp;Assign the space time raster dataset start and end time to the output map  
    **--help**  
    &nbsp;&nbsp;&nbsp;&nbsp;Print usage summary  
    **--verbose**  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    **--quiet**  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    **--qq**  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    **--ui**  
    &nbsp;&nbsp;&nbsp;&nbsp;Force launching GUI dialog

=== "Python (grass.script)"

    **input** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of the input space time raster dataset  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, strds, *name*  
    **where** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;WHERE conditions of SQL statement without 'where' keyword used in the temporal GIS framework  
    &nbsp;&nbsp;&nbsp;&nbsp;Example: start_time &gt; '2001-01-01 12:30:00'  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: *sql_query*  
    **basename** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Basename of the new generated output maps  
    &nbsp;&nbsp;&nbsp;&nbsp;A numerical suffix separated by an underscore will be attached to create a unique identifier  
    **suffix** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Suffix to add at basename: set 'gran' for granularity, 'time' for the full time format, 'num' for numerical suffix with a specific number of digits (default %05)  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *gran*  
    **nprocs** : int, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Number of interpolation processes to run in parallel  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *1*  
    **flags** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *t*  
    &nbsp;&nbsp;&nbsp;&nbsp;**t**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Assign the space time raster dataset start and end time to the output map  
    **verbose** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **quiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **superquiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  

=== "Python (grass.tools)"

    **input** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of the input space time raster dataset  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, strds, *name*  
    **where** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;WHERE conditions of SQL statement without 'where' keyword used in the temporal GIS framework  
    &nbsp;&nbsp;&nbsp;&nbsp;Example: start_time &gt; '2001-01-01 12:30:00'  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: *sql_query*  
    **basename** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Basename of the new generated output maps  
    &nbsp;&nbsp;&nbsp;&nbsp;A numerical suffix separated by an underscore will be attached to create a unique identifier  
    **suffix** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Suffix to add at basename: set 'gran' for granularity, 'time' for the full time format, 'num' for numerical suffix with a specific number of digits (default %05)  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *gran*  
    **nprocs** : int, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Number of interpolation processes to run in parallel  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *1*  
    **flags** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *t*  
    &nbsp;&nbsp;&nbsp;&nbsp;**t**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Assign the space time raster dataset start and end time to the output map  
    **verbose** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **quiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **superquiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  

    Returns:

    **result** : grass.tools.support.ToolResult | None  
    If the tool produces text as standard output, a *ToolResult* object will be returned. Otherwise, `None` will be returned.

    Raises:

    *grass.tools.ToolError*: When the tool ended with an error.

## DESCRIPTION

*t.rast.gapfill* fills temporal gaps in space time raster datasets using
linear interpolation. Temporal all gaps will be detected in the input
space time raster dataset automatically. The predecessor and successor
maps of the gaps will be identified and used to linear interpolate the
raster map between them.

## NOTES

This module uses [r.series.interp](r.series.interp.md) to perform the
interpolation for each gap independently. Hence several interpolation
processes can be run in parallel.

Each gap is re-sampled by the space time raster dataset granularity.
Therefore several time stamped raster map layers will be interpolated if
the gap is larger than the STRDS granularity.

## EXAMPLES

In this example we will create 3 raster maps and register them in the
temporal database an then in the newly created space time raster
dataset. There are gaps of one and two day size between the raster maps.
The values of the maps are chosen so that the interpolated values can be
estimated. We expect one map with a value of 2 for the first gap and two
maps (values 3.666 and 4.333) for the second gap after interpolation.

```sh
r.mapcalc expression="map1 = 1"
r.mapcalc expression="map2 = 3"
r.mapcalc expression="map3 = 5"

t.register type=raster maps=map1 start=2012-08-20 end=2012-08-21
t.register type=raster maps=map2 start=2012-08-22 end=2012-08-23
t.register type=raster maps=map3 start=2012-08-25 end=2012-08-26

t.create type=strds temporaltype=absolute \
         output=precipitation_daily \
         title="Daily precipitation" \
         description="Test dataset with daily precipitation"

t.register type=raster input=precipitation_daily maps=map1,map2,map3

# the output shows three missing maps
t.rast.list input=precipitation_daily columns=name,start_time,min,max

name|start_time|min|max
map1|2012-08-20 00:00:00|1.0|1.0
map2|2012-08-22 00:00:00|3.0|3.0
map3|2012-08-25 00:00:00|5.0|5.0


t.rast.list input=precipitation_daily method=deltagaps

id|name|mapset|start_time|end_time|interval_length|distance_from_begin
map1@PERMANENT|map1|PERMANENT|2012-08-20 00:00:00|2012-08-21 00:00:00|1.0|0.0
None|None|None|2012-08-21 00:00:00|2012-08-22 00:00:00|1.0|1.0
map2@PERMANENT|map2|PERMANENT|2012-08-22 00:00:00|2012-08-23 00:00:00|1.0|2.0
None|None|None|2012-08-23 00:00:00|2012-08-25 00:00:00|2.0|3.0
map3@PERMANENT|map3|PERMANENT|2012-08-25 00:00:00|2012-08-26 00:00:00|1.0|5.0

t.rast.gapfill input=precipitation_daily basename=gap

t.rast.list input=precipitation_daily columns=name,start_time,min,max

name|start_time|min|max
map1|2012-08-20 00:00:00|1.0|1.0
gap_6_1|2012-08-21 00:00:00|2.0|2.0
map2|2012-08-22 00:00:00|3.0|3.0
gap_7_1|2012-08-23 00:00:00|3.666667|3.666667
gap_7_2|2012-08-24 00:00:00|4.333333|4.333333
map3|2012-08-25 00:00:00|5.0|5.0

```

## SEE ALSO

*[r.series.interp](r.series.interp.md), [t.create](t.create.md),
[t.info](t.info.md)*

## AUTHOR

Sören Gebbert, Thünen Institute of Climate-Smart Agriculture

## SOURCE CODE

Available at: [t.rast.gapfill source code](https://github.com/OSGeo/grass/tree/main/temporal/t.rast.gapfill)
([history](https://github.com/OSGeo/grass/commits/main/temporal/t.rast.gapfill))  
Latest change: Thursday Jun 26 10:38:43 2025 in commit [a7bb103](https://github.com/OSGeo/grass/commit/a7bb103537dc5179757a05844431d87018688326)
