---
name: v.build.polylines
description: Builds polylines from lines or boundaries.
keywords: [ vector, topology, geometry, line, node, vertex ]
---

# v.build.polylines

Builds polylines from lines or boundaries.

=== "Command line"

    **v.build.polylines**
    **input**=*name*
    **output**=*name*
    [**cats**=*string*]
    [**type**=*string* [,*string*,...]]
    [**--overwrite**]
    [**--verbose**]
    [**--quiet**]
    [**--qq**]
    [**--ui**]

    Example:

    ```sh
    v.build.polylines input=name output=name
    ```

=== "Python (grass.script)"

    *grass.script.run_command*("***v.build.polylines***",
        **input**,
        **output**,
        **cats**=*"no"*,
        **type**=*"line,boundary"*,
        **overwrite**=*None*,
        **verbose**=*None*,
        **quiet**=*None*,
        **superquiet**=*None*)

    Example:

    ```python
    gs.run_command("v.build.polylines", input="name", output="name")
    ```

=== "Python (grass.tools)"

    *grass.tools.Tools.v_build_polylines*(**input**,
        **output**,
        **cats**=*"no"*,
        **type**=*"line,boundary"*,
        **overwrite**=*None*,
        **verbose**=*None*,
        **quiet**=*None*,
        **superquiet**=*None*)

    Example:

    ```python
    tools = Tools()
    tools.v_build_polylines(input="name", output="name")
    ```

    This grass.tools API is experimental in version 8.5 and expected to be stable in version 8.6.

## Parameters

=== "Command line"

    **input**=*name* **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of input vector map  
    &nbsp;&nbsp;&nbsp;&nbsp;Or data source for direct OGR access  
    **output**=*name* **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;Name for output vector map  
    **cats**=*string*  
    &nbsp;&nbsp;&nbsp;&nbsp;Category number mode  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *no, first, multi, same*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *no*  
    &nbsp;&nbsp;&nbsp;&nbsp;**no**: Do not assign any category number to polyline  
    &nbsp;&nbsp;&nbsp;&nbsp;**first**: Assign category number of first line to polyline  
    &nbsp;&nbsp;&nbsp;&nbsp;**multi**: Assign multiple category numbers to polyline  
    &nbsp;&nbsp;&nbsp;&nbsp;**same**: Create polyline from lines with same categories  
    **type**=*string* [,*string*,...]  
    &nbsp;&nbsp;&nbsp;&nbsp;Input feature type  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *line, boundary*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *line,boundary*  
    **--overwrite**  
    &nbsp;&nbsp;&nbsp;&nbsp;Allow output files to overwrite existing files  
    **--help**  
    &nbsp;&nbsp;&nbsp;&nbsp;Print usage summary  
    **--verbose**  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    **--quiet**  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    **--qq**  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    **--ui**  
    &nbsp;&nbsp;&nbsp;&nbsp;Force launching GUI dialog

=== "Python (grass.script)"

    **input** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of input vector map  
    &nbsp;&nbsp;&nbsp;&nbsp;Or data source for direct OGR access  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, vector, *name*  
    **output** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name for output vector map  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: output, vector, *name*  
    **cats** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Category number mode  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *no, first, multi, same*  
    &nbsp;&nbsp;&nbsp;&nbsp;**no**: Do not assign any category number to polyline  
    &nbsp;&nbsp;&nbsp;&nbsp;**first**: Assign category number of first line to polyline  
    &nbsp;&nbsp;&nbsp;&nbsp;**multi**: Assign multiple category numbers to polyline  
    &nbsp;&nbsp;&nbsp;&nbsp;**same**: Create polyline from lines with same categories  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *no*  
    **type** : str | list[str], *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Input feature type  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *line, boundary*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *line,boundary*  
    **overwrite** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allow output files to overwrite existing files  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **verbose** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **quiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **superquiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  

=== "Python (grass.tools)"

    **input** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of input vector map  
    &nbsp;&nbsp;&nbsp;&nbsp;Or data source for direct OGR access  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, vector, *name*  
    **output** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name for output vector map  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: output, vector, *name*  
    **cats** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Category number mode  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *no, first, multi, same*  
    &nbsp;&nbsp;&nbsp;&nbsp;**no**: Do not assign any category number to polyline  
    &nbsp;&nbsp;&nbsp;&nbsp;**first**: Assign category number of first line to polyline  
    &nbsp;&nbsp;&nbsp;&nbsp;**multi**: Assign multiple category numbers to polyline  
    &nbsp;&nbsp;&nbsp;&nbsp;**same**: Create polyline from lines with same categories  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *no*  
    **type** : str | list[str], *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Input feature type  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *line, boundary*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *line,boundary*  
    **overwrite** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allow output files to overwrite existing files  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **verbose** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **quiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **superquiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  

    Returns:

    **result** : grass.tools.support.ToolResult | None  
    If the tool produces text as standard output, a *ToolResult* object will be returned. Otherwise, `None` will be returned.

    Raises:

    *grass.tools.ToolError*: When the tool ended with an error.

## DESCRIPTION

*v.build.polylines* builds polylines from the lines or boundaries in a
vector map.

A line is defined by one start node, one end node and any number of
vertices between the start and end nodes. The shortest possible line
consists of only two vertices where the coordinates of the start and end
nodes are identical to those of the two vertices.

*v.build.polylines* picks a line and from its start node, walks back as
long as exactly one other line of the same type is connected to this
node. Line directions are reversed as required, i.e. it does not matter
if the next line is connected to the current node by its start or end
node. Once the start line of a polyline is identified, it walks forward
and adds all vertices (in reverse order if needed) of connected lines to
the start line, i.e. the start line and connecting lines are reversed as
needed. That is, if a line is reversed depends on what node is initially
picked for building polylines. If the direction of lines is important
(it's not for boundaries to build areas), you have to manually change
line directions with either *[v.edit](v.edit.md)* or the *[wxGUI vector
digitizer](wxGUI.vdigit.md)*.

Polylines provide the most appropriate representation of curved lines
when it is important that nodes serve to define topology rather than
geometry. Curved lines are usually digitized as polylines, but these are
sometimes broken into their constituent straight line segments during
conversion from one data format to another. *v.build.polylines* can be
used to rebuild such broken polylines.

## NOTES

*v.build.polylines* combines only lines of the same type to a new
polyline, i.e. lines and boundaries are kept separate.

Category number(s) are assigned to a polyline based on **cats**
parameter.

- **cats=no** - No category number is assigned to a polyline. Also
  attributes tables linked to the input vector map are not copied to the
  output vector map.
- **cats=first** - Assign to a polyline category number of the first
  line. All linked attributes tables are copied to the output vector map
  without filtering, but the categories are processed according to the
  cats option.
- **cats=multi** - If the lines that make up a polyline have different
  category numbers then *v.build.polylines* will set the multiple
  category numbers to a polyline. Also all linked attributes tables are
  copied to the output vector map.
- **cats=same** - Assigned lines to a polyline have same category
  numbers in all layers. Linked attributes tables are copied to the
  output vector map.

*v.build.polylines* correctly handles **input** vector maps containing
lines, boundaries, centroids and points. Lines and boundaries will be
converted to polylines. Areas are guaranteed to be preserved.

## ACKNOWLEDGEMENTS

This program was originally written during Mark Lake's tenure of a
Leverhulme Special Research Fellowship at University College London.

## SEE ALSO

*[v.build](v.build.md), [v.in.ascii](v.in.ascii.md),
[v.edit](v.edit.md), [v.split](v.split.md)*

## AUTHORS

Mark Lake, Institute of Archaeology, University College London.  
Major rewrite by Radim Blazek, October 2002  
Category mode added by Martin Landa, FBK-irst, Trento, Italy, October
2007  
Support for categories, attributes, and different line types by Markus
Metz

## SOURCE CODE

Available at: [v.build.polylines source code](https://github.com/OSGeo/grass/tree/main/vector/v.build.polylines)
([history](https://github.com/OSGeo/grass/commits/main/vector/v.build.polylines))  
Latest change: Friday Aug 08 09:39:19 2025 in commit [ed72c71](https://github.com/OSGeo/grass/commit/ed72c71d8580e872cd6fd345c84a15c324764465)
