---
name: v.in.lidar
description: Converts LAS LiDAR point clouds to a GRASS vector map with libLAS.
keywords: [ vector, import, LIDAR, level1 ]
---

# v.in.lidar

Converts LAS LiDAR point clouds to a GRASS vector map with libLAS.

=== "Command line"

    **v.in.lidar**
    [**-pruvetcboi**]
    **input**=*name*
    **output**=*name*
    [**id_layer**=*string*]
    [**return_layer**=*string*]
    [**class_layer**=*string*]
    [**rgb_layer**=*string*]
    [**spatial**=*xmin,ymin,xmax,ymax* [,*xmin,ymin,xmax,ymax*,...]]
    [**zrange**=*min,max*]
    [**return_filter**=*string*]
    [**class_filter**=*integer* [,*integer*,...]]
    [**mask**=*name*]
    [**mask_layer**=*string*]
    [**skip**=*integer*]
    [**preserve**=*integer*]
    [**offset**=*integer*]
    [**limit**=*integer*]
    [**project**=*name*]
    [**--overwrite**]
    [**--verbose**]
    [**--quiet**]
    [**--qq**]
    [**--ui**]

    Example:

    ```sh
    v.in.lidar input=name output=name
    ```

=== "Python (grass.script)"

    *grass.script.run_command*("***v.in.lidar***",
        **input**,
        **output**,
        **id_layer**=*None*,
        **return_layer**=*None*,
        **class_layer**=*None*,
        **rgb_layer**=*None*,
        **spatial**=*None*,
        **zrange**=*None*,
        **return_filter**=*None*,
        **class_filter**=*None*,
        **mask**=*None*,
        **mask_layer**=*"1"*,
        **skip**=*None*,
        **preserve**=*None*,
        **offset**=*None*,
        **limit**=*None*,
        **project**=*None*,
        **flags**=*None*,
        **overwrite**=*None*,
        **verbose**=*None*,
        **quiet**=*None*,
        **superquiet**=*None*)

    Example:

    ```python
    gs.run_command("v.in.lidar", input="name", output="name")
    ```

=== "Python (grass.tools)"

    *grass.tools.Tools.v_in_lidar*(**input**,
        **output**,
        **id_layer**=*None*,
        **return_layer**=*None*,
        **class_layer**=*None*,
        **rgb_layer**=*None*,
        **spatial**=*None*,
        **zrange**=*None*,
        **return_filter**=*None*,
        **class_filter**=*None*,
        **mask**=*None*,
        **mask_layer**=*"1"*,
        **skip**=*None*,
        **preserve**=*None*,
        **offset**=*None*,
        **limit**=*None*,
        **project**=*None*,
        **flags**=*None*,
        **overwrite**=*None*,
        **verbose**=*None*,
        **quiet**=*None*,
        **superquiet**=*None*)

    Example:

    ```python
    tools = Tools()
    tools.v_in_lidar(input="name", output="name")
    ```

    This grass.tools API is experimental in version 8.5 and expected to be stable in version 8.6.

## Parameters

=== "Command line"

    **input**=*name* **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;LAS input file  
    &nbsp;&nbsp;&nbsp;&nbsp;LiDAR input files in LAS format (\*.las or \*.laz)  
    **output**=*name* **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;Name for output vector map  
    **id_layer**=*string*  
    &nbsp;&nbsp;&nbsp;&nbsp;Layer number to store generated point ID as category  
    &nbsp;&nbsp;&nbsp;&nbsp;Set to 1 by default, use -c to not store it  
    **return_layer**=*string*  
    &nbsp;&nbsp;&nbsp;&nbsp;Layer number to store return information as category  
    &nbsp;&nbsp;&nbsp;&nbsp;Leave empty to not store it  
    **class_layer**=*string*  
    &nbsp;&nbsp;&nbsp;&nbsp;Layer number to store class number as category  
    &nbsp;&nbsp;&nbsp;&nbsp;Leave empty to not store it  
    **rgb_layer**=*string*  
    &nbsp;&nbsp;&nbsp;&nbsp;Layer number where RBG colors are stored as category  
    &nbsp;&nbsp;&nbsp;&nbsp;Leave empty to not store it  
    **spatial**=*xmin,ymin,xmax,ymax* [,*xmin,ymin,xmax,ymax*,...]  
    &nbsp;&nbsp;&nbsp;&nbsp;Import subregion only  
    &nbsp;&nbsp;&nbsp;&nbsp;Format: xmin,ymin,xmax,ymax - usually W,S,E,N  
    **zrange**=*min,max*  
    &nbsp;&nbsp;&nbsp;&nbsp;Filter range for z data (min,max)  
    **return_filter**=*string*  
    &nbsp;&nbsp;&nbsp;&nbsp;Only import points of selected return type  
    &nbsp;&nbsp;&nbsp;&nbsp;If not specified, all points are imported  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *first, last, mid*  
    **class_filter**=*integer* [,*integer*,...]  
    &nbsp;&nbsp;&nbsp;&nbsp;Only import points of selected class(es)  
    &nbsp;&nbsp;&nbsp;&nbsp;Input is comma separated integers. If not specified, all points are imported.  
    **mask**=*name*  
    &nbsp;&nbsp;&nbsp;&nbsp;Areas where to import points  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of vector map with areas where the points should be imported  
    **mask_layer**=*string*  
    &nbsp;&nbsp;&nbsp;&nbsp;Layer number or name for mask option  
    &nbsp;&nbsp;&nbsp;&nbsp;Vector features can have category values in different layers. This number determines which layer to use. When used with direct OGR access this is the layer name.  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *1*  
    **skip**=*integer*  
    &nbsp;&nbsp;&nbsp;&nbsp;Do not import every n-th point  
    &nbsp;&nbsp;&nbsp;&nbsp;For example, 5 will import 80 percent of points. If not specified, all points are imported  
    **preserve**=*integer*  
    &nbsp;&nbsp;&nbsp;&nbsp;Import only every n-th point  
    &nbsp;&nbsp;&nbsp;&nbsp;For example, 4 will import 25 percent of points. If not specified, all points are imported  
    **offset**=*integer*  
    &nbsp;&nbsp;&nbsp;&nbsp;Skip first n points  
    &nbsp;&nbsp;&nbsp;&nbsp;Skips the given number of points at the beginning.  
    **limit**=*integer*  
    &nbsp;&nbsp;&nbsp;&nbsp;Import only n points  
    &nbsp;&nbsp;&nbsp;&nbsp;Imports only the given number of points  
    **project**=*name*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name for new project (location) to create  
    **-p**  
    &nbsp;&nbsp;&nbsp;&nbsp;Print LAS file info and exit  
    **-r**  
    &nbsp;&nbsp;&nbsp;&nbsp;Limit import to the current region  
    **-u**  
    &nbsp;&nbsp;&nbsp;&nbsp;Invert mask when selecting points  
    **-v**  
    &nbsp;&nbsp;&nbsp;&nbsp;Use only valid points  
    &nbsp;&nbsp;&nbsp;&nbsp;Points invalid according to APSRS LAS specification will be filtered out  
    **-e**  
    &nbsp;&nbsp;&nbsp;&nbsp;Extend region extents based on new dataset  
    **-t**  
    &nbsp;&nbsp;&nbsp;&nbsp;Do not create attribute table  
    **-c**  
    &nbsp;&nbsp;&nbsp;&nbsp;Do not automatically add unique ID as category to each point  
    &nbsp;&nbsp;&nbsp;&nbsp;Create only requested layers and categories  
    **-b**  
    &nbsp;&nbsp;&nbsp;&nbsp;Do not build topology  
    &nbsp;&nbsp;&nbsp;&nbsp;Advantageous when handling a large number of points  
    **-o**  
    &nbsp;&nbsp;&nbsp;&nbsp;Override projection check (use current project's CRS)  
    &nbsp;&nbsp;&nbsp;&nbsp;Assume that the dataset has the same coordinate reference system as the current project  
    **-i**  
    &nbsp;&nbsp;&nbsp;&nbsp;Create the project specified by the "project" parameter and exit. Do not import the vector data.  
    **--overwrite**  
    &nbsp;&nbsp;&nbsp;&nbsp;Allow output files to overwrite existing files  
    **--help**  
    &nbsp;&nbsp;&nbsp;&nbsp;Print usage summary  
    **--verbose**  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    **--quiet**  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    **--qq**  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    **--ui**  
    &nbsp;&nbsp;&nbsp;&nbsp;Force launching GUI dialog

=== "Python (grass.script)"

    **input** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;LAS input file  
    &nbsp;&nbsp;&nbsp;&nbsp;LiDAR input files in LAS format (\*.las or \*.laz)  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, file, *name*  
    **output** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name for output vector map  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: output, vector, *name*  
    **id_layer** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Layer number to store generated point ID as category  
    &nbsp;&nbsp;&nbsp;&nbsp;Set to 1 by default, use -c to not store it  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, layer  
    **return_layer** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Layer number to store return information as category  
    &nbsp;&nbsp;&nbsp;&nbsp;Leave empty to not store it  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, layer  
    **class_layer** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Layer number to store class number as category  
    &nbsp;&nbsp;&nbsp;&nbsp;Leave empty to not store it  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, layer  
    **rgb_layer** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Layer number where RBG colors are stored as category  
    &nbsp;&nbsp;&nbsp;&nbsp;Leave empty to not store it  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, layer  
    **spatial** : list[tuple[float, float, float, float]] | tuple[float, float, float, float] | list[float] | str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Import subregion only  
    &nbsp;&nbsp;&nbsp;&nbsp;Format: xmin,ymin,xmax,ymax - usually W,S,E,N  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: *xmin,ymin,xmax,ymax*  
    **zrange** : tuple[float, float] | list[float] | str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Filter range for z data (min,max)  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: *min,max*  
    **return_filter** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Only import points of selected return type  
    &nbsp;&nbsp;&nbsp;&nbsp;If not specified, all points are imported  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *first, last, mid*  
    **class_filter** : int | list[int] | str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Only import points of selected class(es)  
    &nbsp;&nbsp;&nbsp;&nbsp;Input is comma separated integers. If not specified, all points are imported.  
    **mask** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Areas where to import points  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of vector map with areas where the points should be imported  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, vector, *name*  
    **mask_layer** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Layer number or name for mask option  
    &nbsp;&nbsp;&nbsp;&nbsp;Vector features can have category values in different layers. This number determines which layer to use. When used with direct OGR access this is the layer name.  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, layer  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *1*  
    **skip** : int, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Do not import every n-th point  
    &nbsp;&nbsp;&nbsp;&nbsp;For example, 5 will import 80 percent of points. If not specified, all points are imported  
    **preserve** : int, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Import only every n-th point  
    &nbsp;&nbsp;&nbsp;&nbsp;For example, 4 will import 25 percent of points. If not specified, all points are imported  
    **offset** : int, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Skip first n points  
    &nbsp;&nbsp;&nbsp;&nbsp;Skips the given number of points at the beginning.  
    **limit** : int, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Import only n points  
    &nbsp;&nbsp;&nbsp;&nbsp;Imports only the given number of points  
    **project** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name for new project (location) to create  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: *name*  
    **flags** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *p*, *r*, *u*, *v*, *e*, *t*, *c*, *b*, *o*, *i*  
    &nbsp;&nbsp;&nbsp;&nbsp;**p**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Print LAS file info and exit  
    &nbsp;&nbsp;&nbsp;&nbsp;**r**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Limit import to the current region  
    &nbsp;&nbsp;&nbsp;&nbsp;**u**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Invert mask when selecting points  
    &nbsp;&nbsp;&nbsp;&nbsp;**v**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Use only valid points  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Points invalid according to APSRS LAS specification will be filtered out  
    &nbsp;&nbsp;&nbsp;&nbsp;**e**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Extend region extents based on new dataset  
    &nbsp;&nbsp;&nbsp;&nbsp;**t**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Do not create attribute table  
    &nbsp;&nbsp;&nbsp;&nbsp;**c**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Do not automatically add unique ID as category to each point  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Create only requested layers and categories  
    &nbsp;&nbsp;&nbsp;&nbsp;**b**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Do not build topology  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Advantageous when handling a large number of points  
    &nbsp;&nbsp;&nbsp;&nbsp;**o**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Override projection check (use current project's CRS)  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Assume that the dataset has the same coordinate reference system as the current project  
    &nbsp;&nbsp;&nbsp;&nbsp;**i**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Create the project specified by the "project" parameter and exit. Do not import the vector data.  
    **overwrite** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allow output files to overwrite existing files  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **verbose** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **quiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **superquiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  

=== "Python (grass.tools)"

    **input** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;LAS input file  
    &nbsp;&nbsp;&nbsp;&nbsp;LiDAR input files in LAS format (\*.las or \*.laz)  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, file, *name*  
    **output** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name for output vector map  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: output, vector, *name*  
    **id_layer** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Layer number to store generated point ID as category  
    &nbsp;&nbsp;&nbsp;&nbsp;Set to 1 by default, use -c to not store it  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, layer  
    **return_layer** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Layer number to store return information as category  
    &nbsp;&nbsp;&nbsp;&nbsp;Leave empty to not store it  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, layer  
    **class_layer** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Layer number to store class number as category  
    &nbsp;&nbsp;&nbsp;&nbsp;Leave empty to not store it  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, layer  
    **rgb_layer** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Layer number where RBG colors are stored as category  
    &nbsp;&nbsp;&nbsp;&nbsp;Leave empty to not store it  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, layer  
    **spatial** : list[tuple[float, float, float, float]] | tuple[float, float, float, float] | list[float] | str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Import subregion only  
    &nbsp;&nbsp;&nbsp;&nbsp;Format: xmin,ymin,xmax,ymax - usually W,S,E,N  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: *xmin,ymin,xmax,ymax*  
    **zrange** : tuple[float, float] | list[float] | str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Filter range for z data (min,max)  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: *min,max*  
    **return_filter** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Only import points of selected return type  
    &nbsp;&nbsp;&nbsp;&nbsp;If not specified, all points are imported  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *first, last, mid*  
    **class_filter** : int | list[int] | str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Only import points of selected class(es)  
    &nbsp;&nbsp;&nbsp;&nbsp;Input is comma separated integers. If not specified, all points are imported.  
    **mask** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Areas where to import points  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of vector map with areas where the points should be imported  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, vector, *name*  
    **mask_layer** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Layer number or name for mask option  
    &nbsp;&nbsp;&nbsp;&nbsp;Vector features can have category values in different layers. This number determines which layer to use. When used with direct OGR access this is the layer name.  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, layer  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *1*  
    **skip** : int, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Do not import every n-th point  
    &nbsp;&nbsp;&nbsp;&nbsp;For example, 5 will import 80 percent of points. If not specified, all points are imported  
    **preserve** : int, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Import only every n-th point  
    &nbsp;&nbsp;&nbsp;&nbsp;For example, 4 will import 25 percent of points. If not specified, all points are imported  
    **offset** : int, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Skip first n points  
    &nbsp;&nbsp;&nbsp;&nbsp;Skips the given number of points at the beginning.  
    **limit** : int, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Import only n points  
    &nbsp;&nbsp;&nbsp;&nbsp;Imports only the given number of points  
    **project** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name for new project (location) to create  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: *name*  
    **flags** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *p*, *r*, *u*, *v*, *e*, *t*, *c*, *b*, *o*, *i*  
    &nbsp;&nbsp;&nbsp;&nbsp;**p**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Print LAS file info and exit  
    &nbsp;&nbsp;&nbsp;&nbsp;**r**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Limit import to the current region  
    &nbsp;&nbsp;&nbsp;&nbsp;**u**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Invert mask when selecting points  
    &nbsp;&nbsp;&nbsp;&nbsp;**v**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Use only valid points  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Points invalid according to APSRS LAS specification will be filtered out  
    &nbsp;&nbsp;&nbsp;&nbsp;**e**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Extend region extents based on new dataset  
    &nbsp;&nbsp;&nbsp;&nbsp;**t**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Do not create attribute table  
    &nbsp;&nbsp;&nbsp;&nbsp;**c**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Do not automatically add unique ID as category to each point  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Create only requested layers and categories  
    &nbsp;&nbsp;&nbsp;&nbsp;**b**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Do not build topology  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Advantageous when handling a large number of points  
    &nbsp;&nbsp;&nbsp;&nbsp;**o**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Override projection check (use current project's CRS)  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Assume that the dataset has the same coordinate reference system as the current project  
    &nbsp;&nbsp;&nbsp;&nbsp;**i**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Create the project specified by the "project" parameter and exit. Do not import the vector data.  
    **overwrite** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allow output files to overwrite existing files  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **verbose** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **quiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **superquiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  

    Returns:

    **result** : grass.tools.support.ToolResult | None  
    If the tool produces text as standard output, a *ToolResult* object will be returned. Otherwise, `None` will be returned.

    Raises:

    *grass.tools.ToolError*: When the tool ended with an error.

## DESCRIPTION

*v.in.lidar* converts LiDAR point clouds in LAS format to a GRASS
vector, using the [libLAS](https://liblas.org) library. The created
vector is true 3D with x, y, z coordinates.

For larger datasets, it is recommended to not build topology (-b flag).
Also, creating a table with attributes can take some time for larger
datasets.

The optional **spatial** parameter defines spatial query extents. This
parameter allows the user to restrict the region to a spatial subset
while importing the data. All LiDAR points falling into this rectangle
subregion are imported. The **-r** current region flag is identical, but
uses the current region settings as the spatial bounds (see
*[g.region](g.region.md)*).

A LiDAR pulse can have multiple returns. The first return values can be
used to obtain a digital surface model (DSM) where e.g. canopy cover is
represented. The last return values can be used to obtain a digital
terrain model (DTM) where e.g. the forest floor instead of canopy cover
is represented. The **return_filter** option allows selecting one of
first, mid, or last returns.

LiDAR points can be already classified into standardized classes. For
example, class number 2 represents ground (for other classes see LAS
format specification in references). The **class_filter** option allows
selecting one or more classes, as numbers (integers) separated by comma.

Note that proper filtering of the input points in not only critical for
the analysis itself but it can also speed up the processing
significantly.

### Decimation

Table with selected percentages of points to keep with corresponding
decimation parameters:

| percentage | parameters    |
|------------|---------------|
| 0.1%       | preserve=1000 |
| 1%         | preserve=100  |
| 5%         | preserve=20   |
| 10%        | preserve=10   |
| 20%        | preserve=5    |
| 25%        | preserve=4    |
| 50%        | skip=2        |
| 75%        | skip=4        |
| 80%        | skip=5        |
| 90%        | skip=10       |

Table with selected fractions of points to keep with corresponding
decimation parameters:

| ratio | parameters |
|-------|------------|
| 1/3   | preserve=3 |
| 1/4   | preserve=4 |
| 1/5   | preserve=5 |
| 1/6   | preserve=6 |

Table with selected fractions of points to throw away with corresponding
decimation parameters:

| ratio | parameters |
|-------|------------|
| 1/3   | skip=3     |
| 1/4   | skip=4     |
| 1/5   | skip=5     |
| 1/6   | skip=6     |

## Project Creation

*v.in.lidar* attempts to preserve coordinate reference system (CRS)
information when importing datasets if the source format includes such
information, and if the LAS driver supports it. If the source dataset
CRS does not match the CRS of the current project (previously called
location) *v.in.lidar* will report an error message
("`Coordinate reference system of dataset does not appear to match current project`")
and then report the PROJ_INFO parameters of the source dataset.

If the user wishes to ignore the difference between the coordinate
system of the source data and the current project, they may pass the
**-o** flag to override the CRS check.

If the user wishes to import the data with the full CRS definition, it
is possible to have *v.in.lidar* automatically create a new project
based on the CRS and extents of the file being read. This is
accomplished by passing the name to be used for the new project via the
**project** parameter. Upon completion of the command, a new project
will have been created (with only a PERMANENT mapset), and the vector
map will have been imported with the indicated **output** name into the
PERMANENT mapset.

## NOTES

The typical file extensions for the LAS format are .las and .laz
(compressed). The compressed LAS (.laz) format can be imported only if
libLAS has been compiled with laszip support. It is also recommended to
compile libLAS with GDAL, needed to test for matching CRSs.

## EXAMPLE

The sample LAS data are in the file "Serpent Mound Model LAS Data.laz",
available at [Serpent Mound Model LAS
Data.laz](https://github.com/PDAL/data/raw/4ee9ee43b195268a59113555908c1c0cdf955bd4/liblas/Serpent-Mound-Model-LAS-Data.laz)

```sh
# print LAS file info
v.in.lidar -p input="Serpent Mound Model LAS Data.laz"

# create a project with CRS information of the LAS data
v.in.lidar -i input="Serpent Mound Model LAS Data.laz" project=Serpent_Mound

# quit and restart GRASS in the newly created project "Serpent_Mound"
# real import of LiDAR LAS data, without topology and without attribute table
v.in.lidar -tb input="Serpent Mound Model LAS Data.laz" output=Serpent_Mound_Model_pts
```

## REFERENCES

[ASPRS LAS
format](https://www.asprs.org/committee-general/laser-las-file-format-exchange-activities.html)  
[LAS library](https://liblas.org/)  
[LAS library C API](https://liblas.org/doxygen/liblas_8h.html)
documentation

## SEE ALSO

*[r.in.lidar](r.in.lidar.md), [r3.in.lidar](r3.in.lidar.md),
[g.region](g.region.md), [v.vect.stats](v.vect.stats.md),
[v.in.ogr](v.in.ogr.md)*

## AUTHORS

Markus Metz  
Vaclav Petras, [NCSU GeoForAll
Lab](https://geospatial.ncsu.edu/geoforall/) (decimation, cats, areas,
zrange)  
based on *v.in.ogr* by various authors

## SOURCE CODE

Available at: [v.in.lidar source code](https://github.com/OSGeo/grass/tree/main/vector/v.in.lidar)
([history](https://github.com/OSGeo/grass/commits/main/vector/v.in.lidar))  
Latest change: Friday May 09 14:33:40 2025 in commit [b356c7e](https://github.com/OSGeo/grass/commit/b356c7e108fcbeca77474c8e83ebec8f1e7b3e4a)
