---
name: v.univar
description: Calculates univariate statistics of vector map features. Variance and standard deviation is calculated only for points if specified.
keywords: [ vector, statistics, univariate statistics, attribute table, geometry ]
---

# v.univar

Calculates univariate statistics of vector map features.

Variance and standard deviation is calculated only for points if specified.

=== "Command line"

    **v.univar**
    [**-gewd**]
    **map**=*name*
    [**layer**=*string*]
    [**type**=*string* [,*string*,...]]
    [**column**=*name*]
    [**where**=*sql_query*]
    [**percentile**=*integer*]
    **format**=*name*
    [**--verbose**]
    [**--quiet**]
    [**--qq**]
    [**--ui**]

    Example:

    ```sh
    v.univar map=name format=plain
    ```

=== "Python (grass.script)"

    *grass.script.parse_command*("***v.univar***",
        **map**,
        **layer**=*"1"*,
        **type**=*"point,line,area"*,
        **column**=*None*,
        **where**=*None*,
        **percentile**=*90*,
        **format**=*"plain"*,
        **flags**=*None*,
        **verbose**=*None*,
        **quiet**=*None*,
        **superquiet**=*None*)

    Example:

    ```python
    gs.parse_command("v.univar", map="name", format="json")
    ```

=== "Python (grass.tools)"

    *grass.tools.Tools.v_univar*(**map**,
        **layer**=*"1"*,
        **type**=*"point,line,area"*,
        **column**=*None*,
        **where**=*None*,
        **percentile**=*90*,
        **format**=*"plain"*,
        **flags**=*None*,
        **verbose**=*None*,
        **quiet**=*None*,
        **superquiet**=*None*)

    Example:

    ```python
    tools = Tools()
    tools.v_univar(map="name", format="json")
    ```

    This grass.tools API is experimental in version 8.5 and expected to be stable in version 8.6.

## Parameters

=== "Command line"

    **map**=*name* **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of vector map  
    &nbsp;&nbsp;&nbsp;&nbsp;Or data source for direct OGR access  
    **layer**=*string*  
    &nbsp;&nbsp;&nbsp;&nbsp;Layer number or name  
    &nbsp;&nbsp;&nbsp;&nbsp;Vector features can have category values in different layers. This number determines which layer to use. When used with direct OGR access this is the layer name.  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *1*  
    **type**=*string* [,*string*,...]  
    &nbsp;&nbsp;&nbsp;&nbsp;Input feature type  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *point, line, boundary, centroid, area*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *point,line,area*  
    **column**=*name*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of attribute column  
    **where**=*sql_query*  
    &nbsp;&nbsp;&nbsp;&nbsp;WHERE conditions of SQL statement without 'where' keyword  
    &nbsp;&nbsp;&nbsp;&nbsp;Example: income &lt; 1000 and population &gt;= 10000  
    **percentile**=*integer*  
    &nbsp;&nbsp;&nbsp;&nbsp;Percentile to calculate (requires extended statistics flag)  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *0-100*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *90*  
    **format**=*name* **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;Output format  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *plain, shell, json*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *plain*  
    &nbsp;&nbsp;&nbsp;&nbsp;**plain**: Human readable text output  
    &nbsp;&nbsp;&nbsp;&nbsp;**shell**: shell script style text output  
    &nbsp;&nbsp;&nbsp;&nbsp;**json**: JSON (JavaScript Object Notation)  
    **-g**  
    &nbsp;&nbsp;&nbsp;&nbsp;Print the stats in shell script style [deprecated]  
    &nbsp;&nbsp;&nbsp;&nbsp;This flag is deprecated and will be removed in a future release. Use format=shell instead.  
    **-e**  
    &nbsp;&nbsp;&nbsp;&nbsp;Calculate extended statistics  
    **-w**  
    &nbsp;&nbsp;&nbsp;&nbsp;Weigh by line length or area size  
    **-d**  
    &nbsp;&nbsp;&nbsp;&nbsp;Calculate geometric distances instead of attribute statistics  
    **--help**  
    &nbsp;&nbsp;&nbsp;&nbsp;Print usage summary  
    **--verbose**  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    **--quiet**  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    **--qq**  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    **--ui**  
    &nbsp;&nbsp;&nbsp;&nbsp;Force launching GUI dialog

=== "Python (grass.script)"

    **map** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of vector map  
    &nbsp;&nbsp;&nbsp;&nbsp;Or data source for direct OGR access  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, vector, *name*  
    **layer** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Layer number or name  
    &nbsp;&nbsp;&nbsp;&nbsp;Vector features can have category values in different layers. This number determines which layer to use. When used with direct OGR access this is the layer name.  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, layer  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *1*  
    **type** : str | list[str], *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Input feature type  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *point, line, boundary, centroid, area*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *point,line,area*  
    **column** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of attribute column  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, dbcolumn, *name*  
    **where** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;WHERE conditions of SQL statement without 'where' keyword  
    &nbsp;&nbsp;&nbsp;&nbsp;Example: income &lt; 1000 and population &gt;= 10000  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, sql_query, *sql_query*  
    **percentile** : int, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Percentile to calculate (requires extended statistics flag)  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *0-100*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *90*  
    **format** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Output format  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: *name*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *plain, shell, json*  
    &nbsp;&nbsp;&nbsp;&nbsp;**plain**: Human readable text output  
    &nbsp;&nbsp;&nbsp;&nbsp;**shell**: shell script style text output  
    &nbsp;&nbsp;&nbsp;&nbsp;**json**: JSON (JavaScript Object Notation)  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *plain*  
    **flags** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *g*, *e*, *w*, *d*  
    &nbsp;&nbsp;&nbsp;&nbsp;**g**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Print the stats in shell script style [deprecated]  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;This flag is deprecated and will be removed in a future release. Use format=shell instead.  
    &nbsp;&nbsp;&nbsp;&nbsp;**e**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Calculate extended statistics  
    &nbsp;&nbsp;&nbsp;&nbsp;**w**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Weigh by line length or area size  
    &nbsp;&nbsp;&nbsp;&nbsp;**d**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Calculate geometric distances instead of attribute statistics  
    **verbose** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **quiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **superquiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  

=== "Python (grass.tools)"

    **map** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of vector map  
    &nbsp;&nbsp;&nbsp;&nbsp;Or data source for direct OGR access  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, vector, *name*  
    **layer** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Layer number or name  
    &nbsp;&nbsp;&nbsp;&nbsp;Vector features can have category values in different layers. This number determines which layer to use. When used with direct OGR access this is the layer name.  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, layer  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *1*  
    **type** : str | list[str], *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Input feature type  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *point, line, boundary, centroid, area*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *point,line,area*  
    **column** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of attribute column  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, dbcolumn, *name*  
    **where** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;WHERE conditions of SQL statement without 'where' keyword  
    &nbsp;&nbsp;&nbsp;&nbsp;Example: income &lt; 1000 and population &gt;= 10000  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, sql_query, *sql_query*  
    **percentile** : int, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Percentile to calculate (requires extended statistics flag)  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *0-100*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *90*  
    **format** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Output format  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: *name*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *plain, shell, json*  
    &nbsp;&nbsp;&nbsp;&nbsp;**plain**: Human readable text output  
    &nbsp;&nbsp;&nbsp;&nbsp;**shell**: shell script style text output  
    &nbsp;&nbsp;&nbsp;&nbsp;**json**: JSON (JavaScript Object Notation)  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *plain*  
    **flags** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *g*, *e*, *w*, *d*  
    &nbsp;&nbsp;&nbsp;&nbsp;**g**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Print the stats in shell script style [deprecated]  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;This flag is deprecated and will be removed in a future release. Use format=shell instead.  
    &nbsp;&nbsp;&nbsp;&nbsp;**e**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Calculate extended statistics  
    &nbsp;&nbsp;&nbsp;&nbsp;**w**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Weigh by line length or area size  
    &nbsp;&nbsp;&nbsp;&nbsp;**d**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Calculate geometric distances instead of attribute statistics  
    **verbose** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **quiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **superquiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  

    Returns:

    **result** : grass.tools.support.ToolResult | None  
    If the tool produces text as standard output, a *ToolResult* object will be returned. Otherwise, `None` will be returned.

    Raises:

    *grass.tools.ToolError*: When the tool ended with an error.

## DESCRIPTION

*v.univar* calculates univariate statistics on (by default) an attribute
of, or, through the **-d** flag on distance between, vector map
features. Attributes are read per feature and per category value. This
means that if the map contains several features with the same category
value, the attribute is read as many times as there are features. On the
other hand, if a feature has more than one category value, each
attribute value linked to each of the category values of the feature is
read. For statistics on one attribute per category value, instead of one
attribute per feature and per category, see
[v.db.univar](v.db.univar.md).

Extended statistics (**-e**) adds median, 1st and 3rd quartiles, and
90th percentile to the output.

## NOTES

When using the **-d** flag, univariate statistics of distances between
vector features are calculated. The distances from all features to all
other features are used. Since the distance from feature A to feature B
is the same like the distance from feature B to feature A, that distance
is considered only once, i.e. all pairwise distances between features
are used. Depending on the selected vector **type**, distances are
calculated as follows:

- **type=point**: point distances are considered;
- **type=line**: line to line distances are considered;
- **type=area**: not supported, use **type=centroid** instead (and see
  [v.distance](v.distance.md) for calculating distances between areas)

## EXAMPLES

The examples are based on the North Carolina sample dataset.

### Example dataset preparation

```sh
g.region raster=elevation -p
v.random output=samples npoints=100
v.db.addtable map=samples columns="heights double precision"
v.what.rast map=samples rast=elevation column=heights
v.db.select map=samples
```

### Calculate height attribute statistics

```sh
v.univar -e samples column=heights type=point

number of features with non NULL attribute: 100
number of missing attributes: 0
number of NULL attributes: 0
minimum: 57.2799
maximum: 148.903
range: 91.6235
sum: 10825.6
mean: 108.256
mean of absolute values: 108.256
population standard deviation: 20.2572
population variance: 410.356
population coefficient of variation: 0.187123
sample standard deviation: 20.3593
sample variance: 414.501
kurtosis: -0.856767
skewness: 0.162093
1st quartile: 90.531
median (even number of cells): 106.518
3rd quartile: 126.274
90th percentile: 135.023
```

### Compare to statistics of original raster map

```sh
r.univar -e elevation

total null and non-null cells: 2025000
total null cells: 0

Of the non-null cells:
----------------------
n: 2025000
minimum: 55.5788
maximum: 156.33
range: 100.751
mean: 110.375
mean of absolute values: 110.375
standard deviation: 20.3153
variance: 412.712
variation coefficient: 18.4057 %
sum: 223510266.558102
1st quartile: 94.79
median (even number of cells): 108.88
3rd quartile: 126.792
90th percentile: 138.66
```

### Calculate statistic of distance between sampling points

```sh
v.univar -d samples type=point

number of primitives: 100
number of non zero distances: 4851
number of zero distances: 0
minimum: 69.9038
maximum: 18727.7
range: 18657.8
sum: 3.51907e+07
mean: 7254.33
mean of absolute values: 7254.33
population standard deviation: 3468.53
population variance: 1.20307e+07
population coefficient of variation: 0.478132
sample standard deviation: 3468.89
sample variance: 1.20332e+07
kurtosis: -0.605406
skewness: 0.238688
```

### Output in JSON format

```sh
v.univar -e samples column=heights type=point format=json
```

will output the results in JSON format:

```json
{
    "n": 1832,
    "missing": 0,
    "nnull": 0,
    "min": 166.946991,
    "max": 2729482.25,
    "range": 2729315.3030090001,
    "sum": 78876146.145385057,
    "mean": 43054.664926520229,
    "mean_abs": 43054.664926520229,
    "population_stddev": 132689.08650029532,
    "population_variance": 17606393676.282852,
    "population_coeff_variation": 3.0818747916573215,
    "sample_stddev": 132725.31560308655,
    "sample_variance": 17616009401.938931,
    "kurtosis": 139.15698418811229,
    "skewness": 9.7065048189730767,
    "first_quartile": 3699.3234859999998,
    "median": 10308.4453125,
    "third_quartile": 29259.074218999998,
    "percentiles": [
        {
            "percentile": 90,
            "value": 86449.734375
        }
    ]
}
```

## SEE ALSO

*[db.univar](db.univar.md), [r.univar](r.univar.md),
[v.db.univar](v.db.univar.md), [v.distance](v.distance.md),
[v.neighbors](v.neighbors.md), [v.qcount](v.qcount.md)*

## AUTHORS

Radim Blazek, ITC-irst

extended by:  
Hamish Bowman, University of Otago, New Zealand  
Martin Landa

## SOURCE CODE

Available at: [v.univar source code](https://github.com/OSGeo/grass/tree/main/vector/v.univar)
([history](https://github.com/OSGeo/grass/commits/main/vector/v.univar))  
Latest change: Thursday Oct 02 14:39:13 2025 in commit [1850489](https://github.com/OSGeo/grass/commit/1850489bf42c72d8dcfe2e4db1738441b4a7dc43)
