---
name: r3.to.rast
description: Converts 3D raster maps to 2D raster maps
keywords: [ raster3d, conversion, raster, voxel ]
---

# r3.to.rast

Converts 3D raster maps to 2D raster maps

=== "Command line"

    **r3.to.rast**
    [**-mr**]
    **input**=*string*
    **output**=*string*
    [**type**=*string*]
    [**multiply**=*float*]
    [**add**=*float*]
    [**--overwrite**]
    [**--verbose**]
    [**--quiet**]
    [**--qq**]
    [**--ui**]

    Example:

    ```sh
    r3.to.rast input=string output=string
    ```

=== "Python (grass.script)"

    *grass.script.run_command*("***r3.to.rast***",
        **input**,
        **output**,
        **type**=*None*,
        **multiply**=*None*,
        **add**=*None*,
        **flags**=*None*,
        **overwrite**=*None*,
        **verbose**=*None*,
        **quiet**=*None*,
        **superquiet**=*None*)

    Example:

    ```python
    gs.run_command("r3.to.rast", input="string", output="string")
    ```

=== "Python (grass.tools)"

    *grass.tools.Tools.r3_to_rast*(**input**,
        **output**,
        **type**=*None*,
        **multiply**=*None*,
        **add**=*None*,
        **flags**=*None*,
        **overwrite**=*None*,
        **verbose**=*None*,
        **quiet**=*None*,
        **superquiet**=*None*)

    Example:

    ```python
    tools = Tools()
    tools.r3_to_rast(input="string", output="string")
    ```

    This grass.tools API is experimental in version 8.5 and expected to be stable in version 8.6.

## Parameters

=== "Command line"

    **input**=*string* **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;3D raster map(s) to be converted to 2D raster slices  
    **output**=*string* **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;Basename for resultant raster slice maps  
    **type**=*string*  
    &nbsp;&nbsp;&nbsp;&nbsp;Type of raster map to be created  
    &nbsp;&nbsp;&nbsp;&nbsp;Storage type for resultant raster map  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *CELL, FCELL, DCELL*  
    &nbsp;&nbsp;&nbsp;&nbsp;**CELL**: Integer  
    &nbsp;&nbsp;&nbsp;&nbsp;**FCELL**: Single precision floating point  
    &nbsp;&nbsp;&nbsp;&nbsp;**DCELL**: Double precision floating point  
    **multiply**=*float*  
    &nbsp;&nbsp;&nbsp;&nbsp;Value to multiply the raster values with  
    &nbsp;&nbsp;&nbsp;&nbsp;Coefficient a in the equation y = ax + b  
    **add**=*float*  
    &nbsp;&nbsp;&nbsp;&nbsp;Value to add to the raster values  
    &nbsp;&nbsp;&nbsp;&nbsp;Coefficient b in the equation y = ax + b  
    **-m**  
    &nbsp;&nbsp;&nbsp;&nbsp;Use 3D raster mask (if exists) with input map  
    **-r**  
    &nbsp;&nbsp;&nbsp;&nbsp;Use the same resolution as the input 3D raster map for the 2D output maps, independent of the current region settings  
    **--overwrite**  
    &nbsp;&nbsp;&nbsp;&nbsp;Allow output files to overwrite existing files  
    **--help**  
    &nbsp;&nbsp;&nbsp;&nbsp;Print usage summary  
    **--verbose**  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    **--quiet**  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    **--qq**  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    **--ui**  
    &nbsp;&nbsp;&nbsp;&nbsp;Force launching GUI dialog

=== "Python (grass.script)"

    **input** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;3D raster map(s) to be converted to 2D raster slices  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, 3d-raster  
    **output** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Basename for resultant raster slice maps  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: output, raster  
    **type** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Type of raster map to be created  
    &nbsp;&nbsp;&nbsp;&nbsp;Storage type for resultant raster map  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *CELL, FCELL, DCELL*  
    &nbsp;&nbsp;&nbsp;&nbsp;**CELL**: Integer  
    &nbsp;&nbsp;&nbsp;&nbsp;**FCELL**: Single precision floating point  
    &nbsp;&nbsp;&nbsp;&nbsp;**DCELL**: Double precision floating point  
    **multiply** : float, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Value to multiply the raster values with  
    &nbsp;&nbsp;&nbsp;&nbsp;Coefficient a in the equation y = ax + b  
    **add** : float, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Value to add to the raster values  
    &nbsp;&nbsp;&nbsp;&nbsp;Coefficient b in the equation y = ax + b  
    **flags** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *m*, *r*  
    &nbsp;&nbsp;&nbsp;&nbsp;**m**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Use 3D raster mask (if exists) with input map  
    &nbsp;&nbsp;&nbsp;&nbsp;**r**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Use the same resolution as the input 3D raster map for the 2D output maps, independent of the current region settings  
    **overwrite** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allow output files to overwrite existing files  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **verbose** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **quiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **superquiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  

=== "Python (grass.tools)"

    **input** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;3D raster map(s) to be converted to 2D raster slices  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, 3d-raster  
    **output** : str | type(np.ndarray) | type(np.array) | type(gs.array.array), *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Basename for resultant raster slice maps  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: output, raster  
    **type** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Type of raster map to be created  
    &nbsp;&nbsp;&nbsp;&nbsp;Storage type for resultant raster map  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *CELL, FCELL, DCELL*  
    &nbsp;&nbsp;&nbsp;&nbsp;**CELL**: Integer  
    &nbsp;&nbsp;&nbsp;&nbsp;**FCELL**: Single precision floating point  
    &nbsp;&nbsp;&nbsp;&nbsp;**DCELL**: Double precision floating point  
    **multiply** : float, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Value to multiply the raster values with  
    &nbsp;&nbsp;&nbsp;&nbsp;Coefficient a in the equation y = ax + b  
    **add** : float, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Value to add to the raster values  
    &nbsp;&nbsp;&nbsp;&nbsp;Coefficient b in the equation y = ax + b  
    **flags** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *m*, *r*  
    &nbsp;&nbsp;&nbsp;&nbsp;**m**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Use 3D raster mask (if exists) with input map  
    &nbsp;&nbsp;&nbsp;&nbsp;**r**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Use the same resolution as the input 3D raster map for the 2D output maps, independent of the current region settings  
    **overwrite** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allow output files to overwrite existing files  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **verbose** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **quiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **superquiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  

    Returns:

    **result** : grass.tools.support.ToolResult | np.ndarray | tuple[np.ndarray] | None  
    If the tool produces text as standard output, a *ToolResult* object will be returned. Otherwise, `None` will be returned. If an array type (e.g., *np.ndarray*) is used for one of the raster outputs, the result will be an array and will have the shape corresponding to the computational region. If an array type is used for more than one raster output, the result will be a tuple of arrays.

    Raises:

    *grass.tools.ToolError*: When the tool ended with an error.

## DESCRIPTION

Converts one 3D raster map into several 2D raster maps (depends on
depths). If the 2D and 3D region settings are different, the 3D
resolution will be adjusted to the 2D resolution (the depths are not
touched). The user can force *r3.to.rast* to use the 2D resolution of
the input 3D raster map for the output maps, independently from the
current region settings.

![How r3.to.rast works](r3.to.rast.png)  
*How r3.to.rast works*

### Map type conversions

Type of resulting 2D raster maps is determined by the type of the input
3D raster, i.e. 3D raster of type DCELL (double) will result in DCELL 2D
rasters. A specific type for 2D rasters can be requested using the
**type** option.

The **type** option is especially advantageous when the 3D raster map
stores categories (which need to be stored as floating point numbers)
and the 2D raster map should be also categorical, i.e. use integers. The
type is set to `CELL` in this case.

### Modifying the values

The values in the 3D raster map can be modified prior to storing in the
2D raster map. The values can be scaled using the option **multiply**
and a constant value can be added using the option **add**. The new
value is computed using the following equation:

```sh
y = ax + b
```

where *x* is the original value, *a* is the value of **multiply**
option, *b* is the value of **add** option, and *y* is the new value.
When **multiply** is not provided, the value of *a* is 1. When **add**
is not provided, the value of *b* is 0.

## NOTES

Every slice of the 3D raster map is copied to one 2D raster map. The
maps are named like **output***\_slicenumber*. Slices are counted from
bottom to the top, so the bottom slice has number 1.

The number of slices is equal to the number of depths.

To round floating point values to integers when using `type=CELL`, the
**add** option should be set to 0.5.

## SEE ALSO

*[r3.cross.rast](r3.cross.rast.md), [r3.out.vtk](r3.out.vtk.md),
[r3.out.ascii](r3.out.ascii.md), [g.region](g.region.md)*

## AUTHORS

Sören Gebbert  
Vaclav Petras, [NCSU GeoForAll
Lab](https://geospatial.ncsu.edu/geoforall/)

## SOURCE CODE

Available at: [r3.to.rast source code](https://github.com/OSGeo/grass/tree/main/raster3d/r3.to.rast)
([history](https://github.com/OSGeo/grass/commits/main/raster3d/r3.to.rast))  
Latest change: Saturday Oct 11 04:38:40 2025 in commit [3dd71f5](https://github.com/OSGeo/grass/commit/3dd71f5fab83b72a2db2da959fe075c5b3b52200)
