---
name: db.columns
description: List all columns for a given table.
keywords: [ database, attribute table ]
---

# db.columns

List all columns for a given table.

=== "Command line"

    **db.columns**
    **table**=*name*
    [**driver**=*name*]
    [**database**=*name*]
    **format**=*name*
    [**--verbose**]
    [**--quiet**]
    [**--qq**]
    [**--ui**]

    Example:

    ```sh
    db.columns table=name format=plain
    ```

=== "Python (grass.script)"

    *grass.script.parse_command*("***db.columns***",
        **table**,
        **driver**=*"sqlite"*,
        **database**=*"$GISDBASE/$LOCATION_NAME/$MAPSET/sqlite/sqlite.db"*,
        **format**=*"plain"*,
        **verbose**=*None*,
        **quiet**=*None*,
        **superquiet**=*None*)

    Example:

    ```python
    gs.parse_command("db.columns", table="name", format="json")
    ```

=== "Python (grass.tools)"

    *grass.tools.Tools.db_columns*(**table**,
        **driver**=*"sqlite"*,
        **database**=*"$GISDBASE/$LOCATION_NAME/$MAPSET/sqlite/sqlite.db"*,
        **format**=*"plain"*,
        **verbose**=*None*,
        **quiet**=*None*,
        **superquiet**=*None*)

    Example:

    ```python
    tools = Tools()
    tools.db_columns(table="name", format="json")
    ```

    This grass.tools API is experimental in version 8.5 and expected to be stable in version 8.6.

## Parameters

=== "Command line"

    **table**=*name* **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of attribute table  
    **driver**=*name*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of database driver  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *dbf, odbc, ogr, pg, sqlite*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *sqlite*  
    **database**=*name*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of database  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *$GISDBASE/$LOCATION_NAME/$MAPSET/sqlite/sqlite.db*  
    **format**=*name* **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;Output format  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *plain, json*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *plain*  
    &nbsp;&nbsp;&nbsp;&nbsp;**plain**: Plain text output  
    &nbsp;&nbsp;&nbsp;&nbsp;**json**: JSON (JavaScript Object Notation)  
    **--help**  
    &nbsp;&nbsp;&nbsp;&nbsp;Print usage summary  
    **--verbose**  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    **--quiet**  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    **--qq**  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    **--ui**  
    &nbsp;&nbsp;&nbsp;&nbsp;Force launching GUI dialog

=== "Python (grass.script)"

    **table** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of attribute table  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, dbtable, *name*  
    **driver** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of database driver  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, dbdriver, *name*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *dbf, odbc, ogr, pg, sqlite*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *sqlite*  
    **database** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of database  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, dbname, *name*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *$GISDBASE/$LOCATION_NAME/$MAPSET/sqlite/sqlite.db*  
    **format** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Output format  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: *name*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *plain, json*  
    &nbsp;&nbsp;&nbsp;&nbsp;**plain**: Plain text output  
    &nbsp;&nbsp;&nbsp;&nbsp;**json**: JSON (JavaScript Object Notation)  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *plain*  
    **verbose** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **quiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **superquiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  

=== "Python (grass.tools)"

    **table** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of attribute table  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, dbtable, *name*  
    **driver** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of database driver  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, dbdriver, *name*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *dbf, odbc, ogr, pg, sqlite*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *sqlite*  
    **database** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of database  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, dbname, *name*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *$GISDBASE/$LOCATION_NAME/$MAPSET/sqlite/sqlite.db*  
    **format** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Output format  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: *name*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *plain, json*  
    &nbsp;&nbsp;&nbsp;&nbsp;**plain**: Plain text output  
    &nbsp;&nbsp;&nbsp;&nbsp;**json**: JSON (JavaScript Object Notation)  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *plain*  
    **verbose** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **quiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **superquiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  

    Returns:

    **result** : grass.tools.support.ToolResult | None  
    If the tool produces text as standard output, a *ToolResult* object will be returned. Otherwise, `None` will be returned.

    Raises:

    *grass.tools.ToolError*: When the tool ended with an error.

## DESCRIPTION

*db.columns* lists all columns for a given table. Connection to databases
are supported through dbf, shp, odbc and pg drivers.

## NOTE

If parameters for database connection are already set with
[db.connect](db.connect.md), they are taken as default values and do not
need to be specified each time.

## EXAMPLES

### List columns of a PostgreSQL attribute table

```sh
db.columns table=zipcodes_wake driver=pg database=grassdb
```

*If the database parameters are already set, the columns can be listed
directly*  

```sh
db.columns table=zipcodes_wake
```

### List columns from Shape file with DBF attribute table

```sh
db.columns table=zipcodes_wake driver=dbf database=/grassdata/nc_spm_08/PERMANENT/dbf/
```

### List columns of table in SQLite database

Note that the SQLite backend is the default setting.

```sh
db.columns driver=sqlite table=archsites database='$GISDBASE/$LOCATION_NAME/$MAPSET/sqlite/sqlite.db'
```

### List columns using Python

```python
import grass.script as gs

data = gs.parse_command("db.columns", table="bridges", format="json")
print(data)
```

Possible output:

```text
['cat', 'OBJECTID', 'BRIDGES__1', 'SIPS_ID', 'TYPE', 'CLASSIFICA', 'BRIDGE_NUM', 'FEATURE_IN', 'FACILITY_C', 'LOCATION', 'YEAR_BUILT', 'WIDTH', 'CO_', 'CO_NAME']
```

## SEE ALSO

*[db.connect](db.connect.md), [db.describe](db.describe.md),
[db.drivers](db.drivers.md), [db.droptable](db.droptable.md),
[db.execute](db.execute.md), [db.login](db.login.md),
[db.tables](db.tables.md), [GRASS SQL interface](sql.md)*

[GRASS SQL interface](sql.md)

## AUTHOR

Radim Blazek, ITC-Irst, Trento, Italy

## SOURCE CODE

Available at: [db.columns source code](https://github.com/OSGeo/grass/tree/main/db/db.columns)
([history](https://github.com/OSGeo/grass/commits/main/db/db.columns))  
Latest change: Thursday Oct 02 14:39:13 2025 in commit [1850489](https://github.com/OSGeo/grass/commit/1850489bf42c72d8dcfe2e4db1738441b4a7dc43)
