---
name: db.select
description: Selects data from attribute table. Performs SQL query statement(s).
keywords: [ database, attribute table, SQL ]
---

# db.select

Selects data from attribute table.

Performs SQL query statement(s).

=== "Command line"

    **db.select**
    [**-cdvt**]
    [**sql**=*sql_query*]
    [**input**=*name*]
    [**table**=*name*]
    [**driver**=*name*]
    [**database**=*name*]
    [**separator**=*character*]
    [**vertical_separator**=*character*]
    [**null_value**=*string*]
    [**output**=*name*]
    [**--overwrite**]
    [**--verbose**]
    [**--quiet**]
    [**--qq**]
    [**--ui**]

    Example:

    ```sh
    db.select
    ```

=== "Python (grass.script)"

    *grass.script.run_command*("***db.select***",
        **sql**=*None*,
        **input**=*None*,
        **table**=*None*,
        **driver**=*"sqlite"*,
        **database**=*"$GISDBASE/$LOCATION_NAME/$MAPSET/sqlite/sqlite.db"*,
        **separator**=*"pipe"*,
        **vertical_separator**=*None*,
        **null_value**=*None*,
        **output**=*None*,
        **flags**=*None*,
        **overwrite**=*None*,
        **verbose**=*None*,
        **quiet**=*None*,
        **superquiet**=*None*)

    Example:

    ```python
    gs.run_command("db.select")
    ```

=== "Python (grass.tools)"

    *grass.tools.Tools.db_select*(**sql**=*None*,
        **input**=*None*,
        **table**=*None*,
        **driver**=*"sqlite"*,
        **database**=*"$GISDBASE/$LOCATION_NAME/$MAPSET/sqlite/sqlite.db"*,
        **separator**=*"pipe"*,
        **vertical_separator**=*None*,
        **null_value**=*None*,
        **output**=*None*,
        **flags**=*None*,
        **overwrite**=*None*,
        **verbose**=*None*,
        **quiet**=*None*,
        **superquiet**=*None*)

    Example:

    ```python
    tools = Tools()
    tools.db_select()
    ```

    This grass.tools API is experimental in version 8.5 and expected to be stable in version 8.6.

## Parameters

=== "Command line"

    **sql**=*sql_query*  
    &nbsp;&nbsp;&nbsp;&nbsp;SQL SELECT statement  
    &nbsp;&nbsp;&nbsp;&nbsp;Example: select \* from towns where population &gt; 10000  
    **input**=*name*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of file containing SQL select statement(s)  
    &nbsp;&nbsp;&nbsp;&nbsp;'-' for standard input  
    **table**=*name*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of table to query  
    **driver**=*name*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of database driver  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *dbf, odbc, ogr, pg, sqlite*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *sqlite*  
    **database**=*name*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of database  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *$GISDBASE/$LOCATION_NAME/$MAPSET/sqlite/sqlite.db*  
    **separator**=*character*  
    &nbsp;&nbsp;&nbsp;&nbsp;Field separator  
    &nbsp;&nbsp;&nbsp;&nbsp;Special characters: pipe, comma, space, tab, newline  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *pipe*  
    **vertical_separator**=*character*  
    &nbsp;&nbsp;&nbsp;&nbsp;Vertical record separator (requires -v flag)  
    &nbsp;&nbsp;&nbsp;&nbsp;Special characters: pipe, comma, space, tab, newline  
    **null_value**=*string*  
    &nbsp;&nbsp;&nbsp;&nbsp;String representing NULL value  
    **output**=*name*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name for output file (if omitted or "-" output to stdout)  
    **-c**  
    &nbsp;&nbsp;&nbsp;&nbsp;Do not include column names in output  
    **-d**  
    &nbsp;&nbsp;&nbsp;&nbsp;Describe query only (don't run it)  
    **-v**  
    &nbsp;&nbsp;&nbsp;&nbsp;Vertical output (instead of horizontal)  
    **-t**  
    &nbsp;&nbsp;&nbsp;&nbsp;Only test query, do not execute  
    **--overwrite**  
    &nbsp;&nbsp;&nbsp;&nbsp;Allow output files to overwrite existing files  
    **--help**  
    &nbsp;&nbsp;&nbsp;&nbsp;Print usage summary  
    **--verbose**  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    **--quiet**  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    **--qq**  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    **--ui**  
    &nbsp;&nbsp;&nbsp;&nbsp;Force launching GUI dialog

=== "Python (grass.script)"

    **sql** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;SQL SELECT statement  
    &nbsp;&nbsp;&nbsp;&nbsp;Example: select \* from towns where population &gt; 10000  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: *sql_query*  
    **input** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of file containing SQL select statement(s)  
    &nbsp;&nbsp;&nbsp;&nbsp;'-' for standard input  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, file, *name*  
    **table** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of table to query  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, dbtable, *name*  
    **driver** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of database driver  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, dbdriver, *name*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *dbf, odbc, ogr, pg, sqlite*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *sqlite*  
    **database** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of database  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, dbname, *name*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *$GISDBASE/$LOCATION_NAME/$MAPSET/sqlite/sqlite.db*  
    **separator** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Field separator  
    &nbsp;&nbsp;&nbsp;&nbsp;Special characters: pipe, comma, space, tab, newline  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, separator, *character*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *pipe*  
    **vertical_separator** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Vertical record separator (requires -v flag)  
    &nbsp;&nbsp;&nbsp;&nbsp;Special characters: pipe, comma, space, tab, newline  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, separator, *character*  
    **null_value** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;String representing NULL value  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: *string*  
    **output** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name for output file (if omitted or "-" output to stdout)  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: output, file, *name*  
    **flags** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *c*, *d*, *v*, *t*  
    &nbsp;&nbsp;&nbsp;&nbsp;**c**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Do not include column names in output  
    &nbsp;&nbsp;&nbsp;&nbsp;**d**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Describe query only (don't run it)  
    &nbsp;&nbsp;&nbsp;&nbsp;**v**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Vertical output (instead of horizontal)  
    &nbsp;&nbsp;&nbsp;&nbsp;**t**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Only test query, do not execute  
    **overwrite** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allow output files to overwrite existing files  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **verbose** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **quiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **superquiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  

=== "Python (grass.tools)"

    **sql** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;SQL SELECT statement  
    &nbsp;&nbsp;&nbsp;&nbsp;Example: select \* from towns where population &gt; 10000  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: *sql_query*  
    **input** : str | io.StringIO, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of file containing SQL select statement(s)  
    &nbsp;&nbsp;&nbsp;&nbsp;'-' for standard input  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, file, *name*  
    **table** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of table to query  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, dbtable, *name*  
    **driver** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of database driver  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, dbdriver, *name*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *dbf, odbc, ogr, pg, sqlite*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *sqlite*  
    **database** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of database  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, dbname, *name*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *$GISDBASE/$LOCATION_NAME/$MAPSET/sqlite/sqlite.db*  
    **separator** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Field separator  
    &nbsp;&nbsp;&nbsp;&nbsp;Special characters: pipe, comma, space, tab, newline  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, separator, *character*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *pipe*  
    **vertical_separator** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Vertical record separator (requires -v flag)  
    &nbsp;&nbsp;&nbsp;&nbsp;Special characters: pipe, comma, space, tab, newline  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, separator, *character*  
    **null_value** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;String representing NULL value  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: *string*  
    **output** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name for output file (if omitted or "-" output to stdout)  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: output, file, *name*  
    **flags** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *c*, *d*, *v*, *t*  
    &nbsp;&nbsp;&nbsp;&nbsp;**c**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Do not include column names in output  
    &nbsp;&nbsp;&nbsp;&nbsp;**d**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Describe query only (don't run it)  
    &nbsp;&nbsp;&nbsp;&nbsp;**v**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Vertical output (instead of horizontal)  
    &nbsp;&nbsp;&nbsp;&nbsp;**t**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Only test query, do not execute  
    **overwrite** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allow output files to overwrite existing files  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **verbose** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **quiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **superquiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  

    Returns:

    **result** : grass.tools.support.ToolResult | None  
    If the tool produces text as standard output, a *ToolResult* object will be returned. Otherwise, `None` will be returned.

    Raises:

    *grass.tools.ToolError*: When the tool ended with an error.

## DESCRIPTION

*db.select* prints result of selection from database based on SQL
statement read from input file or from standard input to standard
output. Each individual query has to be written on one single line and
different queries have to be written on separate lines.

## NOTE

If parameters for database connection are already set with
*[db.connect](db.connect.md)*, they are taken as default values and do
not need to be specified each time. Output will be displayed to standard
output or can be directed to a file (option **output**).

## EXAMPLES

### Basic usage

```sh
db.select sql="select * from roads"
```

or

```sh
echo "select * from roads" | db.select input=-
```

or

```sh
db.select input=file.sql
```

or

```sh
cat file.sql | db.select input=-
```

Select all from table roads:

```sh
db.select -c driver=odbc database=mydb table=hospitals \
          input=file.sql output=result.csv
```

Select some string attribute, exclude others:

```sh
db.select sql="SELECT * FROM archsites WHERE str1 <> 'No Name'"
```

Select some string attribute with ZERO length:

```sh
db.select sql="SELECT * FROM archsites WHERE str1 IS NULL"
```

Select coordinates from PostGIS table:

```sh
db.select sql="SELECT x(geo),y(geo) FROM localizzazione"
```

### Execute multiple SQL statements

```sh
cat file.sql
SELECT * FROM busstopsall WHERE cat = 1
SELECT cat FROM busstopsall WHERE cat > 4 AND cat < 8

db.select input=file.sql
```

### Count number of cases falling into same position

When multiple observation have the spatial coordinates, they can still
be counted (if needed, coordinates can be uploaded to the attribute
table by *v.to.db*:

```sh
db.select sql="SELECT long,lat,site_id,department,obs,COUNT(long) as count_cases \
               FROM diseases GROUP BY long,lat"
```

## SEE ALSO

*[db.connect](db.connect.md), [db.describe](db.describe.md),
[db.drivers](db.drivers.md), [db.droptable](db.droptable.md),
[db.execute](db.execute.md), [db.login](db.login.md),
[db.tables](db.tables.md)*

*[GRASS SQL interface](sql.md)*

## AUTHORS

Original author unknown (probably CERL)  
Modifications by Radim Blazek, ITC-Irst, Trento, Italy  
Support for multiple statements by Martin Landa, Czech Technical
University in Prague

## SOURCE CODE

Available at: [db.select source code](https://github.com/OSGeo/grass/tree/main/db/db.select)
([history](https://github.com/OSGeo/grass/commits/main/db/db.select))  
Latest change: Tuesday Jun 24 05:57:51 2025 in commit [801e552](https://github.com/OSGeo/grass/commit/801e552cdaf8ef40f8760dbbcc5a4a5b83b14d40)
