---
name: r.semantic.label.py
description: Manages semantic label information assigned to a single raster map or to a list of raster maps.
keywords: [ general, imagery, semantic label, image collections ]
---

# r.semantic.label.py

Manages semantic label information assigned to a single raster map or to a list of raster maps.

=== "Command line"

    **r.semantic.label.py**
    **map**=*name* [,*name*,...]
    [**semantic_label**=*name* [,*name*,...]]
    **operation**=*string*
    [**--verbose**]
    [**--quiet**]
    [**--qq**]
    [**--ui**]

    Example:

    ```sh
    r.semantic.label.py map=name operation=add
    ```

=== "Python (grass.script)"

    *grass.script.run_command*("***r.semantic.label.py***",
        **map**,
        **semantic_label**=*None*,
        **operation**=*"add"*,
        **verbose**=*None*,
        **quiet**=*None*,
        **superquiet**=*None*)

    Example:

    ```python
    gs.run_command("r.semantic.label.py", map="name", operation="add")
    ```

=== "Python (grass.tools)"

    *grass.tools.Tools.r_semantic_label_py*(**map**,
        **semantic_label**=*None*,
        **operation**=*"add"*,
        **verbose**=*None*,
        **quiet**=*None*,
        **superquiet**=*None*)

    Example:

    ```python
    tools = Tools()
    tools.r_semantic_label_py(map="name", operation="add")
    ```

    This grass.tools API is experimental in version 8.5 and expected to be stable in version 8.6.

## Parameters

=== "Command line"

    **map**=*name* [,*name*,...] **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of raster map(s)  
    **semantic_label**=*name* [,*name*,...]  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of semantic label identifier (example: S2_1)  
    **operation**=*string* **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;Operation to be performed  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *add, remove, print*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *add*  
    **--help**  
    &nbsp;&nbsp;&nbsp;&nbsp;Print usage summary  
    **--verbose**  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    **--quiet**  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    **--qq**  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    **--ui**  
    &nbsp;&nbsp;&nbsp;&nbsp;Force launching GUI dialog

=== "Python (grass.script)"

    **map** : str | list[str], *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of raster map(s)  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, raster, *name*  
    **semantic_label** : str | list[str], *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of semantic label identifier (example: S2_1)  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: *name*  
    **operation** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Operation to be performed  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *add, remove, print*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *add*  
    **verbose** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **quiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **superquiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  

=== "Python (grass.tools)"

    **map** : str | list[str], *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of raster map(s)  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, raster, *name*  
    **semantic_label** : str | list[str], *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of semantic label identifier (example: S2_1)  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: *name*  
    **operation** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Operation to be performed  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *add, remove, print*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *add*  
    **verbose** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **quiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **superquiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  

    Returns:

    **result** : grass.tools.support.ToolResult | None  
    If the tool produces text as standard output, a *ToolResult* object will be returned. Otherwise, `None` will be returned.

    Raises:

    *grass.tools.ToolError*: When the tool ended with an error.

## DESCRIPTION

*r.semantic.label* allows assigning a semantic label information to a
single raster map or to a list of specified raster maps. Semantic label
can be defined by **semantic_label** option. Already assigned semantic
label can be removed from a specified raster map by
**operation=remove**. The module also allows printing detailed semantic
label information already assigned to a raster map by
**operation=print**.

Either a single raster map or a list of raster maps can be given by
**map** option.

## NOTES

Note that *only raster maps from the current mapsets* can be modified.

For more information about semantic label concept and supported sensors
(generic multispectral system, Landsat-5, Landsat-7, Landsat-8,
Sentinel-2) see the *[i.band.library](i.band.library.md)* module.

Semantic labels are supported by temporal GRASS modules. Name of STRDS
can be extended by band identifier in order to filter the result by a
semantic label. See
*[t.register](t.register.md#support-for-semantic-labels)*,
*[t.rast.list](t.rast.list.md#filtering-the-result-by-semantic-label)*,
*[t.info](t.info.md#space-time-dataset-with-semantic-labels-assigned)*
and *[t.rast.mapcalc](t.rast.mapcalc.md#semantic-label-filtering)*
modules for examples.

## EXAMPLES

### Assign semantic label to a single raster map

```sh
r.semantic.label map=T33UVR_20180506T100031_B01 semantic_label=S2_1
```

### Assign semantic label to a list of raster maps

```sh
r.semantic.label map=T33UVR_20180506T100031_B01,T33UVR_20180521T100029_B01 semantic_label=S2_1,S2_1
```

### Assign different semantic labels to a list of raster maps

```sh
r.semantic.label map=T33UVR_20180506T100031_B01,T33UVR_20180506T100031_B02 semantic_label=S2_1,S2_2
```

### Remove semantic label from a list of raster maps

```sh
r.semantic.label map=T33UVR_20180506T100031_B01,T33UVR_20180506T100031_B02 operation=remove
```

### Print semantic label information about single raster map

```sh
r.semantic.label map=T33UVR_20180506T100031_B01 operation=print
```

### Print extended semantic label information for a list of raster map

```sh
r.semantic.label map=T33UVR_20180506T100031_B01,T33UVR_20180506T100031_B02 operation=print
```

## KNOWN ISSUES

*r.semantic.label* allows managing semantic labels only related to 2D
raster maps.

## SEE ALSO

*[i.band.library](i.band.library.md), [r.info](r.info.md),
[r.support](r.support.md)*

## AUTHORS

Martin Landa  
Development sponsored by [mundialis GmbH & Co.
KG](https://www.mundialis.de/en) (for the [openEO](https://openeo.org)
EU H2020 grant 776242)

## SOURCE CODE

Available at: [r.semantic.label source code](https://github.com/OSGeo/grass/tree/main/scripts/r.semantic.label)
([history](https://github.com/OSGeo/grass/commits/main/scripts/r.semantic.label))  
Latest change: Friday Feb 07 19:16:09 2025 in commit [a82a39f](https://github.com/OSGeo/grass/commit/a82a39f673b97fafcfce1604dc3e6015cb96487a)
