---
name: t.connect
description: Prints/sets general temporal GIS database connection for current mapset.
keywords: [ temporal, settings, metadata ]
---

# t.connect

Prints/sets general temporal GIS database connection for current mapset.

=== "Command line"

    **t.connect**
    [**-pcdg**]
    [**driver**=*name*]
    [**database**=*name*]
    [**--verbose**]
    [**--quiet**]
    [**--qq**]
    [**--ui**]

    Example:

    ```sh
    t.connect
    ```

=== "Python (grass.script)"

    *grass.script.parse_command*("***t.connect***",
        **driver**=*"sqlite"*,
        **database**=*"$GISDBASE/$LOCATION_NAME/$MAPSET/tgis/sqlite.db"*,
        **flags**=*None*,
        **verbose**=*None*,
        **quiet**=*None*,
        **superquiet**=*None*)

    Example:

    ```python
    gs.parse_command("t.connect")
    ```

=== "Python (grass.tools)"

    *grass.tools.Tools.t_connect*(**driver**=*"sqlite"*,
        **database**=*"$GISDBASE/$LOCATION_NAME/$MAPSET/tgis/sqlite.db"*,
        **flags**=*None*,
        **verbose**=*None*,
        **quiet**=*None*,
        **superquiet**=*None*)

    Example:

    ```python
    tools = Tools()
    tools.t_connect()
    ```

    This grass.tools API is experimental in version 8.5 and expected to be stable in version 8.6.

## Parameters

=== "Command line"

    **driver**=*name*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of database driver  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *sqlite, pg*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *sqlite*  
    **database**=*name*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of database  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *$GISDBASE/$LOCATION_NAME/$MAPSET/tgis/sqlite.db*  
    **-p**  
    &nbsp;&nbsp;&nbsp;&nbsp;Print current connection parameters and exit  
    **-c**  
    &nbsp;&nbsp;&nbsp;&nbsp;Check connection parameters, set if uninitialized, and exit  
    **-d**  
    &nbsp;&nbsp;&nbsp;&nbsp;Set from default settings and exit  
    &nbsp;&nbsp;&nbsp;&nbsp;Overwrite current settings if initialized  
    **-g**  
    &nbsp;&nbsp;&nbsp;&nbsp;Print current connection parameter in shell style and exit  
    **--help**  
    &nbsp;&nbsp;&nbsp;&nbsp;Print usage summary  
    **--verbose**  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    **--quiet**  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    **--qq**  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    **--ui**  
    &nbsp;&nbsp;&nbsp;&nbsp;Force launching GUI dialog

=== "Python (grass.script)"

    **driver** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of database driver  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, dbdriver, *name*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *sqlite, pg*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *sqlite*  
    **database** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of database  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, dbname, *name*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *$GISDBASE/$LOCATION_NAME/$MAPSET/tgis/sqlite.db*  
    **flags** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *p*, *c*, *d*, *g*  
    &nbsp;&nbsp;&nbsp;&nbsp;**p**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Print current connection parameters and exit  
    &nbsp;&nbsp;&nbsp;&nbsp;**c**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Check connection parameters, set if uninitialized, and exit  
    &nbsp;&nbsp;&nbsp;&nbsp;**d**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Set from default settings and exit  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Overwrite current settings if initialized  
    &nbsp;&nbsp;&nbsp;&nbsp;**g**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Print current connection parameter in shell style and exit  
    **verbose** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **quiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **superquiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  

=== "Python (grass.tools)"

    **driver** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of database driver  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, dbdriver, *name*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *sqlite, pg*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *sqlite*  
    **database** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of database  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, dbname, *name*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *$GISDBASE/$LOCATION_NAME/$MAPSET/tgis/sqlite.db*  
    **flags** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *p*, *c*, *d*, *g*  
    &nbsp;&nbsp;&nbsp;&nbsp;**p**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Print current connection parameters and exit  
    &nbsp;&nbsp;&nbsp;&nbsp;**c**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Check connection parameters, set if uninitialized, and exit  
    &nbsp;&nbsp;&nbsp;&nbsp;**d**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Set from default settings and exit  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Overwrite current settings if initialized  
    &nbsp;&nbsp;&nbsp;&nbsp;**g**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Print current connection parameter in shell style and exit  
    **verbose** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **quiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **superquiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  

    Returns:

    **result** : grass.tools.support.ToolResult | None  
    If the tool produces text as standard output, a *ToolResult* object will be returned. Otherwise, `None` will be returned.

    Raises:

    *grass.tools.ToolError*: When the tool ended with an error.

## DESCRIPTION

*t.connect* allows the user to set the temporal database connection. The
default setting is that the temporal database of type *sqlite3* is
located in the current mapset directory.

The **-p** flag will display the current temporal database connection
parameters.

The **-pg** flag will display the current temporal database connection
parameters using shell style.

The **-c** flag will silently check if the temporal database connection
parameters have been set, and if not will set them to use GRASS's
default values.

## NOTES

Setting the connection with *t.connect* will not test the connection for
validity. Hence a database connection will not be established.

The connection values are stored in the mapset's `VAR` file. The **-d**
flag will set the default TGIS connection parameters. A SQLite database
"tgis/sqlite.db" will be created in the current mapset directory. It
will be located in the "tgis" sub-directory to not interfere with the
*sqlite3* database used for vector attribute storage.

In case you have tens of thousands of maps to register in the temporal
database or you need concurrent read and write access in the temporal
database, consider to use a PostgreSQL connection instead.

Be aware that you have to set the PostgreSQL connection explicitly in
every mapset that should store temporal information in the temporal
database.

PostgreSQL and SQLite databases can not be mixed in a project.

## EXAMPLES

### SQLite

The SQLite database is created automatically when used the first time.

```sh
# use single quotes here
t.connect driver=sqlite database='$GISDBASE/$LOCATION_NAME/PERMANENT/tgis/sqlite.db'
t.connect -p
t.info -s
```

### PostgreSQL

When using a PostgreSQL database, the user will need to specify the TGIS
database connection for each mapset.

```sh
t.connect driver=pg database="dbname=grass_test user=soeren password=abcdefgh"
t.connect -p
t.info -s
```

## AUTHOR

Soeren Gebbert, Thünen Institute of Climate-Smart Agriculture

## SOURCE CODE

Available at: [t.connect source code](https://github.com/OSGeo/grass/tree/main/temporal/t.connect)
([history](https://github.com/OSGeo/grass/commits/main/temporal/t.connect))  
Latest change: Saturday Apr 19 17:44:03 2025 in commit [24d7441](https://github.com/OSGeo/grass/commit/24d74415758cba0ffef1c1b6f75e21dd5d2a2993)
