---
name: t.rast3d.univar.py
description: Calculates univariate statistics from the non-null cells for each registered 3D raster map of a space time 3D raster dataset.
keywords: [ temporal, statistics, raster3d, voxel, time, parallel ]
---

# t.rast3d.univar.py

Calculates univariate statistics from the non-null cells for each registered 3D raster map of a space time 3D raster dataset.

=== "Command line"

    **t.rast3d.univar.py**
    [**-es**]
    **input**=*name*
    [**zones**=*name*]
    [**nprocs**=*integer*]
    [**output**=*name*]
    [**where**=*sql_query*]
    [**separator**=*character*]
    [**--overwrite**]
    [**--verbose**]
    [**--quiet**]
    [**--qq**]
    [**--ui**]

    Example:

    ```sh
    t.rast3d.univar.py input=name
    ```

=== "Python (grass.script)"

    *grass.script.run_command*("***t.rast3d.univar.py***",
        **input**,
        **zones**=*None*,
        **nprocs**=*0*,
        **output**=*None*,
        **where**=*None*,
        **separator**=*"pipe"*,
        **flags**=*None*,
        **overwrite**=*None*,
        **verbose**=*None*,
        **quiet**=*None*,
        **superquiet**=*None*)

    Example:

    ```python
    gs.run_command("t.rast3d.univar.py", input="name")
    ```

=== "Python (grass.tools)"

    *grass.tools.Tools.t_rast3d_univar_py*(**input**,
        **zones**=*None*,
        **nprocs**=*0*,
        **output**=*None*,
        **where**=*None*,
        **separator**=*"pipe"*,
        **flags**=*None*,
        **overwrite**=*None*,
        **verbose**=*None*,
        **quiet**=*None*,
        **superquiet**=*None*)

    Example:

    ```python
    tools = Tools()
    tools.t_rast3d_univar_py(input="name")
    ```

    This grass.tools API is experimental in version 8.5 and expected to be stable in version 8.6.

## Parameters

=== "Command line"

    **input**=*name* **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of the input space time raster3d dataset  
    **zones**=*name*  
    &nbsp;&nbsp;&nbsp;&nbsp;Raster map with zones to compute statistics for  
    &nbsp;&nbsp;&nbsp;&nbsp;Raster map with zones to compute statistics for (needs to be CELL)  
    **nprocs**=*integer*  
    &nbsp;&nbsp;&nbsp;&nbsp;Number of threads for parallel computing  
    &nbsp;&nbsp;&nbsp;&nbsp;0: use OpenMP default; &gt;0: use nprocs; &lt;0: use MAX-nprocs  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *0*  
    **output**=*name*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name for output file  
    **where**=*sql_query*  
    &nbsp;&nbsp;&nbsp;&nbsp;WHERE conditions of SQL statement without 'where' keyword used in the temporal GIS framework  
    &nbsp;&nbsp;&nbsp;&nbsp;Example: start_time &gt; '2001-01-01 12:30:00'  
    **separator**=*character*  
    &nbsp;&nbsp;&nbsp;&nbsp;Field separator character between the output columns  
    &nbsp;&nbsp;&nbsp;&nbsp;Special characters: pipe, comma, space, tab, newline  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *pipe*  
    **-e**  
    &nbsp;&nbsp;&nbsp;&nbsp;Calculate extended statistics  
    **-s**  
    &nbsp;&nbsp;&nbsp;&nbsp;Suppress printing of column names  
    **--overwrite**  
    &nbsp;&nbsp;&nbsp;&nbsp;Allow output files to overwrite existing files  
    **--help**  
    &nbsp;&nbsp;&nbsp;&nbsp;Print usage summary  
    **--verbose**  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    **--quiet**  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    **--qq**  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    **--ui**  
    &nbsp;&nbsp;&nbsp;&nbsp;Force launching GUI dialog

=== "Python (grass.script)"

    **input** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of the input space time raster3d dataset  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, str3ds, *name*  
    **zones** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Raster map with zones to compute statistics for  
    &nbsp;&nbsp;&nbsp;&nbsp;Raster map with zones to compute statistics for (needs to be CELL)  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, raster, *name*  
    **nprocs** : int, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Number of threads for parallel computing  
    &nbsp;&nbsp;&nbsp;&nbsp;0: use OpenMP default; &gt;0: use nprocs; &lt;0: use MAX-nprocs  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *0*  
    **output** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name for output file  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: output, file, *name*  
    **where** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;WHERE conditions of SQL statement without 'where' keyword used in the temporal GIS framework  
    &nbsp;&nbsp;&nbsp;&nbsp;Example: start_time &gt; '2001-01-01 12:30:00'  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: *sql_query*  
    **separator** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Field separator character between the output columns  
    &nbsp;&nbsp;&nbsp;&nbsp;Special characters: pipe, comma, space, tab, newline  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, separator, *character*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *pipe*  
    **flags** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *e*, *s*  
    &nbsp;&nbsp;&nbsp;&nbsp;**e**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Calculate extended statistics  
    &nbsp;&nbsp;&nbsp;&nbsp;**s**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Suppress printing of column names  
    **overwrite** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allow output files to overwrite existing files  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **verbose** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **quiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **superquiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  

=== "Python (grass.tools)"

    **input** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of the input space time raster3d dataset  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, str3ds, *name*  
    **zones** : str | np.ndarray, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Raster map with zones to compute statistics for  
    &nbsp;&nbsp;&nbsp;&nbsp;Raster map with zones to compute statistics for (needs to be CELL)  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, raster, *name*  
    **nprocs** : int, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Number of threads for parallel computing  
    &nbsp;&nbsp;&nbsp;&nbsp;0: use OpenMP default; &gt;0: use nprocs; &lt;0: use MAX-nprocs  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *0*  
    **output** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name for output file  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: output, file, *name*  
    **where** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;WHERE conditions of SQL statement without 'where' keyword used in the temporal GIS framework  
    &nbsp;&nbsp;&nbsp;&nbsp;Example: start_time &gt; '2001-01-01 12:30:00'  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: *sql_query*  
    **separator** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Field separator character between the output columns  
    &nbsp;&nbsp;&nbsp;&nbsp;Special characters: pipe, comma, space, tab, newline  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, separator, *character*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *pipe*  
    **flags** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *e*, *s*  
    &nbsp;&nbsp;&nbsp;&nbsp;**e**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Calculate extended statistics  
    &nbsp;&nbsp;&nbsp;&nbsp;**s**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Suppress printing of column names  
    **overwrite** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allow output files to overwrite existing files  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **verbose** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **quiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **superquiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  

    Returns:

    **result** : grass.tools.support.ToolResult | None  
    If the tool produces text as standard output, a *ToolResult* object will be returned. Otherwise, `None` will be returned.

    Raises:

    *grass.tools.ToolError*: When the tool ended with an error.

## DESCRIPTION

*t.rast3d.univar* provides the same functionality as
[t.rast.univar](t.rast.univar.md), the only difference is the 3D raster
map layer metadata. Please refer to the manual page of
[t.rast.univar](t.rast.univar.md) for documentation and examples.

## SEE ALSO

*[t.rast.univar](t.rast.univar.md), [t.create](t.create.md),
[t.info](t.info.md)*

## AUTHOR

Sören Gebbert, Thünen Institute of Climate-Smart Agriculture  
Stefan Blumentrath (support for zones)

## SOURCE CODE

Available at: [t.rast3d.univar source code](https://github.com/OSGeo/grass/tree/main/temporal/t.rast3d.univar)
([history](https://github.com/OSGeo/grass/commits/main/temporal/t.rast3d.univar))  
Latest change: Thursday Jun 26 10:38:43 2025 in commit [a7bb103](https://github.com/OSGeo/grass/commit/a7bb103537dc5179757a05844431d87018688326)
