---
name: v.build
description: Creates topology for vector map. Optionally also checks for topological errors.
keywords: [ vector, topology, geometry ]
---

# v.build

Creates topology for vector map.

Optionally also checks for topological errors.

=== "Command line"

    **v.build**
    [**-e**]
    **map**=*name*
    [**error**=*name*]
    **option**=*string* [,*string*,...]
    [**--overwrite**]
    [**--verbose**]
    [**--quiet**]
    [**--qq**]
    [**--ui**]

    Example:

    ```sh
    v.build map=name option=build
    ```

=== "Python (grass.script)"

    *grass.script.run_command*("***v.build***",
        **map**,
        **error**=*None*,
        **option**=*"build"*,
        **flags**=*None*,
        **overwrite**=*None*,
        **verbose**=*None*,
        **quiet**=*None*,
        **superquiet**=*None*)

    Example:

    ```python
    gs.run_command("v.build", map="name", option="build")
    ```

=== "Python (grass.tools)"

    *grass.tools.Tools.v_build*(**map**,
        **error**=*None*,
        **option**=*"build"*,
        **flags**=*None*,
        **overwrite**=*None*,
        **verbose**=*None*,
        **quiet**=*None*,
        **superquiet**=*None*)

    Example:

    ```python
    tools = Tools()
    tools.v_build(map="name", option="build")
    ```

    This grass.tools API is experimental in version 8.5 and expected to be stable in version 8.6.

## Parameters

=== "Command line"

    **map**=*name* **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of vector map  
    **error**=*name*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name for output vector map where erroneous vector features are written to  
    **option**=*string* [,*string*,...] **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;Build topology or dump topology or indices to standard output  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *build, dump, sdump, cdump, fdump*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *build*  
    &nbsp;&nbsp;&nbsp;&nbsp;**build**: build topology  
    &nbsp;&nbsp;&nbsp;&nbsp;**dump**: write topology to stdout  
    &nbsp;&nbsp;&nbsp;&nbsp;**sdump**: write spatial index to stdout  
    &nbsp;&nbsp;&nbsp;&nbsp;**cdump**: write category index to stdout  
    &nbsp;&nbsp;&nbsp;&nbsp;**fdump**: write feature index to stdout (OGR simple-feature-based formats only)  
    **-e**  
    &nbsp;&nbsp;&nbsp;&nbsp;Extensive checks for topological errors  
    &nbsp;&nbsp;&nbsp;&nbsp;Perform in-depth checks for topological errors when building topology  
    **--overwrite**  
    &nbsp;&nbsp;&nbsp;&nbsp;Allow output files to overwrite existing files  
    **--help**  
    &nbsp;&nbsp;&nbsp;&nbsp;Print usage summary  
    **--verbose**  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    **--quiet**  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    **--qq**  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    **--ui**  
    &nbsp;&nbsp;&nbsp;&nbsp;Force launching GUI dialog

=== "Python (grass.script)"

    **map** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of vector map  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, vector, *name*  
    **error** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name for output vector map where erroneous vector features are written to  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: output, vector, *name*  
    **option** : str | list[str], *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Build topology or dump topology or indices to standard output  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *build, dump, sdump, cdump, fdump*  
    &nbsp;&nbsp;&nbsp;&nbsp;**build**: build topology  
    &nbsp;&nbsp;&nbsp;&nbsp;**dump**: write topology to stdout  
    &nbsp;&nbsp;&nbsp;&nbsp;**sdump**: write spatial index to stdout  
    &nbsp;&nbsp;&nbsp;&nbsp;**cdump**: write category index to stdout  
    &nbsp;&nbsp;&nbsp;&nbsp;**fdump**: write feature index to stdout (OGR simple-feature-based formats only)  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *build*  
    **flags** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *e*  
    &nbsp;&nbsp;&nbsp;&nbsp;**e**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Extensive checks for topological errors  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Perform in-depth checks for topological errors when building topology  
    **overwrite** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allow output files to overwrite existing files  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **verbose** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **quiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **superquiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  

=== "Python (grass.tools)"

    **map** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of vector map  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, vector, *name*  
    **error** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name for output vector map where erroneous vector features are written to  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: output, vector, *name*  
    **option** : str | list[str], *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Build topology or dump topology or indices to standard output  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *build, dump, sdump, cdump, fdump*  
    &nbsp;&nbsp;&nbsp;&nbsp;**build**: build topology  
    &nbsp;&nbsp;&nbsp;&nbsp;**dump**: write topology to stdout  
    &nbsp;&nbsp;&nbsp;&nbsp;**sdump**: write spatial index to stdout  
    &nbsp;&nbsp;&nbsp;&nbsp;**cdump**: write category index to stdout  
    &nbsp;&nbsp;&nbsp;&nbsp;**fdump**: write feature index to stdout (OGR simple-feature-based formats only)  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *build*  
    **flags** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *e*  
    &nbsp;&nbsp;&nbsp;&nbsp;**e**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Extensive checks for topological errors  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Perform in-depth checks for topological errors when building topology  
    **overwrite** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allow output files to overwrite existing files  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **verbose** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **quiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **superquiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  

    Returns:

    **result** : grass.tools.support.ToolResult | None  
    If the tool produces text as standard output, a *ToolResult* object will be returned. Otherwise, `None` will be returned.

    Raises:

    *grass.tools.ToolError*: When the tool ended with an error.

## DESCRIPTION

*v.build* builds support files for GRASS vector maps. These support
files supply topology and category information including spatial index
that are needed by other GRASS modules.

GRASS is generating these support files automatically, only in rare
cases the user has to (re)build them.

Refer to [vector data processing in GRASS](vectorintro.md) for more
information on GRASS vector data model.

## NOTES

*v.build* creates support files only for vector maps located in the
user's current mapset. It's not possible to rebuild support files
(**option=build**) for vector maps from other mapsets.

In case of errors, the user can optionally generate an **error** vector
map containing the erroneous vectors for later inspection.

If **error** vector map is specified, *v.build* checks:

- isolated boundaries (which are not forming any areas),
- centroids outside of area,
- duplicated centroids.

Extensive checks for topological errors (flag **-e**) also includes:

- lines or boundaries of zero length,
- intersecting boundaries, i.e. overlapping areas,
- areas without centroids that are not isles.

## EXAMPLES

### Build topology

Note that **option=build** also recreates spatial and category indices,
not only topology. For linked OGR layers (see
*[v.external](v.external.md)*) also feature index is created.

```sh
v.build map=urbanarea option=build
```

Note that the vector map *urbanarea* must be located in the current
mapset.

### Dump topology or indices

Dump options print topology, spatial, category or feature index to
standard output. Such information can also be printed for vector maps
from other mapsets. A description of the vector topology is available in
the [GRASS 8 Programmer's
Manual](https://grass.osgeo.org/programming8/vlibTopology.html), section
"Vector library topology management".

```sh
v.build map=urbanarea option=dump
```

## SEE ALSO

*[v.build.all](v.build.all.md),
[v.build.polylines](v.build.polylines.md), [v.edit](v.edit.md),
[v.split](v.split.md), [v.support](v.support.md)*

See also *[wxGUI vector digitizer](wxGUI.vdigit.md)*.

## AUTHORS

Dave Gerdes, U.S.Army Construction Engineering Research Laboratory,  
Michael Higgins, U.S.Army Construction Engineering Research
Laboratory,  
Radim Blazek, ITC-irst, Trento, Italy

## SOURCE CODE

Available at: [v.build source code](https://github.com/OSGeo/grass/tree/main/vector/v.build)
([history](https://github.com/OSGeo/grass/commits/main/vector/v.build))  
Latest change: Friday Aug 08 09:39:19 2025 in commit [ed72c71](https://github.com/OSGeo/grass/commit/ed72c71d8580e872cd6fd345c84a15c324764465)
