---
name: v.db.univar.py
description: Calculates univariate statistics on selected table column for a GRASS vector map.
keywords: [ vector, statistics, attribute table ]
---

# v.db.univar.py

Calculates univariate statistics on selected table column for a GRASS vector map.

=== "Command line"

    **v.db.univar.py**
    [**-eg**]
    **map**=*name*
    [**layer**=*string*]
    **column**=*name*
    [**where**=*sql_query*]
    [**percentile**=*float* [,*float*,...]]
    [**format**=*string*]
    [**--verbose**]
    [**--quiet**]
    [**--qq**]
    [**--ui**]

    Example:

    ```sh
    v.db.univar.py map=name column=name
    ```

=== "Python (grass.script)"

    *grass.script.parse_command*("***v.db.univar.py***",
        **map**,
        **layer**=*"1"*,
        **column**,
        **where**=*None*,
        **percentile**=*90*,
        **format**=*None*,
        **flags**=*None*,
        **verbose**=*None*,
        **quiet**=*None*,
        **superquiet**=*None*)

    Example:

    ```python
    gs.parse_command("v.db.univar.py", map="name", column="name", format="json")
    ```

=== "Python (grass.tools)"

    *grass.tools.Tools.v_db_univar_py*(**map**,
        **layer**=*"1"*,
        **column**,
        **where**=*None*,
        **percentile**=*90*,
        **format**=*None*,
        **flags**=*None*,
        **verbose**=*None*,
        **quiet**=*None*,
        **superquiet**=*None*)

    Example:

    ```python
    tools = Tools()
    tools.v_db_univar_py(map="name", column="name", format="json")
    ```

    This grass.tools API is experimental in version 8.5 and expected to be stable in version 8.6.

## Parameters

=== "Command line"

    **map**=*name* **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of vector map  
    &nbsp;&nbsp;&nbsp;&nbsp;Or data source for direct OGR access  
    **layer**=*string*  
    &nbsp;&nbsp;&nbsp;&nbsp;Layer number or name  
    &nbsp;&nbsp;&nbsp;&nbsp;Vector features can have category values in different layers. This number determines which layer to use. When used with direct OGR access this is the layer name.  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *1*  
    **column**=*name* **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of attribute column on which to calculate statistics (must be numeric)  
    **where**=*sql_query*  
    &nbsp;&nbsp;&nbsp;&nbsp;WHERE conditions of SQL statement without 'where' keyword  
    &nbsp;&nbsp;&nbsp;&nbsp;Example: income &lt; 1000 and population &gt;= 10000  
    **percentile**=*float* [,*float*,...]  
    &nbsp;&nbsp;&nbsp;&nbsp;Percentile to calculate (requires extended statistics flag)  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *0-100*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *90*  
    **format**=*string*  
    &nbsp;&nbsp;&nbsp;&nbsp;Output format  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *plain, json, shell*  
    &nbsp;&nbsp;&nbsp;&nbsp;**plain**: Plain text output  
    &nbsp;&nbsp;&nbsp;&nbsp;**json**: JSON (JavaScript Object Notation)  
    &nbsp;&nbsp;&nbsp;&nbsp;**shell**: Shell script style for Bash eval  
    **-e**  
    &nbsp;&nbsp;&nbsp;&nbsp;Extended statistics (quartiles and 90th percentile)  
    **-g**  
    &nbsp;&nbsp;&nbsp;&nbsp;Print stats in shell script style [deprecated]  
    &nbsp;&nbsp;&nbsp;&nbsp;This flag is deprecated and will be removed in a future release. Use format=shell instead.  
    **--help**  
    &nbsp;&nbsp;&nbsp;&nbsp;Print usage summary  
    **--verbose**  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    **--quiet**  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    **--qq**  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    **--ui**  
    &nbsp;&nbsp;&nbsp;&nbsp;Force launching GUI dialog

=== "Python (grass.script)"

    **map** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of vector map  
    &nbsp;&nbsp;&nbsp;&nbsp;Or data source for direct OGR access  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, vector, *name*  
    **layer** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Layer number or name  
    &nbsp;&nbsp;&nbsp;&nbsp;Vector features can have category values in different layers. This number determines which layer to use. When used with direct OGR access this is the layer name.  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, layer  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *1*  
    **column** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of attribute column on which to calculate statistics (must be numeric)  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, dbcolumn, *name*  
    **where** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;WHERE conditions of SQL statement without 'where' keyword  
    &nbsp;&nbsp;&nbsp;&nbsp;Example: income &lt; 1000 and population &gt;= 10000  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, sql_query, *sql_query*  
    **percentile** : float | list[float] | str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Percentile to calculate (requires extended statistics flag)  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *0-100*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *90*  
    **format** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Output format  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *plain, json, shell*  
    &nbsp;&nbsp;&nbsp;&nbsp;**plain**: Plain text output  
    &nbsp;&nbsp;&nbsp;&nbsp;**json**: JSON (JavaScript Object Notation)  
    &nbsp;&nbsp;&nbsp;&nbsp;**shell**: Shell script style for Bash eval  
    **flags** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *e*, *g*  
    &nbsp;&nbsp;&nbsp;&nbsp;**e**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Extended statistics (quartiles and 90th percentile)  
    &nbsp;&nbsp;&nbsp;&nbsp;**g**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Print stats in shell script style [deprecated]  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;This flag is deprecated and will be removed in a future release. Use format=shell instead.  
    **verbose** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **quiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **superquiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  

=== "Python (grass.tools)"

    **map** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of vector map  
    &nbsp;&nbsp;&nbsp;&nbsp;Or data source for direct OGR access  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, vector, *name*  
    **layer** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Layer number or name  
    &nbsp;&nbsp;&nbsp;&nbsp;Vector features can have category values in different layers. This number determines which layer to use. When used with direct OGR access this is the layer name.  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, layer  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *1*  
    **column** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of attribute column on which to calculate statistics (must be numeric)  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, dbcolumn, *name*  
    **where** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;WHERE conditions of SQL statement without 'where' keyword  
    &nbsp;&nbsp;&nbsp;&nbsp;Example: income &lt; 1000 and population &gt;= 10000  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, sql_query, *sql_query*  
    **percentile** : float | list[float] | str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Percentile to calculate (requires extended statistics flag)  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *0-100*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *90*  
    **format** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Output format  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *plain, json, shell*  
    &nbsp;&nbsp;&nbsp;&nbsp;**plain**: Plain text output  
    &nbsp;&nbsp;&nbsp;&nbsp;**json**: JSON (JavaScript Object Notation)  
    &nbsp;&nbsp;&nbsp;&nbsp;**shell**: Shell script style for Bash eval  
    **flags** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *e*, *g*  
    &nbsp;&nbsp;&nbsp;&nbsp;**e**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Extended statistics (quartiles and 90th percentile)  
    &nbsp;&nbsp;&nbsp;&nbsp;**g**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Print stats in shell script style [deprecated]  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;This flag is deprecated and will be removed in a future release. Use format=shell instead.  
    **verbose** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **quiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **superquiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  

    Returns:

    **result** : grass.tools.support.ToolResult | None  
    If the tool produces text as standard output, a *ToolResult* object will be returned. Otherwise, `None` will be returned.

    Raises:

    *grass.tools.ToolError*: When the tool ended with an error.

## DESCRIPTION

*v.db.univar* calculates basic univariate statistics for numeric
attributes in a vector attribute table. It will calculate minimum,
maximum, range, mean, standard deviation, variance, coefficient of
variation, quartiles, median, and 90th percentile.

*v.db.univar* uses *db.univar* which in turn uses *db.select* to get the
attribute values on which it calculates the statistics. This means that
statistics are calculated based on the entries in the attribute table,
not based on the features in the map. One attribute value is read from
each line in the attribute table, whether there are no, one or several
features with the category value referenced by that line, or whether any
features have more than one category value. For feature-based, instead
of attribute table-based, univariate statistics on attributes see
[v.univar](v.univar.md).

## NOTES

A database connection must be defined for the selected vector layer.

## EXAMPLES

### Univariate statistics on attribute table column

In this example, the 30 years precipitation data table is statistically
analysed (North Carolina sample dataset) and univariate statistics
performed:

```sh
# show columns of attribute table connected to precipitation map
v.info -c precip_30ynormals

# univariate statistics on 30 years annual precipitation in NC
v.db.univar precip_30ynormals column=annual
 Number of values: 136
 Minimum: 947.42
 Maximum: 2329.18
 Range: 1381.76
 Mean: 1289.31147058823
 [...]
```

### Univariate statistics on randomly sampled data points

In this example, random points are sampled from the elevation map (North
Carolina sample dataset) and univariate statistics performed:

```sh
g.region raster=elevation -p
v.random output=samples n=100
v.db.addtable samples column="heights double precision"
v.what.rast samples raster=elevation column=heights
v.db.select samples

v.db.univar samples column=heights
```

### Python example with JSON output

Using the example above, print the 90th percentile in Python:

```python
import grass.script as gs

data = gs.parse_command(
    "v.db.univar", table="samples", column="heights", format="json", flags="e"
)
print(data["percentiles"])
```

Output:

```text
[{'percentile': 90.0, 'value': 139.0807}]
```

The JSON will look like this:

```json
{
    "n": 100,
    "min": 62.71209,
    "max": 147.2162,
    "range": 84.50410999999998,
    "mean": 110.95470289999996,
    "mean_abs": 110.95470289999996,
    "variance": 362.63393287085927,
    "stddev": 19.042949689343278,
    "coeff_var": 0.17162814366242862,
    "sum": 11095.470289999996,
    "first_quartile": 95.56498,
    "median": 107.5519,
    "third_quartile": 125.1526,
    "percentiles": [
        {
            "percentile": 90.0,
            "value": 139.0807
        }
    ]
}
```

## SEE ALSO

*[db.univar](db.univar.md), [r.univar](r.univar.md),
[v.univar](v.univar.md), [db.select](db.select.md),
[d.vect.thematic](d.vect.thematic.md), [v.random](v.random.md)*

*[GRASS SQL interface](sql.md)*

## AUTHORS

Michael Barton, Arizona State University

and authors of *r.univar.sh* (Markus Neteler et al.)

## SOURCE CODE

Available at: [v.db.univar source code](https://github.com/OSGeo/grass/tree/main/scripts/v.db.univar)
([history](https://github.com/OSGeo/grass/commits/main/scripts/v.db.univar))  
Latest change: Sunday Jul 20 17:11:04 2025 in commit [80eaa84](https://github.com/OSGeo/grass/commit/80eaa846323b1de2441fb08f84ba53d6cfc61ba6)
