---
name: v.outlier
description: Removes outliers from vector point data.
keywords: [ vector, statistics, extract, select, filter, LIDAR ]
---

# v.outlier

Removes outliers from vector point data.

=== "Command line"

    **v.outlier**
    [**-e**]
    **input**=*name*
    **output**=*name*
    **outlier**=*name*
    [**qgis**=*name*]
    [**ew_step**=*float*]
    [**ns_step**=*float*]
    [**lambda**=*float*]
    [**threshold**=*float*]
    [**filter**=*string*]
    [**--overwrite**]
    [**--verbose**]
    [**--quiet**]
    [**--qq**]
    [**--ui**]

    Example:

    ```sh
    v.outlier input=name output=name outlier=name
    ```

=== "Python (grass.script)"

    *grass.script.run_command*("***v.outlier***",
        **input**,
        **output**,
        **outlier**,
        **qgis**=*None*,
        **ew_step**=*None*,
        **ns_step**=*None*,
        **lambda**=*0.1*,
        **threshold**=*50*,
        **filter**=*"both"*,
        **flags**=*None*,
        **overwrite**=*None*,
        **verbose**=*None*,
        **quiet**=*None*,
        **superquiet**=*None*)

    Example:

    ```python
    gs.run_command("v.outlier", input="name", output="name", outlier="name")
    ```

=== "Python (grass.tools)"

    *grass.tools.Tools.v_outlier*(**input**,
        **output**,
        **outlier**,
        **qgis**=*None*,
        **ew_step**=*None*,
        **ns_step**=*None*,
        **lambda**=*0.1*,
        **threshold**=*50*,
        **filter**=*"both"*,
        **flags**=*None*,
        **overwrite**=*None*,
        **verbose**=*None*,
        **quiet**=*None*,
        **superquiet**=*None*)

    Example:

    ```python
    tools = Tools()
    tools.v_outlier(input="name", output="name", outlier="name")
    ```

    This grass.tools API is experimental in version 8.5 and expected to be stable in version 8.6.

## Parameters

=== "Command line"

    **input**=*name* **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of input vector map  
    &nbsp;&nbsp;&nbsp;&nbsp;Or data source for direct OGR access  
    **output**=*name* **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;Name for output vector map  
    **outlier**=*name* **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;Name for output outlier vector map  
    **qgis**=*name*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name for vector map for visualization in QGIS  
    **ew_step**=*float*  
    &nbsp;&nbsp;&nbsp;&nbsp;Length of each spline step in the east-west direction  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: 10 \* east-west resolution  
    **ns_step**=*float*  
    &nbsp;&nbsp;&nbsp;&nbsp;Length of each spline step in the north-south direction  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: 10 \* north-south resolution  
    **lambda**=*float*  
    &nbsp;&nbsp;&nbsp;&nbsp;Tykhonov regularization weight  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *0.1*  
    **threshold**=*float*  
    &nbsp;&nbsp;&nbsp;&nbsp;Threshold for the outliers  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *50*  
    **filter**=*string*  
    &nbsp;&nbsp;&nbsp;&nbsp;Filtering option  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *both, positive, negative*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *both*  
    **-e**  
    &nbsp;&nbsp;&nbsp;&nbsp;Estimate point density and distance  
    &nbsp;&nbsp;&nbsp;&nbsp;Estimate point density and distance for the input vector points within the current region extends and quit  
    **--overwrite**  
    &nbsp;&nbsp;&nbsp;&nbsp;Allow output files to overwrite existing files  
    **--help**  
    &nbsp;&nbsp;&nbsp;&nbsp;Print usage summary  
    **--verbose**  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    **--quiet**  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    **--qq**  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    **--ui**  
    &nbsp;&nbsp;&nbsp;&nbsp;Force launching GUI dialog

=== "Python (grass.script)"

    **input** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of input vector map  
    &nbsp;&nbsp;&nbsp;&nbsp;Or data source for direct OGR access  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, vector, *name*  
    **output** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name for output vector map  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: output, vector, *name*  
    **outlier** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name for output outlier vector map  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: output, vector, *name*  
    **qgis** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name for vector map for visualization in QGIS  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: output, vector, *name*  
    **ew_step** : float, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Length of each spline step in the east-west direction  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: 10 \* east-west resolution  
    **ns_step** : float, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Length of each spline step in the north-south direction  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: 10 \* north-south resolution  
    **lambda** : float, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Tykhonov regularization weight  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *0.1*  
    **threshold** : float, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Threshold for the outliers  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *50*  
    **filter** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Filtering option  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *both, positive, negative*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *both*  
    **flags** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *e*  
    &nbsp;&nbsp;&nbsp;&nbsp;**e**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Estimate point density and distance  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Estimate point density and distance for the input vector points within the current region extends and quit  
    **overwrite** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allow output files to overwrite existing files  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **verbose** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **quiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **superquiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  

=== "Python (grass.tools)"

    **input** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of input vector map  
    &nbsp;&nbsp;&nbsp;&nbsp;Or data source for direct OGR access  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, vector, *name*  
    **output** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name for output vector map  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: output, vector, *name*  
    **outlier** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name for output outlier vector map  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: output, vector, *name*  
    **qgis** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name for vector map for visualization in QGIS  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: output, vector, *name*  
    **ew_step** : float, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Length of each spline step in the east-west direction  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: 10 \* east-west resolution  
    **ns_step** : float, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Length of each spline step in the north-south direction  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: 10 \* north-south resolution  
    **lambda** : float, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Tykhonov regularization weight  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *0.1*  
    **threshold** : float, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Threshold for the outliers  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *50*  
    **filter** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Filtering option  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *both, positive, negative*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *both*  
    **flags** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *e*  
    &nbsp;&nbsp;&nbsp;&nbsp;**e**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Estimate point density and distance  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Estimate point density and distance for the input vector points within the current region extends and quit  
    **overwrite** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allow output files to overwrite existing files  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **verbose** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **quiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **superquiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  

    Returns:

    **result** : grass.tools.support.ToolResult | None  
    If the tool produces text as standard output, a *ToolResult* object will be returned. Otherwise, `None` will be returned.

    Raises:

    *grass.tools.ToolError*: When the tool ended with an error.

## DESCRIPTION

*v.outlier* removes outliers in a 3D point cloud. By default, the
outlier identification is done by a bicubic spline interpolation of the
observation with a high regularization parameter and a low resolution in
south-north and east-west directions. Those points that differ in an
absolute value more than the given threshold from a fixed value,
reckoned from its surroundings by the interpolation, are considered as
an outlier, and hence are removed.

The *filter* option specifies if all outliers will be removed (default),
or only positive or only negative outliers. Filtering out only positive
outliers can be useful to filter out vegetation returns (e.g. from
forest canopies) from LIDAR point clouds, in order to extract digital
terrain models (DTMs). Filtering out only negative outliers can be
useful to estimate vegetation height.

There is a flag to create a vector that can be visualized in QGIS. That
means that topology is built and the z coordinate is considered as a
category.

## EXAMPLES

### Basic outlier removal

In this case, a basic outlier removal is done with a threshold of 25 m:

```sh
v.outlier input=vector_map output=vector_output outlier=vector_outlier thres_O=25
```

Now, the outlier removal uses the default threshold and there is also an
output vector available for visualization in QGIS:

```sh
v.outlier input=vector_map output=vector_output outlier=vector_outlier qgis=vector_qgis
```

### North Carolina dataset example

```sh
v.outlier input=elev_lid792_bepts output=elev_lid792_bepts_nooutliers \
  outlier=elev_lid792_bepts_outliers ew_step=5 ns_step=5 thres_o=0.1
```

## NOTES

This module is designed to work with LIDAR data, so not topology is
built but in the QGIS output.

## SEE ALSO

*[v.surf.bspline](v.surf.bspline.md)*

## AUTHORS

Original version of the program in GRASS 5.4:  
Maria Antonia Brovelli, Massimiliano Cannata, Ulisse Longoni and Mirko
Reguzzoni  
  
Updates for GRASS 6:  
Roberto Antolin

## SOURCE CODE

Available at: [v.outlier source code](https://github.com/OSGeo/grass/tree/main/vector/v.outlier)
([history](https://github.com/OSGeo/grass/commits/main/vector/v.outlier))  
Latest change: Friday May 09 14:33:40 2025 in commit [b356c7e](https://github.com/OSGeo/grass/commit/b356c7e108fcbeca77474c8e83ebec8f1e7b3e4a)
