---
name: g.extension.all.py
description: Rebuilds or removes all locally installed GRASS Addons extensions. By default only extensions built against different GIS Library are rebuilt.
keywords: [ general, installation, extensions ]
---

# g.extension.all.py

Rebuilds or removes all locally installed GRASS Addons extensions.

By default only extensions built against different GIS Library are rebuilt.

=== "Command line"

    **g.extension.all.py**
    [**-f**]
    [**operation**=*string*]
    [**--verbose**]
    [**--quiet**]
    [**--qq**]
    [**--ui**]

    Example:

    ```sh
    g.extension.all.py
    ```

=== "Python (grass.script)"

    *grass.script.run_command*("***g.extension.all.py***",
        **operation**=*"rebuild"*,
        **flags**=*None*,
        **verbose**=*None*,
        **quiet**=*None*,
        **superquiet**=*None*)

    Example:

    ```python
    gs.run_command("g.extension.all.py")
    ```

=== "Python (grass.tools)"

    *grass.tools.Tools.g_extension_all_py*(**operation**=*"rebuild"*,
        **flags**=*None*,
        **verbose**=*None*,
        **quiet**=*None*,
        **superquiet**=*None*)

    Example:

    ```python
    tools = Tools()
    tools.g_extension_all_py()
    ```

    This grass.tools API is experimental in version 8.5 and expected to be stable in version 8.6.

## Parameters

=== "Command line"

    **operation**=*string*  
    &nbsp;&nbsp;&nbsp;&nbsp;Operation to be performed  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *rebuild, remove*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *rebuild*  
    **-f**  
    &nbsp;&nbsp;&nbsp;&nbsp;Force operation (required for removal)  
  
    **--help**  
    &nbsp;&nbsp;&nbsp;&nbsp;Print usage summary  
    **--verbose**  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    **--quiet**  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    **--qq**  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    **--ui**  
    &nbsp;&nbsp;&nbsp;&nbsp;Force launching GUI dialog

=== "Python (grass.script)"

    **operation** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Operation to be performed  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *rebuild, remove*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *rebuild*  
    **flags** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *f*  
    &nbsp;&nbsp;&nbsp;&nbsp;**f**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Force operation (required for removal)  
  
    **verbose** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **quiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **superquiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  

=== "Python (grass.tools)"

    **operation** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Operation to be performed  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *rebuild, remove*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *rebuild*  
    **flags** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *f*  
    &nbsp;&nbsp;&nbsp;&nbsp;**f**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Force operation (required for removal)  
  
    **verbose** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **quiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **superquiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  

    Returns:

    **result** : grass.tools.support.ToolResult | None  
    If the tool produces text as standard output, a *ToolResult* object will be returned. Otherwise, `None` will be returned.

    Raises:

    *grass.tools.ToolError*: When the tool ended with an error.

## DESCRIPTION

*g.extension.rebuild.all* reinstalls and updates all locally installed
GRASS Addons extensions in local GRASS installation. The extensions can
be installed by *[g.extension](g.extension.md)*. List of locally
installed extensions can be printed by `g.extension -a`.

## EXAMPLES

Rebuild locally installed extensions which were built against different
GIS Library (see `g.version -r`)

```sh
g.extension.rebuild.all
```

Force to rebuild all locally installed extensions

```sh
g.extension.rebuild.all -f
```

## SEE ALSO

*[g.extension](g.extension.md)*

See also [GRASS Addons](https://grasswiki.osgeo.org/wiki/GRASS_AddOns)
wiki page.

## AUTHOR

Martin Landa, Czech Technical University in Prague, Czech Republic

## SOURCE CODE

Available at: [g.extension.all source code](https://github.com/OSGeo/grass/tree/main/scripts/g.extension.all)
([history](https://github.com/OSGeo/grass/commits/main/scripts/g.extension.all))  
Latest change: Friday Aug 08 09:39:19 2025 in commit [ed72c71](https://github.com/OSGeo/grass/commit/ed72c71d8580e872cd6fd345c84a15c324764465)
