---
name: g.gui.tplot
description: Plots the values of temporal datasets.
keywords: [ general, GUI, temporal, plot ]
description: wxGUI Temporal Plot Tool
index: topic_GUI|GUI
---

# g.gui.tplot

Plots the values of temporal datasets.

=== "Command line"

    **g.gui.tplot**
    [**-hl**]
    [**stvds**=*name* [,*name*,...]]
    [**strds**=*name* [,*name*,...]]
    [**coordinates**=*east,north*]
    [**cats**=*string*]
    [**attr**=*string*]
    [**output**=*name*]
    [**csv**=*name*]
    [**title**=*string*]
    [**xlabel**=*string*]
    [**ylabel**=*string*]
    [**size**=*string*]
    [**--overwrite**]
    [**--verbose**]
    [**--quiet**]
    [**--qq**]
    [**--ui**]

    Example:

    ```sh
    g.gui.tplot
    ```

=== "Python (grass.script)"

    *grass.script.run_command*("***g.gui.tplot***",
        **stvds**=*None*,
        **strds**=*None*,
        **coordinates**=*None*,
        **cats**=*None*,
        **attr**=*None*,
        **output**=*None*,
        **csv**=*None*,
        **title**=*None*,
        **xlabel**=*None*,
        **ylabel**=*None*,
        **size**=*None*,
        **flags**=*None*,
        **overwrite**=*None*,
        **verbose**=*None*,
        **quiet**=*None*,
        **superquiet**=*None*)

    Example:

    ```python
    gs.run_command("g.gui.tplot")
    ```

=== "Python (grass.tools)"

    *grass.tools.Tools.g_gui_tplot*(**stvds**=*None*,
        **strds**=*None*,
        **coordinates**=*None*,
        **cats**=*None*,
        **attr**=*None*,
        **output**=*None*,
        **csv**=*None*,
        **title**=*None*,
        **xlabel**=*None*,
        **ylabel**=*None*,
        **size**=*None*,
        **flags**=*None*,
        **overwrite**=*None*,
        **verbose**=*None*,
        **quiet**=*None*,
        **superquiet**=*None*)

    Example:

    ```python
    tools = Tools()
    tools.g_gui_tplot()
    ```

    This grass.tools API is experimental in version 8.5 and expected to be stable in version 8.6.

## Parameters

=== "Command line"

    **stvds**=*name* [,*name*,...]  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of the input space time vector datasets  
    **strds**=*name* [,*name*,...]  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of the input space time raster datasets  
    **coordinates**=*east,north*  
    &nbsp;&nbsp;&nbsp;&nbsp;Coordinates  
    **cats**=*string*  
    &nbsp;&nbsp;&nbsp;&nbsp;Categories of vectors features  
    &nbsp;&nbsp;&nbsp;&nbsp;To use only with stvds  
    **attr**=*string*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of attribute  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of attribute which represent data for plotting  
    **output**=*name*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name for output graphical file  
    &nbsp;&nbsp;&nbsp;&nbsp;Full path for output file containing the plot, ddd extension to specify format (.png, .pdf, .svg)  
    **csv**=*name*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name for output CSV file  
    &nbsp;&nbsp;&nbsp;&nbsp;Full path for the CSV file containing the plotted data  
    **title**=*string*  
    &nbsp;&nbsp;&nbsp;&nbsp;Title for plot  
    &nbsp;&nbsp;&nbsp;&nbsp;The title for the output plot  
    **xlabel**=*string*  
    &nbsp;&nbsp;&nbsp;&nbsp;Label for x axis  
    &nbsp;&nbsp;&nbsp;&nbsp;The x axis label for the output plot  
    **ylabel**=*string*  
    &nbsp;&nbsp;&nbsp;&nbsp;Label for y axis  
    &nbsp;&nbsp;&nbsp;&nbsp;The y axis label for the output plot  
    **size**=*string*  
    &nbsp;&nbsp;&nbsp;&nbsp;Size of output image as width,height in pixels  
    &nbsp;&nbsp;&nbsp;&nbsp;It works only with output parameter  
    **-h**  
    &nbsp;&nbsp;&nbsp;&nbsp;Set the header of CSV file, to be used with csv option  
    **-l**  
    &nbsp;&nbsp;&nbsp;&nbsp;Show simple linear regression model line  
    **--overwrite**  
    &nbsp;&nbsp;&nbsp;&nbsp;Allow output files to overwrite existing files  
    **--help**  
    &nbsp;&nbsp;&nbsp;&nbsp;Print usage summary  
    **--verbose**  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    **--quiet**  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    **--qq**  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    **--ui**  
    &nbsp;&nbsp;&nbsp;&nbsp;Force launching GUI dialog

=== "Python (grass.script)"

    **stvds** : str | list[str], *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of the input space time vector datasets  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, stvds, *name*  
    **strds** : str | list[str], *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of the input space time raster datasets  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, strds, *name*  
    **coordinates** : tuple[float, float] | list[float] | str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Coordinates  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, coords, *east,north*  
    **cats** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Categories of vectors features  
    &nbsp;&nbsp;&nbsp;&nbsp;To use only with stvds  
    **attr** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of attribute  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of attribute which represent data for plotting  
    **output** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name for output graphical file  
    &nbsp;&nbsp;&nbsp;&nbsp;Full path for output file containing the plot, ddd extension to specify format (.png, .pdf, .svg)  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: output, file, *name*  
    **csv** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name for output CSV file  
    &nbsp;&nbsp;&nbsp;&nbsp;Full path for the CSV file containing the plotted data  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: output, file, *name*  
    **title** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Title for plot  
    &nbsp;&nbsp;&nbsp;&nbsp;The title for the output plot  
    **xlabel** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Label for x axis  
    &nbsp;&nbsp;&nbsp;&nbsp;The x axis label for the output plot  
    **ylabel** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Label for y axis  
    &nbsp;&nbsp;&nbsp;&nbsp;The y axis label for the output plot  
    **size** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Size of output image as width,height in pixels  
    &nbsp;&nbsp;&nbsp;&nbsp;It works only with output parameter  
    **flags** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *h*, *l*  
    &nbsp;&nbsp;&nbsp;&nbsp;**h**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Set the header of CSV file, to be used with csv option  
    &nbsp;&nbsp;&nbsp;&nbsp;**l**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Show simple linear regression model line  
    **overwrite** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allow output files to overwrite existing files  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **verbose** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **quiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **superquiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  

=== "Python (grass.tools)"

    **stvds** : str | list[str], *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of the input space time vector datasets  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, stvds, *name*  
    **strds** : str | list[str], *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of the input space time raster datasets  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, strds, *name*  
    **coordinates** : tuple[float, float] | list[float] | str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Coordinates  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, coords, *east,north*  
    **cats** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Categories of vectors features  
    &nbsp;&nbsp;&nbsp;&nbsp;To use only with stvds  
    **attr** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of attribute  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of attribute which represent data for plotting  
    **output** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name for output graphical file  
    &nbsp;&nbsp;&nbsp;&nbsp;Full path for output file containing the plot, ddd extension to specify format (.png, .pdf, .svg)  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: output, file, *name*  
    **csv** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name for output CSV file  
    &nbsp;&nbsp;&nbsp;&nbsp;Full path for the CSV file containing the plotted data  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: output, file, *name*  
    **title** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Title for plot  
    &nbsp;&nbsp;&nbsp;&nbsp;The title for the output plot  
    **xlabel** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Label for x axis  
    &nbsp;&nbsp;&nbsp;&nbsp;The x axis label for the output plot  
    **ylabel** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Label for y axis  
    &nbsp;&nbsp;&nbsp;&nbsp;The y axis label for the output plot  
    **size** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Size of output image as width,height in pixels  
    &nbsp;&nbsp;&nbsp;&nbsp;It works only with output parameter  
    **flags** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *h*, *l*  
    &nbsp;&nbsp;&nbsp;&nbsp;**h**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Set the header of CSV file, to be used with csv option  
    &nbsp;&nbsp;&nbsp;&nbsp;**l**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Show simple linear regression model line  
    **overwrite** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allow output files to overwrite existing files  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **verbose** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **quiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **superquiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  

    Returns:

    **result** : grass.tools.support.ToolResult | None  
    If the tool produces text as standard output, a *ToolResult* object will be returned. Otherwise, `None` will be returned.

    Raises:

    *grass.tools.ToolError*: When the tool ended with an error.

# wxGUI Temporal Plot Tool

## DESCRIPTION

The **Temporal Plot Tool** is a *[wxGUI](wxGUI.md)* component that
queries and plots the values of a point, defined by a coordinate pair,
in one or more temporal datasets (strds, stvds, str3ds).

Supported features:

- temporal datasets with interval/point and absolute/relative time,

- show simple linear regression model line with calculated formula
  `y = a + b*x`  (y is dependent variable, a is intercept, b is slope,
  x is explanatory variable) and `r-squared` (parameter of goodness-of-fit
  measure for linear regression model)

- pop-up annotations with values information,

- query and plot multiple points via the command line,

- zoom and pan,

- change labels to x and y axes,

- add title to the plot, and

- export the time series values to a CSV file (x axis data has date time
  string format, if you want to use for calculating simple regression
  model in the [R environment](https://www.r-project.org/),
  [LibreOffice](https://www.libreoffice.org/) etc., you will obtain a
  different calculated formula

  ```sh
  y = a + b*x
  ```

  because these software packages use a reference date other than the
  UNIX Epoch time (00:00:00 UTC on 1 January 1970)).

![Temporal Plot Tool](tplot.png)  
*Figure: Temporal Plot Tool*

To optionally add a title to the temporal plot and/or change the x and y
axes labels, first type the desired text and then click *Draw* as showed
below.

![g.gui.tplot add title and axes labels](g_gui_tplot_labels.png)  
*Figure: Add title and labels to a time series plot*

To export the time series data to a text file (date and data values),
type a name for the file and click *Draw* again. Optionally, set the
check-box to print headers, as well.

[g.gui.tplot export time series as csv file](g_gui_tplot_export_csv.png)  
*Figure: Export time series values to a text file*

## NOTES

*g.gui.tplot* requires the Python plotting library
[Matplotlib](https://matplotlib.org/).

## SEE ALSO

*[Temporal data processing](temporal.md), [wxGUI](wxGUI.md), [wxGUI
components](wxGUI.components.md)*

## AUTHOR

Luca Delucchi, [Fondazione Edmund Mach](http://www.gis.cri.fmach.it),
Italy

## SOURCE CODE

Available at: [g.gui.tplot source code](https://github.com/OSGeo/grass/tree/main/gui/wxpython/tplot)
([history](https://github.com/OSGeo/grass/commits/main/gui/wxpython/tplot))  
Latest change: Saturday Oct 11 04:38:40 2025 in commit [3dd71f5](https://github.com/OSGeo/grass/commit/3dd71f5fab83b72a2db2da959fe075c5b3b52200)
