---
name: g.gui.iclass
description: Tool for supervised classification of imagery data. Generates spectral signatures for an image by allowing the user to outline regions of interest.
keywords: [ general, GUI, classification, supervised classification, signatures ]
description: wxGUI Supervised Classification Tool
index: topic_GUI|GUI
keywords: [display, GUI, imagery, classification, supervised classification]
---

# g.gui.iclass

Tool for supervised classification of imagery data.

Generates spectral signatures for an image by allowing the user to outline regions of interest.

=== "Command line"

    **g.gui.iclass**
    [**-m**]
    [**group**=*name*]
    [**subgroup**=*name*]
    [**map**=*name*]
    [**trainingmap**=*name*]
    [**--verbose**]
    [**--quiet**]
    [**--qq**]
    [**--ui**]

    Example:

    ```sh
    g.gui.iclass
    ```

=== "Python (grass.script)"

    *grass.script.run_command*("***g.gui.iclass***",
        **group**=*None*,
        **subgroup**=*None*,
        **map**=*None*,
        **trainingmap**=*None*,
        **flags**=*None*,
        **verbose**=*None*,
        **quiet**=*None*,
        **superquiet**=*None*)

    Example:

    ```python
    gs.run_command("g.gui.iclass")
    ```

=== "Python (grass.tools)"

    *grass.tools.Tools.g_gui_iclass*(**group**=*None*,
        **subgroup**=*None*,
        **map**=*None*,
        **trainingmap**=*None*,
        **flags**=*None*,
        **verbose**=*None*,
        **quiet**=*None*,
        **superquiet**=*None*)

    Example:

    ```python
    tools = Tools()
    tools.g_gui_iclass()
    ```

    This grass.tools API is experimental in version 8.5 and expected to be stable in version 8.6.

## Parameters

=== "Command line"

    **group**=*name*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of input imagery group  
    **subgroup**=*name*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of input imagery subgroup  
    **map**=*name*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of raster map to load  
    **trainingmap**=*name*  
    &nbsp;&nbsp;&nbsp;&nbsp;Ground truth training map to load  
    **-m**  
    &nbsp;&nbsp;&nbsp;&nbsp;Maximize window  
    **--help**  
    &nbsp;&nbsp;&nbsp;&nbsp;Print usage summary  
    **--verbose**  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    **--quiet**  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    **--qq**  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    **--ui**  
    &nbsp;&nbsp;&nbsp;&nbsp;Force launching GUI dialog

=== "Python (grass.script)"

    **group** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of input imagery group  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, group, *name*  
    **subgroup** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of input imagery subgroup  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, subgroup, *name*  
    **map** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of raster map to load  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, raster, *name*  
    **trainingmap** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Ground truth training map to load  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, vector, *name*  
    **flags** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *m*  
    &nbsp;&nbsp;&nbsp;&nbsp;**m**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Maximize window  
    **verbose** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **quiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **superquiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  

=== "Python (grass.tools)"

    **group** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of input imagery group  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, group, *name*  
    **subgroup** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of input imagery subgroup  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, subgroup, *name*  
    **map** : str | np.ndarray, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of raster map to load  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, raster, *name*  
    **trainingmap** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Ground truth training map to load  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, vector, *name*  
    **flags** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *m*  
    &nbsp;&nbsp;&nbsp;&nbsp;**m**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Maximize window  
    **verbose** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **quiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **superquiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  

    Returns:

    **result** : grass.tools.support.ToolResult | None  
    If the tool produces text as standard output, a *ToolResult* object will be returned. Otherwise, `None` will be returned.

    Raises:

    *grass.tools.ToolError*: When the tool ended with an error.

# wxGUI Supervised Classification Tool

## DESCRIPTION

**Supervised Classification Tool** (wxIClass) is a *[wxGUI](wxGUI.md)*
component which allows the user to create training areas and generate
spectral signatures. The resulting signature file can be used as input
for *[i.maxlik](i.maxlik.md)* or as a seed signature file for
*[i.cluster](i.cluster.md)*. *WxIClass* can be launched from the Layer
Manager menu *Imagery → Classify image → Interactive input for
supervised classification* or via command line as *g.gui.iclass*.

*wxIClass* currently allows you to:

- create training areas (using customized *[vector
  digitizer](wxGUI.vdigit.md)*)
- show histograms for each band and class (category)
- show coincidence plots for each band
- show raster cells that match training areas (within the number of
  standard deviations specified)
- specify color of class
- write signature file
- import vector map
- export vector map with attribute table

![Supervised Classification Tool](iclass_frame.jpg)

*wxIClass* performs the first pass in the GRASS two-pass supervised
image classification process; the GRASS module *[i.maxlik](i.maxlik.md)*
executes the second pass. Both programs must be run to generate a
classified map in GRASS raster format.

*wxIClass* is an interactive program that allows the user to create
multiple training areas for multiple classes and calculate the spectral
signatures based on the cells that are within the training areas. During
this process the user will be shown histograms for each image band. The
user can also display the cells of the image bands which fall within a
user-specified number of standard deviations from the means in the
spectral signature. By doing this, the user can see how much of the
image is likely to be put into the class associated with the signature.

*wxIClass* can also import training areas defined in a vector layer. In
that case the program expects the vector layer to have the following
columns defined:

- cat: category value
- class: a string with the class name
- color: a color defined using format "RRR:GGG:BBB"

The spectral signatures are composed of region means and covariance
matrices. These region means and covariance matrices are used in the
second pass (*[i.maxlik](i.maxlik.md)*) to classify the image.

Alternatively, the spectral signatures generated by *wxIClass* can be
used for seed means for the clusters in *[i.cluster](i.cluster.md)*.

## SEE ALSO

*[wxGUI](wxGUI.md), [wxGUI components](wxGUI.components.md),
[Interactive Scatter Plot Tool](wxGUI.iscatt.md)*

See also user [wiki](https://grasswiki.osgeo.org/wiki/WxIClass) page and
[development](https://trac.osgeo.org/grass/wiki/wxGUIDevelopment/wxIClass)
page.

## AUTHORS

Anna Kratochvilova, [Czech Technical University in
Prague](https://www.cvut.cz), Czech Republic  
Vaclav Petras, [Czech Technical University in
Prague](https://www.cvut.cz), Czech Republic

## SOURCE CODE

Available at: [g.gui.iclass source code](https://github.com/OSGeo/grass/tree/main/gui/wxpython/iclass)
([history](https://github.com/OSGeo/grass/commits/main/gui/wxpython/iclass))  
Latest change: Sunday Oct 19 06:41:19 2025 in commit [3852c52](https://github.com/OSGeo/grass/commit/3852c52a6ee5ed16ab7c0d2129951ff2d4badb8b)
