---
name: r.param.scale
description: Extracts terrain parameters from a DEM. Uses a multi-scale approach by taking fitting quadratic parameters to any size window (via least squares).
keywords: [ raster, geomorphology, terrain, elevation, landform ]
---

# r.param.scale

Extracts terrain parameters from a DEM.

Uses a multi-scale approach by taking fitting quadratic parameters to any size window (via least squares).

=== "Command line"

    **r.param.scale**
    [**-c**]
    **input**=*name*
    **output**=*name*
    [**slope_tolerance**=*float*]
    [**curvature_tolerance**=*float*]
    [**size**=*integer*]
    [**method**=*string*]
    [**exponent**=*float*]
    [**zscale**=*float*]
    [**--overwrite**]
    [**--verbose**]
    [**--quiet**]
    [**--qq**]
    [**--ui**]

    Example:

    ```sh
    r.param.scale input=name output=name
    ```

=== "Python (grass.script)"

    *grass.script.run_command*("***r.param.scale***",
        **input**,
        **output**,
        **slope_tolerance**=*1.0*,
        **curvature_tolerance**=*0.0001*,
        **size**=*3*,
        **method**=*"elev"*,
        **exponent**=*0.0*,
        **zscale**=*1.0*,
        **flags**=*None*,
        **overwrite**=*None*,
        **verbose**=*None*,
        **quiet**=*None*,
        **superquiet**=*None*)

    Example:

    ```python
    gs.run_command("r.param.scale", input="name", output="name")
    ```

=== "Python (grass.tools)"

    *grass.tools.Tools.r_param_scale*(**input**,
        **output**,
        **slope_tolerance**=*1.0*,
        **curvature_tolerance**=*0.0001*,
        **size**=*3*,
        **method**=*"elev"*,
        **exponent**=*0.0*,
        **zscale**=*1.0*,
        **flags**=*None*,
        **overwrite**=*None*,
        **verbose**=*None*,
        **quiet**=*None*,
        **superquiet**=*None*)

    Example:

    ```python
    tools = Tools()
    tools.r_param_scale(input="name", output="name")
    ```

    This grass.tools API is experimental in version 8.5 and expected to be stable in version 8.6.

## Parameters

=== "Command line"

    **input**=*name* **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of input raster map  
    **output**=*name* **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;Name for output raster map containing morphometric parameter  
    **slope_tolerance**=*float*  
    &nbsp;&nbsp;&nbsp;&nbsp;Slope tolerance that defines a 'flat' surface (degrees)  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *1.0*  
    **curvature_tolerance**=*float*  
    &nbsp;&nbsp;&nbsp;&nbsp;Curvature tolerance that defines 'planar' surface  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *0.0001*  
    **size**=*integer*  
    &nbsp;&nbsp;&nbsp;&nbsp;Size of processing window (odd number only)  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *3-499*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *3*  
    **method**=*string*  
    &nbsp;&nbsp;&nbsp;&nbsp;Morphometric parameter in 'size' window to calculate  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *elev, slope, aspect, profc, planc, longc, crosc, minic, maxic, feature*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *elev*  
    **exponent**=*float*  
    &nbsp;&nbsp;&nbsp;&nbsp;Exponent for distance weighting (0.0-4.0)  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *0.0*  
    **zscale**=*float*  
    &nbsp;&nbsp;&nbsp;&nbsp;Vertical scaling factor  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *1.0*  
    **-c**  
    &nbsp;&nbsp;&nbsp;&nbsp;Constrain model through central window cell  
    **--overwrite**  
    &nbsp;&nbsp;&nbsp;&nbsp;Allow output files to overwrite existing files  
    **--help**  
    &nbsp;&nbsp;&nbsp;&nbsp;Print usage summary  
    **--verbose**  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    **--quiet**  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    **--qq**  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    **--ui**  
    &nbsp;&nbsp;&nbsp;&nbsp;Force launching GUI dialog

=== "Python (grass.script)"

    **input** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of input raster map  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, raster, *name*  
    **output** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name for output raster map containing morphometric parameter  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: output, raster, *name*  
    **slope_tolerance** : float, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Slope tolerance that defines a 'flat' surface (degrees)  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *1.0*  
    **curvature_tolerance** : float, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Curvature tolerance that defines 'planar' surface  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *0.0001*  
    **size** : int, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Size of processing window (odd number only)  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *3-499*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *3*  
    **method** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Morphometric parameter in 'size' window to calculate  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *elev, slope, aspect, profc, planc, longc, crosc, minic, maxic, feature*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *elev*  
    **exponent** : float, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Exponent for distance weighting (0.0-4.0)  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *0.0*  
    **zscale** : float, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Vertical scaling factor  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *1.0*  
    **flags** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *c*  
    &nbsp;&nbsp;&nbsp;&nbsp;**c**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Constrain model through central window cell  
    **overwrite** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allow output files to overwrite existing files  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **verbose** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **quiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **superquiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  

=== "Python (grass.tools)"

    **input** : str | np.ndarray, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of input raster map  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, raster, *name*  
    **output** : str | type(np.ndarray) | type(np.array) | type(gs.array.array), *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name for output raster map containing morphometric parameter  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: output, raster, *name*  
    **slope_tolerance** : float, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Slope tolerance that defines a 'flat' surface (degrees)  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *1.0*  
    **curvature_tolerance** : float, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Curvature tolerance that defines 'planar' surface  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *0.0001*  
    **size** : int, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Size of processing window (odd number only)  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *3-499*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *3*  
    **method** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Morphometric parameter in 'size' window to calculate  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *elev, slope, aspect, profc, planc, longc, crosc, minic, maxic, feature*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *elev*  
    **exponent** : float, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Exponent for distance weighting (0.0-4.0)  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *0.0*  
    **zscale** : float, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Vertical scaling factor  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *1.0*  
    **flags** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *c*  
    &nbsp;&nbsp;&nbsp;&nbsp;**c**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Constrain model through central window cell  
    **overwrite** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allow output files to overwrite existing files  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **verbose** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **quiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **superquiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  

    Returns:

    **result** : grass.tools.support.ToolResult | np.ndarray | tuple[np.ndarray] | None  
    If the tool produces text as standard output, a *ToolResult* object will be returned. Otherwise, `None` will be returned. If an array type (e.g., *np.ndarray*) is used for one of the raster outputs, the result will be an array and will have the shape corresponding to the computational region. If an array type is used for more than one raster output, the result will be a tuple of arrays.

    Raises:

    *grass.tools.ToolError*: When the tool ended with an error.

## DESCRIPTION

*r.param.scale* extracts terrain parameters from a digital elevation
model. Uses a multi-scale approach by fitting a bivariate quadratic
polynomial to a given window size using least squares.

The module calculates the following parameters (terminology is from
Wood, 1996 with related terminology used in other GRASS modules listed
in brackets):

- *elev*: Generalised elevation value (for resampling purposes at
  different scale)
- *slope*: Magnitude of maximum gradient (steepest slope angle)
- *aspect*: Direction of maximum gradient (steepest slope direction=flow
  direction)
- *profc*: profile curvature (curvature intersecting with the plane
  defined by *Z* axis and maximum gradient direction). Positive values
  describe convex profile curvature, negative values concave profile
  curvature.
- *planc*: plan curvature (horizontal curvature, intersecting with the
  *XY* plane)
- *longc*: longitudinal curvature (profile curvature intersecting with
  the plane defined by the surface normal and maximum gradient
  direction)
- *crosc*: cross-sectional curvature (tangential curvature intersecting
  with the plane defined by the surface normal and a tangent to the
  contour - perpendicular to maximum gradient direction)
- *maxic*: maximum curvature (can be in any direction)
- *minic*: minimum curvature (in direction perpendicular to the
  direction of of maximum curvature)
- *feature*: Morphometric features: peaks, ridges, passes, channels,
  pits and planes

## NOTES

In *r.param.scale* the direction of maximum gradient (considered
downslope) is stored as (West is 0 degree, East is +/- 180 degree):

- 0..+180 degree from West to North to East
- 0..-180 degree from West to South to East

Note that the aspect map is calculated differently from
*[r.slope.aspect](r.slope.aspect.md)*.

## EXAMPLE

The next commands will create a geomorphological map of the Spearfish
sample dataset region:

```sh
g.region raster=elevation.10m -p
r.param.scale in=elevation.10m output=morphology method=feature size=9
```

![r.param.scale example](r_param_scale_morph.jpg)  
*Figure: Geomorphological map of a subregion
in the Spearfish (SD) area*

## TODO

Fix bug when \`constrain through central cell' option selected. Create
color tables for all output files (presently only on features).

## REFERENCES

- Wood, J. (1996): The Geomorphological characterisation of Digital
  Elevation Models. Diss., Department of Geography, University of
  Leicester, U.K  
  online at: <http://hdl.handle.net/2381/34503>
- Java Code in
  [LandSerf](http://www.geog.le.ac.uk/jwo/research/LandSerf) that
  implements the same procedure

## SEE ALSO

*[r.geomorphon](r.geomorphon.md), [r.slope.aspect](r.slope.aspect.md)*

## AUTHORS

[Jo Wood](MAILTO:jwo@le.ac.uk) - [ASSIST's
home](http://www.geog.le.ac.uk/assist/index.html)

Update to FP 3/2002: L. Potrich, M. Neteler, S. Menegon (ITC-irst)

## SOURCE CODE

Available at: [r.param.scale source code](https://github.com/OSGeo/grass/tree/main/raster/r.param.scale)
([history](https://github.com/OSGeo/grass/commits/main/raster/r.param.scale))  
Latest change: Thursday May 08 20:58:05 2025 in commit [4144ba8](https://github.com/OSGeo/grass/commit/4144ba81fa125e1549fc52e1cf5feb4fa004be8b)
