---
name: r.statistics
description: Calculates category or object oriented statistics.
keywords: [ raster, statistics, zonal statistics ]
---

# r.statistics

Calculates category or object oriented statistics.

=== "Command line"

    **r.statistics**
    [**-c**]
    **base**=*name*
    **cover**=*name*
    **method**=*string*
    **output**=*name*
    [**--overwrite**]
    [**--verbose**]
    [**--quiet**]
    [**--qq**]
    [**--ui**]

    Example:

    ```sh
    r.statistics base=name cover=name method=diversity output=name
    ```

=== "Python (grass.script)"

    *grass.script.run_command*("***r.statistics***",
        **base**,
        **cover**,
        **method**,
        **output**,
        **flags**=*None*,
        **overwrite**=*None*,
        **verbose**=*None*,
        **quiet**=*None*,
        **superquiet**=*None*)

    Example:

    ```python
    gs.run_command("r.statistics", base="name", cover="name", method="diversity", output="name")
    ```

=== "Python (grass.tools)"

    *grass.tools.Tools.r_statistics*(**base**,
        **cover**,
        **method**,
        **output**,
        **flags**=*None*,
        **overwrite**=*None*,
        **verbose**=*None*,
        **quiet**=*None*,
        **superquiet**=*None*)

    Example:

    ```python
    tools = Tools()
    tools.r_statistics(base="name", cover="name", method="diversity", output="name")
    ```

    This grass.tools API is experimental in version 8.5 and expected to be stable in version 8.6.

## Parameters

=== "Command line"

    **base**=*name* **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of base raster map  
    **cover**=*name* **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of cover raster map  
    **method**=*string* **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;Method of object-based statistic  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *diversity, average, mode, median, avedev, stddev, variance, skewness, kurtosis, min, max, sum*  
    &nbsp;&nbsp;&nbsp;&nbsp;**diversity**: Diversity of values in specified objects in %%  
    &nbsp;&nbsp;&nbsp;&nbsp;**average**: Average of values in specified objects  
    &nbsp;&nbsp;&nbsp;&nbsp;**mode**: Mode of values in specified objects  
    &nbsp;&nbsp;&nbsp;&nbsp;**median**: Median of values in specified objects  
    &nbsp;&nbsp;&nbsp;&nbsp;**avedev**: Average deviation of values in specified objects  
    &nbsp;&nbsp;&nbsp;&nbsp;**stddev**: Standard deviation of values in specified objects  
    &nbsp;&nbsp;&nbsp;&nbsp;**variance**: Variance of values in specified objects  
    &nbsp;&nbsp;&nbsp;&nbsp;**skewness**: Skewnes of values in specified objects  
    &nbsp;&nbsp;&nbsp;&nbsp;**kurtosis**: Kurtosis of values in specified objects  
    &nbsp;&nbsp;&nbsp;&nbsp;**min**: Minimum of values in specified objects  
    &nbsp;&nbsp;&nbsp;&nbsp;**max**: Maximum of values in specified objects  
    &nbsp;&nbsp;&nbsp;&nbsp;**sum**: Sum of values in specified objects  
    **output**=*name* **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;Resultant raster map  
    **-c**  
    &nbsp;&nbsp;&nbsp;&nbsp;Cover values extracted from the category labels of the cover map  
    **--overwrite**  
    &nbsp;&nbsp;&nbsp;&nbsp;Allow output files to overwrite existing files  
    **--help**  
    &nbsp;&nbsp;&nbsp;&nbsp;Print usage summary  
    **--verbose**  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    **--quiet**  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    **--qq**  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    **--ui**  
    &nbsp;&nbsp;&nbsp;&nbsp;Force launching GUI dialog

=== "Python (grass.script)"

    **base** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of base raster map  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, raster, *name*  
    **cover** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of cover raster map  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, raster, *name*  
    **method** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Method of object-based statistic  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *diversity, average, mode, median, avedev, stddev, variance, skewness, kurtosis, min, max, sum*  
    &nbsp;&nbsp;&nbsp;&nbsp;**diversity**: Diversity of values in specified objects in %%  
    &nbsp;&nbsp;&nbsp;&nbsp;**average**: Average of values in specified objects  
    &nbsp;&nbsp;&nbsp;&nbsp;**mode**: Mode of values in specified objects  
    &nbsp;&nbsp;&nbsp;&nbsp;**median**: Median of values in specified objects  
    &nbsp;&nbsp;&nbsp;&nbsp;**avedev**: Average deviation of values in specified objects  
    &nbsp;&nbsp;&nbsp;&nbsp;**stddev**: Standard deviation of values in specified objects  
    &nbsp;&nbsp;&nbsp;&nbsp;**variance**: Variance of values in specified objects  
    &nbsp;&nbsp;&nbsp;&nbsp;**skewness**: Skewnes of values in specified objects  
    &nbsp;&nbsp;&nbsp;&nbsp;**kurtosis**: Kurtosis of values in specified objects  
    &nbsp;&nbsp;&nbsp;&nbsp;**min**: Minimum of values in specified objects  
    &nbsp;&nbsp;&nbsp;&nbsp;**max**: Maximum of values in specified objects  
    &nbsp;&nbsp;&nbsp;&nbsp;**sum**: Sum of values in specified objects  
    **output** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Resultant raster map  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: output, raster, *name*  
    **flags** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *c*  
    &nbsp;&nbsp;&nbsp;&nbsp;**c**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Cover values extracted from the category labels of the cover map  
    **overwrite** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allow output files to overwrite existing files  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **verbose** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **quiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **superquiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  

=== "Python (grass.tools)"

    **base** : str | np.ndarray, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of base raster map  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, raster, *name*  
    **cover** : str | np.ndarray, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of cover raster map  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, raster, *name*  
    **method** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Method of object-based statistic  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *diversity, average, mode, median, avedev, stddev, variance, skewness, kurtosis, min, max, sum*  
    &nbsp;&nbsp;&nbsp;&nbsp;**diversity**: Diversity of values in specified objects in %%  
    &nbsp;&nbsp;&nbsp;&nbsp;**average**: Average of values in specified objects  
    &nbsp;&nbsp;&nbsp;&nbsp;**mode**: Mode of values in specified objects  
    &nbsp;&nbsp;&nbsp;&nbsp;**median**: Median of values in specified objects  
    &nbsp;&nbsp;&nbsp;&nbsp;**avedev**: Average deviation of values in specified objects  
    &nbsp;&nbsp;&nbsp;&nbsp;**stddev**: Standard deviation of values in specified objects  
    &nbsp;&nbsp;&nbsp;&nbsp;**variance**: Variance of values in specified objects  
    &nbsp;&nbsp;&nbsp;&nbsp;**skewness**: Skewnes of values in specified objects  
    &nbsp;&nbsp;&nbsp;&nbsp;**kurtosis**: Kurtosis of values in specified objects  
    &nbsp;&nbsp;&nbsp;&nbsp;**min**: Minimum of values in specified objects  
    &nbsp;&nbsp;&nbsp;&nbsp;**max**: Maximum of values in specified objects  
    &nbsp;&nbsp;&nbsp;&nbsp;**sum**: Sum of values in specified objects  
    **output** : str | type(np.ndarray) | type(np.array) | type(gs.array.array), *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Resultant raster map  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: output, raster, *name*  
    **flags** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *c*  
    &nbsp;&nbsp;&nbsp;&nbsp;**c**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Cover values extracted from the category labels of the cover map  
    **overwrite** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allow output files to overwrite existing files  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **verbose** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **quiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **superquiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  

    Returns:

    **result** : grass.tools.support.ToolResult | np.ndarray | tuple[np.ndarray] | None  
    If the tool produces text as standard output, a *ToolResult* object will be returned. Otherwise, `None` will be returned. If an array type (e.g., *np.ndarray*) is used for one of the raster outputs, the result will be an array and will have the shape corresponding to the computational region. If an array type is used for more than one raster output, the result will be a tuple of arrays.

    Raises:

    *grass.tools.ToolError*: When the tool ended with an error.

## DESCRIPTION

*r.statistics* is a tool to analyse exploratory statistics of a
categorical "cover layer" according to how it intersects with objects in
a "base layer". A variety of standard statistical measures are possible
(called "zonal statistics" in some GIS). All cells in the base layer are
considered one object for the analysis. For some applications, one will
first want to prepare the input data so that all areas of contiguous
cell category values in the base layer are uniquely identified, which
can be done with *r.clump*.  
The available methods are the following:

- average deviation
- average
- diversity
- kurtosis
- maximum
- median
- minimum
- mode
- skewness
- standard deviation
- sum
- variance

The calculations will be performed on each area of data of the cover
layers which fall within each unique value, or category, of the base
layer.

Setting the *-c* flag the category labels of the covering raster layer
will be used. This is nice to avoid the GRASS limitation to integer in
raster maps because using category values floating point numbers can be
stored.

All calculations create an output layer. The output layer is a
reclassified version of the base layer with identical category values,
but modified category labels - the results of the calculations are
stored in the category labels of the output layer.

## NOTES

For floating-point cover map support, see the alternative
*[r.stats.zonal](r.stats.zonal.md)*. For quantile calculations with
support for floating-point cover maps, see the alternative
*[r.stats.quantile](r.stats.quantile.md)*.

## EXAMPLES

Calculation of average elevation of each field in the Spearfish region:

```sh
r.statistics base=fields cover=elevation.dem out=elevstats method=average
r.category elevstats
r.mapcalc "fieldelev = @elevstats"
r.univar fieldelev
```

## SEE ALSO

*[r.category](r.category.md), [r.clump](r.clump.md),
[r.mode](r.mode.md), [r.mapcalc](r.mapcalc.md),
[r.neighbors](r.neighbors.md), [r.stats.quantile](r.stats.quantile.md),
[r.stats.zonal](r.stats.zonal.md), [r.univar](r.univar.md)*

## AUTHOR

Martin Schroeder, Geographisches Institut Heidelberg, Germany

## SOURCE CODE

Available at: [r.statistics source code](https://github.com/OSGeo/grass/tree/main/raster/r.statistics)
([history](https://github.com/OSGeo/grass/commits/main/raster/r.statistics))  
Latest change: Thursday May 08 20:58:05 2025 in commit [4144ba8](https://github.com/OSGeo/grass/commit/4144ba81fa125e1549fc52e1cf5feb4fa004be8b)
