---
name: v.in.e00.py
description: Imports E00 file into a vector map.
keywords: [ vector, import, E00 ]
---

# v.in.e00.py

Imports E00 file into a vector map.

=== "Command line"

    **v.in.e00.py**
    **input**=*name*
    **type**=*string* [,*string*,...]
    **output**=*name*
    [**--overwrite**]
    [**--verbose**]
    [**--quiet**]
    [**--qq**]
    [**--ui**]

    Example:

    ```sh
    v.in.e00.py input=name type=point output=name
    ```

=== "Python (grass.script)"

    *grass.script.run_command*("***v.in.e00.py***",
        **input**,
        **type**=*"point"*,
        **output**,
        **overwrite**=*None*,
        **verbose**=*None*,
        **quiet**=*None*,
        **superquiet**=*None*)

    Example:

    ```python
    gs.run_command("v.in.e00.py", input="name", type="point", output="name")
    ```

=== "Python (grass.tools)"

    *grass.tools.Tools.v_in_e00_py*(**input**,
        **type**=*"point"*,
        **output**,
        **overwrite**=*None*,
        **verbose**=*None*,
        **quiet**=*None*,
        **superquiet**=*None*)

    Example:

    ```python
    tools = Tools()
    tools.v_in_e00_py(input="name", type="point", output="name")
    ```

    This grass.tools API is experimental in version 8.5 and expected to be stable in version 8.6.

## Parameters

=== "Command line"

    **input**=*name* **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of input E00 file  
    **type**=*string* [,*string*,...] **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;Input feature type  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *point, line, area*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *point*  
    **output**=*name* **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;Name for output vector map  
    **--overwrite**  
    &nbsp;&nbsp;&nbsp;&nbsp;Allow output files to overwrite existing files  
    **--help**  
    &nbsp;&nbsp;&nbsp;&nbsp;Print usage summary  
    **--verbose**  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    **--quiet**  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    **--qq**  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    **--ui**  
    &nbsp;&nbsp;&nbsp;&nbsp;Force launching GUI dialog

=== "Python (grass.script)"

    **input** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of input E00 file  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, file, *name*  
    **type** : str | list[str], *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Input feature type  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *point, line, area*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *point*  
    **output** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name for output vector map  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: output, vector, *name*  
    **overwrite** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allow output files to overwrite existing files  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **verbose** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **quiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **superquiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  

=== "Python (grass.tools)"

    **input** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of input E00 file  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, file, *name*  
    **type** : str | list[str], *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Input feature type  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *point, line, area*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *point*  
    **output** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name for output vector map  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: output, vector, *name*  
    **overwrite** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allow output files to overwrite existing files  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **verbose** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **quiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **superquiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  

    Returns:

    **result** : grass.tools.support.ToolResult | None  
    If the tool produces text as standard output, a *ToolResult* object will be returned. Otherwise, `None` will be returned.

    Raises:

    *grass.tools.ToolError*: When the tool ended with an error.

## DESCRIPTION

*v.in.e00* imports ASCII and binary E00 vector maps into GRASS.

## NOTES

Sometimes an .e00 coverage consists of multiple files, where a single
data set is contained as a series of files named filename.e00,
filename.e01, filename.e02 etc. The user must take care to download them
all, the scripts automatically detects the presence of such multiple
files.

## REFERENCES

[AVCE00 library](http://avce00.maptools.org) (providing 'avcimport' and
'e00conv')  
[OGR vector library](https://gdal.org/)

## SEE ALSO

*[v.in.ogr](v.in.ogr.md)*

## AUTHORS

Markus Neteler, Otto Dassau, [GDF Hannover
bR](http://www.gdf-hannover.de/), Germany

## SOURCE CODE

Available at: [v.in.e00 source code](https://github.com/OSGeo/grass/tree/main/scripts/v.in.e00)
([history](https://github.com/OSGeo/grass/commits/main/scripts/v.in.e00))  
Latest change: Friday Feb 07 19:16:09 2025 in commit [a82a39f](https://github.com/OSGeo/grass/commit/a82a39f673b97fafcfce1604dc3e6015cb96487a)
