---
name: d.labels
description: Displays text labels (created with v.label) to the active frame on the graphics monitor.
keywords: [ display, paint labels ]
---

# d.labels

Displays text labels (created with v.label) to the active frame on the graphics monitor.

=== "Command line"

    **d.labels**
    [**-i**]
    **labels**=*string*
    [**minreg**=*float*]
    [**maxreg**=*float*]
    [**--verbose**]
    [**--quiet**]
    [**--qq**]
    [**--ui**]

    Example:

    ```sh
    d.labels labels=string
    ```

=== "Python (grass.script)"

    *grass.script.run_command*("***d.labels***",
        **labels**,
        **minreg**=*None*,
        **maxreg**=*None*,
        **flags**=*None*,
        **verbose**=*None*,
        **quiet**=*None*,
        **superquiet**=*None*)

    Example:

    ```python
    gs.run_command("d.labels", labels="string")
    ```

=== "Python (grass.tools)"

    *grass.tools.Tools.d_labels*(**labels**,
        **minreg**=*None*,
        **maxreg**=*None*,
        **flags**=*None*,
        **verbose**=*None*,
        **quiet**=*None*,
        **superquiet**=*None*)

    Example:

    ```python
    tools = Tools()
    tools.d_labels(labels="string")
    ```

    This grass.tools API is experimental in version 8.5 and expected to be stable in version 8.6.

## Parameters

=== "Command line"

    **labels**=*string* **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of label file  
    **minreg**=*float*  
    &nbsp;&nbsp;&nbsp;&nbsp;Minimum region size (diagonal) when labels are displayed  
    **maxreg**=*float*  
    &nbsp;&nbsp;&nbsp;&nbsp;Maximum region size (diagonal) when labels are displayed  
    **-i**  
    &nbsp;&nbsp;&nbsp;&nbsp;Ignore rotation setting and draw horizontally  
    **--help**  
    &nbsp;&nbsp;&nbsp;&nbsp;Print usage summary  
    **--verbose**  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    **--quiet**  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    **--qq**  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    **--ui**  
    &nbsp;&nbsp;&nbsp;&nbsp;Force launching GUI dialog

=== "Python (grass.script)"

    **labels** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of label file  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, paint labels  
    **minreg** : float, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Minimum region size (diagonal) when labels are displayed  
    **maxreg** : float, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Maximum region size (diagonal) when labels are displayed  
    **flags** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *i*  
    &nbsp;&nbsp;&nbsp;&nbsp;**i**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Ignore rotation setting and draw horizontally  
    **verbose** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **quiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **superquiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  

=== "Python (grass.tools)"

    **labels** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of label file  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, paint labels  
    **minreg** : float, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Minimum region size (diagonal) when labels are displayed  
    **maxreg** : float, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Maximum region size (diagonal) when labels are displayed  
    **flags** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *i*  
    &nbsp;&nbsp;&nbsp;&nbsp;**i**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Ignore rotation setting and draw horizontally  
    **verbose** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **quiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **superquiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  

    Returns:

    **result** : grass.tools.support.ToolResult | None  
    If the tool produces text as standard output, a *ToolResult* object will be returned. Otherwise, `None` will be returned.

    Raises:

    *grass.tools.ToolError*: When the tool ended with an error.

## DESCRIPTION

*d.labels* displays a *paint* label file in the active display frame on
the graphics monitor. Each label has components which determine the
text, the location of the text on the image, its size, and the
background for the text. This file can be generated with the
*[v.label](v.label.md)* program or simply created by the user as an
ASCII file (using a text editor) and placed in the appropriate directory
under the user's current mapset and project (i.e.
`$MAPSET/paint/labels/`).

## NOTES

Some of the information stored in the label file is unused by
*d.labels*. This extra information is used by such programs as
*[ps.map](ps.map.md)*.

This module was formerly known as *d.paint.labels*. The old version
of *d.labels* from GRASS 5, which provided interactive placement and
modification of paint labels, still needs to have its functionality
merged into this module.

## SEE ALSO

*[d.font](d.font.md)*  
*[d.text](d.text.md)*  
*[d.title](d.title.md)*  
*[ps.map](ps.map.md)*  
*[v.label](v.label.md)*  

## AUTHOR

James Westervelt, U.S. Army Construction Engineering Research Laboratory

## SOURCE CODE

Available at: [d.labels source code](https://github.com/OSGeo/grass/tree/main/display/d.labels)
([history](https://github.com/OSGeo/grass/commits/main/display/d.labels))  
Latest change: Thursday Oct 02 03:38:16 2025 in commit [a858662](https://github.com/OSGeo/grass/commit/a858662dcd08f7746569c68693789bea25ad197b)
