---
name: m.nviz.image
description: Creates a 3D rendering of GIS data. Renders surfaces (raster data), 2D/3D vector data, and volumes (3D raster data) in 3D.
keywords: [ miscellaneous, visualization, graphics, raster, vector, raster3d ]
---

# m.nviz.image

Creates a 3D rendering of GIS data.

Renders surfaces (raster data), 2D/3D vector data, and volumes (3D raster data) in 3D.

=== "Command line"

    **m.nviz.image**
    [**-anb**]
    [**elevation_map**=*name* [,*name*,...]]
    [**elevation_value**=*value* [,*value*,...]]
    [**color_map**=*name* [,*name*,...]]
    [**color**=*name* [,*name*,...]]
    [**mask_map**=*name* [,*name*,...]]
    [**transparency_map**=*name* [,*name*,...]]
    [**transparency_value**=*value* [,*value*,...]]
    [**shininess_map**=*name* [,*name*,...]]
    [**shininess_value**=*value* [,*value*,...]]
    [**emission_map**=*name* [,*name*,...]]
    [**emission_value**=*value* [,*value*,...]]
    [**mode**=*string* [,*string*,...]]
    [**resolution_fine**=*value* [,*value*,...]]
    [**resolution_coarse**=*value* [,*value*,...]]
    [**style**=*string* [,*string*,...]]
    [**shading**=*string* [,*string*,...]]
    [**wire_color**=*name* [,*name*,...]]
    [**surface_position**=*x,y,z* [,*x,y,z*,...]]
    [**vline**=*name* [,*name*,...]]
    [**vline_layer**=*string* [,*string*,...]]
    [**vline_width**=*value* [,*value*,...]]
    [**vline_width_column**=*name* [,*name*,...]]
    [**vline_color**=*name* [,*name*,...]]
    [**vline_color_column**=*name* [,*name*,...]]
    [**vline_mode**=*string* [,*string*,...]]
    [**vline_height**=*value* [,*value*,...]]
    [**vline_position**=*x,y,z* [,*x,y,z*,...]]
    [**vpoint**=*name* [,*name*,...]]
    [**vpoint_layer**=*string* [,*string*,...]]
    [**vpoint_size**=*value* [,*value*,...]]
    [**vpoint_size_column**=*name* [,*name*,...]]
    [**vpoint_width**=*value* [,*value*,...]]
    [**vpoint_width_column**=*name* [,*name*,...]]
    [**vpoint_color**=*name* [,*name*,...]]
    [**vpoint_color_column**=*name* [,*name*,...]]
    [**vpoint_marker**=*string* [,*string*,...]]
    [**vpoint_marker_column**=*name* [,*name*,...]]
    [**vpoint_mode**=*string* [,*string*,...]]
    [**vpoint_position**=*x,y,z* [,*x,y,z*,...]]
    [**volume**=*name* [,*name*,...]]
    [**volume_mode**=*string* [,*string*,...]]
    [**volume_shading**=*string* [,*string*,...]]
    [**volume_position**=*x,y,z* [,*x,y,z*,...]]
    [**volume_resolution**=*value* [,*value*,...]]
    [**isosurf_level**=*volume:value* [,*volume:value*,...]]
    [**isosurf_color_map**=*name* [,*name*,...]]
    [**isosurf_color_value**=*name* [,*name*,...]]
    [**isosurf_transparency_map**=*name* [,*name*,...]]
    [**isosurf_transparency_value**=*value* [,*value*,...]]
    [**isosurf_shininess_map**=*name* [,*name*,...]]
    [**isosurf_shininess_value**=*value* [,*value*,...]]
    [**slice**=*volume:axis* [,*volume:axis*,...]]
    [**slice_position**=*x1,x2,y1,y2,z1,z2* [,*x1,x2,y1,y2,z1,z2*,...]]
    [**slice_transparency**=*value* [,*value*,...]]
    [**bgcolor**=*name*]
    [**position**=*x,y*]
    [**height**=*value*]
    [**perspective**=*value*]
    [**twist**=*value*]
    [**zexag**=*value*]
    [**focus**=*x,y,z*]
    [**light_position**=*x,y,z*]
    [**light_color**=*name*]
    [**light_brightness**=*integer*]
    [**light_ambient**=*integer*]
    [**fringe**=*string* [,*string*,...]]
    [**fringe_color**=*name*]
    [**fringe_elevation**=*integer*]
    [**cplane**=*value* [,*value*,...]]
    [**cplane_position**=*x,y,z* [,*x,y,z*,...]]
    [**cplane_rotation**=*value* [,*value*,...]]
    [**cplane_tilt**=*value* [,*value*,...]]
    [**cplane_shading**=*string*]
    [**arrow_position**=*x,y*]
    [**arrow_size**=*value*]
    [**arrow_color**=*name*]
    **output**=*name*
    **format**=*string*
    **size**=*width,height*
    [**--overwrite**]
    [**--verbose**]
    [**--quiet**]
    [**--qq**]
    [**--ui**]

    Example:

    ```sh
    m.nviz.image output=name format=ppm size=640,480
    ```

=== "Python (grass.script)"

    *grass.script.run_command*("***m.nviz.image***",
        **elevation_map**=*None*,
        **elevation_value**=*None*,
        **color_map**=*None*,
        **color**=*None*,
        **mask_map**=*None*,
        **transparency_map**=*None*,
        **transparency_value**=*None*,
        **shininess_map**=*None*,
        **shininess_value**=*None*,
        **emission_map**=*None*,
        **emission_value**=*None*,
        **mode**=*"fine"*,
        **resolution_fine**=*6*,
        **resolution_coarse**=*9*,
        **style**=*"surface"*,
        **shading**=*"gouraud"*,
        **wire_color**=*"136:136:136"*,
        **surface_position**=*"0,0,0"*,
        **vline**=*None*,
        **vline_layer**=*"1"*,
        **vline_width**=*2*,
        **vline_width_column**=*None*,
        **vline_color**=*"blue"*,
        **vline_color_column**=*None*,
        **vline_mode**=*"surface"*,
        **vline_height**=*0*,
        **vline_position**=*"0,0,0"*,
        **vpoint**=*None*,
        **vpoint_layer**=*"1"*,
        **vpoint_size**=*100*,
        **vpoint_size_column**=*None*,
        **vpoint_width**=*2*,
        **vpoint_width_column**=*None*,
        **vpoint_color**=*"blue"*,
        **vpoint_color_column**=*None*,
        **vpoint_marker**=*"sphere"*,
        **vpoint_marker_column**=*None*,
        **vpoint_mode**=*"3D"*,
        **vpoint_position**=*"0,0,0"*,
        **volume**=*None*,
        **volume_mode**=*"isosurface"*,
        **volume_shading**=*"gouraud"*,
        **volume_position**=*"0,0,0"*,
        **volume_resolution**=*3*,
        **isosurf_level**=*None*,
        **isosurf_color_map**=*None*,
        **isosurf_color_value**=*None*,
        **isosurf_transparency_map**=*None*,
        **isosurf_transparency_value**=*None*,
        **isosurf_shininess_map**=*None*,
        **isosurf_shininess_value**=*None*,
        **slice**=*None*,
        **slice_position**=*"0,1,0,1,0,1"*,
        **slice_transparency**=*0*,
        **bgcolor**=*"white"*,
        **position**=*"0.84,0.16"*,
        **height**=*None*,
        **perspective**=*40*,
        **twist**=*0*,
        **zexag**=*None*,
        **focus**=*None*,
        **light_position**=*"0.68,-0.68,0.80"*,
        **light_color**=*"white"*,
        **light_brightness**=*80*,
        **light_ambient**=*20*,
        **fringe**=*None*,
        **fringe_color**=*"grey"*,
        **fringe_elevation**=*55*,
        **cplane**=*None*,
        **cplane_position**=*"0,0,0"*,
        **cplane_rotation**=*0*,
        **cplane_tilt**=*0*,
        **cplane_shading**=*"clear"*,
        **arrow_position**=*None*,
        **arrow_size**=*None*,
        **arrow_color**=*"black"*,
        **output**,
        **format**=*"ppm"*,
        **size**=*"640,480"*,
        **flags**=*None*,
        **overwrite**=*None*,
        **verbose**=*None*,
        **quiet**=*None*,
        **superquiet**=*None*)

    Example:

    ```python
    gs.run_command("m.nviz.image", output="name", format="ppm", size=640,480)
    ```

=== "Python (grass.tools)"

    *grass.tools.Tools.m_nviz_image*(**elevation_map**=*None*,
        **elevation_value**=*None*,
        **color_map**=*None*,
        **color**=*None*,
        **mask_map**=*None*,
        **transparency_map**=*None*,
        **transparency_value**=*None*,
        **shininess_map**=*None*,
        **shininess_value**=*None*,
        **emission_map**=*None*,
        **emission_value**=*None*,
        **mode**=*"fine"*,
        **resolution_fine**=*6*,
        **resolution_coarse**=*9*,
        **style**=*"surface"*,
        **shading**=*"gouraud"*,
        **wire_color**=*"136:136:136"*,
        **surface_position**=*"0,0,0"*,
        **vline**=*None*,
        **vline_layer**=*"1"*,
        **vline_width**=*2*,
        **vline_width_column**=*None*,
        **vline_color**=*"blue"*,
        **vline_color_column**=*None*,
        **vline_mode**=*"surface"*,
        **vline_height**=*0*,
        **vline_position**=*"0,0,0"*,
        **vpoint**=*None*,
        **vpoint_layer**=*"1"*,
        **vpoint_size**=*100*,
        **vpoint_size_column**=*None*,
        **vpoint_width**=*2*,
        **vpoint_width_column**=*None*,
        **vpoint_color**=*"blue"*,
        **vpoint_color_column**=*None*,
        **vpoint_marker**=*"sphere"*,
        **vpoint_marker_column**=*None*,
        **vpoint_mode**=*"3D"*,
        **vpoint_position**=*"0,0,0"*,
        **volume**=*None*,
        **volume_mode**=*"isosurface"*,
        **volume_shading**=*"gouraud"*,
        **volume_position**=*"0,0,0"*,
        **volume_resolution**=*3*,
        **isosurf_level**=*None*,
        **isosurf_color_map**=*None*,
        **isosurf_color_value**=*None*,
        **isosurf_transparency_map**=*None*,
        **isosurf_transparency_value**=*None*,
        **isosurf_shininess_map**=*None*,
        **isosurf_shininess_value**=*None*,
        **slice**=*None*,
        **slice_position**=*"0,1,0,1,0,1"*,
        **slice_transparency**=*0*,
        **bgcolor**=*"white"*,
        **position**=*"0.84,0.16"*,
        **height**=*None*,
        **perspective**=*40*,
        **twist**=*0*,
        **zexag**=*None*,
        **focus**=*None*,
        **light_position**=*"0.68,-0.68,0.80"*,
        **light_color**=*"white"*,
        **light_brightness**=*80*,
        **light_ambient**=*20*,
        **fringe**=*None*,
        **fringe_color**=*"grey"*,
        **fringe_elevation**=*55*,
        **cplane**=*None*,
        **cplane_position**=*"0,0,0"*,
        **cplane_rotation**=*0*,
        **cplane_tilt**=*0*,
        **cplane_shading**=*"clear"*,
        **arrow_position**=*None*,
        **arrow_size**=*None*,
        **arrow_color**=*"black"*,
        **output**,
        **format**=*"ppm"*,
        **size**=*"640,480"*,
        **flags**=*None*,
        **overwrite**=*None*,
        **verbose**=*None*,
        **quiet**=*None*,
        **superquiet**=*None*)

    Example:

    ```python
    tools = Tools()
    tools.m_nviz_image(output="name", format="ppm", size=640,480)
    ```

    This grass.tools API is experimental in version 8.5 and expected to be stable in version 8.6.

## Parameters

=== "Command line"

    **elevation_map**=*name* [,*name*,...]  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of raster map(s) for elevation  
    **elevation_value**=*value* [,*value*,...]  
    &nbsp;&nbsp;&nbsp;&nbsp;Constant elevation value(s) to use instead of a raster DEM  
    **color_map**=*name* [,*name*,...]  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of raster map(s) for color  
    **color**=*name* [,*name*,...]  
    &nbsp;&nbsp;&nbsp;&nbsp;Color value(s)  
    &nbsp;&nbsp;&nbsp;&nbsp;Either a standard color name or R:G:B triplet  
    **mask_map**=*name* [,*name*,...]  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of raster map(s) for mask  
    **transparency_map**=*name* [,*name*,...]  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of raster map(s) for transparency  
    **transparency_value**=*value* [,*value*,...]  
    &nbsp;&nbsp;&nbsp;&nbsp;Transparency value(s)  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *0-255*  
    **shininess_map**=*name* [,*name*,...]  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of raster map(s) for shininess  
    **shininess_value**=*value* [,*value*,...]  
    &nbsp;&nbsp;&nbsp;&nbsp;Shininess value(s)  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *0-255*  
    **emission_map**=*name* [,*name*,...]  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of raster map(s) for emission  
    **emission_value**=*value* [,*value*,...]  
    &nbsp;&nbsp;&nbsp;&nbsp;Emission value(s)  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *0-255*  
    **mode**=*string* [,*string*,...]  
    &nbsp;&nbsp;&nbsp;&nbsp;Draw mode  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *coarse, fine, both*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *fine*  
    **resolution_fine**=*value* [,*value*,...]  
    &nbsp;&nbsp;&nbsp;&nbsp;Fine resolution  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *6*  
    **resolution_coarse**=*value* [,*value*,...]  
    &nbsp;&nbsp;&nbsp;&nbsp;Coarse resolution  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *9*  
    **style**=*string* [,*string*,...]  
    &nbsp;&nbsp;&nbsp;&nbsp;Draw style  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *wire, surface*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *surface*  
    **shading**=*string* [,*string*,...]  
    &nbsp;&nbsp;&nbsp;&nbsp;Shading  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *flat, gouraud*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *gouraud*  
    **wire_color**=*name* [,*name*,...]  
    &nbsp;&nbsp;&nbsp;&nbsp;Wire color  
    &nbsp;&nbsp;&nbsp;&nbsp;Either a standard color name or R:G:B triplet  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *136:136:136*  
    **surface_position**=*x,y,z* [,*x,y,z*,...]  
    &nbsp;&nbsp;&nbsp;&nbsp;Surface position  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *0,0,0*  
    **vline**=*name* [,*name*,...]  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of vector map  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of line vector overlay map(s)  
    **vline_layer**=*string* [,*string*,...]  
    &nbsp;&nbsp;&nbsp;&nbsp;Layer number or name  
    &nbsp;&nbsp;&nbsp;&nbsp;Layer number or name for thematic mapping  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *1*  
    **vline_width**=*value* [,*value*,...]  
    &nbsp;&nbsp;&nbsp;&nbsp;Vector line width  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *1-100*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *2*  
    **vline_width_column**=*name* [,*name*,...]  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of width definition column  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of attribute column  
    **vline_color**=*name* [,*name*,...]  
    &nbsp;&nbsp;&nbsp;&nbsp;Vector line color  
    &nbsp;&nbsp;&nbsp;&nbsp;Either a standard color name or R:G:B triplet  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *blue*  
    **vline_color_column**=*name* [,*name*,...]  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of color definition column  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of attribute column  
    **vline_mode**=*string* [,*string*,...]  
    &nbsp;&nbsp;&nbsp;&nbsp;Vector line display mode  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *surface, flat*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *surface*  
    &nbsp;&nbsp;&nbsp;&nbsp;**surface**: drape on raster surface  
    &nbsp;&nbsp;&nbsp;&nbsp;**flat**: draw at constant elevation  
    **vline_height**=*value* [,*value*,...]  
    &nbsp;&nbsp;&nbsp;&nbsp;Vector line height  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *0-1000*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *0*  
    **vline_position**=*x,y,z* [,*x,y,z*,...]  
    &nbsp;&nbsp;&nbsp;&nbsp;Vector lines position  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *0,0,0*  
    **vpoint**=*name* [,*name*,...]  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of vector map  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of point vector overlay map(s)  
    **vpoint_layer**=*string* [,*string*,...]  
    &nbsp;&nbsp;&nbsp;&nbsp;Layer number or name  
    &nbsp;&nbsp;&nbsp;&nbsp;Layer number or name for thematic mapping  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *1*  
    **vpoint_size**=*value* [,*value*,...]  
    &nbsp;&nbsp;&nbsp;&nbsp;Icon size (map units)  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *0-1000*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *100*  
    **vpoint_size_column**=*name* [,*name*,...]  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of size definition column  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of attribute column  
    **vpoint_width**=*value* [,*value*,...]  
    &nbsp;&nbsp;&nbsp;&nbsp;Icon width  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *1-1000*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *2*  
    **vpoint_width_column**=*name* [,*name*,...]  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of width definition column  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of attribute column  
    **vpoint_color**=*name* [,*name*,...]  
    &nbsp;&nbsp;&nbsp;&nbsp;Icon color  
    &nbsp;&nbsp;&nbsp;&nbsp;Either a standard color name or R:G:B triplet  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *blue*  
    **vpoint_color_column**=*name* [,*name*,...]  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of color definition column  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of attribute column  
    **vpoint_marker**=*string* [,*string*,...]  
    &nbsp;&nbsp;&nbsp;&nbsp;Icon marker  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *x, box, sphere, cube, diamond, dec_tree, con_tree, aster, gyro, histogram*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *sphere*  
    **vpoint_marker_column**=*name* [,*name*,...]  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of marker definition column  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of attribute column  
    **vpoint_mode**=*string* [,*string*,...]  
    &nbsp;&nbsp;&nbsp;&nbsp;3D vector point display mode  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *surface, 3D*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *3D*  
    &nbsp;&nbsp;&nbsp;&nbsp;**surface**: drape on raster surface  
    &nbsp;&nbsp;&nbsp;&nbsp;**3D**: place at 3D point's z-elevation  
    **vpoint_position**=*x,y,z* [,*x,y,z*,...]  
    &nbsp;&nbsp;&nbsp;&nbsp;Vector points position  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *0,0,0*  
    **volume**=*name* [,*name*,...]  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of 3D raster map(s)  
    **volume_mode**=*string* [,*string*,...]  
    &nbsp;&nbsp;&nbsp;&nbsp;Volume draw mode  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *isosurface, slice*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *isosurface*  
    **volume_shading**=*string* [,*string*,...]  
    &nbsp;&nbsp;&nbsp;&nbsp;Volume shading  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *flat, gouraud*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *gouraud*  
    **volume_position**=*x,y,z* [,*x,y,z*,...]  
    &nbsp;&nbsp;&nbsp;&nbsp;Volume position  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *0,0,0*  
    **volume_resolution**=*value* [,*value*,...]  
    &nbsp;&nbsp;&nbsp;&nbsp;Volume resolution  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *3*  
    **isosurf_level**=*volume:value* [,*volume:value*,...]  
    &nbsp;&nbsp;&nbsp;&nbsp;Isosurface level  
    **isosurf_color_map**=*name* [,*name*,...]  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of volume for isosurface color  
    **isosurf_color_value**=*name* [,*name*,...]  
    &nbsp;&nbsp;&nbsp;&nbsp;Isosurface color  
    &nbsp;&nbsp;&nbsp;&nbsp;Either a standard color name or R:G:B triplet  
    **isosurf_transparency_map**=*name* [,*name*,...]  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of 3D raster map(s) for isosurface transparency  
    **isosurf_transparency_value**=*value* [,*value*,...]  
    &nbsp;&nbsp;&nbsp;&nbsp;Transparency value(s)for isosurfaces  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *0-255*  
    **isosurf_shininess_map**=*name* [,*name*,...]  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of 3D raster map(s) for shininess  
    **isosurf_shininess_value**=*value* [,*value*,...]  
    &nbsp;&nbsp;&nbsp;&nbsp;Shininess value(s) for isosurfaces  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *0-255*  
    **slice**=*volume:axis* [,*volume:axis*,...]  
    &nbsp;&nbsp;&nbsp;&nbsp;Volume slice parallel to given axis (x, y, z)  
    **slice_position**=*x1,x2,y1,y2,z1,z2* [,*x1,x2,y1,y2,z1,z2*,...]  
    &nbsp;&nbsp;&nbsp;&nbsp;Volume slice position  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *0,1,0,1,0,1*  
    **slice_transparency**=*value* [,*value*,...]  
    &nbsp;&nbsp;&nbsp;&nbsp;Volume slice transparency  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *0-255*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *0*  
    **bgcolor**=*name*  
    &nbsp;&nbsp;&nbsp;&nbsp;Background color  
    &nbsp;&nbsp;&nbsp;&nbsp;Either a standard color name or R:G:B triplet  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *white*  
    **position**=*x,y*  
    &nbsp;&nbsp;&nbsp;&nbsp;Viewpoint position (x,y model coordinates)  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *0.0-1.0*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *0.84,0.16*  
    **height**=*value*  
    &nbsp;&nbsp;&nbsp;&nbsp;Viewpoint height (in map units)  
    **perspective**=*value*  
    &nbsp;&nbsp;&nbsp;&nbsp;Viewpoint field of view (in degrees)  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *1-180*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *40*  
    **twist**=*value*  
    &nbsp;&nbsp;&nbsp;&nbsp;Viewpoint twist angle (in degrees)  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *-180-180*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *0*  
    **zexag**=*value*  
    &nbsp;&nbsp;&nbsp;&nbsp;Vertical exaggeration  
    **focus**=*x,y,z*  
    &nbsp;&nbsp;&nbsp;&nbsp;Focus to point on surface (from SW corner in map units)  
    **light_position**=*x,y,z*  
    &nbsp;&nbsp;&nbsp;&nbsp;Light position (x,y,z model coordinates)  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *0.68,-0.68,0.80*  
    **light_color**=*name*  
    &nbsp;&nbsp;&nbsp;&nbsp;Light color  
    &nbsp;&nbsp;&nbsp;&nbsp;Either a standard color name or R:G:B triplet  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *white*  
    **light_brightness**=*integer*  
    &nbsp;&nbsp;&nbsp;&nbsp;Light brightness  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *0-100*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *80*  
    **light_ambient**=*integer*  
    &nbsp;&nbsp;&nbsp;&nbsp;Light ambient  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *0-100*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *20*  
    **fringe**=*string* [,*string*,...]  
    &nbsp;&nbsp;&nbsp;&nbsp;Fringe edges  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *nw, ne, sw, se*  
    &nbsp;&nbsp;&nbsp;&nbsp;**nw**: North-West edge  
    &nbsp;&nbsp;&nbsp;&nbsp;**ne**: North-East edge  
    &nbsp;&nbsp;&nbsp;&nbsp;**sw**: South-West edge  
    &nbsp;&nbsp;&nbsp;&nbsp;**se**: South-East edge  
    **fringe_color**=*name*  
    &nbsp;&nbsp;&nbsp;&nbsp;Fringe color  
    &nbsp;&nbsp;&nbsp;&nbsp;Either a standard color name or R:G:B triplet  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *grey*  
    **fringe_elevation**=*integer*  
    &nbsp;&nbsp;&nbsp;&nbsp;Fringe elevation  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *55*  
    **cplane**=*value* [,*value*,...]  
    &nbsp;&nbsp;&nbsp;&nbsp;Cutting plane index (0-5)  
    **cplane_position**=*x,y,z* [,*x,y,z*,...]  
    &nbsp;&nbsp;&nbsp;&nbsp;Cutting plane x,y,z coordinates  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *0,0,0*  
    **cplane_rotation**=*value* [,*value*,...]  
    &nbsp;&nbsp;&nbsp;&nbsp;Cutting plane rotation along the vertical axis  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *0-360*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *0*  
    **cplane_tilt**=*value* [,*value*,...]  
    &nbsp;&nbsp;&nbsp;&nbsp;Cutting plane tilt  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *0-360*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *0*  
    **cplane_shading**=*string*  
    &nbsp;&nbsp;&nbsp;&nbsp;Cutting plane color (between two surfaces)  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *clear, top, bottom, blend, shaded*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *clear*  
    **arrow_position**=*x,y*  
    &nbsp;&nbsp;&nbsp;&nbsp;Place north arrow at given position&nbsp;&nbsp;&nbsp;&nbsp;(in screen coordinates from bottom left corner)  
    **arrow_size**=*value*  
    &nbsp;&nbsp;&nbsp;&nbsp;North arrow size (in map units)  
    **arrow_color**=*name*  
    &nbsp;&nbsp;&nbsp;&nbsp;North arrow color  
    &nbsp;&nbsp;&nbsp;&nbsp;Either a standard color name or R:G:B triplet  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *black*  
    **output**=*name* **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;Name for output image file (without extension)  
    **format**=*string* **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;Graphics file format  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *ppm, tif*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *ppm*  
    **size**=*width,height* **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;Size (width, height) of output image  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *640,480*  
    **-a**  
    &nbsp;&nbsp;&nbsp;&nbsp;Use draw mode for all loaded surfaces  
    **-n**  
    &nbsp;&nbsp;&nbsp;&nbsp;Toggles normal direction of all isosurfaces (changes light effect)  
    **-b**  
    &nbsp;&nbsp;&nbsp;&nbsp;Draw volume box  
    **--overwrite**  
    &nbsp;&nbsp;&nbsp;&nbsp;Allow output files to overwrite existing files  
    **--help**  
    &nbsp;&nbsp;&nbsp;&nbsp;Print usage summary  
    **--verbose**  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    **--quiet**  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    **--qq**  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    **--ui**  
    &nbsp;&nbsp;&nbsp;&nbsp;Force launching GUI dialog

=== "Python (grass.script)"

    **elevation_map** : str | list[str], *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of raster map(s) for elevation  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, raster, *name*  
    **elevation_value** : int | list[int] | str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Constant elevation value(s) to use instead of a raster DEM  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: *value*  
    **color_map** : str | list[str], *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of raster map(s) for color  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, raster, *name*  
    **color** : str | list[str], *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Color value(s)  
    &nbsp;&nbsp;&nbsp;&nbsp;Either a standard color name or R:G:B triplet  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, color, *name*  
    **mask_map** : str | list[str], *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of raster map(s) for mask  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, raster, *name*  
    **transparency_map** : str | list[str], *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of raster map(s) for transparency  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, raster, *name*  
    **transparency_value** : int | list[int] | str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Transparency value(s)  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: *value*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *0-255*  
    **shininess_map** : str | list[str], *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of raster map(s) for shininess  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, raster, *name*  
    **shininess_value** : int | list[int] | str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Shininess value(s)  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: *value*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *0-255*  
    **emission_map** : str | list[str], *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of raster map(s) for emission  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, raster, *name*  
    **emission_value** : int | list[int] | str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Emission value(s)  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: *value*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *0-255*  
    **mode** : str | list[str], *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Draw mode  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: *string*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *coarse, fine, both*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *fine*  
    **resolution_fine** : int | list[int] | str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Fine resolution  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: *value*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *6*  
    **resolution_coarse** : int | list[int] | str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Coarse resolution  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: *value*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *9*  
    **style** : str | list[str], *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Draw style  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: *string*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *wire, surface*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *surface*  
    **shading** : str | list[str], *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Shading  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: *string*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *flat, gouraud*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *gouraud*  
    **wire_color** : str | list[str], *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Wire color  
    &nbsp;&nbsp;&nbsp;&nbsp;Either a standard color name or R:G:B triplet  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, color, *name*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *136:136:136*  
    **surface_position** : list[tuple[int, int, int]] | tuple[int, int, int] | list[int] | str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Surface position  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: *x,y,z*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *0,0,0*  
    **vline** : str | list[str], *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of vector map  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of line vector overlay map(s)  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, vector, *name*  
    **vline_layer** : str | list[str], *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Layer number or name  
    &nbsp;&nbsp;&nbsp;&nbsp;Layer number or name for thematic mapping  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, layer  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *1*  
    **vline_width** : int | list[int] | str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Vector line width  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: *value*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *1-100*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *2*  
    **vline_width_column** : str | list[str], *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of width definition column  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of attribute column  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, dbcolumn, *name*  
    **vline_color** : str | list[str], *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Vector line color  
    &nbsp;&nbsp;&nbsp;&nbsp;Either a standard color name or R:G:B triplet  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, color, *name*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *blue*  
    **vline_color_column** : str | list[str], *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of color definition column  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of attribute column  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, dbcolumn, *name*  
    **vline_mode** : str | list[str], *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Vector line display mode  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: *string*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *surface, flat*  
    &nbsp;&nbsp;&nbsp;&nbsp;**surface**: drape on raster surface  
    &nbsp;&nbsp;&nbsp;&nbsp;**flat**: draw at constant elevation  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *surface*  
    **vline_height** : int | list[int] | str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Vector line height  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: *value*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *0-1000*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *0*  
    **vline_position** : list[tuple[int, int, int]] | tuple[int, int, int] | list[int] | str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Vector lines position  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: *x,y,z*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *0,0,0*  
    **vpoint** : str | list[str], *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of vector map  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of point vector overlay map(s)  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, vector, *name*  
    **vpoint_layer** : str | list[str], *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Layer number or name  
    &nbsp;&nbsp;&nbsp;&nbsp;Layer number or name for thematic mapping  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, layer  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *1*  
    **vpoint_size** : float | list[float] | str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Icon size (map units)  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: *value*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *0-1000*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *100*  
    **vpoint_size_column** : str | list[str], *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of size definition column  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of attribute column  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, dbcolumn, *name*  
    **vpoint_width** : int | list[int] | str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Icon width  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: *value*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *1-1000*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *2*  
    **vpoint_width_column** : str | list[str], *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of width definition column  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of attribute column  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, dbcolumn, *name*  
    **vpoint_color** : str | list[str], *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Icon color  
    &nbsp;&nbsp;&nbsp;&nbsp;Either a standard color name or R:G:B triplet  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, color, *name*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *blue*  
    **vpoint_color_column** : str | list[str], *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of color definition column  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of attribute column  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, dbcolumn, *name*  
    **vpoint_marker** : str | list[str], *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Icon marker  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: *string*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *x, box, sphere, cube, diamond, dec_tree, con_tree, aster, gyro, histogram*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *sphere*  
    **vpoint_marker_column** : str | list[str], *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of marker definition column  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of attribute column  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, dbcolumn, *name*  
    **vpoint_mode** : str | list[str], *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;3D vector point display mode  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: *string*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *surface, 3D*  
    &nbsp;&nbsp;&nbsp;&nbsp;**surface**: drape on raster surface  
    &nbsp;&nbsp;&nbsp;&nbsp;**3D**: place at 3D point's z-elevation  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *3D*  
    **vpoint_position** : list[tuple[float, float, float]] | tuple[float, float, float] | list[float] | str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Vector points position  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: *x,y,z*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *0,0,0*  
    **volume** : str | list[str], *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of 3D raster map(s)  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, raster_3d, *name*  
    **volume_mode** : str | list[str], *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Volume draw mode  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: *string*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *isosurface, slice*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *isosurface*  
    **volume_shading** : str | list[str], *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Volume shading  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: *string*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *flat, gouraud*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *gouraud*  
    **volume_position** : list[tuple[int, int, int]] | tuple[int, int, int] | list[int] | str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Volume position  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: *x,y,z*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *0,0,0*  
    **volume_resolution** : int | list[int] | str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Volume resolution  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: *value*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *3*  
    **isosurf_level** : str | list[str], *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Isosurface level  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: *volume:value*  
    **isosurf_color_map** : str | list[str], *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of volume for isosurface color  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, raster_3d, *name*  
    **isosurf_color_value** : str | list[str], *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Isosurface color  
    &nbsp;&nbsp;&nbsp;&nbsp;Either a standard color name or R:G:B triplet  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, color, *name*  
    **isosurf_transparency_map** : str | list[str], *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of 3D raster map(s) for isosurface transparency  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, raster_3d, *name*  
    **isosurf_transparency_value** : int | list[int] | str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Transparency value(s)for isosurfaces  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: *value*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *0-255*  
    **isosurf_shininess_map** : str | list[str], *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of 3D raster map(s) for shininess  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, raster_3d, *name*  
    **isosurf_shininess_value** : int | list[int] | str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Shininess value(s) for isosurfaces  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: *value*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *0-255*  
    **slice** : str | list[str], *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Volume slice parallel to given axis (x, y, z)  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: *volume:axis*  
    **slice_position** : list[tuple[float, float, float, float, float, float]] | tuple[float, float, float, float, float, float] | list[float] | str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Volume slice position  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: *x1,x2,y1,y2,z1,z2*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *0,1,0,1,0,1*  
    **slice_transparency** : int | list[int] | str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Volume slice transparency  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: *value*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *0-255*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *0*  
    **bgcolor** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Background color  
    &nbsp;&nbsp;&nbsp;&nbsp;Either a standard color name or R:G:B triplet  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, color, *name*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *white*  
    **position** : tuple[float, float] | list[float] | str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Viewpoint position (x,y model coordinates)  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: *x,y*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *0.0-1.0*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *0.84,0.16*  
    **height** : int, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Viewpoint height (in map units)  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: *value*  
    **perspective** : int, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Viewpoint field of view (in degrees)  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: *value*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *1-180*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *40*  
    **twist** : int, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Viewpoint twist angle (in degrees)  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: *value*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *-180-180*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *0*  
    **zexag** : float, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Vertical exaggeration  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: *value*  
    **focus** : tuple[float, float, float] | list[float] | str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Focus to point on surface (from SW corner in map units)  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: *x,y,z*  
    **light_position** : tuple[float, float, float] | list[float] | str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Light position (x,y,z model coordinates)  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: *x,y,z*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *0.68,-0.68,0.80*  
    **light_color** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Light color  
    &nbsp;&nbsp;&nbsp;&nbsp;Either a standard color name or R:G:B triplet  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, color, *name*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *white*  
    **light_brightness** : int, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Light brightness  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *0-100*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *80*  
    **light_ambient** : int, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Light ambient  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *0-100*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *20*  
    **fringe** : str | list[str], *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Fringe edges  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *nw, ne, sw, se*  
    &nbsp;&nbsp;&nbsp;&nbsp;**nw**: North-West edge  
    &nbsp;&nbsp;&nbsp;&nbsp;**ne**: North-East edge  
    &nbsp;&nbsp;&nbsp;&nbsp;**sw**: South-West edge  
    &nbsp;&nbsp;&nbsp;&nbsp;**se**: South-East edge  
    **fringe_color** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Fringe color  
    &nbsp;&nbsp;&nbsp;&nbsp;Either a standard color name or R:G:B triplet  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, color, *name*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *grey*  
    **fringe_elevation** : int, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Fringe elevation  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *55*  
    **cplane** : int | list[int] | str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Cutting plane index (0-5)  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: *value*  
    **cplane_position** : list[tuple[float, float, float]] | tuple[float, float, float] | list[float] | str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Cutting plane x,y,z coordinates  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: *x,y,z*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *0,0,0*  
    **cplane_rotation** : float | list[float] | str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Cutting plane rotation along the vertical axis  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: *value*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *0-360*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *0*  
    **cplane_tilt** : float | list[float] | str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Cutting plane tilt  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: *value*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *0-360*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *0*  
    **cplane_shading** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Cutting plane color (between two surfaces)  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: *string*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *clear, top, bottom, blend, shaded*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *clear*  
    **arrow_position** : tuple[int, int] | list[int] | str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Place north arrow at given position&nbsp;&nbsp;&nbsp;&nbsp;(in screen coordinates from bottom left corner)  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: *x,y*  
    **arrow_size** : float, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;North arrow size (in map units)  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: *value*  
    **arrow_color** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;North arrow color  
    &nbsp;&nbsp;&nbsp;&nbsp;Either a standard color name or R:G:B triplet  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, color, *name*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *black*  
    **output** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name for output image file (without extension)  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: output, file, *name*  
    **format** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Graphics file format  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *ppm, tif*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *ppm*  
    **size** : tuple[int, int] | list[int] | str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Size (width, height) of output image  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: *width,height*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *640,480*  
    **flags** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *a*, *n*, *b*  
    &nbsp;&nbsp;&nbsp;&nbsp;**a**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Use draw mode for all loaded surfaces  
    &nbsp;&nbsp;&nbsp;&nbsp;**n**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Toggles normal direction of all isosurfaces (changes light effect)  
    &nbsp;&nbsp;&nbsp;&nbsp;**b**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Draw volume box  
    **overwrite** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allow output files to overwrite existing files  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **verbose** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **quiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **superquiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  

=== "Python (grass.tools)"

    **elevation_map** : str | list[str], *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of raster map(s) for elevation  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, raster, *name*  
    **elevation_value** : int | list[int] | str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Constant elevation value(s) to use instead of a raster DEM  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: *value*  
    **color_map** : str | list[str], *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of raster map(s) for color  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, raster, *name*  
    **color** : str | list[str], *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Color value(s)  
    &nbsp;&nbsp;&nbsp;&nbsp;Either a standard color name or R:G:B triplet  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, color, *name*  
    **mask_map** : str | list[str], *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of raster map(s) for mask  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, raster, *name*  
    **transparency_map** : str | list[str], *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of raster map(s) for transparency  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, raster, *name*  
    **transparency_value** : int | list[int] | str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Transparency value(s)  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: *value*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *0-255*  
    **shininess_map** : str | list[str], *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of raster map(s) for shininess  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, raster, *name*  
    **shininess_value** : int | list[int] | str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Shininess value(s)  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: *value*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *0-255*  
    **emission_map** : str | list[str], *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of raster map(s) for emission  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, raster, *name*  
    **emission_value** : int | list[int] | str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Emission value(s)  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: *value*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *0-255*  
    **mode** : str | list[str], *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Draw mode  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: *string*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *coarse, fine, both*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *fine*  
    **resolution_fine** : int | list[int] | str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Fine resolution  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: *value*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *6*  
    **resolution_coarse** : int | list[int] | str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Coarse resolution  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: *value*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *9*  
    **style** : str | list[str], *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Draw style  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: *string*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *wire, surface*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *surface*  
    **shading** : str | list[str], *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Shading  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: *string*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *flat, gouraud*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *gouraud*  
    **wire_color** : str | list[str], *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Wire color  
    &nbsp;&nbsp;&nbsp;&nbsp;Either a standard color name or R:G:B triplet  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, color, *name*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *136:136:136*  
    **surface_position** : list[tuple[int, int, int]] | tuple[int, int, int] | list[int] | str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Surface position  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: *x,y,z*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *0,0,0*  
    **vline** : str | list[str], *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of vector map  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of line vector overlay map(s)  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, vector, *name*  
    **vline_layer** : str | list[str], *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Layer number or name  
    &nbsp;&nbsp;&nbsp;&nbsp;Layer number or name for thematic mapping  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, layer  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *1*  
    **vline_width** : int | list[int] | str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Vector line width  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: *value*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *1-100*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *2*  
    **vline_width_column** : str | list[str], *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of width definition column  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of attribute column  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, dbcolumn, *name*  
    **vline_color** : str | list[str], *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Vector line color  
    &nbsp;&nbsp;&nbsp;&nbsp;Either a standard color name or R:G:B triplet  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, color, *name*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *blue*  
    **vline_color_column** : str | list[str], *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of color definition column  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of attribute column  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, dbcolumn, *name*  
    **vline_mode** : str | list[str], *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Vector line display mode  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: *string*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *surface, flat*  
    &nbsp;&nbsp;&nbsp;&nbsp;**surface**: drape on raster surface  
    &nbsp;&nbsp;&nbsp;&nbsp;**flat**: draw at constant elevation  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *surface*  
    **vline_height** : int | list[int] | str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Vector line height  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: *value*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *0-1000*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *0*  
    **vline_position** : list[tuple[int, int, int]] | tuple[int, int, int] | list[int] | str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Vector lines position  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: *x,y,z*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *0,0,0*  
    **vpoint** : str | list[str], *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of vector map  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of point vector overlay map(s)  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, vector, *name*  
    **vpoint_layer** : str | list[str], *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Layer number or name  
    &nbsp;&nbsp;&nbsp;&nbsp;Layer number or name for thematic mapping  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, layer  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *1*  
    **vpoint_size** : float | list[float] | str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Icon size (map units)  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: *value*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *0-1000*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *100*  
    **vpoint_size_column** : str | list[str], *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of size definition column  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of attribute column  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, dbcolumn, *name*  
    **vpoint_width** : int | list[int] | str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Icon width  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: *value*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *1-1000*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *2*  
    **vpoint_width_column** : str | list[str], *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of width definition column  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of attribute column  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, dbcolumn, *name*  
    **vpoint_color** : str | list[str], *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Icon color  
    &nbsp;&nbsp;&nbsp;&nbsp;Either a standard color name or R:G:B triplet  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, color, *name*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *blue*  
    **vpoint_color_column** : str | list[str], *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of color definition column  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of attribute column  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, dbcolumn, *name*  
    **vpoint_marker** : str | list[str], *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Icon marker  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: *string*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *x, box, sphere, cube, diamond, dec_tree, con_tree, aster, gyro, histogram*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *sphere*  
    **vpoint_marker_column** : str | list[str], *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of marker definition column  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of attribute column  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, dbcolumn, *name*  
    **vpoint_mode** : str | list[str], *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;3D vector point display mode  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: *string*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *surface, 3D*  
    &nbsp;&nbsp;&nbsp;&nbsp;**surface**: drape on raster surface  
    &nbsp;&nbsp;&nbsp;&nbsp;**3D**: place at 3D point's z-elevation  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *3D*  
    **vpoint_position** : list[tuple[float, float, float]] | tuple[float, float, float] | list[float] | str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Vector points position  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: *x,y,z*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *0,0,0*  
    **volume** : str | list[str], *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of 3D raster map(s)  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, raster_3d, *name*  
    **volume_mode** : str | list[str], *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Volume draw mode  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: *string*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *isosurface, slice*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *isosurface*  
    **volume_shading** : str | list[str], *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Volume shading  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: *string*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *flat, gouraud*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *gouraud*  
    **volume_position** : list[tuple[int, int, int]] | tuple[int, int, int] | list[int] | str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Volume position  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: *x,y,z*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *0,0,0*  
    **volume_resolution** : int | list[int] | str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Volume resolution  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: *value*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *3*  
    **isosurf_level** : str | list[str], *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Isosurface level  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: *volume:value*  
    **isosurf_color_map** : str | list[str], *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of volume for isosurface color  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, raster_3d, *name*  
    **isosurf_color_value** : str | list[str], *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Isosurface color  
    &nbsp;&nbsp;&nbsp;&nbsp;Either a standard color name or R:G:B triplet  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, color, *name*  
    **isosurf_transparency_map** : str | list[str], *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of 3D raster map(s) for isosurface transparency  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, raster_3d, *name*  
    **isosurf_transparency_value** : int | list[int] | str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Transparency value(s)for isosurfaces  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: *value*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *0-255*  
    **isosurf_shininess_map** : str | list[str], *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of 3D raster map(s) for shininess  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, raster_3d, *name*  
    **isosurf_shininess_value** : int | list[int] | str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Shininess value(s) for isosurfaces  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: *value*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *0-255*  
    **slice** : str | list[str], *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Volume slice parallel to given axis (x, y, z)  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: *volume:axis*  
    **slice_position** : list[tuple[float, float, float, float, float, float]] | tuple[float, float, float, float, float, float] | list[float] | str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Volume slice position  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: *x1,x2,y1,y2,z1,z2*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *0,1,0,1,0,1*  
    **slice_transparency** : int | list[int] | str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Volume slice transparency  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: *value*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *0-255*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *0*  
    **bgcolor** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Background color  
    &nbsp;&nbsp;&nbsp;&nbsp;Either a standard color name or R:G:B triplet  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, color, *name*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *white*  
    **position** : tuple[float, float] | list[float] | str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Viewpoint position (x,y model coordinates)  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: *x,y*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *0.0-1.0*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *0.84,0.16*  
    **height** : int, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Viewpoint height (in map units)  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: *value*  
    **perspective** : int, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Viewpoint field of view (in degrees)  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: *value*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *1-180*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *40*  
    **twist** : int, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Viewpoint twist angle (in degrees)  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: *value*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *-180-180*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *0*  
    **zexag** : float, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Vertical exaggeration  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: *value*  
    **focus** : tuple[float, float, float] | list[float] | str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Focus to point on surface (from SW corner in map units)  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: *x,y,z*  
    **light_position** : tuple[float, float, float] | list[float] | str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Light position (x,y,z model coordinates)  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: *x,y,z*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *0.68,-0.68,0.80*  
    **light_color** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Light color  
    &nbsp;&nbsp;&nbsp;&nbsp;Either a standard color name or R:G:B triplet  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, color, *name*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *white*  
    **light_brightness** : int, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Light brightness  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *0-100*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *80*  
    **light_ambient** : int, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Light ambient  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *0-100*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *20*  
    **fringe** : str | list[str], *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Fringe edges  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *nw, ne, sw, se*  
    &nbsp;&nbsp;&nbsp;&nbsp;**nw**: North-West edge  
    &nbsp;&nbsp;&nbsp;&nbsp;**ne**: North-East edge  
    &nbsp;&nbsp;&nbsp;&nbsp;**sw**: South-West edge  
    &nbsp;&nbsp;&nbsp;&nbsp;**se**: South-East edge  
    **fringe_color** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Fringe color  
    &nbsp;&nbsp;&nbsp;&nbsp;Either a standard color name or R:G:B triplet  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, color, *name*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *grey*  
    **fringe_elevation** : int, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Fringe elevation  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *55*  
    **cplane** : int | list[int] | str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Cutting plane index (0-5)  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: *value*  
    **cplane_position** : list[tuple[float, float, float]] | tuple[float, float, float] | list[float] | str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Cutting plane x,y,z coordinates  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: *x,y,z*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *0,0,0*  
    **cplane_rotation** : float | list[float] | str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Cutting plane rotation along the vertical axis  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: *value*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *0-360*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *0*  
    **cplane_tilt** : float | list[float] | str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Cutting plane tilt  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: *value*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *0-360*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *0*  
    **cplane_shading** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Cutting plane color (between two surfaces)  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: *string*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *clear, top, bottom, blend, shaded*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *clear*  
    **arrow_position** : tuple[int, int] | list[int] | str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Place north arrow at given position&nbsp;&nbsp;&nbsp;&nbsp;(in screen coordinates from bottom left corner)  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: *x,y*  
    **arrow_size** : float, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;North arrow size (in map units)  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: *value*  
    **arrow_color** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;North arrow color  
    &nbsp;&nbsp;&nbsp;&nbsp;Either a standard color name or R:G:B triplet  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, color, *name*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *black*  
    **output** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name for output image file (without extension)  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: output, file, *name*  
    **format** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Graphics file format  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *ppm, tif*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *ppm*  
    **size** : tuple[int, int] | list[int] | str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Size (width, height) of output image  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: *width,height*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *640,480*  
    **flags** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *a*, *n*, *b*  
    &nbsp;&nbsp;&nbsp;&nbsp;**a**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Use draw mode for all loaded surfaces  
    &nbsp;&nbsp;&nbsp;&nbsp;**n**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Toggles normal direction of all isosurfaces (changes light effect)  
    &nbsp;&nbsp;&nbsp;&nbsp;**b**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Draw volume box  
    **overwrite** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allow output files to overwrite existing files  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **verbose** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **quiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **superquiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  

    Returns:

    **result** : grass.tools.support.ToolResult | None  
    If the tool produces text as standard output, a *ToolResult* object will be returned. Otherwise, `None` will be returned.

    Raises:

    *grass.tools.ToolError*: When the tool ended with an error.

## DESCRIPTION

*m.nviz.image* allows users to realistically render multiple *surfaces*
(raster data) in a 3D space, optionally using thematic coloring, draping
2D *vector* data over the surfaces, displaying 3D vector data in the
space, and visualization of *volume* data (3D raster data) from the
command line.

## EXAMPLE

Render elevation map in a 3D space.

```sh
g.region raster=elevation
m.nviz.image elevation_map=elevation output=elev perspective=15
```

## SEE ALSO

*[wxGUI 3D viewer](wxGUI.nviz.md)*

## AUTHORS

[Martin Landa](http://geo.fsv.cvut.cz/gwiki/Landa), [Google Summer of
Code 2008](https://grasswiki.osgeo.org/wiki/WxNviz_GSoC_2008) (mentor:
Michael Barton) and [Google Summer of Code
2010](https://grasswiki.osgeo.org/wiki/WxNviz_GSoC_2010) (mentor: Helena
Mitasova)  
Anna Kratochvilova, [Google Summer of Code
2011](https://grasswiki.osgeo.org/wiki/WxNviz_GSoC_2011) (mentor: Martin
Landa)

## SOURCE CODE

Available at: [m.nviz.image source code](https://github.com/OSGeo/grass/tree/main/misc/m.nviz.image)
([history](https://github.com/OSGeo/grass/commits/main/misc/m.nviz.image))  
Latest change: Tuesday Feb 25 19:01:58 2025 in commit [34b6764](https://github.com/OSGeo/grass/commit/34b6764aa53fe1f1170230efd0949e34194de119)
