---
name: r.circle
description: Creates a raster map containing concentric rings around a given point.
keywords: [ raster, buffer, geometry, circle ]
---

# r.circle

Creates a raster map containing concentric rings around a given point.

=== "Command line"

    **r.circle**
    [**-b**]
    **output**=*name*
    **coordinates**=*east,north*
    [**min**=*float*]
    [**max**=*float*]
    [**multiplier**=*float*]
    [**--overwrite**]
    [**--verbose**]
    [**--quiet**]
    [**--qq**]
    [**--ui**]

    Example:

    ```sh
    r.circle output=name coordinates=0.0
    ```

=== "Python (grass.script)"

    *grass.script.run_command*("***r.circle***",
        **output**,
        **coordinates**,
        **min**=*None*,
        **max**=*None*,
        **multiplier**=*None*,
        **flags**=*None*,
        **overwrite**=*None*,
        **verbose**=*None*,
        **quiet**=*None*,
        **superquiet**=*None*)

    Example:

    ```python
    gs.run_command("r.circle", output="name", coordinates=0.0)
    ```

=== "Python (grass.tools)"

    *grass.tools.Tools.r_circle*(**output**,
        **coordinates**,
        **min**=*None*,
        **max**=*None*,
        **multiplier**=*None*,
        **flags**=*None*,
        **overwrite**=*None*,
        **verbose**=*None*,
        **quiet**=*None*,
        **superquiet**=*None*)

    Example:

    ```python
    tools = Tools()
    tools.r_circle(output="name", coordinates=0.0)
    ```

    This grass.tools API is experimental in version 8.5 and expected to be stable in version 8.6.

## Parameters

=== "Command line"

    **output**=*name* **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;Name for output raster map  
    **coordinates**=*east,north* **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;The coordinate of the center (east,north)  
    **min**=*float*  
    &nbsp;&nbsp;&nbsp;&nbsp;Minimum radius for ring/circle map (in meters)  
    **max**=*float*  
    &nbsp;&nbsp;&nbsp;&nbsp;Maximum radius for ring/circle map (in meters)  
    **multiplier**=*float*  
    &nbsp;&nbsp;&nbsp;&nbsp;Data value multiplier  
    **-b**  
    &nbsp;&nbsp;&nbsp;&nbsp;Generate binary raster map  
    &nbsp;&nbsp;&nbsp;&nbsp;Generate binary pattern only (useful for creating mask)  
    **--overwrite**  
    &nbsp;&nbsp;&nbsp;&nbsp;Allow output files to overwrite existing files  
    **--help**  
    &nbsp;&nbsp;&nbsp;&nbsp;Print usage summary  
    **--verbose**  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    **--quiet**  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    **--qq**  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    **--ui**  
    &nbsp;&nbsp;&nbsp;&nbsp;Force launching GUI dialog

=== "Python (grass.script)"

    **output** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name for output raster map  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: output, raster, *name*  
    **coordinates** : tuple[float, float] | list[float] | str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;The coordinate of the center (east,north)  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, coords, *east,north*  
    **min** : float, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Minimum radius for ring/circle map (in meters)  
    **max** : float, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Maximum radius for ring/circle map (in meters)  
    **multiplier** : float, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Data value multiplier  
    **flags** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *b*  
    &nbsp;&nbsp;&nbsp;&nbsp;**b**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Generate binary raster map  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Generate binary pattern only (useful for creating mask)  
    **overwrite** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allow output files to overwrite existing files  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **verbose** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **quiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **superquiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  

=== "Python (grass.tools)"

    **output** : str | type(np.ndarray) | type(np.array) | type(gs.array.array), *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name for output raster map  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: output, raster, *name*  
    **coordinates** : tuple[float, float] | list[float] | str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;The coordinate of the center (east,north)  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, coords, *east,north*  
    **min** : float, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Minimum radius for ring/circle map (in meters)  
    **max** : float, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Maximum radius for ring/circle map (in meters)  
    **multiplier** : float, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Data value multiplier  
    **flags** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *b*  
    &nbsp;&nbsp;&nbsp;&nbsp;**b**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Generate binary raster map  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Generate binary pattern only (useful for creating mask)  
    **overwrite** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allow output files to overwrite existing files  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **verbose** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **quiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **superquiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  

    Returns:

    **result** : grass.tools.support.ToolResult | np.ndarray | tuple[np.ndarray] | None  
    If the tool produces text as standard output, a *ToolResult* object will be returned. Otherwise, `None` will be returned. If an array type (e.g., *np.ndarray*) is used for one of the raster outputs, the result will be an array and will have the shape corresponding to the computational region. If an array type is used for more than one raster output, the result will be a tuple of arrays.

    Raises:

    *grass.tools.ToolError*: When the tool ended with an error.

## DESCRIPTION

*r.circle* creates an output raster map centered on the *x,y* values
specified with the *coordinate* parameter, out to the edge of the
current region. The output cell values increase linearly from the
specified center. The *min* and *max* parameters control the inner and
outer output raster map radii, respectively.

The *mult* parameter can be used to multiply the output raster cells by
a common factor. Note that this parameter does not affect the output
raster position or size; only the z-values are changed with this
parameter.

Binary-output raster maps (solid circles of one value) can be created
with the **-b** flag. Raster maps so created can be used to create
binary filters for use in *i.ifft* (inverse Fourier transformations;
apply filter with *r.mask*).

## EXAMPLES

Generate a raster circle at current map center with a radius of 300m and
outwardly increasing raster values:

```sh
EASTCENTER=`g.region -c |  awk ' /center easting:/ { print $3 }'`
NORTHCENTER=`g.region -c | awk ' /center northing:/ { print $3 }'`
r.circle output=circle coordinate=${EASTCENTER},${NORTHCENTER} max=300
```

Generate a binary raster ring around current map center with an inner
radius of 500m and an outer radius of 1000m:

```sh
EASTCENTER=`g.region -c |  awk ' /center easting:/ { print $3 }'`
NORTHCENTER=`g.region -c | awk ' /center northing:/ { print $3 }'`
r.circle -b output=circle coordinate=${EASTCENTER},${NORTHCENTER} min=500 max=1000
```

## SEE ALSO

*[g.region](g.region.md), [g.remove](g.remove.md),
[g.rename](g.rename.md), [i.fft](i.fft.md), [i.ifft](i.ifft.md),
[r.mask](r.mask.md)*

## AUTHORS

Bill Brown, U.S. Army Construction Engineering Research Laboratory  
Additional flag/min/max parameter by Markus Neteler, University of
Hannover

## SOURCE CODE

Available at: [r.circle source code](https://github.com/OSGeo/grass/tree/main/raster/r.circle)
([history](https://github.com/OSGeo/grass/commits/main/raster/r.circle))  
Latest change: Friday Feb 07 19:16:09 2025 in commit [a82a39f](https://github.com/OSGeo/grass/commit/a82a39f673b97fafcfce1604dc3e6015cb96487a)
